% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_update_vocabulary}
\alias{transcribeservice_update_vocabulary}
\title{Updates an existing custom vocabulary with new values}
\usage{
transcribeservice_update_vocabulary(
  VocabularyName,
  LanguageCode,
  Phrases = NULL,
  VocabularyFileUri = NULL
)
}
\arguments{
\item{VocabularyName}{[required] The name of the custom vocabulary you want to update. Vocabulary names
are case sensitive.}

\item{LanguageCode}{[required] The language code that represents the language of the entries in the
custom vocabulary you want to update. Each vocabulary must contain terms
in only one language.

A custom vocabulary can only be used to transcribe files in the same
language as the vocabulary. For example, if you create a vocabulary
using US English (\code{en-US}), you can only apply this vocabulary to files
that contain English audio.

For a list of supported languages and their associated language codes,
refer to the \href{https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html}{Supported languages}
table.}

\item{Phrases}{Use this parameter if you want to update your vocabulary by including
all desired terms, as comma-separated values, within your request. The
other option for updating your vocabulary is to save your entries in a
text file and upload them to an Amazon S3 bucket, then specify the
location of your file using the \code{VocabularyFileUri} parameter.

Note that if you include \code{Phrases} in your request, you cannot use
\code{VocabularyFileUri}; you must choose one or the other.

Each language has a character set that contains all allowed characters
for that specific language. If you use unsupported characters, your
vocabulary filter request fails. Refer to \href{https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html}{Character Sets for Custom Vocabularies}
to get the character set for your language.}

\item{VocabularyFileUri}{The Amazon S3 location of the text file that contains your custom
vocabulary. The URI must be located in the same Amazon Web Services
Region as the resource you're calling.

Here's an example URI path: \verb{s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt}

Note that if you include \code{VocabularyFileUri} in your request, you cannot
use the \code{Phrases} flag; you must choose one or the other.}
}
\description{
Updates an existing custom vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing vocabulary.

See \url{https://paws-r.github.io/docs/transcribeservice/update_vocabulary.html} for full documentation.
}
\keyword{internal}
