% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_project}
\alias{sagemaker_create_project}
\title{Creates a machine learning (ML) project that can contain one or more
templates that set up an ML pipeline from training to deploying an
approved model}
\usage{
sagemaker_create_project(
  ProjectName,
  ProjectDescription = NULL,
  ServiceCatalogProvisioningDetails,
  Tags = NULL
)
}
\arguments{
\item{ProjectName}{[required] The name of the project.}

\item{ProjectDescription}{A description for the project.}

\item{ServiceCatalogProvisioningDetails}{[required] The product ID and provisioning artifact ID to provision a service
catalog. The provisioning artifact ID will default to the latest
provisioning artifact ID of the product, if you don't provide the
provisioning artifact ID. For more information, see \href{https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html}{What is Amazon Web Services Service Catalog}.}

\item{Tags}{An array of key-value pairs that you want to use to organize and track
your Amazon Web Services resource costs. For more information, see
\href{https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html}{Tagging Amazon Web Services resources}
in the \emph{Amazon Web Services General Reference Guide}.}
}
\description{
Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from training to deploying an approved model.

See \url{https://paws-r.github.io/docs/sagemaker/create_project.html} for full documentation.
}
\keyword{internal}
