% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexruntimev2_operations.R
\name{lexruntimev2_recognize_utterance}
\alias{lexruntimev2_recognize_utterance}
\title{Sends user input to Amazon Lex V2}
\usage{
lexruntimev2_recognize_utterance(
  botId,
  botAliasId,
  localeId,
  sessionId,
  sessionState = NULL,
  requestAttributes = NULL,
  requestContentType,
  responseContentType = NULL,
  inputStream = NULL
)
}
\arguments{
\item{botId}{[required] The identifier of the bot that should receive the request.}

\item{botAliasId}{[required] The alias identifier in use for the bot that should receive the request.}

\item{localeId}{[required] The locale where the session is in use.}

\item{sessionId}{[required] The identifier of the session in use.}

\item{sessionState}{Sets the state of the session with the user. You can use this to set the
current intent, attributes, context, and dialog action. Use the dialog
action to determine the next step that Amazon Lex V2 should use in the
conversation with the user.

The \code{sessionState} field must be compressed using gzip and then base64
encoded before sending to Amazon Lex V2.}

\item{requestAttributes}{Request-specific information passed between the client application and
Amazon Lex V2

The namespace \verb{x-amz-lex:} is reserved for special attributes. Don't
create any request attributes for prefix \verb{x-amz-lex:}.

The \code{requestAttributes} field must be compressed using gzip and then
base64 encoded before sending to Amazon Lex V2.}

\item{requestContentType}{[required] Indicates the format for audio input or that the content is text. The
header must start with one of the following prefixes:
\itemize{
\item PCM format, audio data must be in little-endian byte order.
\itemize{
\item audio/l16; rate=16000; channels=1
\item audio/x-l16; sample-rate=16000; channel-count=1
\item audio/lpcm; sample-rate=8000; sample-size-bits=16;
channel-count=1; is-big-endian=false
}
\item Opus format
\itemize{
\item audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4
}
\item Text format
\itemize{
\item text/plain; charset=utf-8
}
}}

\item{responseContentType}{The message that Amazon Lex V2 returns in the response can be either
text or speech based on the \code{responseContentType} value.
\itemize{
\item If the value is \verb{text/plain;charset=utf-8}, Amazon Lex V2 returns
text in the response.
\item If the value begins with \verb{audio/}, Amazon Lex V2 returns speech in
the response. Amazon Lex V2 uses Amazon Polly to generate the speech
using the configuration that you specified in the
\code{requestContentType} parameter. For example, if you specify
\code{audio/mpeg} as the value, Amazon Lex V2 returns speech in the MPEG
format.
\item If the value is \code{audio/pcm}, the speech returned is \code{audio/pcm} at
16 KHz in 16-bit, little-endian format.
\item The following are the accepted values:
\itemize{
\item audio/mpeg
\item audio/ogg
\item audio/pcm (16 KHz)
\item audio/* (defaults to mpeg)
\item text/plain; charset=utf-8
}
}}

\item{inputStream}{User input in PCM or Opus audio format or text format as described in
the \code{requestContentType} parameter.}
}
\description{
Sends user input to Amazon Lex V2. You can send text or speech. Clients use this API to send text and audio requests to Amazon Lex V2 at runtime. Amazon Lex V2 interprets the user input using the machine learning model built for the bot.

See \url{https://paws-r.github.io/docs/lexruntimev2/recognize_utterance.html} for full documentation.
}
\keyword{internal}
