% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_presigned_domain_url}
\alias{sagemaker_create_presigned_domain_url}
\title{Creates a URL for a specified UserProfile in a Domain}
\usage{
sagemaker_create_presigned_domain_url(DomainId, UserProfileName,
  SessionExpirationDurationInSeconds)
}
\arguments{
\item{DomainId}{[required] The domain ID.}

\item{UserProfileName}{[required] The name of the UserProfile to sign-in as.}

\item{SessionExpirationDurationInSeconds}{The session expiration duration in seconds.}
}
\description{
Creates a URL for a specified UserProfile in a Domain. When accessed in
a web browser, the user will be automatically signed in to Amazon
SageMaker Amazon SageMaker Studio (Studio), and granted access to all of
the Apps and files associated with that Amazon Elastic File System
(EFS). This operation can only be called when AuthMode equals IAM.
}
\section{Request syntax}{
\preformatted{svc$create_presigned_domain_url(
  DomainId = "string",
  UserProfileName = "string",
  SessionExpirationDurationInSeconds = 123
)
}
}

\keyword{internal}
