% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_operations.R
\name{translate_describe_text_translation_job}
\alias{translate_describe_text_translation_job}
\title{Gets the properties associated with an asycnhronous batch translation
job including name, ID, status, source and target languages,
input/output S3 buckets, and so on}
\usage{
translate_describe_text_translation_job(JobId)
}
\arguments{
\item{JobId}{[required] The identifier that Amazon Translate generated for the job. The
\code{\link[=translate_start_text_translation_job]{start_text_translation_job}}
operation returns this identifier in its response.}
}
\value{
A list with the following syntax:\preformatted{list(
  TextTranslationJobProperties = list(
    JobId = "string",
    JobName = "string",
    JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"COMPLETED_WITH_ERROR"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
    JobDetails = list(
      TranslatedDocumentsCount = 123,
      DocumentsWithErrorsCount = 123,
      InputDocumentsCount = 123
    ),
    SourceLanguageCode = "string",
    TargetLanguageCodes = list(
      "string"
    ),
    TerminologyNames = list(
      "string"
    ),
    ParallelDataNames = list(
      "string"
    ),
    Message = "string",
    SubmittedTime = as.POSIXct(
      "2015-01-01"
    ),
    EndTime = as.POSIXct(
      "2015-01-01"
    ),
    InputDataConfig = list(
      S3Uri = "string",
      ContentType = "string"
    ),
    OutputDataConfig = list(
      S3Uri = "string"
    ),
    DataAccessRoleArn = "string"
  )
)
}
}
\description{
Gets the properties associated with an asycnhronous batch translation
job including name, ID, status, source and target languages,
input/output S3 buckets, and so on.
}
\section{Request syntax}{
\preformatted{svc$describe_text_translation_job(
  JobId = "string"
)
}
}

\keyword{internal}
