% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_describe_connection_alias_permissions}
\alias{workspaces_describe_connection_alias_permissions}
\title{Describes the permissions that the owner of a connection alias has
granted to another AWS account for the specified connection alias}
\usage{
workspaces_describe_connection_alias_permissions(AliasId, NextToken,
  MaxResults)
}
\arguments{
\item{AliasId}{[required] The identifier of the connection alias.}

\item{NextToken}{If you received a \code{NextToken} from a previous call that was paginated,
provide this token to receive the next set of results.}

\item{MaxResults}{The maximum number of results to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  AliasId = "string",
  ConnectionAliasPermissions = list(
    list(
      SharedAccountId = "string",
      AllowAssociation = TRUE|FALSE
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes the permissions that the owner of a connection alias has
granted to another AWS account for the specified connection alias. For
more information, see \href{https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html}{Cross-Region Redirection for Amazon WorkSpaces}.
}
\section{Request syntax}{
\preformatted{svc$describe_connection_alias_permissions(
  AliasId = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
