% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_describe_image_permissions}
\alias{appstream_describe_image_permissions}
\title{Retrieves a list that describes the permissions for shared AWS account
IDs on a private image that you own}
\usage{
appstream_describe_image_permissions(Name, MaxResults,
  SharedAwsAccountIds, NextToken)
}
\arguments{
\item{Name}{[required] The name of the private image for which to describe permissions. The
image must be one that you own.}

\item{MaxResults}{The maximum size of each page of results.}

\item{SharedAwsAccountIds}{The 12-digit identifier of one or more AWS accounts with which the image
is shared.}

\item{NextToken}{The pagination token to use to retrieve the next page of results for
this operation. If this value is null, it retrieves the first page.}
}
\value{
A list with the following syntax:\preformatted{list(
  Name = "string",
  SharedImagePermissionsList = list(
    list(
      sharedAccountId = "string",
      imagePermissions = list(
        allowFleet = TRUE|FALSE,
        allowImageBuilder = TRUE|FALSE
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves a list that describes the permissions for shared AWS account
IDs on a private image that you own.
}
\section{Request syntax}{
\preformatted{svc$describe_image_permissions(
  Name = "string",
  MaxResults = 123,
  SharedAwsAccountIds = list(
    "string"
  ),
  NextToken = "string"
)
}
}

\keyword{internal}
