# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS CodeStar Notifications
#'
#' @description
#' This AWS CodeStar Notifications API Reference provides descriptions and
#' usage examples of the operations and data types for the AWS CodeStar
#' Notifications API. You can use the AWS CodeStar Notifications API to
#' work with the following objects:
#' 
#' Notification rules, by calling the following:
#' 
#' -   [`create_notification_rule`][codestarnotifications_create_notification_rule],
#'     which creates a notification rule for a resource in your account.
#' 
#' -   [`delete_notification_rule`][codestarnotifications_delete_notification_rule],
#'     which deletes a notification rule.
#' 
#' -   [`describe_notification_rule`][codestarnotifications_describe_notification_rule],
#'     which provides information about a notification rule.
#' 
#' -   [`list_notification_rules`][codestarnotifications_list_notification_rules],
#'     which lists the notification rules associated with your account.
#' 
#' -   [`update_notification_rule`][codestarnotifications_update_notification_rule],
#'     which changes the name, events, or targets associated with a
#'     notification rule.
#' 
#' -   [`subscribe`][codestarnotifications_subscribe], which subscribes a
#'     target to a notification rule.
#' 
#' -   [`unsubscribe`][codestarnotifications_unsubscribe], which removes a
#'     target from a notification rule.
#' 
#' Targets, by calling the following:
#' 
#' -   [`delete_target`][codestarnotifications_delete_target], which
#'     removes a notification rule target from a notification rule.
#' 
#' -   [`list_targets`][codestarnotifications_list_targets], which lists
#'     the targets associated with a notification rule.
#' 
#' Events, by calling the following:
#' 
#' -   [`list_event_types`][codestarnotifications_list_event_types], which
#'     lists the event types you can include in a notification rule.
#' 
#' Tags, by calling the following:
#' 
#' -   [`list_tags_for_resource`][codestarnotifications_list_tags_for_resource],
#'     which lists the tags already associated with a notification rule in
#'     your account.
#' 
#' -   [`tag_resource`][codestarnotifications_tag_resource], which
#'     associates a tag you provide with a notification rule in your
#'     account.
#' 
#' -   [`untag_resource`][codestarnotifications_untag_resource], which
#'     removes a tag from a notification rule in your account.
#' 
#' For information about how to use AWS CodeStar Notifications, see the
#' [Amazon Web Services Developer Tools Console User
#' Guide](https://docs.aws.amazon.com/dtconsole/latest/userguide/what-is-dtconsole.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- codestarnotifications(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- codestarnotifications()
#' svc$create_notification_rule(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=codestarnotifications_create_notification_rule]{create_notification_rule} \tab Creates a notification rule for a resource\cr
#'  \link[=codestarnotifications_delete_notification_rule]{delete_notification_rule} \tab Deletes a notification rule for a resource\cr
#'  \link[=codestarnotifications_delete_target]{delete_target} \tab Deletes a specified target for notifications\cr
#'  \link[=codestarnotifications_describe_notification_rule]{describe_notification_rule} \tab Returns information about a specified notification rule\cr
#'  \link[=codestarnotifications_list_event_types]{list_event_types} \tab Returns information about the event types available for configuring notifications\cr
#'  \link[=codestarnotifications_list_notification_rules]{list_notification_rules} \tab Returns a list of the notification rules for an Amazon Web Services account\cr
#'  \link[=codestarnotifications_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of the tags associated with a notification rule\cr
#'  \link[=codestarnotifications_list_targets]{list_targets} \tab Returns a list of the notification rule targets for an Amazon Web Services account\cr
#'  \link[=codestarnotifications_subscribe]{subscribe} \tab Creates an association between a notification rule and an Chatbot topic or Chatbot client so that the associated target can receive notifications when the events described in the rule are triggered\cr
#'  \link[=codestarnotifications_tag_resource]{tag_resource} \tab Associates a set of provided tags with a notification rule\cr
#'  \link[=codestarnotifications_unsubscribe]{unsubscribe} \tab Removes an association between a notification rule and an Chatbot topic so that subscribers to that topic stop receiving notifications when the events described in the rule are triggered\cr
#'  \link[=codestarnotifications_untag_resource]{untag_resource} \tab Removes the association between one or more provided tags and a notification rule\cr
#'  \link[=codestarnotifications_update_notification_rule]{update_notification_rule} \tab Updates a notification rule for a resource
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname codestarnotifications
#' @export
codestarnotifications <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .codestarnotifications$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.codestarnotifications <- list()

.codestarnotifications$operations <- list()

.codestarnotifications$metadata <- list(
  service_name = "codestarnotifications",
  endpoints = list("*" = list(endpoint = "codestar-notifications.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "codestar-notifications.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "codestar-notifications.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "codestar-notifications.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "codestar-notifications.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "codestar-notifications.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "codestar notifications",
  api_version = "2019-10-15",
  signing_name = "codestar-notifications",
  json_version = "1.1",
  target_prefix = ""
)

.codestarnotifications$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.codestarnotifications$metadata, handlers, config, op)
}
