# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include codeartifact_service.R
NULL

#' Adds an existing external connection to a repository
#'
#' @description
#' Adds an existing external connection to a repository. One external connection is allowed per repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_associate_external_connection/](https://www.paws-r-sdk.com/docs/codeartifact_associate_external_connection/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository to which the external connection is added.
#' @param externalConnection &#91;required&#93; The name of the external connection to add to the repository. The
#' following values are supported:
#' 
#' -   `public:npmjs` - for the npm public repository.
#' 
#' -   `public:nuget-org` - for the NuGet Gallery.
#' 
#' -   `public:pypi` - for the Python Package Index.
#' 
#' -   `public:maven-central` - for Maven Central.
#' 
#' -   `public:maven-googleandroid` - for the Google Android repository.
#' 
#' -   `public:maven-gradleplugins` - for the Gradle plugins repository.
#' 
#' -   `public:maven-commonsware` - for the CommonsWare Android repository.
#' 
#' -   `public:maven-clojars` - for the Clojars repository.
#'
#' @keywords internal
#'
#' @rdname codeartifact_associate_external_connection
codeartifact_associate_external_connection <- function(domain, domainOwner = NULL, repository, externalConnection) {
  op <- new_operation(
    name = "AssociateExternalConnection",
    http_method = "POST",
    http_path = "/v1/repository/external-connection",
    paginator = list()
  )
  input <- .codeartifact$associate_external_connection_input(domain = domain, domainOwner = domainOwner, repository = repository, externalConnection = externalConnection)
  output <- .codeartifact$associate_external_connection_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$associate_external_connection <- codeartifact_associate_external_connection

#' Copies package versions from one repository to another repository in the
#' same domain
#'
#' @description
#' Copies package versions from one repository to another repository in the same domain.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_copy_package_versions/](https://www.paws-r-sdk.com/docs/codeartifact_copy_package_versions/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the source and destination
#' repositories.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param sourceRepository &#91;required&#93; The name of the repository that contains the package versions to be
#' copied.
#' @param destinationRepository &#91;required&#93; The name of the repository into which package versions are copied.
#' @param format &#91;required&#93; The format of the package versions to be copied.
#' @param namespace The namespace of the package versions to be copied. The package version
#' component that specifies its namespace depends on its type. For example:
#' 
#' -   The namespace of a Maven package version is its `groupId`. The
#'     namespace is required when copying Maven package versions.
#' 
#' -   The namespace of an npm package version is its `scope`.
#' 
#' -   Python and NuGet package versions do not contain a corresponding
#'     component, package versions of those formats do not have a
#'     namespace.
#' 
#' -   The namespace of a generic package is its `namespace`.
#' @param package &#91;required&#93; The name of the package that contains the versions to be copied.
#' @param versions The versions of the package to be copied.
#' 
#' You must specify `versions` or `versionRevisions`. You cannot specify
#' both.
#' @param versionRevisions A list of key-value pairs. The keys are package versions and the values
#' are package version revisions. A `CopyPackageVersion` operation succeeds
#' if the specified versions in the source repository match the specified
#' package version revision.
#' 
#' You must specify `versions` or `versionRevisions`. You cannot specify
#' both.
#' @param allowOverwrite Set to true to overwrite a package version that already exists in the
#' destination repository. If set to false and the package version already
#' exists in the destination repository, the package version is returned in
#' the `failedVersions` field of the response with an `ALREADY_EXISTS`
#' error code.
#' @param includeFromUpstream Set to true to copy packages from repositories that are upstream from
#' the source repository to the destination repository. The default setting
#' is false. For more information, see [Working with upstream
#' repositories](https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html).
#'
#' @keywords internal
#'
#' @rdname codeartifact_copy_package_versions
codeartifact_copy_package_versions <- function(domain, domainOwner = NULL, sourceRepository, destinationRepository, format, namespace = NULL, package, versions = NULL, versionRevisions = NULL, allowOverwrite = NULL, includeFromUpstream = NULL) {
  op <- new_operation(
    name = "CopyPackageVersions",
    http_method = "POST",
    http_path = "/v1/package/versions/copy",
    paginator = list()
  )
  input <- .codeartifact$copy_package_versions_input(domain = domain, domainOwner = domainOwner, sourceRepository = sourceRepository, destinationRepository = destinationRepository, format = format, namespace = namespace, package = package, versions = versions, versionRevisions = versionRevisions, allowOverwrite = allowOverwrite, includeFromUpstream = includeFromUpstream)
  output <- .codeartifact$copy_package_versions_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$copy_package_versions <- codeartifact_copy_package_versions

#' Creates a domain
#'
#' @description
#' Creates a domain. CodeArtifact *domains* make it easier to manage multiple repositories across an organization. You can use a domain to apply permissions across many repositories owned by different Amazon Web Services accounts. An asset is stored only once in a domain, even if it's in multiple repositories.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_create_domain/](https://www.paws-r-sdk.com/docs/codeartifact_create_domain/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain to create. All domain names in an Amazon Web
#' Services Region that are in the same Amazon Web Services account must be
#' unique. The domain name is used as the prefix in DNS hostnames. Do not
#' use sensitive information in a domain name because it is publicly
#' discoverable.
#' @param encryptionKey The encryption key for the domain. This is used to encrypt content
#' stored in a domain. An encryption key can be a key ID, a key Amazon
#' Resource Name (ARN), a key alias, or a key alias ARN. To specify an
#' `encryptionKey`, your IAM role must have `kms:DescribeKey` and
#' `kms:CreateGrant` permissions on the encryption key that is used. For
#' more information, see
#' [DescribeKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestSyntax)
#' in the *Key Management Service API Reference* and [Key Management
#' Service API Permissions
#' Reference](https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
#' in the *Key Management Service Developer Guide*.
#' 
#' CodeArtifact supports only symmetric CMKs. Do not associate an
#' asymmetric CMK with your domain. For more information, see [Using
#' symmetric and asymmetric
#' keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
#' in the *Key Management Service Developer Guide*.
#' @param tags One or more tag key-value pairs for the domain.
#'
#' @keywords internal
#'
#' @rdname codeartifact_create_domain
codeartifact_create_domain <- function(domain, encryptionKey = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateDomain",
    http_method = "POST",
    http_path = "/v1/domain",
    paginator = list()
  )
  input <- .codeartifact$create_domain_input(domain = domain, encryptionKey = encryptionKey, tags = tags)
  output <- .codeartifact$create_domain_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$create_domain <- codeartifact_create_domain

#' Creates a repository
#'
#' @description
#' Creates a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_create_repository/](https://www.paws-r-sdk.com/docs/codeartifact_create_repository/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the created repository.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository to create.
#' @param description A description of the created repository.
#' @param upstreams A list of upstream repositories to associate with the repository. The
#' order of the upstream repositories in the list determines their priority
#' order when CodeArtifact looks for a requested package version. For more
#' information, see [Working with upstream
#' repositories](https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html).
#' @param tags One or more tag key-value pairs for the repository.
#'
#' @keywords internal
#'
#' @rdname codeartifact_create_repository
codeartifact_create_repository <- function(domain, domainOwner = NULL, repository, description = NULL, upstreams = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateRepository",
    http_method = "POST",
    http_path = "/v1/repository",
    paginator = list()
  )
  input <- .codeartifact$create_repository_input(domain = domain, domainOwner = domainOwner, repository = repository, description = description, upstreams = upstreams, tags = tags)
  output <- .codeartifact$create_repository_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$create_repository <- codeartifact_create_repository

#' Deletes a domain
#'
#' @description
#' Deletes a domain. You cannot delete a domain that contains repositories. If you want to delete a domain with repositories, first delete its repositories.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_delete_domain/](https://www.paws-r-sdk.com/docs/codeartifact_delete_domain/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain to delete.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#'
#' @keywords internal
#'
#' @rdname codeartifact_delete_domain
codeartifact_delete_domain <- function(domain, domainOwner = NULL) {
  op <- new_operation(
    name = "DeleteDomain",
    http_method = "DELETE",
    http_path = "/v1/domain",
    paginator = list()
  )
  input <- .codeartifact$delete_domain_input(domain = domain, domainOwner = domainOwner)
  output <- .codeartifact$delete_domain_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$delete_domain <- codeartifact_delete_domain

#' Deletes the resource policy set on a domain
#'
#' @description
#' Deletes the resource policy set on a domain.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_delete_domain_permissions_policy/](https://www.paws-r-sdk.com/docs/codeartifact_delete_domain_permissions_policy/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain associated with the resource policy to be
#' deleted.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param policyRevision The current revision of the resource policy to be deleted. This revision
#' is used for optimistic locking, which prevents others from overwriting
#' your changes to the domain's resource policy.
#'
#' @keywords internal
#'
#' @rdname codeartifact_delete_domain_permissions_policy
codeartifact_delete_domain_permissions_policy <- function(domain, domainOwner = NULL, policyRevision = NULL) {
  op <- new_operation(
    name = "DeleteDomainPermissionsPolicy",
    http_method = "DELETE",
    http_path = "/v1/domain/permissions/policy",
    paginator = list()
  )
  input <- .codeartifact$delete_domain_permissions_policy_input(domain = domain, domainOwner = domainOwner, policyRevision = policyRevision)
  output <- .codeartifact$delete_domain_permissions_policy_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$delete_domain_permissions_policy <- codeartifact_delete_domain_permissions_policy

#' Deletes a package and all associated package versions
#'
#' @description
#' Deletes a package and all associated package versions. A deleted package cannot be restored. To delete one or more package versions, use the [`delete_package_versions`][codeartifact_delete_package_versions] API.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_delete_package/](https://www.paws-r-sdk.com/docs/codeartifact_delete_package/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the package to delete.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository that contains the package to delete.
#' @param format &#91;required&#93; The format of the requested package to delete.
#' @param namespace The namespace of the package to delete. The package component that
#' specifies its namespace depends on its type. For example:
#' 
#' -   The namespace of a Maven package is its `groupId`. The namespace is
#'     required when deleting Maven package versions.
#' 
#' -   The namespace of an npm package is its `scope`.
#' 
#' -   Python and NuGet packages do not contain corresponding components,
#'     packages of those formats do not have a namespace.
#' 
#' -   The namespace of a generic package is its `namespace`.
#' @param package &#91;required&#93; The name of the package to delete.
#'
#' @keywords internal
#'
#' @rdname codeartifact_delete_package
codeartifact_delete_package <- function(domain, domainOwner = NULL, repository, format, namespace = NULL, package) {
  op <- new_operation(
    name = "DeletePackage",
    http_method = "DELETE",
    http_path = "/v1/package",
    paginator = list()
  )
  input <- .codeartifact$delete_package_input(domain = domain, domainOwner = domainOwner, repository = repository, format = format, namespace = namespace, package = package)
  output <- .codeartifact$delete_package_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$delete_package <- codeartifact_delete_package

#' Deletes one or more versions of a package
#'
#' @description
#' Deletes one or more versions of a package. A deleted package version cannot be restored in your repository. If you want to remove a package version from your repository and be able to restore it later, set its status to `Archived`. Archived packages cannot be downloaded from a repository and don't show up with list package APIs (for example, [`list_package_versions`][codeartifact_list_package_versions]), but you can restore them using [`update_package_versions_status`][codeartifact_update_package_versions_status].
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_delete_package_versions/](https://www.paws-r-sdk.com/docs/codeartifact_delete_package_versions/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the package to delete.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository that contains the package versions to delete.
#' @param format &#91;required&#93; The format of the package versions to delete.
#' @param namespace The namespace of the package versions to be deleted. The package version
#' component that specifies its namespace depends on its type. For example:
#' 
#' -   The namespace of a Maven package version is its `groupId`. The
#'     namespace is required when deleting Maven package versions.
#' 
#' -   The namespace of an npm package version is its `scope`.
#' 
#' -   Python and NuGet package versions do not contain a corresponding
#'     component, package versions of those formats do not have a
#'     namespace.
#' 
#' -   The namespace of a generic package is its `namespace`.
#' @param package &#91;required&#93; The name of the package with the versions to delete.
#' @param versions &#91;required&#93; An array of strings that specify the versions of the package to delete.
#' @param expectedStatus The expected status of the package version to delete.
#'
#' @keywords internal
#'
#' @rdname codeartifact_delete_package_versions
codeartifact_delete_package_versions <- function(domain, domainOwner = NULL, repository, format, namespace = NULL, package, versions, expectedStatus = NULL) {
  op <- new_operation(
    name = "DeletePackageVersions",
    http_method = "POST",
    http_path = "/v1/package/versions/delete",
    paginator = list()
  )
  input <- .codeartifact$delete_package_versions_input(domain = domain, domainOwner = domainOwner, repository = repository, format = format, namespace = namespace, package = package, versions = versions, expectedStatus = expectedStatus)
  output <- .codeartifact$delete_package_versions_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$delete_package_versions <- codeartifact_delete_package_versions

#' Deletes a repository
#'
#' @description
#' Deletes a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_delete_repository/](https://www.paws-r-sdk.com/docs/codeartifact_delete_repository/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository to delete.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository to delete.
#'
#' @keywords internal
#'
#' @rdname codeartifact_delete_repository
codeartifact_delete_repository <- function(domain, domainOwner = NULL, repository) {
  op <- new_operation(
    name = "DeleteRepository",
    http_method = "DELETE",
    http_path = "/v1/repository",
    paginator = list()
  )
  input <- .codeartifact$delete_repository_input(domain = domain, domainOwner = domainOwner, repository = repository)
  output <- .codeartifact$delete_repository_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$delete_repository <- codeartifact_delete_repository

#' Deletes the resource policy that is set on a repository
#'
#' @description
#' Deletes the resource policy that is set on a repository. After a resource policy is deleted, the permissions allowed and denied by the deleted policy are removed. The effect of deleting a resource policy might not be immediate.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_delete_repository_permissions_policy/](https://www.paws-r-sdk.com/docs/codeartifact_delete_repository_permissions_policy/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository associated with the
#' resource policy to be deleted.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository that is associated with the resource policy
#' to be deleted
#' @param policyRevision The revision of the repository's resource policy to be deleted. This
#' revision is used for optimistic locking, which prevents others from
#' accidentally overwriting your changes to the repository's resource
#' policy.
#'
#' @keywords internal
#'
#' @rdname codeartifact_delete_repository_permissions_policy
codeartifact_delete_repository_permissions_policy <- function(domain, domainOwner = NULL, repository, policyRevision = NULL) {
  op <- new_operation(
    name = "DeleteRepositoryPermissionsPolicy",
    http_method = "DELETE",
    http_path = "/v1/repository/permissions/policies",
    paginator = list()
  )
  input <- .codeartifact$delete_repository_permissions_policy_input(domain = domain, domainOwner = domainOwner, repository = repository, policyRevision = policyRevision)
  output <- .codeartifact$delete_repository_permissions_policy_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$delete_repository_permissions_policy <- codeartifact_delete_repository_permissions_policy

#' Returns a DomainDescription object that contains information about the
#' requested domain
#'
#' @description
#' Returns a [DomainDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainDescription.html) object that contains information about the requested domain.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_describe_domain/](https://www.paws-r-sdk.com/docs/codeartifact_describe_domain/) for full documentation.
#'
#' @param domain &#91;required&#93; A string that specifies the name of the requested domain.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#'
#' @keywords internal
#'
#' @rdname codeartifact_describe_domain
codeartifact_describe_domain <- function(domain, domainOwner = NULL) {
  op <- new_operation(
    name = "DescribeDomain",
    http_method = "GET",
    http_path = "/v1/domain",
    paginator = list()
  )
  input <- .codeartifact$describe_domain_input(domain = domain, domainOwner = domainOwner)
  output <- .codeartifact$describe_domain_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$describe_domain <- codeartifact_describe_domain

#' Returns a PackageDescription object that contains information about the
#' requested package
#'
#' @description
#' Returns a [PackageDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDescription.html) object that contains information about the requested package.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_describe_package/](https://www.paws-r-sdk.com/docs/codeartifact_describe_package/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository that contains the
#' package.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository that contains the requested package.
#' @param format &#91;required&#93; A format that specifies the type of the requested package.
#' @param namespace The namespace of the requested package. The package component that
#' specifies its namespace depends on its type. For example:
#' 
#' -   The namespace of a Maven package is its `groupId`. The namespace is
#'     required when requesting Maven packages.
#' 
#' -   The namespace of an npm package is its `scope`.
#' 
#' -   Python and NuGet packages do not contain a corresponding component,
#'     packages of those formats do not have a namespace.
#' 
#' -   The namespace of a generic package is its `namespace`.
#' @param package &#91;required&#93; The name of the requested package.
#'
#' @keywords internal
#'
#' @rdname codeartifact_describe_package
codeartifact_describe_package <- function(domain, domainOwner = NULL, repository, format, namespace = NULL, package) {
  op <- new_operation(
    name = "DescribePackage",
    http_method = "GET",
    http_path = "/v1/package",
    paginator = list()
  )
  input <- .codeartifact$describe_package_input(domain = domain, domainOwner = domainOwner, repository = repository, format = format, namespace = namespace, package = package)
  output <- .codeartifact$describe_package_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$describe_package <- codeartifact_describe_package

#' Returns a PackageVersionDescription object that contains information
#' about the requested package version
#'
#' @description
#' Returns a [PackageVersionDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html) object that contains information about the requested package version.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_describe_package_version/](https://www.paws-r-sdk.com/docs/codeartifact_describe_package_version/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository that contains the
#' package version.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository that contains the package version.
#' @param format &#91;required&#93; A format that specifies the type of the requested package version.
#' @param namespace The namespace of the requested package version. The package version
#' component that specifies its namespace depends on its type. For example:
#' 
#' -   The namespace of a Maven package version is its `groupId`.
#' 
#' -   The namespace of an npm package version is its `scope`.
#' 
#' -   Python and NuGet package versions do not contain a corresponding
#'     component, package versions of those formats do not have a
#'     namespace.
#' 
#' -   The namespace of a generic package is its `namespace`.
#' @param package &#91;required&#93; The name of the requested package version.
#' @param packageVersion &#91;required&#93; A string that contains the package version (for example, `3.5.2`).
#'
#' @keywords internal
#'
#' @rdname codeartifact_describe_package_version
codeartifact_describe_package_version <- function(domain, domainOwner = NULL, repository, format, namespace = NULL, package, packageVersion) {
  op <- new_operation(
    name = "DescribePackageVersion",
    http_method = "GET",
    http_path = "/v1/package/version",
    paginator = list()
  )
  input <- .codeartifact$describe_package_version_input(domain = domain, domainOwner = domainOwner, repository = repository, format = format, namespace = namespace, package = package, packageVersion = packageVersion)
  output <- .codeartifact$describe_package_version_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$describe_package_version <- codeartifact_describe_package_version

#' Returns a RepositoryDescription object that contains detailed
#' information about the requested repository
#'
#' @description
#' Returns a `RepositoryDescription` object that contains detailed information about the requested repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_describe_repository/](https://www.paws-r-sdk.com/docs/codeartifact_describe_repository/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository to describe.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; A string that specifies the name of the requested repository.
#'
#' @keywords internal
#'
#' @rdname codeartifact_describe_repository
codeartifact_describe_repository <- function(domain, domainOwner = NULL, repository) {
  op <- new_operation(
    name = "DescribeRepository",
    http_method = "GET",
    http_path = "/v1/repository",
    paginator = list()
  )
  input <- .codeartifact$describe_repository_input(domain = domain, domainOwner = domainOwner, repository = repository)
  output <- .codeartifact$describe_repository_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$describe_repository <- codeartifact_describe_repository

#' Removes an existing external connection from a repository
#'
#' @description
#' Removes an existing external connection from a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_disassociate_external_connection/](https://www.paws-r-sdk.com/docs/codeartifact_disassociate_external_connection/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository from which to remove
#' the external repository.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository from which the external connection will be
#' removed.
#' @param externalConnection &#91;required&#93; The name of the external connection to be removed from the repository.
#'
#' @keywords internal
#'
#' @rdname codeartifact_disassociate_external_connection
codeartifact_disassociate_external_connection <- function(domain, domainOwner = NULL, repository, externalConnection) {
  op <- new_operation(
    name = "DisassociateExternalConnection",
    http_method = "DELETE",
    http_path = "/v1/repository/external-connection",
    paginator = list()
  )
  input <- .codeartifact$disassociate_external_connection_input(domain = domain, domainOwner = domainOwner, repository = repository, externalConnection = externalConnection)
  output <- .codeartifact$disassociate_external_connection_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$disassociate_external_connection <- codeartifact_disassociate_external_connection

#' Deletes the assets in package versions and sets the package versions'
#' status to Disposed
#'
#' @description
#' Deletes the assets in package versions and sets the package versions' status to `Disposed`. A disposed package version cannot be restored in your repository because its assets are deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_dispose_package_versions/](https://www.paws-r-sdk.com/docs/codeartifact_dispose_package_versions/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository you want to dispose.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository that contains the package versions you want
#' to dispose.
#' @param format &#91;required&#93; A format that specifies the type of package versions you want to
#' dispose.
#' @param namespace The namespace of the package versions to be disposed. The package
#' version component that specifies its namespace depends on its type. For
#' example:
#' 
#' -   The namespace of a Maven package version is its `groupId`.
#' 
#' -   The namespace of an npm package version is its `scope`.
#' 
#' -   Python and NuGet package versions do not contain a corresponding
#'     component, package versions of those formats do not have a
#'     namespace.
#' 
#' -   The namespace of a generic package is its `namespace`.
#' @param package &#91;required&#93; The name of the package with the versions you want to dispose.
#' @param versions &#91;required&#93; The versions of the package you want to dispose.
#' @param versionRevisions The revisions of the package versions you want to dispose.
#' @param expectedStatus The expected status of the package version to dispose.
#'
#' @keywords internal
#'
#' @rdname codeartifact_dispose_package_versions
codeartifact_dispose_package_versions <- function(domain, domainOwner = NULL, repository, format, namespace = NULL, package, versions, versionRevisions = NULL, expectedStatus = NULL) {
  op <- new_operation(
    name = "DisposePackageVersions",
    http_method = "POST",
    http_path = "/v1/package/versions/dispose",
    paginator = list()
  )
  input <- .codeartifact$dispose_package_versions_input(domain = domain, domainOwner = domainOwner, repository = repository, format = format, namespace = namespace, package = package, versions = versions, versionRevisions = versionRevisions, expectedStatus = expectedStatus)
  output <- .codeartifact$dispose_package_versions_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$dispose_package_versions <- codeartifact_dispose_package_versions

#' Generates a temporary authorization token for accessing repositories in
#' the domain
#'
#' @description
#' Generates a temporary authorization token for accessing repositories in the domain. This API requires the `codeartifact:GetAuthorizationToken` and `sts:GetServiceBearerToken` permissions. For more information about authorization tokens, see [CodeArtifact authentication and tokens](https://docs.aws.amazon.com/codeartifact/latest/ug/tokens-authentication.html).
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_get_authorization_token/](https://www.paws-r-sdk.com/docs/codeartifact_get_authorization_token/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that is in scope for the generated authorization
#' token.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param durationSeconds The time, in seconds, that the generated authorization token is valid.
#' Valid values are `0` and any number between `900` (15 minutes) and
#' `43200` (12 hours). A value of `0` will set the expiration of the
#' authorization token to the same expiration of the user's role's
#' temporary credentials.
#'
#' @keywords internal
#'
#' @rdname codeartifact_get_authorization_token
codeartifact_get_authorization_token <- function(domain, domainOwner = NULL, durationSeconds = NULL) {
  op <- new_operation(
    name = "GetAuthorizationToken",
    http_method = "POST",
    http_path = "/v1/authorization-token",
    paginator = list()
  )
  input <- .codeartifact$get_authorization_token_input(domain = domain, domainOwner = domainOwner, durationSeconds = durationSeconds)
  output <- .codeartifact$get_authorization_token_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$get_authorization_token <- codeartifact_get_authorization_token

#' Returns the resource policy attached to the specified domain
#'
#' @description
#' Returns the resource policy attached to the specified domain.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_get_domain_permissions_policy/](https://www.paws-r-sdk.com/docs/codeartifact_get_domain_permissions_policy/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain to which the resource policy is attached.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#'
#' @keywords internal
#'
#' @rdname codeartifact_get_domain_permissions_policy
codeartifact_get_domain_permissions_policy <- function(domain, domainOwner = NULL) {
  op <- new_operation(
    name = "GetDomainPermissionsPolicy",
    http_method = "GET",
    http_path = "/v1/domain/permissions/policy",
    paginator = list()
  )
  input <- .codeartifact$get_domain_permissions_policy_input(domain = domain, domainOwner = domainOwner)
  output <- .codeartifact$get_domain_permissions_policy_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$get_domain_permissions_policy <- codeartifact_get_domain_permissions_policy

#' Returns an asset (or file) that is in a package
#'
#' @description
#' Returns an asset (or file) that is in a package. For example, for a Maven package version, use [`get_package_version_asset`][codeartifact_get_package_version_asset] to download a `JAR` file, a `POM` file, or any other assets in the package version.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_get_package_version_asset/](https://www.paws-r-sdk.com/docs/codeartifact_get_package_version_asset/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository that contains the
#' package version with the requested asset.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The repository that contains the package version with the requested
#' asset.
#' @param format &#91;required&#93; A format that specifies the type of the package version with the
#' requested asset file.
#' @param namespace The namespace of the package version with the requested asset file. The
#' package version component that specifies its namespace depends on its
#' type. For example:
#' 
#' -   The namespace of a Maven package version is its `groupId`.
#' 
#' -   The namespace of an npm package version is its `scope`.
#' 
#' -   Python and NuGet package versions do not contain a corresponding
#'     component, package versions of those formats do not have a
#'     namespace.
#' 
#' -   The namespace of a generic package is its `namespace`.
#' @param package &#91;required&#93; The name of the package that contains the requested asset.
#' @param packageVersion &#91;required&#93; A string that contains the package version (for example, `3.5.2`).
#' @param asset &#91;required&#93; The name of the requested asset.
#' @param packageVersionRevision The name of the package version revision that contains the requested
#' asset.
#'
#' @keywords internal
#'
#' @rdname codeartifact_get_package_version_asset
codeartifact_get_package_version_asset <- function(domain, domainOwner = NULL, repository, format, namespace = NULL, package, packageVersion, asset, packageVersionRevision = NULL) {
  op <- new_operation(
    name = "GetPackageVersionAsset",
    http_method = "GET",
    http_path = "/v1/package/version/asset",
    paginator = list()
  )
  input <- .codeartifact$get_package_version_asset_input(domain = domain, domainOwner = domainOwner, repository = repository, format = format, namespace = namespace, package = package, packageVersion = packageVersion, asset = asset, packageVersionRevision = packageVersionRevision)
  output <- .codeartifact$get_package_version_asset_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$get_package_version_asset <- codeartifact_get_package_version_asset

#' Gets the readme file or descriptive text for a package version
#'
#' @description
#' Gets the readme file or descriptive text for a package version.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_get_package_version_readme/](https://www.paws-r-sdk.com/docs/codeartifact_get_package_version_readme/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository that contains the
#' package version with the requested readme file.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The repository that contains the package with the requested readme file.
#' @param format &#91;required&#93; A format that specifies the type of the package version with the
#' requested readme file.
#' @param namespace The namespace of the package version with the requested readme file. The
#' package version component that specifies its namespace depends on its
#' type. For example:
#' 
#' -   The namespace of an npm package version is its `scope`.
#' 
#' -   Python and NuGet package versions do not contain a corresponding
#'     component, package versions of those formats do not have a
#'     namespace.
#' @param package &#91;required&#93; The name of the package version that contains the requested readme file.
#' @param packageVersion &#91;required&#93; A string that contains the package version (for example, `3.5.2`).
#'
#' @keywords internal
#'
#' @rdname codeartifact_get_package_version_readme
codeartifact_get_package_version_readme <- function(domain, domainOwner = NULL, repository, format, namespace = NULL, package, packageVersion) {
  op <- new_operation(
    name = "GetPackageVersionReadme",
    http_method = "GET",
    http_path = "/v1/package/version/readme",
    paginator = list()
  )
  input <- .codeartifact$get_package_version_readme_input(domain = domain, domainOwner = domainOwner, repository = repository, format = format, namespace = namespace, package = package, packageVersion = packageVersion)
  output <- .codeartifact$get_package_version_readme_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$get_package_version_readme <- codeartifact_get_package_version_readme

#' Returns the endpoint of a repository for a specific package format
#'
#' @description
#' Returns the endpoint of a repository for a specific package format. A repository has one endpoint for each package format:
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_get_repository_endpoint/](https://www.paws-r-sdk.com/docs/codeartifact_get_repository_endpoint/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain that contains the repository. It does not include dashes or
#' spaces.
#' @param repository &#91;required&#93; The name of the repository.
#' @param format &#91;required&#93; Returns which endpoint of a repository to return. A repository has one
#' endpoint for each package format.
#'
#' @keywords internal
#'
#' @rdname codeartifact_get_repository_endpoint
codeartifact_get_repository_endpoint <- function(domain, domainOwner = NULL, repository, format) {
  op <- new_operation(
    name = "GetRepositoryEndpoint",
    http_method = "GET",
    http_path = "/v1/repository/endpoint",
    paginator = list()
  )
  input <- .codeartifact$get_repository_endpoint_input(domain = domain, domainOwner = domainOwner, repository = repository, format = format)
  output <- .codeartifact$get_repository_endpoint_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$get_repository_endpoint <- codeartifact_get_repository_endpoint

#' Returns the resource policy that is set on a repository
#'
#' @description
#' Returns the resource policy that is set on a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_get_repository_permissions_policy/](https://www.paws-r-sdk.com/docs/codeartifact_get_repository_permissions_policy/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain containing the repository whose associated
#' resource policy is to be retrieved.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository whose associated resource policy is to be
#' retrieved.
#'
#' @keywords internal
#'
#' @rdname codeartifact_get_repository_permissions_policy
codeartifact_get_repository_permissions_policy <- function(domain, domainOwner = NULL, repository) {
  op <- new_operation(
    name = "GetRepositoryPermissionsPolicy",
    http_method = "GET",
    http_path = "/v1/repository/permissions/policy",
    paginator = list()
  )
  input <- .codeartifact$get_repository_permissions_policy_input(domain = domain, domainOwner = domainOwner, repository = repository)
  output <- .codeartifact$get_repository_permissions_policy_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$get_repository_permissions_policy <- codeartifact_get_repository_permissions_policy

#' Returns a list of DomainSummary objects for all domains owned by the
#' Amazon Web Services account that makes this call
#'
#' @description
#' Returns a list of [DomainSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html) objects for all domains owned by the Amazon Web Services account that makes this call. Each returned `DomainSummary` object contains information about a domain.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_list_domains/](https://www.paws-r-sdk.com/docs/codeartifact_list_domains/) for full documentation.
#'
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname codeartifact_list_domains
codeartifact_list_domains <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListDomains",
    http_method = "POST",
    http_path = "/v1/domains",
    paginator = list()
  )
  input <- .codeartifact$list_domains_input(maxResults = maxResults, nextToken = nextToken)
  output <- .codeartifact$list_domains_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$list_domains <- codeartifact_list_domains

#' Returns a list of AssetSummary objects for assets in a package version
#'
#' @description
#' Returns a list of [AssetSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html) objects for assets in a package version.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_list_package_version_assets/](https://www.paws-r-sdk.com/docs/codeartifact_list_package_version_assets/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository associated with the
#' package version assets.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository that contains the package that contains the
#' requested package version assets.
#' @param format &#91;required&#93; The format of the package that contains the requested package version
#' assets.
#' @param namespace The namespace of the package version that contains the requested package
#' version assets. The package version component that specifies its
#' namespace depends on its type. For example:
#' 
#' -   The namespace of a Maven package version is its `groupId`.
#' 
#' -   The namespace of an npm package version is its `scope`.
#' 
#' -   Python and NuGet package versions do not contain a corresponding
#'     component, package versions of those formats do not have a
#'     namespace.
#' 
#' -   The namespace of a generic package is its `namespace`.
#' @param package &#91;required&#93; The name of the package that contains the requested package version
#' assets.
#' @param packageVersion &#91;required&#93; A string that contains the package version (for example, `3.5.2`).
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname codeartifact_list_package_version_assets
codeartifact_list_package_version_assets <- function(domain, domainOwner = NULL, repository, format, namespace = NULL, package, packageVersion, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListPackageVersionAssets",
    http_method = "POST",
    http_path = "/v1/package/version/assets",
    paginator = list()
  )
  input <- .codeartifact$list_package_version_assets_input(domain = domain, domainOwner = domainOwner, repository = repository, format = format, namespace = namespace, package = package, packageVersion = packageVersion, maxResults = maxResults, nextToken = nextToken)
  output <- .codeartifact$list_package_version_assets_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$list_package_version_assets <- codeartifact_list_package_version_assets

#' Returns the direct dependencies for a package version
#'
#' @description
#' Returns the direct dependencies for a package version. The dependencies are returned as [PackageDependency](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html) objects. CodeArtifact extracts the dependencies for a package version from the metadata file for the package format (for example, the `package.json` file for npm packages and the `pom.xml` file for Maven). Any package version dependencies that are not listed in the configuration file are not returned.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_list_package_version_dependencies/](https://www.paws-r-sdk.com/docs/codeartifact_list_package_version_dependencies/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository that contains the
#' requested package version dependencies.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository that contains the requested package version.
#' @param format &#91;required&#93; The format of the package with the requested dependencies.
#' @param namespace The namespace of the package version with the requested dependencies.
#' The package version component that specifies its namespace depends on
#' its type. For example:
#' 
#' -   The namespace of a Maven package version is its `groupId`.
#' 
#' -   The namespace of an npm package version is its `scope`.
#' 
#' -   Python and NuGet package versions do not contain a corresponding
#'     component, package versions of those formats do not have a
#'     namespace.
#' 
#' -   The namespace of a generic package is its `namespace`.
#' @param package &#91;required&#93; The name of the package versions' package.
#' @param packageVersion &#91;required&#93; A string that contains the package version (for example, `3.5.2`).
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname codeartifact_list_package_version_dependencies
codeartifact_list_package_version_dependencies <- function(domain, domainOwner = NULL, repository, format, namespace = NULL, package, packageVersion, nextToken = NULL) {
  op <- new_operation(
    name = "ListPackageVersionDependencies",
    http_method = "POST",
    http_path = "/v1/package/version/dependencies",
    paginator = list()
  )
  input <- .codeartifact$list_package_version_dependencies_input(domain = domain, domainOwner = domainOwner, repository = repository, format = format, namespace = namespace, package = package, packageVersion = packageVersion, nextToken = nextToken)
  output <- .codeartifact$list_package_version_dependencies_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$list_package_version_dependencies <- codeartifact_list_package_version_dependencies

#' Returns a list of PackageVersionSummary objects for package versions in
#' a repository that match the request parameters
#'
#' @description
#' Returns a list of [PackageVersionSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html) objects for package versions in a repository that match the request parameters. Package versions of all statuses will be returned by default when calling `list-package-versions` with no `--status` parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_list_package_versions/](https://www.paws-r-sdk.com/docs/codeartifact_list_package_versions/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository that contains the
#' requested package versions.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository that contains the requested package versions.
#' @param format &#91;required&#93; The format of the package versions you want to list.
#' @param namespace The namespace of the package that contains the requested package
#' versions. The package component that specifies its namespace depends on
#' its type. For example:
#' 
#' -   The namespace of a Maven package is its `groupId`.
#' 
#' -   The namespace of an npm package is its `scope`.
#' 
#' -   Python and NuGet packages do not contain a corresponding component,
#'     packages of those formats do not have a namespace.
#' 
#' -   The namespace of a generic package is its `namespace`.
#' @param package &#91;required&#93; The name of the package for which you want to request package versions.
#' @param status A string that filters the requested package versions by status.
#' @param sortBy How to sort the requested list of package versions.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param originType The `originType` used to filter package versions. Only package versions
#' with the provided `originType` will be returned.
#'
#' @keywords internal
#'
#' @rdname codeartifact_list_package_versions
codeartifact_list_package_versions <- function(domain, domainOwner = NULL, repository, format, namespace = NULL, package, status = NULL, sortBy = NULL, maxResults = NULL, nextToken = NULL, originType = NULL) {
  op <- new_operation(
    name = "ListPackageVersions",
    http_method = "POST",
    http_path = "/v1/package/versions",
    paginator = list()
  )
  input <- .codeartifact$list_package_versions_input(domain = domain, domainOwner = domainOwner, repository = repository, format = format, namespace = namespace, package = package, status = status, sortBy = sortBy, maxResults = maxResults, nextToken = nextToken, originType = originType)
  output <- .codeartifact$list_package_versions_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$list_package_versions <- codeartifact_list_package_versions

#' Returns a list of PackageSummary objects for packages in a repository
#' that match the request parameters
#'
#' @description
#' Returns a list of [PackageSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html) objects for packages in a repository that match the request parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_list_packages/](https://www.paws-r-sdk.com/docs/codeartifact_list_packages/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository that contains the
#' requested packages.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository that contains the requested packages.
#' @param format The format used to filter requested packages. Only packages from the
#' provided format will be returned.
#' @param namespace The namespace prefix used to filter requested packages. Only packages
#' with a namespace that starts with the provided string value are
#' returned. Note that although this option is called `--namespace` and not
#' `--namespace-prefix`, it has prefix-matching behavior.
#' 
#' Each package format uses namespace as follows:
#' 
#' -   The namespace of a Maven package is its `groupId`.
#' 
#' -   The namespace of an npm package is its `scope`.
#' 
#' -   Python and NuGet packages do not contain a corresponding component,
#'     packages of those formats do not have a namespace.
#' 
#' -   The namespace of a generic package is its `namespace`.
#' @param packagePrefix A prefix used to filter requested packages. Only packages with names
#' that start with `packagePrefix` are returned.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param publish The value of the `Publish` package origin control restriction used to
#' filter requested packages. Only packages with the provided restriction
#' are returned. For more information, see
#' [PackageOriginRestrictions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html).
#' @param upstream The value of the `Upstream` package origin control restriction used to
#' filter requested packages. Only packages with the provided restriction
#' are returned. For more information, see
#' [PackageOriginRestrictions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html).
#'
#' @keywords internal
#'
#' @rdname codeartifact_list_packages
codeartifact_list_packages <- function(domain, domainOwner = NULL, repository, format = NULL, namespace = NULL, packagePrefix = NULL, maxResults = NULL, nextToken = NULL, publish = NULL, upstream = NULL) {
  op <- new_operation(
    name = "ListPackages",
    http_method = "POST",
    http_path = "/v1/packages",
    paginator = list()
  )
  input <- .codeartifact$list_packages_input(domain = domain, domainOwner = domainOwner, repository = repository, format = format, namespace = namespace, packagePrefix = packagePrefix, maxResults = maxResults, nextToken = nextToken, publish = publish, upstream = upstream)
  output <- .codeartifact$list_packages_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$list_packages <- codeartifact_list_packages

#' Returns a list of RepositorySummary objects
#'
#' @description
#' Returns a list of [RepositorySummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html) objects. Each `RepositorySummary` contains information about a repository in the specified Amazon Web Services account and that matches the input parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_list_repositories/](https://www.paws-r-sdk.com/docs/codeartifact_list_repositories/) for full documentation.
#'
#' @param repositoryPrefix A prefix used to filter returned repositories. Only repositories with
#' names that start with `repositoryPrefix` are returned.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname codeartifact_list_repositories
codeartifact_list_repositories <- function(repositoryPrefix = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListRepositories",
    http_method = "POST",
    http_path = "/v1/repositories",
    paginator = list()
  )
  input <- .codeartifact$list_repositories_input(repositoryPrefix = repositoryPrefix, maxResults = maxResults, nextToken = nextToken)
  output <- .codeartifact$list_repositories_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$list_repositories <- codeartifact_list_repositories

#' Returns a list of RepositorySummary objects
#'
#' @description
#' Returns a list of [RepositorySummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html) objects. Each `RepositorySummary` contains information about a repository in the specified domain and that matches the input parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_list_repositories_in_domain/](https://www.paws-r-sdk.com/docs/codeartifact_list_repositories_in_domain/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the returned list of repositories.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param administratorAccount Filter the list of repositories to only include those that are managed
#' by the Amazon Web Services account ID.
#' @param repositoryPrefix A prefix used to filter returned repositories. Only repositories with
#' names that start with `repositoryPrefix` are returned.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname codeartifact_list_repositories_in_domain
codeartifact_list_repositories_in_domain <- function(domain, domainOwner = NULL, administratorAccount = NULL, repositoryPrefix = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListRepositoriesInDomain",
    http_method = "POST",
    http_path = "/v1/domain/repositories",
    paginator = list()
  )
  input <- .codeartifact$list_repositories_in_domain_input(domain = domain, domainOwner = domainOwner, administratorAccount = administratorAccount, repositoryPrefix = repositoryPrefix, maxResults = maxResults, nextToken = nextToken)
  output <- .codeartifact$list_repositories_in_domain_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$list_repositories_in_domain <- codeartifact_list_repositories_in_domain

#' Gets information about Amazon Web Services tags for a specified Amazon
#' Resource Name (ARN) in CodeArtifact
#'
#' @description
#' Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in CodeArtifact.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/codeartifact_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to get tags for.
#'
#' @keywords internal
#'
#' @rdname codeartifact_list_tags_for_resource
codeartifact_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/v1/tags",
    paginator = list()
  )
  input <- .codeartifact$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .codeartifact$list_tags_for_resource_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$list_tags_for_resource <- codeartifact_list_tags_for_resource

#' Creates a new package version containing one or more assets (or files)
#'
#' @description
#' Creates a new package version containing one or more assets (or files).
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_publish_package_version/](https://www.paws-r-sdk.com/docs/codeartifact_publish_package_version/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository that contains the
#' package version to publish.
#' @param domainOwner The 12-digit account number of the AWS account that owns the domain. It
#' does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository that the package version will be published
#' to.
#' @param format &#91;required&#93; A format that specifies the type of the package version with the
#' requested asset file.
#' @param namespace The namespace of the package version to publish.
#' @param package &#91;required&#93; The name of the package version to publish.
#' @param packageVersion &#91;required&#93; The package version to publish (for example, `3.5.2`).
#' @param assetContent &#91;required&#93; The content of the asset to publish.
#' @param assetName &#91;required&#93; The name of the asset to publish. Asset names can include Unicode
#' letters and numbers, and the following special characters:
#' `` ~ ! @@ ^ & ( ) - ` _ + [ ] { } ; , . ` ``
#' @param assetSHA256 &#91;required&#93; The SHA256 hash of the `assetContent` to publish. This value must be
#' calculated by the caller and provided with the request (see [Publishing
#' a generic
#' package](https://docs.aws.amazon.com/codeartifact/latest/ug/using-generic.html#publishing-generic-packages)
#' in the *CodeArtifact User Guide*).
#' 
#' This value is used as an integrity check to verify that the
#' `assetContent` has not changed after it was originally sent.
#' @param unfinished Specifies whether the package version should remain in the `unfinished`
#' state. If omitted, the package version status will be set to `Published`
#' (see [Package version
#' status](https://docs.aws.amazon.com/codeartifact/latest/ug/packages-overview.html#package-version-status)
#' in the *CodeArtifact User Guide*).
#' 
#' Valid values: `unfinished`
#'
#' @keywords internal
#'
#' @rdname codeartifact_publish_package_version
codeartifact_publish_package_version <- function(domain, domainOwner = NULL, repository, format, namespace = NULL, package, packageVersion, assetContent, assetName, assetSHA256, unfinished = NULL) {
  op <- new_operation(
    name = "PublishPackageVersion",
    http_method = "POST",
    http_path = "/v1/package/version/publish",
    paginator = list()
  )
  input <- .codeartifact$publish_package_version_input(domain = domain, domainOwner = domainOwner, repository = repository, format = format, namespace = namespace, package = package, packageVersion = packageVersion, assetContent = assetContent, assetName = assetName, assetSHA256 = assetSHA256, unfinished = unfinished)
  output <- .codeartifact$publish_package_version_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$publish_package_version <- codeartifact_publish_package_version

#' Sets a resource policy on a domain that specifies permissions to access
#' it
#'
#' @description
#' Sets a resource policy on a domain that specifies permissions to access it.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_put_domain_permissions_policy/](https://www.paws-r-sdk.com/docs/codeartifact_put_domain_permissions_policy/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain on which to set the resource policy.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param policyRevision The current revision of the resource policy to be set. This revision is
#' used for optimistic locking, which prevents others from overwriting your
#' changes to the domain's resource policy.
#' @param policyDocument &#91;required&#93; A valid displayable JSON Aspen policy string to be set as the access
#' control resource policy on the provided domain.
#'
#' @keywords internal
#'
#' @rdname codeartifact_put_domain_permissions_policy
codeartifact_put_domain_permissions_policy <- function(domain, domainOwner = NULL, policyRevision = NULL, policyDocument) {
  op <- new_operation(
    name = "PutDomainPermissionsPolicy",
    http_method = "PUT",
    http_path = "/v1/domain/permissions/policy",
    paginator = list()
  )
  input <- .codeartifact$put_domain_permissions_policy_input(domain = domain, domainOwner = domainOwner, policyRevision = policyRevision, policyDocument = policyDocument)
  output <- .codeartifact$put_domain_permissions_policy_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$put_domain_permissions_policy <- codeartifact_put_domain_permissions_policy

#' Sets the package origin configuration for a package
#'
#' @description
#' Sets the package origin configuration for a package.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_put_package_origin_configuration/](https://www.paws-r-sdk.com/docs/codeartifact_put_package_origin_configuration/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository that contains the
#' package.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository that contains the package.
#' @param format &#91;required&#93; A format that specifies the type of the package to be updated.
#' @param namespace The namespace of the package to be updated. The package component that
#' specifies its namespace depends on its type. For example:
#' 
#' -   The namespace of a Maven package is its `groupId`.
#' 
#' -   The namespace of an npm package is its `scope`.
#' 
#' -   Python and NuGet packages do not contain a corresponding component,
#'     packages of those formats do not have a namespace.
#' 
#' -   The namespace of a generic package is its `namespace`.
#' @param package &#91;required&#93; The name of the package to be updated.
#' @param restrictions &#91;required&#93; A
#' [PackageOriginRestrictions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html)
#' object that contains information about the `upstream` and `publish`
#' package origin restrictions. The `upstream` restriction determines if
#' new package versions can be ingested or retained from external
#' connections or upstream repositories. The `publish` restriction
#' determines if new package versions can be published directly to the
#' repository.
#' 
#' You must include both the desired `upstream` and `publish` restrictions.
#'
#' @keywords internal
#'
#' @rdname codeartifact_put_package_origin_configuration
codeartifact_put_package_origin_configuration <- function(domain, domainOwner = NULL, repository, format, namespace = NULL, package, restrictions) {
  op <- new_operation(
    name = "PutPackageOriginConfiguration",
    http_method = "POST",
    http_path = "/v1/package",
    paginator = list()
  )
  input <- .codeartifact$put_package_origin_configuration_input(domain = domain, domainOwner = domainOwner, repository = repository, format = format, namespace = namespace, package = package, restrictions = restrictions)
  output <- .codeartifact$put_package_origin_configuration_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$put_package_origin_configuration <- codeartifact_put_package_origin_configuration

#' Sets the resource policy on a repository that specifies permissions to
#' access it
#'
#' @description
#' Sets the resource policy on a repository that specifies permissions to access it.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_put_repository_permissions_policy/](https://www.paws-r-sdk.com/docs/codeartifact_put_repository_permissions_policy/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain containing the repository to set the resource
#' policy on.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository to set the resource policy on.
#' @param policyRevision Sets the revision of the resource policy that specifies permissions to
#' access the repository. This revision is used for optimistic locking,
#' which prevents others from overwriting your changes to the repository's
#' resource policy.
#' @param policyDocument &#91;required&#93; A valid displayable JSON Aspen policy string to be set as the access
#' control resource policy on the provided repository.
#'
#' @keywords internal
#'
#' @rdname codeartifact_put_repository_permissions_policy
codeartifact_put_repository_permissions_policy <- function(domain, domainOwner = NULL, repository, policyRevision = NULL, policyDocument) {
  op <- new_operation(
    name = "PutRepositoryPermissionsPolicy",
    http_method = "PUT",
    http_path = "/v1/repository/permissions/policy",
    paginator = list()
  )
  input <- .codeartifact$put_repository_permissions_policy_input(domain = domain, domainOwner = domainOwner, repository = repository, policyRevision = policyRevision, policyDocument = policyDocument)
  output <- .codeartifact$put_repository_permissions_policy_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$put_repository_permissions_policy <- codeartifact_put_repository_permissions_policy

#' Adds or updates tags for a resource in CodeArtifact
#'
#' @description
#' Adds or updates tags for a resource in CodeArtifact.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_tag_resource/](https://www.paws-r-sdk.com/docs/codeartifact_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to add or
#' update tags for.
#' @param tags &#91;required&#93; The tags you want to modify or add to the resource.
#'
#' @keywords internal
#'
#' @rdname codeartifact_tag_resource
codeartifact_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/v1/tag",
    paginator = list()
  )
  input <- .codeartifact$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .codeartifact$tag_resource_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$tag_resource <- codeartifact_tag_resource

#' Removes tags from a resource in CodeArtifact
#'
#' @description
#' Removes tags from a resource in CodeArtifact.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_untag_resource/](https://www.paws-r-sdk.com/docs/codeartifact_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to remove
#' tags from.
#' @param tagKeys &#91;required&#93; The tag key for each tag that you want to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname codeartifact_untag_resource
codeartifact_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/v1/untag",
    paginator = list()
  )
  input <- .codeartifact$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .codeartifact$untag_resource_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$untag_resource <- codeartifact_untag_resource

#' Updates the status of one or more versions of a package
#'
#' @description
#' Updates the status of one or more versions of a package. Using [`update_package_versions_status`][codeartifact_update_package_versions_status], you can update the status of package versions to `Archived`, `Published`, or `Unlisted`. To set the status of a package version to `Disposed`, use [`dispose_package_versions`][codeartifact_dispose_package_versions].
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_update_package_versions_status/](https://www.paws-r-sdk.com/docs/codeartifact_update_package_versions_status/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the repository that contains the
#' package versions with a status to be updated.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The repository that contains the package versions with the status you
#' want to update.
#' @param format &#91;required&#93; A format that specifies the type of the package with the statuses to
#' update.
#' @param namespace The namespace of the package version to be updated. The package version
#' component that specifies its namespace depends on its type. For example:
#' 
#' -   The namespace of a Maven package version is its `groupId`.
#' 
#' -   The namespace of an npm package version is its `scope`.
#' 
#' -   Python and NuGet package versions do not contain a corresponding
#'     component, package versions of those formats do not have a
#'     namespace.
#' 
#' -   The namespace of a generic package is its `namespace`.
#' @param package &#91;required&#93; The name of the package with the version statuses to update.
#' @param versions &#91;required&#93; An array of strings that specify the versions of the package with the
#' statuses to update.
#' @param versionRevisions A map of package versions and package version revisions. The map `key`
#' is the package version (for example, `3.5.2`), and the map `value` is
#' the package version revision.
#' @param expectedStatus The package version’s expected status before it is updated. If
#' `expectedStatus` is provided, the package version's status is updated
#' only if its status at the time
#' [`update_package_versions_status`][codeartifact_update_package_versions_status]
#' is called matches `expectedStatus`.
#' @param targetStatus &#91;required&#93; The status you want to change the package version status to.
#'
#' @keywords internal
#'
#' @rdname codeartifact_update_package_versions_status
codeartifact_update_package_versions_status <- function(domain, domainOwner = NULL, repository, format, namespace = NULL, package, versions, versionRevisions = NULL, expectedStatus = NULL, targetStatus) {
  op <- new_operation(
    name = "UpdatePackageVersionsStatus",
    http_method = "POST",
    http_path = "/v1/package/versions/update_status",
    paginator = list()
  )
  input <- .codeartifact$update_package_versions_status_input(domain = domain, domainOwner = domainOwner, repository = repository, format = format, namespace = namespace, package = package, versions = versions, versionRevisions = versionRevisions, expectedStatus = expectedStatus, targetStatus = targetStatus)
  output <- .codeartifact$update_package_versions_status_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$update_package_versions_status <- codeartifact_update_package_versions_status

#' Update the properties of a repository
#'
#' @description
#' Update the properties of a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codeartifact_update_repository/](https://www.paws-r-sdk.com/docs/codeartifact_update_repository/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain associated with the repository to update.
#' @param domainOwner The 12-digit account number of the Amazon Web Services account that owns
#' the domain. It does not include dashes or spaces.
#' @param repository &#91;required&#93; The name of the repository to update.
#' @param description An updated repository description.
#' @param upstreams A list of upstream repositories to associate with the repository. The
#' order of the upstream repositories in the list determines their priority
#' order when CodeArtifact looks for a requested package version. For more
#' information, see [Working with upstream
#' repositories](https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html).
#'
#' @keywords internal
#'
#' @rdname codeartifact_update_repository
codeartifact_update_repository <- function(domain, domainOwner = NULL, repository, description = NULL, upstreams = NULL) {
  op <- new_operation(
    name = "UpdateRepository",
    http_method = "PUT",
    http_path = "/v1/repository",
    paginator = list()
  )
  input <- .codeartifact$update_repository_input(domain = domain, domainOwner = domainOwner, repository = repository, description = description, upstreams = upstreams)
  output <- .codeartifact$update_repository_output()
  config <- get_config()
  svc <- .codeartifact$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeartifact$operations$update_repository <- codeartifact_update_repository
