# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudcontrolapi_service.R
NULL

#' Cancels the specified resource operation request
#'
#' @description
#' Cancels the specified resource operation request. For more information, see [Canceling resource operation requests](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html#resource-operations-manage-requests-cancel) in the *Amazon Web Services Cloud Control API User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudcontrolapi_cancel_resource_request/](https://www.paws-r-sdk.com/docs/cloudcontrolapi_cancel_resource_request/) for full documentation.
#'
#' @param RequestToken &#91;required&#93; The `RequestToken` of the `ProgressEvent` object returned by the
#' resource operation request.
#'
#' @keywords internal
#'
#' @rdname cloudcontrolapi_cancel_resource_request
cloudcontrolapi_cancel_resource_request <- function(RequestToken) {
  op <- new_operation(
    name = "CancelResourceRequest",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudcontrolapi$cancel_resource_request_input(RequestToken = RequestToken)
  output <- .cloudcontrolapi$cancel_resource_request_output()
  config <- get_config()
  svc <- .cloudcontrolapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudcontrolapi$operations$cancel_resource_request <- cloudcontrolapi_cancel_resource_request

#' Creates the specified resource
#'
#' @description
#' Creates the specified resource. For more information, see [Creating a resource](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-create.html) in the *Amazon Web Services Cloud Control API User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudcontrolapi_create_resource/](https://www.paws-r-sdk.com/docs/cloudcontrolapi_create_resource/) for full documentation.
#'
#' @param TypeName &#91;required&#93; The name of the resource type.
#' @param TypeVersionId For private resource types, the type version to use in this resource
#' operation. If you do not specify a resource version, CloudFormation uses
#' the default version.
#' @param RoleArn The Amazon Resource Name (ARN) of the Identity and Access Management
#' (IAM) role for Cloud Control API to use when performing this resource
#' operation. The role specified must have the permissions required for
#' this operation. The necessary permissions for each event handler are
#' defined in the ` handlers ` section of the [resource type definition
#' schema](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html).
#' 
#' If you do not specify a role, Cloud Control API uses a temporary session
#' created using your Amazon Web Services user credentials.
#' 
#' For more information, see [Specifying
#' credentials](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions)
#' in the *Amazon Web Services Cloud Control API User Guide*.
#' @param ClientToken A unique identifier to ensure the idempotency of the resource request.
#' As a best practice, specify this token to ensure idempotency, so that
#' Amazon Web Services Cloud Control API can accurately distinguish between
#' request retries and new resource requests. You might retry a resource
#' request to ensure that it was successfully received.
#' 
#' A client token is valid for 36 hours once used. After that, a resource
#' request with the same client token is treated as a new request.
#' 
#' If you do not specify a client token, one is generated for inclusion in
#' the request.
#' 
#' For more information, see [Ensuring resource operation requests are
#' unique](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency)
#' in the *Amazon Web Services Cloud Control API User Guide*.
#' @param DesiredState &#91;required&#93; Structured data format representing the desired state of the resource,
#' consisting of that resource's properties and their desired values.
#' 
#' Cloud Control API currently supports JSON as a structured data format.
#' 
#'      <p>Specify the desired state as one of the following:</p> <ul> <li> <p>A JSON blob</p> </li> <li> <p>A local path containing the desired state in JSON data format</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-create.html#resource-operations-create-desiredstate">Composing the desired state of the resource</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p> <p>For more information about the properties of a specific resource, refer to the related topic for the resource in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Resource and property types reference</a> in the <i>CloudFormation Users Guide</i>.</p> 
#'
#' @keywords internal
#'
#' @rdname cloudcontrolapi_create_resource
cloudcontrolapi_create_resource <- function(TypeName, TypeVersionId = NULL, RoleArn = NULL, ClientToken = NULL, DesiredState) {
  op <- new_operation(
    name = "CreateResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudcontrolapi$create_resource_input(TypeName = TypeName, TypeVersionId = TypeVersionId, RoleArn = RoleArn, ClientToken = ClientToken, DesiredState = DesiredState)
  output <- .cloudcontrolapi$create_resource_output()
  config <- get_config()
  svc <- .cloudcontrolapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudcontrolapi$operations$create_resource <- cloudcontrolapi_create_resource

#' Deletes the specified resource
#'
#' @description
#' Deletes the specified resource. For details, see [Deleting a resource](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-delete.html) in the *Amazon Web Services Cloud Control API User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudcontrolapi_delete_resource/](https://www.paws-r-sdk.com/docs/cloudcontrolapi_delete_resource/) for full documentation.
#'
#' @param TypeName &#91;required&#93; The name of the resource type.
#' @param TypeVersionId For private resource types, the type version to use in this resource
#' operation. If you do not specify a resource version, CloudFormation uses
#' the default version.
#' @param RoleArn The Amazon Resource Name (ARN) of the Identity and Access Management
#' (IAM) role for Cloud Control API to use when performing this resource
#' operation. The role specified must have the permissions required for
#' this operation. The necessary permissions for each event handler are
#' defined in the ` handlers ` section of the [resource type definition
#' schema](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html).
#' 
#' If you do not specify a role, Cloud Control API uses a temporary session
#' created using your Amazon Web Services user credentials.
#' 
#' For more information, see [Specifying
#' credentials](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions)
#' in the *Amazon Web Services Cloud Control API User Guide*.
#' @param ClientToken A unique identifier to ensure the idempotency of the resource request.
#' As a best practice, specify this token to ensure idempotency, so that
#' Amazon Web Services Cloud Control API can accurately distinguish between
#' request retries and new resource requests. You might retry a resource
#' request to ensure that it was successfully received.
#' 
#' A client token is valid for 36 hours once used. After that, a resource
#' request with the same client token is treated as a new request.
#' 
#' If you do not specify a client token, one is generated for inclusion in
#' the request.
#' 
#' For more information, see [Ensuring resource operation requests are
#' unique](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency)
#' in the *Amazon Web Services Cloud Control API User Guide*.
#' @param Identifier &#91;required&#93; The identifier for the resource.
#' 
#' You can specify the primary identifier, or any secondary identifier
#' defined for the resource type in its resource schema. You can only
#' specify one identifier. Primary identifiers can be specified as a string
#' or JSON; secondary identifiers must be specified as JSON.
#' 
#' For compound primary identifiers (that is, one that consists of multiple
#' resource properties strung together), to specify the primary identifier
#' as a string, list the property values *in the order they are specified*
#' in the primary identifier definition, separated by `|`.
#' 
#' For more information, see [Identifying
#' resources](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html)
#' in the *Amazon Web Services Cloud Control API User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudcontrolapi_delete_resource
cloudcontrolapi_delete_resource <- function(TypeName, TypeVersionId = NULL, RoleArn = NULL, ClientToken = NULL, Identifier) {
  op <- new_operation(
    name = "DeleteResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudcontrolapi$delete_resource_input(TypeName = TypeName, TypeVersionId = TypeVersionId, RoleArn = RoleArn, ClientToken = ClientToken, Identifier = Identifier)
  output <- .cloudcontrolapi$delete_resource_output()
  config <- get_config()
  svc <- .cloudcontrolapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudcontrolapi$operations$delete_resource <- cloudcontrolapi_delete_resource

#' Returns information about the current state of the specified resource
#'
#' @description
#' Returns information about the current state of the specified resource. For details, see [Reading a resource's current state](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-read.html).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudcontrolapi_get_resource/](https://www.paws-r-sdk.com/docs/cloudcontrolapi_get_resource/) for full documentation.
#'
#' @param TypeName &#91;required&#93; The name of the resource type.
#' @param TypeVersionId For private resource types, the type version to use in this resource
#' operation. If you do not specify a resource version, CloudFormation uses
#' the default version.
#' @param RoleArn The Amazon Resource Name (ARN) of the Identity and Access Management
#' (IAM) role for Cloud Control API to use when performing this resource
#' operation. The role specified must have the permissions required for
#' this operation. The necessary permissions for each event handler are
#' defined in the ` handlers ` section of the [resource type definition
#' schema](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html).
#' 
#' If you do not specify a role, Cloud Control API uses a temporary session
#' created using your Amazon Web Services user credentials.
#' 
#' For more information, see [Specifying
#' credentials](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions)
#' in the *Amazon Web Services Cloud Control API User Guide*.
#' @param Identifier &#91;required&#93; The identifier for the resource.
#' 
#' You can specify the primary identifier, or any secondary identifier
#' defined for the resource type in its resource schema. You can only
#' specify one identifier. Primary identifiers can be specified as a string
#' or JSON; secondary identifiers must be specified as JSON.
#' 
#' For compound primary identifiers (that is, one that consists of multiple
#' resource properties strung together), to specify the primary identifier
#' as a string, list the property values *in the order they are specified*
#' in the primary identifier definition, separated by `|`.
#' 
#' For more information, see [Identifying
#' resources](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html)
#' in the *Amazon Web Services Cloud Control API User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudcontrolapi_get_resource
cloudcontrolapi_get_resource <- function(TypeName, TypeVersionId = NULL, RoleArn = NULL, Identifier) {
  op <- new_operation(
    name = "GetResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudcontrolapi$get_resource_input(TypeName = TypeName, TypeVersionId = TypeVersionId, RoleArn = RoleArn, Identifier = Identifier)
  output <- .cloudcontrolapi$get_resource_output()
  config <- get_config()
  svc <- .cloudcontrolapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudcontrolapi$operations$get_resource <- cloudcontrolapi_get_resource

#' Returns the current status of a resource operation request
#'
#' @description
#' Returns the current status of a resource operation request. For more information, see [Tracking the progress of resource operation requests](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html#resource-operations-manage-requests-track) in the *Amazon Web Services Cloud Control API User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudcontrolapi_get_resource_request_status/](https://www.paws-r-sdk.com/docs/cloudcontrolapi_get_resource_request_status/) for full documentation.
#'
#' @param RequestToken &#91;required&#93; A unique token used to track the progress of the resource operation
#' request.
#' 
#' Request tokens are included in the `ProgressEvent` type returned by a
#' resource operation request.
#'
#' @keywords internal
#'
#' @rdname cloudcontrolapi_get_resource_request_status
cloudcontrolapi_get_resource_request_status <- function(RequestToken) {
  op <- new_operation(
    name = "GetResourceRequestStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudcontrolapi$get_resource_request_status_input(RequestToken = RequestToken)
  output <- .cloudcontrolapi$get_resource_request_status_output()
  config <- get_config()
  svc <- .cloudcontrolapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudcontrolapi$operations$get_resource_request_status <- cloudcontrolapi_get_resource_request_status

#' Returns existing resource operation requests
#'
#' @description
#' Returns existing resource operation requests. This includes requests of all status types. For more information, see [Listing active resource operation requests](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html#resource-operations-manage-requests-list) in the *Amazon Web Services Cloud Control API User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudcontrolapi_list_resource_requests/](https://www.paws-r-sdk.com/docs/cloudcontrolapi_list_resource_requests/) for full documentation.
#'
#' @param MaxResults The maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#' 
#' The default is `20`.
#' @param NextToken If the previous paginated request didn't return all of the remaining
#' results, the response object's `NextToken` parameter value is set to a
#' token. To retrieve the next set of results, call this action again and
#' assign that token to the request object's `NextToken` parameter. If
#' there are no remaining results, the previous response object's
#' `NextToken` parameter is set to `null`.
#' @param ResourceRequestStatusFilter The filter criteria to apply to the requests returned.
#'
#' @keywords internal
#'
#' @rdname cloudcontrolapi_list_resource_requests
cloudcontrolapi_list_resource_requests <- function(MaxResults = NULL, NextToken = NULL, ResourceRequestStatusFilter = NULL) {
  op <- new_operation(
    name = "ListResourceRequests",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudcontrolapi$list_resource_requests_input(MaxResults = MaxResults, NextToken = NextToken, ResourceRequestStatusFilter = ResourceRequestStatusFilter)
  output <- .cloudcontrolapi$list_resource_requests_output()
  config <- get_config()
  svc <- .cloudcontrolapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudcontrolapi$operations$list_resource_requests <- cloudcontrolapi_list_resource_requests

#' Returns information about the specified resources
#'
#' @description
#' Returns information about the specified resources. For more information, see [Discovering resources](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-list.html) in the *Amazon Web Services Cloud Control API User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudcontrolapi_list_resources/](https://www.paws-r-sdk.com/docs/cloudcontrolapi_list_resources/) for full documentation.
#'
#' @param TypeName &#91;required&#93; The name of the resource type.
#' @param TypeVersionId For private resource types, the type version to use in this resource
#' operation. If you do not specify a resource version, CloudFormation uses
#' the default version.
#' @param RoleArn The Amazon Resource Name (ARN) of the Identity and Access Management
#' (IAM) role for Cloud Control API to use when performing this resource
#' operation. The role specified must have the permissions required for
#' this operation. The necessary permissions for each event handler are
#' defined in the ` handlers ` section of the [resource type definition
#' schema](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html).
#' 
#' If you do not specify a role, Cloud Control API uses a temporary session
#' created using your Amazon Web Services user credentials.
#' 
#' For more information, see [Specifying
#' credentials](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions)
#' in the *Amazon Web Services Cloud Control API User Guide*.
#' @param NextToken If the previous paginated request didn't return all of the remaining
#' results, the response object's `NextToken` parameter value is set to a
#' token. To retrieve the next set of results, call this action again and
#' assign that token to the request object's `NextToken` parameter. If
#' there are no remaining results, the previous response object's
#' `NextToken` parameter is set to `null`.
#' @param MaxResults Reserved.
#' @param ResourceModel The resource model to use to select the resources to return.
#'
#' @keywords internal
#'
#' @rdname cloudcontrolapi_list_resources
cloudcontrolapi_list_resources <- function(TypeName, TypeVersionId = NULL, RoleArn = NULL, NextToken = NULL, MaxResults = NULL, ResourceModel = NULL) {
  op <- new_operation(
    name = "ListResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudcontrolapi$list_resources_input(TypeName = TypeName, TypeVersionId = TypeVersionId, RoleArn = RoleArn, NextToken = NextToken, MaxResults = MaxResults, ResourceModel = ResourceModel)
  output <- .cloudcontrolapi$list_resources_output()
  config <- get_config()
  svc <- .cloudcontrolapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudcontrolapi$operations$list_resources <- cloudcontrolapi_list_resources

#' Updates the specified property values in the resource
#'
#' @description
#' Updates the specified property values in the resource.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudcontrolapi_update_resource/](https://www.paws-r-sdk.com/docs/cloudcontrolapi_update_resource/) for full documentation.
#'
#' @param TypeName &#91;required&#93; The name of the resource type.
#' @param TypeVersionId For private resource types, the type version to use in this resource
#' operation. If you do not specify a resource version, CloudFormation uses
#' the default version.
#' @param RoleArn The Amazon Resource Name (ARN) of the Identity and Access Management
#' (IAM) role for Cloud Control API to use when performing this resource
#' operation. The role specified must have the permissions required for
#' this operation. The necessary permissions for each event handler are
#' defined in the ` handlers ` section of the [resource type definition
#' schema](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html).
#' 
#' If you do not specify a role, Cloud Control API uses a temporary session
#' created using your Amazon Web Services user credentials.
#' 
#' For more information, see [Specifying
#' credentials](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions)
#' in the *Amazon Web Services Cloud Control API User Guide*.
#' @param ClientToken A unique identifier to ensure the idempotency of the resource request.
#' As a best practice, specify this token to ensure idempotency, so that
#' Amazon Web Services Cloud Control API can accurately distinguish between
#' request retries and new resource requests. You might retry a resource
#' request to ensure that it was successfully received.
#' 
#' A client token is valid for 36 hours once used. After that, a resource
#' request with the same client token is treated as a new request.
#' 
#' If you do not specify a client token, one is generated for inclusion in
#' the request.
#' 
#' For more information, see [Ensuring resource operation requests are
#' unique](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency)
#' in the *Amazon Web Services Cloud Control API User Guide*.
#' @param Identifier &#91;required&#93; The identifier for the resource.
#' 
#' You can specify the primary identifier, or any secondary identifier
#' defined for the resource type in its resource schema. You can only
#' specify one identifier. Primary identifiers can be specified as a string
#' or JSON; secondary identifiers must be specified as JSON.
#' 
#' For compound primary identifiers (that is, one that consists of multiple
#' resource properties strung together), to specify the primary identifier
#' as a string, list the property values *in the order they are specified*
#' in the primary identifier definition, separated by `|`.
#' 
#' For more information, see [Identifying
#' resources](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html)
#' in the *Amazon Web Services Cloud Control API User Guide*.
#' @param PatchDocument &#91;required&#93; A JavaScript Object Notation (JSON) document listing the patch
#' operations that represent the updates to apply to the current resource
#' properties. For details, see [Composing the patch
#' document](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-update.html#resource-operations-update-patch)
#' in the *Amazon Web Services Cloud Control API User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudcontrolapi_update_resource
cloudcontrolapi_update_resource <- function(TypeName, TypeVersionId = NULL, RoleArn = NULL, ClientToken = NULL, Identifier, PatchDocument) {
  op <- new_operation(
    name = "UpdateResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudcontrolapi$update_resource_input(TypeName = TypeName, TypeVersionId = TypeVersionId, RoleArn = RoleArn, ClientToken = ClientToken, Identifier = Identifier, PatchDocument = PatchDocument)
  output <- .cloudcontrolapi$update_resource_output()
  config <- get_config()
  svc <- .cloudcontrolapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudcontrolapi$operations$update_resource <- cloudcontrolapi_update_resource
