% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_merge_branches_by_fast_forward}
\alias{codecommit_merge_branches_by_fast_forward}
\title{Merges two branches using the fast-forward merge strategy}
\usage{
codecommit_merge_branches_by_fast_forward(
  repositoryName,
  sourceCommitSpecifier,
  destinationCommitSpecifier,
  targetBranch = NULL
)
}
\arguments{
\item{repositoryName}{[required] The name of the repository where you want to merge two branches.}

\item{sourceCommitSpecifier}{[required] The branch, tag, HEAD, or other fully qualified reference used to
identify a commit (for example, a branch name or a full commit ID).}

\item{destinationCommitSpecifier}{[required] The branch, tag, HEAD, or other fully qualified reference used to
identify a commit (for example, a branch name or a full commit ID).}

\item{targetBranch}{The branch where the merge is applied.}
}
\description{
Merges two branches using the fast-forward merge strategy.

See \url{https://paws-r.github.io/docs/codecommit/merge_branches_by_fast_forward.html} for full documentation.
}
\keyword{internal}
