% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codedeploy_operations.R
\name{codedeploy_create_deployment_group}
\alias{codedeploy_create_deployment_group}
\title{Creates a deployment group to which application revisions are deployed}
\usage{
codedeploy_create_deployment_group(applicationName, deploymentGroupName,
  deploymentConfigName, ec2TagFilters, onPremisesInstanceTagFilters,
  autoScalingGroups, serviceRoleArn, triggerConfigurations,
  alarmConfiguration, autoRollbackConfiguration, deploymentStyle,
  blueGreenDeploymentConfiguration, loadBalancerInfo, ec2TagSet,
  ecsServices, onPremisesTagSet, tags)
}
\arguments{
\item{applicationName}{[required] The name of an AWS CodeDeploy application associated with the IAM user
or AWS account.}

\item{deploymentGroupName}{[required] The name of a new deployment group for the specified application.}

\item{deploymentConfigName}{If specified, the deployment configuration name can be either one of the
predefined configurations provided with AWS CodeDeploy or a custom
deployment configuration that you create by calling the create
deployment configuration operation.

\code{CodeDeployDefault.OneAtATime} is the default deployment configuration.
It is used if a configuration isn't specified for the deployment or
deployment group.

For more information about the predefined deployment configurations in
AWS CodeDeploy, see \href{https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html}{Working with Deployment Configurations in CodeDeploy}
in the \emph{AWS CodeDeploy User Guide}.}

\item{ec2TagFilters}{The Amazon EC2 tags on which to filter. The deployment group includes
EC2 instances with any of the specified tags. Cannot be used in the same
call as ec2TagSet.}

\item{onPremisesInstanceTagFilters}{The on-premises instance tags on which to filter. The deployment group
includes on-premises instances with any of the specified tags. Cannot be
used in the same call as \code{OnPremisesTagSet}.}

\item{autoScalingGroups}{A list of associated Amazon EC2 Auto Scaling groups.}

\item{serviceRoleArn}{[required] A service role Amazon Resource Name (ARN) that allows AWS CodeDeploy to
act on the user's behalf when interacting with AWS services.}

\item{triggerConfigurations}{Information about triggers to create when the deployment group is
created. For examples, see \href{https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-sns-event-notifications-create-trigger.html}{Create a Trigger for an AWS CodeDeploy Event}
in the \emph{AWS CodeDeploy User Guide}.}

\item{alarmConfiguration}{Information to add about Amazon CloudWatch alarms when the deployment
group is created.}

\item{autoRollbackConfiguration}{Configuration information for an automatic rollback that is added when a
deployment group is created.}

\item{deploymentStyle}{Information about the type of deployment, in-place or blue/green, that
you want to run and whether to route deployment traffic behind a load
balancer.}

\item{blueGreenDeploymentConfiguration}{Information about blue/green deployment options for a deployment group.}

\item{loadBalancerInfo}{Information about the load balancer used in a deployment.}

\item{ec2TagSet}{Information about groups of tags applied to EC2 instances. The
deployment group includes only EC2 instances identified by all the tag
groups. Cannot be used in the same call as \code{ec2TagFilters}.}

\item{ecsServices}{The target Amazon ECS services in the deployment group. This applies
only to deployment groups that use the Amazon ECS compute platform. A
target Amazon ECS service is specified as an Amazon ECS cluster and
service name pair using the format \verb{<clustername>:<servicename>}.}

\item{onPremisesTagSet}{Information about groups of tags applied to on-premises instances. The
deployment group includes only on-premises instances identified by all
of the tag groups. Cannot be used in the same call as
\code{onPremisesInstanceTagFilters}.}

\item{tags}{The metadata that you apply to CodeDeploy deployment groups to help you
organize and categorize them. Each tag consists of a key and an optional
value, both of which you define.}
}
\value{
A list with the following syntax:\preformatted{list(
  deploymentGroupId = "string"
)
}
}
\description{
Creates a deployment group to which application revisions are deployed.
}
\section{Request syntax}{
\preformatted{svc$create_deployment_group(
  applicationName = "string",
  deploymentGroupName = "string",
  deploymentConfigName = "string",
  ec2TagFilters = list(
    list(
      Key = "string",
      Value = "string",
      Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
    )
  ),
  onPremisesInstanceTagFilters = list(
    list(
      Key = "string",
      Value = "string",
      Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
    )
  ),
  autoScalingGroups = list(
    "string"
  ),
  serviceRoleArn = "string",
  triggerConfigurations = list(
    list(
      triggerName = "string",
      triggerTargetArn = "string",
      triggerEvents = list(
        "DeploymentStart"|"DeploymentSuccess"|"DeploymentFailure"|"DeploymentStop"|"DeploymentRollback"|"DeploymentReady"|"InstanceStart"|"InstanceSuccess"|"InstanceFailure"|"InstanceReady"
      )
    )
  ),
  alarmConfiguration = list(
    enabled = TRUE|FALSE,
    ignorePollAlarmFailure = TRUE|FALSE,
    alarms = list(
      list(
        name = "string"
      )
    )
  ),
  autoRollbackConfiguration = list(
    enabled = TRUE|FALSE,
    events = list(
      "DEPLOYMENT_FAILURE"|"DEPLOYMENT_STOP_ON_ALARM"|"DEPLOYMENT_STOP_ON_REQUEST"
    )
  ),
  deploymentStyle = list(
    deploymentType = "IN_PLACE"|"BLUE_GREEN",
    deploymentOption = "WITH_TRAFFIC_CONTROL"|"WITHOUT_TRAFFIC_CONTROL"
  ),
  blueGreenDeploymentConfiguration = list(
    terminateBlueInstancesOnDeploymentSuccess = list(
      action = "TERMINATE"|"KEEP_ALIVE",
      terminationWaitTimeInMinutes = 123
    ),
    deploymentReadyOption = list(
      actionOnTimeout = "CONTINUE_DEPLOYMENT"|"STOP_DEPLOYMENT",
      waitTimeInMinutes = 123
    ),
    greenFleetProvisioningOption = list(
      action = "DISCOVER_EXISTING"|"COPY_AUTO_SCALING_GROUP"
    )
  ),
  loadBalancerInfo = list(
    elbInfoList = list(
      list(
        name = "string"
      )
    ),
    targetGroupInfoList = list(
      list(
        name = "string"
      )
    ),
    targetGroupPairInfoList = list(
      list(
        targetGroups = list(
          list(
            name = "string"
          )
        ),
        prodTrafficRoute = list(
          listenerArns = list(
            "string"
          )
        ),
        testTrafficRoute = list(
          listenerArns = list(
            "string"
          )
        )
      )
    )
  ),
  ec2TagSet = list(
    ec2TagSetList = list(
      list(
        list(
          Key = "string",
          Value = "string",
          Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
        )
      )
    )
  ),
  ecsServices = list(
    list(
      serviceName = "string",
      clusterName = "string"
    )
  ),
  onPremisesTagSet = list(
    onPremisesTagSetList = list(
      list(
        list(
          Key = "string",
          Value = "string",
          Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
        )
      )
    )
  ),
  tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
