% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_post_comment_for_compared_commit}
\alias{codecommit_post_comment_for_compared_commit}
\title{Posts a comment on the comparison between two commits}
\usage{
codecommit_post_comment_for_compared_commit(repositoryName,
  beforeCommitId, afterCommitId, location, content, clientRequestToken)
}
\arguments{
\item{repositoryName}{[required] The name of the repository where you want to post a comment on the
comparison between commits.}

\item{beforeCommitId}{To establish the directionality of the comparison, the full commit ID of
the before commit. Required for commenting on any commit unless that
commit is the initial commit.}

\item{afterCommitId}{[required] To establish the directionality of the comparison, the full commit ID of
the after commit.}

\item{location}{The location of the comparison where you want to comment.}

\item{content}{[required] The content of the comment you want to make.}

\item{clientRequestToken}{A unique, client-generated idempotency token that, when provided in a
request, ensures the request cannot be repeated with a changed
parameter. If a request is received with the same parameters and a token
is included, the request returns information about the initial request
that used that token.}
}
\value{
A list with the following syntax:\preformatted{list(
  repositoryName = "string",
  beforeCommitId = "string",
  afterCommitId = "string",
  beforeBlobId = "string",
  afterBlobId = "string",
  location = list(
    filePath = "string",
    filePosition = 123,
    relativeFileVersion = "BEFORE"|"AFTER"
  ),
  comment = list(
    commentId = "string",
    content = "string",
    inReplyTo = "string",
    creationDate = as.POSIXct(
      "2015-01-01"
    ),
    lastModifiedDate = as.POSIXct(
      "2015-01-01"
    ),
    authorArn = "string",
    deleted = TRUE|FALSE,
    clientRequestToken = "string",
    callerReactions = list(
      "string"
    ),
    reactionCounts = list(
      123
    )
  )
)
}
}
\description{
Posts a comment on the comparison between two commits.
}
\section{Request syntax}{
\preformatted{svc$post_comment_for_compared_commit(
  repositoryName = "string",
  beforeCommitId = "string",
  afterCommitId = "string",
  location = list(
    filePath = "string",
    filePosition = 123,
    relativeFileVersion = "BEFORE"|"AFTER"
  ),
  content = "string",
  clientRequestToken = "string"
)
}
}

\keyword{internal}
