% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_update_report_group}
\alias{codebuild_update_report_group}
\title{Updates a report group}
\usage{
codebuild_update_report_group(arn, exportConfig, tags)
}
\arguments{
\item{arn}{[required] The ARN of the report group to update.}

\item{exportConfig}{Used to specify an updated export type. Valid values are:
\itemize{
\item \code{S3}: The report results are exported to an S3 bucket.
\item \code{NO_EXPORT}: The report results are not exported.
}}

\item{tags}{An updated list of tag key and value pairs associated with this report
group.

These tags are available for use by AWS services that support AWS
CodeBuild report group tags.}
}
\value{
A list with the following syntax:\preformatted{list(
  reportGroup = list(
    arn = "string",
    name = "string",
    type = "TEST"|"CODE_COVERAGE",
    exportConfig = list(
      exportConfigType = "S3"|"NO_EXPORT",
      s3Destination = list(
        bucket = "string",
        path = "string",
        packaging = "ZIP"|"NONE",
        encryptionKey = "string",
        encryptionDisabled = TRUE|FALSE
      )
    ),
    created = as.POSIXct(
      "2015-01-01"
    ),
    lastModified = as.POSIXct(
      "2015-01-01"
    ),
    tags = list(
      list(
        key = "string",
        value = "string"
      )
    ),
    status = "ACTIVE"|"DELETING"
  )
)
}
}
\description{
Updates a report group.
}
\section{Request syntax}{
\preformatted{svc$update_report_group(
  arn = "string",
  exportConfig = list(
    exportConfigType = "S3"|"NO_EXPORT",
    s3Destination = list(
      bucket = "string",
      path = "string",
      packaging = "ZIP"|"NONE",
      encryptionKey = "string",
      encryptionDisabled = TRUE|FALSE
    )
  ),
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
