% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_list_build_batches_for_project}
\alias{codebuild_list_build_batches_for_project}
\title{Retrieves the identifiers of the build batches for a specific project}
\usage{
codebuild_list_build_batches_for_project(projectName, filter,
  maxResults, sortOrder, nextToken)
}
\arguments{
\item{projectName}{The name of the project.}

\item{filter}{A \code{BuildBatchFilter} object that specifies the filters for the search.}

\item{maxResults}{The maximum number of results to return.}

\item{sortOrder}{Specifies the sort order of the returned items. Valid values include:
\itemize{
\item \code{ASCENDING}: List the batch build identifiers in ascending order by
identifier.
\item \code{DESCENDING}: List the batch build identifiers in descending order
by identifier.
}}

\item{nextToken}{The \code{nextToken} value returned from a previous call to
\code{\link[=codebuild_list_build_batches_for_project]{list_build_batches_for_project}}.
This specifies the next item to return. To return the beginning of the
list, exclude this parameter.}
}
\value{
A list with the following syntax:\preformatted{list(
  ids = list(
    "string"
  ),
  nextToken = "string"
)
}
}
\description{
Retrieves the identifiers of the build batches for a specific project.
}
\section{Request syntax}{
\preformatted{svc$list_build_batches_for_project(
  projectName = "string",
  filter = list(
    status = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED"
  ),
  maxResults = 123,
  sortOrder = "ASCENDING"|"DESCENDING",
  nextToken = "string"
)
}
}

\keyword{internal}
