% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloud9_operations.R
\name{cloud9_list_environments}
\alias{cloud9_list_environments}
\title{Gets a list of AWS Cloud9 development environment identifiers}
\usage{
cloud9_list_environments(nextToken, maxResults)
}
\arguments{
\item{nextToken}{During a previous call, if there are more than 25 items in the list,
only the first 25 items are returned, along with a unique string called
a \emph{next token}. To get the next batch of items in the list, call this
operation again, adding the next token to the call. To get all of the
items in the list, keep calling this operation with each subsequent next
token that is returned, until no more next tokens are returned.}

\item{maxResults}{The maximum number of environments to get identifiers for.}
}
\value{
A list with the following syntax:\preformatted{list(
  nextToken = "string",
  environmentIds = list(
    "string"
  )
)
}
}
\description{
Gets a list of AWS Cloud9 development environment identifiers.
}
\section{Request syntax}{
\preformatted{svc$list_environments(
  nextToken = "string",
  maxResults = 123
)
}
}

\examples{
\dontrun{
# 
svc$list_environments()
}

}
\keyword{internal}
