# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS CodeBuild
#'
#' @description
#' AWS CodeBuild is a fully managed build service in the cloud. AWS
#' CodeBuild compiles your source code, runs unit tests, and produces
#' artifacts that are ready to deploy. AWS CodeBuild eliminates the need to
#' provision, manage, and scale your own build servers. It provides
#' prepackaged build environments for the most popular programming
#' languages and build tools, such as Apache Maven, Gradle, and more. You
#' can also fully customize build environments in AWS CodeBuild to use your
#' own build tools. AWS CodeBuild scales automatically to meet peak build
#' requests. You pay only for the build time you consume. For more
#' information about AWS CodeBuild, see the *[AWS CodeBuild User
#' Guide](https://docs.aws.amazon.com/codebuild/latest/userguide/welcome.html).*
#' 
#' AWS CodeBuild supports these operations:
#' 
#' -   [`batch_delete_builds`][codebuild_batch_delete_builds]: Deletes one
#'     or more builds.
#' 
#' -   [`batch_get_builds`][codebuild_batch_get_builds]: Gets information
#'     about one or more builds.
#' 
#' -   [`batch_get_projects`][codebuild_batch_get_projects]: Gets
#'     information about one or more build projects. A *build project*
#'     defines how AWS CodeBuild runs a build. This includes information
#'     such as where to get the source code to build, the build environment
#'     to use, the build commands to run, and where to store the build
#'     output. A *build environment* is a representation of operating
#'     system, programming language runtime, and tools that AWS CodeBuild
#'     uses to run a build. You can add tags to build projects to help
#'     manage your resources and costs.
#' 
#' -   [`batch_get_report_groups`][codebuild_batch_get_report_groups]:
#'     Returns an array of report groups.
#' 
#' -   [`batch_get_reports`][codebuild_batch_get_reports]: Returns an array
#'     of reports.
#' 
#' -   [`create_project`][codebuild_create_project]: Creates a build
#'     project.
#' 
#' -   [`create_report_group`][codebuild_create_report_group]: Creates a
#'     report group. A report group contains a collection of reports.
#' 
#' -   [`create_webhook`][codebuild_create_webhook]: For an existing AWS
#'     CodeBuild build project that has its source code stored in a GitHub
#'     or Bitbucket repository, enables AWS CodeBuild to start rebuilding
#'     the source code every time a code change is pushed to the
#'     repository.
#' 
#' -   [`delete_project`][codebuild_delete_project]: Deletes a build
#'     project.
#' 
#' -   [`delete_report`][codebuild_delete_report]: Deletes a report.
#' 
#' -   [`delete_report_group`][codebuild_delete_report_group]: Deletes a
#'     report group.
#' 
#' -   [`delete_resource_policy`][codebuild_delete_resource_policy]:
#'     Deletes a resource policy that is identified by its resource ARN.
#' 
#' -   [`delete_source_credentials`][codebuild_delete_source_credentials]:
#'     Deletes a set of GitHub, GitHub Enterprise, or Bitbucket source
#'     credentials.
#' 
#' -   [`delete_webhook`][codebuild_delete_webhook]: For an existing AWS
#'     CodeBuild build project that has its source code stored in a GitHub
#'     or Bitbucket repository, stops AWS CodeBuild from rebuilding the
#'     source code every time a code change is pushed to the repository.
#' 
#' -   [`describe_test_cases`][codebuild_describe_test_cases]: Returns a
#'     list of details about test cases for a report.
#' 
#' -   [`get_resource_policy`][codebuild_get_resource_policy]: Gets a
#'     resource policy that is identified by its resource ARN.
#' 
#' -   [`import_source_credentials`][codebuild_import_source_credentials]:
#'     Imports the source repository credentials for an AWS CodeBuild
#'     project that has its source code stored in a GitHub, GitHub
#'     Enterprise, or Bitbucket repository.
#' 
#' -   [`invalidate_project_cache`][codebuild_invalidate_project_cache]:
#'     Resets the cache for a project.
#' 
#' -   [`list_builds`][codebuild_list_builds]: Gets a list of build IDs,
#'     with each build ID representing a single build.
#' 
#' -   [`list_builds_for_project`][codebuild_list_builds_for_project]: Gets
#'     a list of build IDs for the specified build project, with each build
#'     ID representing a single build.
#' 
#' -   [`list_curated_environment_images`][codebuild_list_curated_environment_images]:
#'     Gets information about Docker images that are managed by AWS
#'     CodeBuild.
#' 
#' -   [`list_projects`][codebuild_list_projects]: Gets a list of build
#'     project names, with each build project name representing a single
#'     build project.
#' 
#' -   [`list_report_groups`][codebuild_list_report_groups]: Gets a list
#'     ARNs for the report groups in the current AWS account.
#' 
#' -   [`list_reports`][codebuild_list_reports]: Gets a list ARNs for the
#'     reports in the current AWS account.
#' 
#' -   [`list_reports_for_report_group`][codebuild_list_reports_for_report_group]:
#'     Returns a list of ARNs for the reports that belong to a
#'     `ReportGroup`.
#' 
#' -   [`list_shared_projects`][codebuild_list_shared_projects]: Gets a
#'     list of ARNs associated with projects shared with the current AWS
#'     account or user.
#' 
#' -   [`list_shared_report_groups`][codebuild_list_shared_report_groups]:
#'     Gets a list of ARNs associated with report groups shared with the
#'     current AWS account or user
#' 
#' -   [`list_source_credentials`][codebuild_list_source_credentials]:
#'     Returns a list of `SourceCredentialsInfo` objects. Each
#'     `SourceCredentialsInfo` object includes the authentication type,
#'     token ARN, and type of source provider for one set of credentials.
#' 
#' -   [`put_resource_policy`][codebuild_put_resource_policy]: Stores a
#'     resource policy for the ARN of a `Project` or `ReportGroup` object.
#' 
#' -   [`start_build`][codebuild_start_build]: Starts running a build.
#' 
#' -   [`stop_build`][codebuild_stop_build]: Attempts to stop running a
#'     build.
#' 
#' -   [`update_project`][codebuild_update_project]: Changes the settings
#'     of an existing build project.
#' 
#' -   [`update_report_group`][codebuild_update_report_group]: Changes a
#'     report group.
#' 
#' -   [`update_webhook`][codebuild_update_webhook]: Changes the settings
#'     of an existing webhook.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- codebuild(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- codebuild()
#' # The following example gets information about builds with the specified
#' # build IDs.
#' svc$batch_get_builds(
#'   ids = list(
#'     "codebuild-demo-project:9b0ac37f-d19e-4254-9079-f47e9a389eEX",
#'     "codebuild-demo-project:b79a46f7-1473-4636-a23f-da9c45c208EX"
#'   )
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=codebuild_batch_delete_builds]{batch_delete_builds} \tab Deletes one or more builds\cr
#'  \link[=codebuild_batch_get_build_batches]{batch_get_build_batches} \tab Retrieves information about one or more batch builds\cr
#'  \link[=codebuild_batch_get_builds]{batch_get_builds} \tab Gets information about one or more builds\cr
#'  \link[=codebuild_batch_get_projects]{batch_get_projects} \tab Gets information about one or more build projects\cr
#'  \link[=codebuild_batch_get_report_groups]{batch_get_report_groups} \tab Returns an array of report groups\cr
#'  \link[=codebuild_batch_get_reports]{batch_get_reports} \tab Returns an array of reports\cr
#'  \link[=codebuild_create_project]{create_project} \tab Creates a build project\cr
#'  \link[=codebuild_create_report_group]{create_report_group} \tab Creates a report group\cr
#'  \link[=codebuild_create_webhook]{create_webhook} \tab For an existing AWS CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository, enables AWS CodeBuild to start rebuilding the source code every time a code change is pushed to the repository\cr
#'  \link[=codebuild_delete_build_batch]{delete_build_batch} \tab Deletes a batch build\cr
#'  \link[=codebuild_delete_project]{delete_project} \tab Deletes a build project\cr
#'  \link[=codebuild_delete_report]{delete_report} \tab Deletes a report\cr
#'  \link[=codebuild_delete_report_group]{delete_report_group} \tab Deletes a report group\cr
#'  \link[=codebuild_delete_resource_policy]{delete_resource_policy} \tab Deletes a resource policy that is identified by its resource ARN\cr
#'  \link[=codebuild_delete_source_credentials]{delete_source_credentials} \tab Deletes a set of GitHub, GitHub Enterprise, or Bitbucket source credentials\cr
#'  \link[=codebuild_delete_webhook]{delete_webhook} \tab For an existing AWS CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository, stops AWS CodeBuild from rebuilding the source code every time a code change is pushed to the repository\cr
#'  \link[=codebuild_describe_code_coverages]{describe_code_coverages} \tab Retrieves one or more code coverage reports\cr
#'  \link[=codebuild_describe_test_cases]{describe_test_cases} \tab Returns a list of details about test cases for a report\cr
#'  \link[=codebuild_get_report_group_trend]{get_report_group_trend} \tab Get report group trend\cr
#'  \link[=codebuild_get_resource_policy]{get_resource_policy} \tab Gets a resource policy that is identified by its resource ARN\cr
#'  \link[=codebuild_import_source_credentials]{import_source_credentials} \tab Imports the source repository credentials for an AWS CodeBuild project that has its source code stored in a GitHub, GitHub Enterprise, or Bitbucket repository\cr
#'  \link[=codebuild_invalidate_project_cache]{invalidate_project_cache} \tab Resets the cache for a project\cr
#'  \link[=codebuild_list_build_batches]{list_build_batches} \tab Retrieves the identifiers of your build batches in the current region\cr
#'  \link[=codebuild_list_build_batches_for_project]{list_build_batches_for_project} \tab Retrieves the identifiers of the build batches for a specific project\cr
#'  \link[=codebuild_list_builds]{list_builds} \tab Gets a list of build IDs, with each build ID representing a single build\cr
#'  \link[=codebuild_list_builds_for_project]{list_builds_for_project} \tab Gets a list of build IDs for the specified build project, with each build ID representing a single build\cr
#'  \link[=codebuild_list_curated_environment_images]{list_curated_environment_images} \tab Gets information about Docker images that are managed by AWS CodeBuild\cr
#'  \link[=codebuild_list_projects]{list_projects} \tab Gets a list of build project names, with each build project name representing a single build project\cr
#'  \link[=codebuild_list_report_groups]{list_report_groups} \tab Gets a list ARNs for the report groups in the current AWS account\cr
#'  \link[=codebuild_list_reports]{list_reports} \tab Returns a list of ARNs for the reports in the current AWS account\cr
#'  \link[=codebuild_list_reports_for_report_group]{list_reports_for_report_group} \tab Returns a list of ARNs for the reports that belong to a ReportGroup\cr
#'  \link[=codebuild_list_shared_projects]{list_shared_projects} \tab Gets a list of projects that are shared with other AWS accounts or users\cr
#'  \link[=codebuild_list_shared_report_groups]{list_shared_report_groups} \tab Gets a list of report groups that are shared with other AWS accounts or users\cr
#'  \link[=codebuild_list_source_credentials]{list_source_credentials} \tab Returns a list of SourceCredentialsInfo objects\cr
#'  \link[=codebuild_put_resource_policy]{put_resource_policy} \tab Stores a resource policy for the ARN of a Project or ReportGroup object\cr
#'  \link[=codebuild_retry_build]{retry_build} \tab Restarts a build\cr
#'  \link[=codebuild_retry_build_batch]{retry_build_batch} \tab Restarts a failed batch build\cr
#'  \link[=codebuild_start_build]{start_build} \tab Starts running a build\cr
#'  \link[=codebuild_start_build_batch]{start_build_batch} \tab Starts a batch build for a project\cr
#'  \link[=codebuild_stop_build]{stop_build} \tab Attempts to stop running a build\cr
#'  \link[=codebuild_stop_build_batch]{stop_build_batch} \tab Stops a running batch build\cr
#'  \link[=codebuild_update_project]{update_project} \tab Changes the settings of a build project\cr
#'  \link[=codebuild_update_report_group]{update_report_group} \tab Updates a report group\cr
#'  \link[=codebuild_update_webhook]{update_webhook} \tab Updates the webhook associated with an AWS CodeBuild build project
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname codebuild
#' @export
codebuild <- function(config = list()) {
  svc <- .codebuild$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.codebuild <- list()

.codebuild$operations <- list()

.codebuild$metadata <- list(
  service_name = "codebuild",
  endpoints = list("*" = list(endpoint = "codebuild.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "codebuild.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "codebuild.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "codebuild.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "CodeBuild",
  api_version = "2016-10-06",
  signing_name = "codebuild",
  json_version = "1.1",
  target_prefix = "CodeBuild_20161006"
)

.codebuild$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.codebuild$metadata, handlers, config)
}
