# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include neptunedata_service.R
NULL

#' Cancels a Gremlin query
#'
#' @description
#' Cancels a Gremlin query. See [Gremlin query cancellation](https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status-cancel.html) for more information.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_cancel_gremlin_query/](https://www.paws-r-sdk.com/docs/neptunedata_cancel_gremlin_query/) for full documentation.
#'
#' @param queryId &#91;required&#93; The unique identifier that identifies the query to be canceled.
#'
#' @keywords internal
#'
#' @rdname neptunedata_cancel_gremlin_query
neptunedata_cancel_gremlin_query <- function(queryId) {
  op <- new_operation(
    name = "CancelGremlinQuery",
    http_method = "DELETE",
    http_path = "/gremlin/status/{queryId}",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$cancel_gremlin_query_input(queryId = queryId)
  output <- .neptunedata$cancel_gremlin_query_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$cancel_gremlin_query <- neptunedata_cancel_gremlin_query

#' Cancels a specified load job
#'
#' @description
#' Cancels a specified load job. This is an HTTP `DELETE` request. See [Neptune Loader Get-Status API](https://docs.aws.amazon.com/neptune/latest/userguide/) for more information.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_cancel_loader_job/](https://www.paws-r-sdk.com/docs/neptunedata_cancel_loader_job/) for full documentation.
#'
#' @param loadId &#91;required&#93; The ID of the load job to be deleted.
#'
#' @keywords internal
#'
#' @rdname neptunedata_cancel_loader_job
neptunedata_cancel_loader_job <- function(loadId) {
  op <- new_operation(
    name = "CancelLoaderJob",
    http_method = "DELETE",
    http_path = "/loader/{loadId}",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$cancel_loader_job_input(loadId = loadId)
  output <- .neptunedata$cancel_loader_job_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$cancel_loader_job <- neptunedata_cancel_loader_job

#' Cancels a Neptune ML data processing job
#'
#' @description
#' Cancels a Neptune ML data processing job. See [The `dataprocessing` command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_cancel_ml_data_processing_job/](https://www.paws-r-sdk.com/docs/neptunedata_cancel_ml_data_processing_job/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier of the data-processing job.
#' @param neptuneIamRoleArn The ARN of an IAM role that provides Neptune access to SageMaker and
#' Amazon S3 resources. This must be listed in your DB cluster parameter
#' group or an error will occur.
#' @param clean If set to `TRUE`, this flag specifies that all Neptune ML S3 artifacts
#' should be deleted when the job is stopped. The default is `FALSE`.
#'
#' @keywords internal
#'
#' @rdname neptunedata_cancel_ml_data_processing_job
neptunedata_cancel_ml_data_processing_job <- function(id, neptuneIamRoleArn = NULL, clean = NULL) {
  op <- new_operation(
    name = "CancelMLDataProcessingJob",
    http_method = "DELETE",
    http_path = "/ml/dataprocessing/{id}",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$cancel_ml_data_processing_job_input(id = id, neptuneIamRoleArn = neptuneIamRoleArn, clean = clean)
  output <- .neptunedata$cancel_ml_data_processing_job_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$cancel_ml_data_processing_job <- neptunedata_cancel_ml_data_processing_job

#' Cancels a Neptune ML model training job
#'
#' @description
#' Cancels a Neptune ML model training job. See [Model training using the `modeltraining` command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_cancel_ml_model_training_job/](https://www.paws-r-sdk.com/docs/neptunedata_cancel_ml_model_training_job/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier of the model-training job to be canceled.
#' @param neptuneIamRoleArn The ARN of an IAM role that provides Neptune access to SageMaker and
#' Amazon S3 resources. This must be listed in your DB cluster parameter
#' group or an error will occur.
#' @param clean If set to `TRUE`, this flag specifies that all Amazon S3 artifacts
#' should be deleted when the job is stopped. The default is `FALSE`.
#'
#' @keywords internal
#'
#' @rdname neptunedata_cancel_ml_model_training_job
neptunedata_cancel_ml_model_training_job <- function(id, neptuneIamRoleArn = NULL, clean = NULL) {
  op <- new_operation(
    name = "CancelMLModelTrainingJob",
    http_method = "DELETE",
    http_path = "/ml/modeltraining/{id}",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$cancel_ml_model_training_job_input(id = id, neptuneIamRoleArn = neptuneIamRoleArn, clean = clean)
  output <- .neptunedata$cancel_ml_model_training_job_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$cancel_ml_model_training_job <- neptunedata_cancel_ml_model_training_job

#' Cancels a specified model transform job
#'
#' @description
#' Cancels a specified model transform job. See [Use a trained model to generate new model artifacts](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_cancel_ml_model_transform_job/](https://www.paws-r-sdk.com/docs/neptunedata_cancel_ml_model_transform_job/) for full documentation.
#'
#' @param id &#91;required&#93; The unique ID of the model transform job to be canceled.
#' @param neptuneIamRoleArn The ARN of an IAM role that provides Neptune access to SageMaker and
#' Amazon S3 resources. This must be listed in your DB cluster parameter
#' group or an error will occur.
#' @param clean If this flag is set to `TRUE`, all Neptune ML S3 artifacts should be
#' deleted when the job is stopped. The default is `FALSE`.
#'
#' @keywords internal
#'
#' @rdname neptunedata_cancel_ml_model_transform_job
neptunedata_cancel_ml_model_transform_job <- function(id, neptuneIamRoleArn = NULL, clean = NULL) {
  op <- new_operation(
    name = "CancelMLModelTransformJob",
    http_method = "DELETE",
    http_path = "/ml/modeltransform/{id}",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$cancel_ml_model_transform_job_input(id = id, neptuneIamRoleArn = neptuneIamRoleArn, clean = clean)
  output <- .neptunedata$cancel_ml_model_transform_job_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$cancel_ml_model_transform_job <- neptunedata_cancel_ml_model_transform_job

#' Cancels a specified openCypher query
#'
#' @description
#' Cancels a specified openCypher query. See [Neptune openCypher status endpoint](https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html) for more information.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_cancel_open_cypher_query/](https://www.paws-r-sdk.com/docs/neptunedata_cancel_open_cypher_query/) for full documentation.
#'
#' @param queryId &#91;required&#93; The unique ID of the openCypher query to cancel.
#' @param silent If set to `TRUE`, causes the cancelation of the openCypher query to
#' happen silently.
#'
#' @keywords internal
#'
#' @rdname neptunedata_cancel_open_cypher_query
neptunedata_cancel_open_cypher_query <- function(queryId, silent = NULL) {
  op <- new_operation(
    name = "CancelOpenCypherQuery",
    http_method = "DELETE",
    http_path = "/opencypher/status/{queryId}",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$cancel_open_cypher_query_input(queryId = queryId, silent = silent)
  output <- .neptunedata$cancel_open_cypher_query_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$cancel_open_cypher_query <- neptunedata_cancel_open_cypher_query

#' Creates a new Neptune ML inference endpoint that lets you query one
#' specific model that the model-training process constructed
#'
#' @description
#' Creates a new Neptune ML inference endpoint that lets you query one specific model that the model-training process constructed. See [Managing inference endpoints using the endpoints command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_create_ml_endpoint/](https://www.paws-r-sdk.com/docs/neptunedata_create_ml_endpoint/) for full documentation.
#'
#' @param id A unique identifier for the new inference endpoint. The default is an
#' autogenerated timestamped name.
#' @param mlModelTrainingJobId The job Id of the completed model-training job that has created the
#' model that the inference endpoint will point to. You must supply either
#' the `mlModelTrainingJobId` or the `mlModelTransformJobId`.
#' @param mlModelTransformJobId The job Id of the completed model-transform job. You must supply either
#' the `mlModelTrainingJobId` or the `mlModelTransformJobId`.
#' @param update If set to `true`, `update` indicates that this is an update request. The
#' default is `false`. You must supply either the `mlModelTrainingJobId` or
#' the `mlModelTransformJobId`.
#' @param neptuneIamRoleArn The ARN of an IAM role providing Neptune access to SageMaker and Amazon
#' S3 resources. This must be listed in your DB cluster parameter group or
#' an error will be thrown.
#' @param modelName Model type for training. By default the Neptune ML model is
#' automatically based on the `modelType` used in data processing, but you
#' can specify a different model type here. The default is `rgcn` for
#' heterogeneous graphs and `kge` for knowledge graphs. The only valid
#' value for heterogeneous graphs is `rgcn`. Valid values for knowledge
#' graphs are: `kge`, `transe`, `distmult`, and `rotate`.
#' @param instanceType The type of Neptune ML instance to use for online servicing. The default
#' is `ml.m5.xlarge`. Choosing the ML instance for an inference endpoint
#' depends on the task type, the graph size, and your budget.
#' @param instanceCount The minimum number of Amazon EC2 instances to deploy to an endpoint for
#' prediction. The default is 1
#' @param volumeEncryptionKMSKey The Amazon Key Management Service (Amazon KMS) key that SageMaker uses
#' to encrypt data on the storage volume attached to the ML compute
#' instances that run the training job. The default is None.
#'
#' @keywords internal
#'
#' @rdname neptunedata_create_ml_endpoint
neptunedata_create_ml_endpoint <- function(id = NULL, mlModelTrainingJobId = NULL, mlModelTransformJobId = NULL, update = NULL, neptuneIamRoleArn = NULL, modelName = NULL, instanceType = NULL, instanceCount = NULL, volumeEncryptionKMSKey = NULL) {
  op <- new_operation(
    name = "CreateMLEndpoint",
    http_method = "POST",
    http_path = "/ml/endpoints",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$create_ml_endpoint_input(id = id, mlModelTrainingJobId = mlModelTrainingJobId, mlModelTransformJobId = mlModelTransformJobId, update = update, neptuneIamRoleArn = neptuneIamRoleArn, modelName = modelName, instanceType = instanceType, instanceCount = instanceCount, volumeEncryptionKMSKey = volumeEncryptionKMSKey)
  output <- .neptunedata$create_ml_endpoint_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$create_ml_endpoint <- neptunedata_create_ml_endpoint

#' Cancels the creation of a Neptune ML inference endpoint
#'
#' @description
#' Cancels the creation of a Neptune ML inference endpoint. See [Managing inference endpoints using the endpoints command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_delete_ml_endpoint/](https://www.paws-r-sdk.com/docs/neptunedata_delete_ml_endpoint/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier of the inference endpoint.
#' @param neptuneIamRoleArn The ARN of an IAM role providing Neptune access to SageMaker and Amazon
#' S3 resources. This must be listed in your DB cluster parameter group or
#' an error will be thrown.
#' @param clean If this flag is set to `TRUE`, all Neptune ML S3 artifacts should be
#' deleted when the job is stopped. The default is `FALSE`.
#'
#' @keywords internal
#'
#' @rdname neptunedata_delete_ml_endpoint
neptunedata_delete_ml_endpoint <- function(id, neptuneIamRoleArn = NULL, clean = NULL) {
  op <- new_operation(
    name = "DeleteMLEndpoint",
    http_method = "DELETE",
    http_path = "/ml/endpoints/{id}",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$delete_ml_endpoint_input(id = id, neptuneIamRoleArn = neptuneIamRoleArn, clean = clean)
  output <- .neptunedata$delete_ml_endpoint_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$delete_ml_endpoint <- neptunedata_delete_ml_endpoint

#' Deletes statistics for Gremlin and openCypher (property graph) data
#'
#' @description
#' Deletes statistics for Gremlin and openCypher (property graph) data.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_delete_propertygraph_statistics/](https://www.paws-r-sdk.com/docs/neptunedata_delete_propertygraph_statistics/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname neptunedata_delete_propertygraph_statistics
neptunedata_delete_propertygraph_statistics <- function() {
  op <- new_operation(
    name = "DeletePropertygraphStatistics",
    http_method = "DELETE",
    http_path = "/propertygraph/statistics",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$delete_propertygraph_statistics_input()
  output <- .neptunedata$delete_propertygraph_statistics_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$delete_propertygraph_statistics <- neptunedata_delete_propertygraph_statistics

#' Deletes SPARQL statistics
#'
#' @description
#' Deletes SPARQL statistics
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_delete_sparql_statistics/](https://www.paws-r-sdk.com/docs/neptunedata_delete_sparql_statistics/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname neptunedata_delete_sparql_statistics
neptunedata_delete_sparql_statistics <- function() {
  op <- new_operation(
    name = "DeleteSparqlStatistics",
    http_method = "DELETE",
    http_path = "/sparql/statistics",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$delete_sparql_statistics_input()
  output <- .neptunedata$delete_sparql_statistics_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$delete_sparql_statistics <- neptunedata_delete_sparql_statistics

#' The fast reset REST API lets you reset a Neptune graph quicky and
#' easily, removing all of its data
#'
#' @description
#' The fast reset REST API lets you reset a Neptune graph quicky and easily, removing all of its data.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_execute_fast_reset/](https://www.paws-r-sdk.com/docs/neptunedata_execute_fast_reset/) for full documentation.
#'
#' @param action &#91;required&#93; The fast reset action. One of the following values:
#' 
#' -   **`initiateDatabaseReset`**   –   This action generates a unique
#'     token needed to actually perform the fast reset.
#' 
#' -   **`performDatabaseReset`**   –   This action uses the token
#'     generated by the `initiateDatabaseReset` action to actually perform
#'     the fast reset.
#' @param token The fast-reset token to initiate the reset.
#'
#' @keywords internal
#'
#' @rdname neptunedata_execute_fast_reset
neptunedata_execute_fast_reset <- function(action, token = NULL) {
  op <- new_operation(
    name = "ExecuteFastReset",
    http_method = "POST",
    http_path = "/system",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$execute_fast_reset_input(action = action, token = token)
  output <- .neptunedata$execute_fast_reset_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$execute_fast_reset <- neptunedata_execute_fast_reset

#' Executes a Gremlin Explain query
#'
#' @description
#' Executes a Gremlin Explain query.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_execute_gremlin_explain_query/](https://www.paws-r-sdk.com/docs/neptunedata_execute_gremlin_explain_query/) for full documentation.
#'
#' @param gremlinQuery &#91;required&#93; The Gremlin explain query string.
#'
#' @keywords internal
#'
#' @rdname neptunedata_execute_gremlin_explain_query
neptunedata_execute_gremlin_explain_query <- function(gremlinQuery) {
  op <- new_operation(
    name = "ExecuteGremlinExplainQuery",
    http_method = "POST",
    http_path = "/gremlin/explain",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$execute_gremlin_explain_query_input(gremlinQuery = gremlinQuery)
  output <- .neptunedata$execute_gremlin_explain_query_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$execute_gremlin_explain_query <- neptunedata_execute_gremlin_explain_query

#' Executes a Gremlin Profile query, which runs a specified traversal,
#' collects various metrics about the run, and produces a profile report as
#' output
#'
#' @description
#' Executes a Gremlin Profile query, which runs a specified traversal, collects various metrics about the run, and produces a profile report as output. See [Gremlin profile API in Neptune](https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html) for details.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_execute_gremlin_profile_query/](https://www.paws-r-sdk.com/docs/neptunedata_execute_gremlin_profile_query/) for full documentation.
#'
#' @param gremlinQuery &#91;required&#93; The Gremlin query string to profile.
#' @param results If this flag is set to `TRUE`, the query results are gathered and
#' displayed as part of the profile report. If `FALSE`, only the result
#' count is displayed.
#' @param chop If non-zero, causes the results string to be truncated at that number of
#' characters. If set to zero, the string contains all the results.
#' @param serializer If non-null, the gathered results are returned in a serialized response
#' message in the format specified by this parameter. See [Gremlin profile
#' API in
#' Neptune](https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html)
#' for more information.
#' @param indexOps If this flag is set to `TRUE`, the results include a detailed report of
#' all index operations that took place during query execution and
#' serialization.
#'
#' @keywords internal
#'
#' @rdname neptunedata_execute_gremlin_profile_query
neptunedata_execute_gremlin_profile_query <- function(gremlinQuery, results = NULL, chop = NULL, serializer = NULL, indexOps = NULL) {
  op <- new_operation(
    name = "ExecuteGremlinProfileQuery",
    http_method = "POST",
    http_path = "/gremlin/profile",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$execute_gremlin_profile_query_input(gremlinQuery = gremlinQuery, results = results, chop = chop, serializer = serializer, indexOps = indexOps)
  output <- .neptunedata$execute_gremlin_profile_query_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$execute_gremlin_profile_query <- neptunedata_execute_gremlin_profile_query

#' This commands executes a Gremlin query
#'
#' @description
#' This commands executes a Gremlin query. Amazon Neptune is compatible with Apache TinkerPop3 and Gremlin, so you can use the Gremlin traversal language to query the graph, as described under [The Graph](https://tinkerpop.apache.org/docs/current/reference/#graph) in the Apache TinkerPop3 documentation. More details can also be found in [Accessing a Neptune graph with Gremlin](https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin.html).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_execute_gremlin_query/](https://www.paws-r-sdk.com/docs/neptunedata_execute_gremlin_query/) for full documentation.
#'
#' @param gremlinQuery &#91;required&#93; Using this API, you can run Gremlin queries in string format much as you
#' can using the HTTP endpoint. The interface is compatible with whatever
#' Gremlin version your DB cluster is using (see the [Tinkerpop client
#' section](https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin-client.html#best-practices-gremlin-java-latest)
#' to determine which Gremlin releases your engine version supports).
#' @param serializer If non-null, the query results are returned in a serialized response
#' message in the format specified by this parameter. See the
#' [GraphSON](https://tinkerpop.apache.org/docs/current/reference/#_graphson)
#' section in the TinkerPop documentation for a list of the formats that
#' are currently supported.
#'
#' @keywords internal
#'
#' @rdname neptunedata_execute_gremlin_query
neptunedata_execute_gremlin_query <- function(gremlinQuery, serializer = NULL) {
  op <- new_operation(
    name = "ExecuteGremlinQuery",
    http_method = "POST",
    http_path = "/gremlin",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$execute_gremlin_query_input(gremlinQuery = gremlinQuery, serializer = serializer)
  output <- .neptunedata$execute_gremlin_query_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$execute_gremlin_query <- neptunedata_execute_gremlin_query

#' Executes an openCypher explain request
#'
#' @description
#' Executes an openCypher `explain` request. See [The openCypher explain feature](https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-explain.html) for more information.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_execute_open_cypher_explain_query/](https://www.paws-r-sdk.com/docs/neptunedata_execute_open_cypher_explain_query/) for full documentation.
#'
#' @param openCypherQuery &#91;required&#93; The openCypher query string.
#' @param parameters The openCypher query parameters.
#' @param explainMode &#91;required&#93; The openCypher `explain` mode. Can be one of: `static`, `dynamic`, or
#' `details`.
#'
#' @keywords internal
#'
#' @rdname neptunedata_execute_open_cypher_explain_query
neptunedata_execute_open_cypher_explain_query <- function(openCypherQuery, parameters = NULL, explainMode) {
  op <- new_operation(
    name = "ExecuteOpenCypherExplainQuery",
    http_method = "POST",
    http_path = "/opencypher/explain",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$execute_open_cypher_explain_query_input(openCypherQuery = openCypherQuery, parameters = parameters, explainMode = explainMode)
  output <- .neptunedata$execute_open_cypher_explain_query_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$execute_open_cypher_explain_query <- neptunedata_execute_open_cypher_explain_query

#' Executes an openCypher query
#'
#' @description
#' Executes an openCypher query. See [Accessing the Neptune Graph with openCypher](https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher.html) for more information.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_execute_open_cypher_query/](https://www.paws-r-sdk.com/docs/neptunedata_execute_open_cypher_query/) for full documentation.
#'
#' @param openCypherQuery &#91;required&#93; The openCypher query string to be executed.
#' @param parameters The openCypher query parameters for query execution. See [Examples of
#' openCypher parameterized
#' queries](https://docs.aws.amazon.com/neptune/latest/userguide/opencypher-parameterized-queries.html)
#' for more information.
#'
#' @keywords internal
#'
#' @rdname neptunedata_execute_open_cypher_query
neptunedata_execute_open_cypher_query <- function(openCypherQuery, parameters = NULL) {
  op <- new_operation(
    name = "ExecuteOpenCypherQuery",
    http_method = "POST",
    http_path = "/opencypher",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$execute_open_cypher_query_input(openCypherQuery = openCypherQuery, parameters = parameters)
  output <- .neptunedata$execute_open_cypher_query_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$execute_open_cypher_query <- neptunedata_execute_open_cypher_query

#' Retrieves the status of the graph database on the host
#'
#' @description
#' Retrieves the status of the graph database on the host.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_get_engine_status/](https://www.paws-r-sdk.com/docs/neptunedata_get_engine_status/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname neptunedata_get_engine_status
neptunedata_get_engine_status <- function() {
  op <- new_operation(
    name = "GetEngineStatus",
    http_method = "GET",
    http_path = "/status",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$get_engine_status_input()
  output <- .neptunedata$get_engine_status_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$get_engine_status <- neptunedata_get_engine_status

#' Gets the status of a specified Gremlin query
#'
#' @description
#' Gets the status of a specified Gremlin query.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_get_gremlin_query_status/](https://www.paws-r-sdk.com/docs/neptunedata_get_gremlin_query_status/) for full documentation.
#'
#' @param queryId &#91;required&#93; The unique identifier that identifies the Gremlin query.
#'
#' @keywords internal
#'
#' @rdname neptunedata_get_gremlin_query_status
neptunedata_get_gremlin_query_status <- function(queryId) {
  op <- new_operation(
    name = "GetGremlinQueryStatus",
    http_method = "GET",
    http_path = "/gremlin/status/{queryId}",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$get_gremlin_query_status_input(queryId = queryId)
  output <- .neptunedata$get_gremlin_query_status_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$get_gremlin_query_status <- neptunedata_get_gremlin_query_status

#' Gets status information about a specified load job
#'
#' @description
#' Gets status information about a specified load job. Neptune keeps track of the most recent 1,024 bulk load jobs, and stores the last 10,000 error details per job.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_get_loader_job_status/](https://www.paws-r-sdk.com/docs/neptunedata_get_loader_job_status/) for full documentation.
#'
#' @param loadId &#91;required&#93; The load ID of the load job to get the status of.
#' @param details Flag indicating whether or not to include details beyond the overall
#' status (`TRUE` or `FALSE`; the default is `FALSE`).
#' @param errors Flag indicating whether or not to include a list of errors encountered
#' (`TRUE` or `FALSE`; the default is `FALSE`).
#' 
#' The list of errors is paged. The `page` and `errorsPerPage` parameters
#' allow you to page through all the errors.
#' @param page The error page number (a positive integer; the default is `1`). Only
#' valid when the `errors` parameter is set to `TRUE`.
#' @param errorsPerPage The number of errors returned in each page (a positive integer; the
#' default is `10`). Only valid when the `errors` parameter set to `TRUE`.
#'
#' @keywords internal
#'
#' @rdname neptunedata_get_loader_job_status
neptunedata_get_loader_job_status <- function(loadId, details = NULL, errors = NULL, page = NULL, errorsPerPage = NULL) {
  op <- new_operation(
    name = "GetLoaderJobStatus",
    http_method = "GET",
    http_path = "/loader/{loadId}",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$get_loader_job_status_input(loadId = loadId, details = details, errors = errors, page = page, errorsPerPage = errorsPerPage)
  output <- .neptunedata$get_loader_job_status_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$get_loader_job_status <- neptunedata_get_loader_job_status

#' Retrieves information about a specified data processing job
#'
#' @description
#' Retrieves information about a specified data processing job. See [The `dataprocessing` command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_get_ml_data_processing_job/](https://www.paws-r-sdk.com/docs/neptunedata_get_ml_data_processing_job/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier of the data-processing job to be retrieved.
#' @param neptuneIamRoleArn The ARN of an IAM role that provides Neptune access to SageMaker and
#' Amazon S3 resources. This must be listed in your DB cluster parameter
#' group or an error will occur.
#'
#' @keywords internal
#'
#' @rdname neptunedata_get_ml_data_processing_job
neptunedata_get_ml_data_processing_job <- function(id, neptuneIamRoleArn = NULL) {
  op <- new_operation(
    name = "GetMLDataProcessingJob",
    http_method = "GET",
    http_path = "/ml/dataprocessing/{id}",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$get_ml_data_processing_job_input(id = id, neptuneIamRoleArn = neptuneIamRoleArn)
  output <- .neptunedata$get_ml_data_processing_job_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$get_ml_data_processing_job <- neptunedata_get_ml_data_processing_job

#' Retrieves details about an inference endpoint
#'
#' @description
#' Retrieves details about an inference endpoint. See [Managing inference endpoints using the endpoints command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_get_ml_endpoint/](https://www.paws-r-sdk.com/docs/neptunedata_get_ml_endpoint/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier of the inference endpoint.
#' @param neptuneIamRoleArn The ARN of an IAM role that provides Neptune access to SageMaker and
#' Amazon S3 resources. This must be listed in your DB cluster parameter
#' group or an error will occur.
#'
#' @keywords internal
#'
#' @rdname neptunedata_get_ml_endpoint
neptunedata_get_ml_endpoint <- function(id, neptuneIamRoleArn = NULL) {
  op <- new_operation(
    name = "GetMLEndpoint",
    http_method = "GET",
    http_path = "/ml/endpoints/{id}",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$get_ml_endpoint_input(id = id, neptuneIamRoleArn = neptuneIamRoleArn)
  output <- .neptunedata$get_ml_endpoint_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$get_ml_endpoint <- neptunedata_get_ml_endpoint

#' Retrieves information about a Neptune ML model training job
#'
#' @description
#' Retrieves information about a Neptune ML model training job. See [Model training using the `modeltraining` command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_get_ml_model_training_job/](https://www.paws-r-sdk.com/docs/neptunedata_get_ml_model_training_job/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier of the model-training job to retrieve.
#' @param neptuneIamRoleArn The ARN of an IAM role that provides Neptune access to SageMaker and
#' Amazon S3 resources. This must be listed in your DB cluster parameter
#' group or an error will occur.
#'
#' @keywords internal
#'
#' @rdname neptunedata_get_ml_model_training_job
neptunedata_get_ml_model_training_job <- function(id, neptuneIamRoleArn = NULL) {
  op <- new_operation(
    name = "GetMLModelTrainingJob",
    http_method = "GET",
    http_path = "/ml/modeltraining/{id}",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$get_ml_model_training_job_input(id = id, neptuneIamRoleArn = neptuneIamRoleArn)
  output <- .neptunedata$get_ml_model_training_job_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$get_ml_model_training_job <- neptunedata_get_ml_model_training_job

#' Gets information about a specified model transform job
#'
#' @description
#' Gets information about a specified model transform job. See [Use a trained model to generate new model artifacts](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_get_ml_model_transform_job/](https://www.paws-r-sdk.com/docs/neptunedata_get_ml_model_transform_job/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier of the model-transform job to be reetrieved.
#' @param neptuneIamRoleArn The ARN of an IAM role that provides Neptune access to SageMaker and
#' Amazon S3 resources. This must be listed in your DB cluster parameter
#' group or an error will occur.
#'
#' @keywords internal
#'
#' @rdname neptunedata_get_ml_model_transform_job
neptunedata_get_ml_model_transform_job <- function(id, neptuneIamRoleArn = NULL) {
  op <- new_operation(
    name = "GetMLModelTransformJob",
    http_method = "GET",
    http_path = "/ml/modeltransform/{id}",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$get_ml_model_transform_job_input(id = id, neptuneIamRoleArn = neptuneIamRoleArn)
  output <- .neptunedata$get_ml_model_transform_job_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$get_ml_model_transform_job <- neptunedata_get_ml_model_transform_job

#' Retrieves the status of a specified openCypher query
#'
#' @description
#' Retrieves the status of a specified openCypher query.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_get_open_cypher_query_status/](https://www.paws-r-sdk.com/docs/neptunedata_get_open_cypher_query_status/) for full documentation.
#'
#' @param queryId &#91;required&#93; The unique ID of the openCypher query for which to retrieve the query
#' status.
#'
#' @keywords internal
#'
#' @rdname neptunedata_get_open_cypher_query_status
neptunedata_get_open_cypher_query_status <- function(queryId) {
  op <- new_operation(
    name = "GetOpenCypherQueryStatus",
    http_method = "GET",
    http_path = "/opencypher/status/{queryId}",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$get_open_cypher_query_status_input(queryId = queryId)
  output <- .neptunedata$get_open_cypher_query_status_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$get_open_cypher_query_status <- neptunedata_get_open_cypher_query_status

#' Gets property graph statistics (Gremlin and openCypher)
#'
#' @description
#' Gets property graph statistics (Gremlin and openCypher).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_get_propertygraph_statistics/](https://www.paws-r-sdk.com/docs/neptunedata_get_propertygraph_statistics/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname neptunedata_get_propertygraph_statistics
neptunedata_get_propertygraph_statistics <- function() {
  op <- new_operation(
    name = "GetPropertygraphStatistics",
    http_method = "GET",
    http_path = "/propertygraph/statistics",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$get_propertygraph_statistics_input()
  output <- .neptunedata$get_propertygraph_statistics_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$get_propertygraph_statistics <- neptunedata_get_propertygraph_statistics

#' Gets a stream for a property graph
#'
#' @description
#' Gets a stream for a property graph.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_get_propertygraph_stream/](https://www.paws-r-sdk.com/docs/neptunedata_get_propertygraph_stream/) for full documentation.
#'
#' @param limit Specifies the maximum number of records to return. There is also a size
#' limit of 10 MB on the response that can't be modified and that takes
#' precedence over the number of records specified in the `limit`
#' parameter. The response does include a threshold-breaching record if the
#' 10 MB limit was reached.
#' 
#' The range for `limit` is 1 to 100,000, with a default of 10.
#' @param iteratorType Can be one of:
#' 
#' -   `AT_SEQUENCE_NUMBER`   –   Indicates that reading should start from
#'     the event sequence number specified jointly by the `commitNum` and
#'     `opNum` parameters.
#' 
#' -   `AFTER_SEQUENCE_NUMBER`   –   Indicates that reading should start
#'     right after the event sequence number specified jointly by the
#'     `commitNum` and `opNum` parameters.
#' 
#' -   `TRIM_HORIZON`   –   Indicates that reading should start at the last
#'     untrimmed record in the system, which is the oldest unexpired (not
#'     yet deleted) record in the change-log stream.
#' 
#' -   `LATEST`   –   Indicates that reading should start at the most
#'     recent record in the system, which is the latest unexpired (not yet
#'     deleted) record in the change-log stream.
#' @param commitNum The commit number of the starting record to read from the change-log
#' stream. This parameter is required when `iteratorType`
#' is`AT_SEQUENCE_NUMBER` or `AFTER_SEQUENCE_NUMBER`, and ignored when
#' `iteratorType` is `TRIM_HORIZON` or `LATEST`.
#' @param opNum The operation sequence number within the specified commit to start
#' reading from in the change-log stream data. The default is `1`.
#' @param encoding If set to TRUE, Neptune compresses the response using gzip encoding.
#'
#' @keywords internal
#'
#' @rdname neptunedata_get_propertygraph_stream
neptunedata_get_propertygraph_stream <- function(limit = NULL, iteratorType = NULL, commitNum = NULL, opNum = NULL, encoding = NULL) {
  op <- new_operation(
    name = "GetPropertygraphStream",
    http_method = "GET",
    http_path = "/propertygraph/stream",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$get_propertygraph_stream_input(limit = limit, iteratorType = iteratorType, commitNum = commitNum, opNum = opNum, encoding = encoding)
  output <- .neptunedata$get_propertygraph_stream_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$get_propertygraph_stream <- neptunedata_get_propertygraph_stream

#' Gets a graph summary for a property graph
#'
#' @description
#' Gets a graph summary for a property graph.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_get_propertygraph_summary/](https://www.paws-r-sdk.com/docs/neptunedata_get_propertygraph_summary/) for full documentation.
#'
#' @param mode Mode can take one of two values: `BASIC` (the default), and `DETAILED`.
#'
#' @keywords internal
#'
#' @rdname neptunedata_get_propertygraph_summary
neptunedata_get_propertygraph_summary <- function(mode = NULL) {
  op <- new_operation(
    name = "GetPropertygraphSummary",
    http_method = "GET",
    http_path = "/propertygraph/statistics/summary",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$get_propertygraph_summary_input(mode = mode)
  output <- .neptunedata$get_propertygraph_summary_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$get_propertygraph_summary <- neptunedata_get_propertygraph_summary

#' Gets a graph summary for an RDF graph
#'
#' @description
#' Gets a graph summary for an RDF graph.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_get_rdf_graph_summary/](https://www.paws-r-sdk.com/docs/neptunedata_get_rdf_graph_summary/) for full documentation.
#'
#' @param mode Mode can take one of two values: `BASIC` (the default), and `DETAILED`.
#'
#' @keywords internal
#'
#' @rdname neptunedata_get_rdf_graph_summary
neptunedata_get_rdf_graph_summary <- function(mode = NULL) {
  op <- new_operation(
    name = "GetRDFGraphSummary",
    http_method = "GET",
    http_path = "/rdf/statistics/summary",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$get_rdf_graph_summary_input(mode = mode)
  output <- .neptunedata$get_rdf_graph_summary_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$get_rdf_graph_summary <- neptunedata_get_rdf_graph_summary

#' Gets RDF statistics (SPARQL)
#'
#' @description
#' Gets RDF statistics (SPARQL).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_get_sparql_statistics/](https://www.paws-r-sdk.com/docs/neptunedata_get_sparql_statistics/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname neptunedata_get_sparql_statistics
neptunedata_get_sparql_statistics <- function() {
  op <- new_operation(
    name = "GetSparqlStatistics",
    http_method = "GET",
    http_path = "/sparql/statistics",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$get_sparql_statistics_input()
  output <- .neptunedata$get_sparql_statistics_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$get_sparql_statistics <- neptunedata_get_sparql_statistics

#' Gets a stream for an RDF graph
#'
#' @description
#' Gets a stream for an RDF graph.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_get_sparql_stream/](https://www.paws-r-sdk.com/docs/neptunedata_get_sparql_stream/) for full documentation.
#'
#' @param limit Specifies the maximum number of records to return. There is also a size
#' limit of 10 MB on the response that can't be modified and that takes
#' precedence over the number of records specified in the `limit`
#' parameter. The response does include a threshold-breaching record if the
#' 10 MB limit was reached.
#' 
#' The range for `limit` is 1 to 100,000, with a default of 10.
#' @param iteratorType Can be one of:
#' 
#' -   `AT_SEQUENCE_NUMBER`   –   Indicates that reading should start from
#'     the event sequence number specified jointly by the `commitNum` and
#'     `opNum` parameters.
#' 
#' -   `AFTER_SEQUENCE_NUMBER`   –   Indicates that reading should start
#'     right after the event sequence number specified jointly by the
#'     `commitNum` and `opNum` parameters.
#' 
#' -   `TRIM_HORIZON`   –   Indicates that reading should start at the last
#'     untrimmed record in the system, which is the oldest unexpired (not
#'     yet deleted) record in the change-log stream.
#' 
#' -   `LATEST`   –   Indicates that reading should start at the most
#'     recent record in the system, which is the latest unexpired (not yet
#'     deleted) record in the change-log stream.
#' @param commitNum The commit number of the starting record to read from the change-log
#' stream. This parameter is required when `iteratorType`
#' is`AT_SEQUENCE_NUMBER` or `AFTER_SEQUENCE_NUMBER`, and ignored when
#' `iteratorType` is `TRIM_HORIZON` or `LATEST`.
#' @param opNum The operation sequence number within the specified commit to start
#' reading from in the change-log stream data. The default is `1`.
#' @param encoding If set to TRUE, Neptune compresses the response using gzip encoding.
#'
#' @keywords internal
#'
#' @rdname neptunedata_get_sparql_stream
neptunedata_get_sparql_stream <- function(limit = NULL, iteratorType = NULL, commitNum = NULL, opNum = NULL, encoding = NULL) {
  op <- new_operation(
    name = "GetSparqlStream",
    http_method = "GET",
    http_path = "/sparql/stream",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$get_sparql_stream_input(limit = limit, iteratorType = iteratorType, commitNum = commitNum, opNum = opNum, encoding = encoding)
  output <- .neptunedata$get_sparql_stream_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$get_sparql_stream <- neptunedata_get_sparql_stream

#' Lists active Gremlin queries
#'
#' @description
#' Lists active Gremlin queries. See [Gremlin query status API](https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status.html) for details about the output.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_list_gremlin_queries/](https://www.paws-r-sdk.com/docs/neptunedata_list_gremlin_queries/) for full documentation.
#'
#' @param includeWaiting If set to `TRUE`, the list returned includes waiting queries. The
#' default is `FALSE`;
#'
#' @keywords internal
#'
#' @rdname neptunedata_list_gremlin_queries
neptunedata_list_gremlin_queries <- function(includeWaiting = NULL) {
  op <- new_operation(
    name = "ListGremlinQueries",
    http_method = "GET",
    http_path = "/gremlin/status",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$list_gremlin_queries_input(includeWaiting = includeWaiting)
  output <- .neptunedata$list_gremlin_queries_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$list_gremlin_queries <- neptunedata_list_gremlin_queries

#' Retrieves a list of the loadIds for all active loader jobs
#'
#' @description
#' Retrieves a list of the `loadIds` for all active loader jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_list_loader_jobs/](https://www.paws-r-sdk.com/docs/neptunedata_list_loader_jobs/) for full documentation.
#'
#' @param limit The number of load IDs to list. Must be a positive integer greater than
#' zero and not more than `100` (which is the default).
#' @param includeQueuedLoads An optional parameter that can be used to exclude the load IDs of queued
#' load requests when requesting a list of load IDs by setting the
#' parameter to `FALSE`. The default value is `TRUE`.
#'
#' @keywords internal
#'
#' @rdname neptunedata_list_loader_jobs
neptunedata_list_loader_jobs <- function(limit = NULL, includeQueuedLoads = NULL) {
  op <- new_operation(
    name = "ListLoaderJobs",
    http_method = "GET",
    http_path = "/loader",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$list_loader_jobs_input(limit = limit, includeQueuedLoads = includeQueuedLoads)
  output <- .neptunedata$list_loader_jobs_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$list_loader_jobs <- neptunedata_list_loader_jobs

#' Returns a list of Neptune ML data processing jobs
#'
#' @description
#' Returns a list of Neptune ML data processing jobs. See [Listing active data-processing jobs using the Neptune ML dataprocessing command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html#machine-learning-api-dataprocessing-list-jobs).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_list_ml_data_processing_jobs/](https://www.paws-r-sdk.com/docs/neptunedata_list_ml_data_processing_jobs/) for full documentation.
#'
#' @param maxItems The maximum number of items to return (from 1 to 1024; the default is
#' 10).
#' @param neptuneIamRoleArn The ARN of an IAM role that provides Neptune access to SageMaker and
#' Amazon S3 resources. This must be listed in your DB cluster parameter
#' group or an error will occur.
#'
#' @keywords internal
#'
#' @rdname neptunedata_list_ml_data_processing_jobs
neptunedata_list_ml_data_processing_jobs <- function(maxItems = NULL, neptuneIamRoleArn = NULL) {
  op <- new_operation(
    name = "ListMLDataProcessingJobs",
    http_method = "GET",
    http_path = "/ml/dataprocessing",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$list_ml_data_processing_jobs_input(maxItems = maxItems, neptuneIamRoleArn = neptuneIamRoleArn)
  output <- .neptunedata$list_ml_data_processing_jobs_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$list_ml_data_processing_jobs <- neptunedata_list_ml_data_processing_jobs

#' Lists existing inference endpoints
#'
#' @description
#' Lists existing inference endpoints. See [Managing inference endpoints using the endpoints command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_list_ml_endpoints/](https://www.paws-r-sdk.com/docs/neptunedata_list_ml_endpoints/) for full documentation.
#'
#' @param maxItems The maximum number of items to return (from 1 to 1024; the default is
#' 10.
#' @param neptuneIamRoleArn The ARN of an IAM role that provides Neptune access to SageMaker and
#' Amazon S3 resources. This must be listed in your DB cluster parameter
#' group or an error will occur.
#'
#' @keywords internal
#'
#' @rdname neptunedata_list_ml_endpoints
neptunedata_list_ml_endpoints <- function(maxItems = NULL, neptuneIamRoleArn = NULL) {
  op <- new_operation(
    name = "ListMLEndpoints",
    http_method = "GET",
    http_path = "/ml/endpoints",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$list_ml_endpoints_input(maxItems = maxItems, neptuneIamRoleArn = neptuneIamRoleArn)
  output <- .neptunedata$list_ml_endpoints_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$list_ml_endpoints <- neptunedata_list_ml_endpoints

#' Lists Neptune ML model-training jobs
#'
#' @description
#' Lists Neptune ML model-training jobs. See [Model training using the `modeltraining` command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_list_ml_model_training_jobs/](https://www.paws-r-sdk.com/docs/neptunedata_list_ml_model_training_jobs/) for full documentation.
#'
#' @param maxItems The maximum number of items to return (from 1 to 1024; the default is
#' 10).
#' @param neptuneIamRoleArn The ARN of an IAM role that provides Neptune access to SageMaker and
#' Amazon S3 resources. This must be listed in your DB cluster parameter
#' group or an error will occur.
#'
#' @keywords internal
#'
#' @rdname neptunedata_list_ml_model_training_jobs
neptunedata_list_ml_model_training_jobs <- function(maxItems = NULL, neptuneIamRoleArn = NULL) {
  op <- new_operation(
    name = "ListMLModelTrainingJobs",
    http_method = "GET",
    http_path = "/ml/modeltraining",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$list_ml_model_training_jobs_input(maxItems = maxItems, neptuneIamRoleArn = neptuneIamRoleArn)
  output <- .neptunedata$list_ml_model_training_jobs_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$list_ml_model_training_jobs <- neptunedata_list_ml_model_training_jobs

#' Returns a list of model transform job IDs
#'
#' @description
#' Returns a list of model transform job IDs. See [Use a trained model to generate new model artifacts](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_list_ml_model_transform_jobs/](https://www.paws-r-sdk.com/docs/neptunedata_list_ml_model_transform_jobs/) for full documentation.
#'
#' @param maxItems The maximum number of items to return (from 1 to 1024; the default is
#' 10).
#' @param neptuneIamRoleArn The ARN of an IAM role that provides Neptune access to SageMaker and
#' Amazon S3 resources. This must be listed in your DB cluster parameter
#' group or an error will occur.
#'
#' @keywords internal
#'
#' @rdname neptunedata_list_ml_model_transform_jobs
neptunedata_list_ml_model_transform_jobs <- function(maxItems = NULL, neptuneIamRoleArn = NULL) {
  op <- new_operation(
    name = "ListMLModelTransformJobs",
    http_method = "GET",
    http_path = "/ml/modeltransform",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$list_ml_model_transform_jobs_input(maxItems = maxItems, neptuneIamRoleArn = neptuneIamRoleArn)
  output <- .neptunedata$list_ml_model_transform_jobs_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$list_ml_model_transform_jobs <- neptunedata_list_ml_model_transform_jobs

#' Lists active openCypher queries
#'
#' @description
#' Lists active openCypher queries. See [Neptune openCypher status endpoint](https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html) for more information.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_list_open_cypher_queries/](https://www.paws-r-sdk.com/docs/neptunedata_list_open_cypher_queries/) for full documentation.
#'
#' @param includeWaiting When set to `TRUE` and other parameters are not present, causes status
#' information to be returned for waiting queries as well as for running
#' queries.
#'
#' @keywords internal
#'
#' @rdname neptunedata_list_open_cypher_queries
neptunedata_list_open_cypher_queries <- function(includeWaiting = NULL) {
  op <- new_operation(
    name = "ListOpenCypherQueries",
    http_method = "GET",
    http_path = "/opencypher/status",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$list_open_cypher_queries_input(includeWaiting = includeWaiting)
  output <- .neptunedata$list_open_cypher_queries_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$list_open_cypher_queries <- neptunedata_list_open_cypher_queries

#' Manages the generation and use of property graph statistics
#'
#' @description
#' Manages the generation and use of property graph statistics.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_manage_propertygraph_statistics/](https://www.paws-r-sdk.com/docs/neptunedata_manage_propertygraph_statistics/) for full documentation.
#'
#' @param mode The statistics generation mode. One of: `DISABLE_AUTOCOMPUTE`,
#' `ENABLE_AUTOCOMPUTE`, or `REFRESH`, the last of which manually triggers
#' DFE statistics generation.
#'
#' @keywords internal
#'
#' @rdname neptunedata_manage_propertygraph_statistics
neptunedata_manage_propertygraph_statistics <- function(mode = NULL) {
  op <- new_operation(
    name = "ManagePropertygraphStatistics",
    http_method = "POST",
    http_path = "/propertygraph/statistics",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$manage_propertygraph_statistics_input(mode = mode)
  output <- .neptunedata$manage_propertygraph_statistics_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$manage_propertygraph_statistics <- neptunedata_manage_propertygraph_statistics

#' Manages the generation and use of RDF graph statistics
#'
#' @description
#' Manages the generation and use of RDF graph statistics.
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_manage_sparql_statistics/](https://www.paws-r-sdk.com/docs/neptunedata_manage_sparql_statistics/) for full documentation.
#'
#' @param mode The statistics generation mode. One of: `DISABLE_AUTOCOMPUTE`,
#' `ENABLE_AUTOCOMPUTE`, or `REFRESH`, the last of which manually triggers
#' DFE statistics generation.
#'
#' @keywords internal
#'
#' @rdname neptunedata_manage_sparql_statistics
neptunedata_manage_sparql_statistics <- function(mode = NULL) {
  op <- new_operation(
    name = "ManageSparqlStatistics",
    http_method = "POST",
    http_path = "/sparql/statistics",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$manage_sparql_statistics_input(mode = mode)
  output <- .neptunedata$manage_sparql_statistics_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$manage_sparql_statistics <- neptunedata_manage_sparql_statistics

#' Starts a Neptune bulk loader job to load data from an Amazon S3 bucket
#' into a Neptune DB instance
#'
#' @description
#' Starts a Neptune bulk loader job to load data from an Amazon S3 bucket into a Neptune DB instance. See [Using the Amazon Neptune Bulk Loader to Ingest Data](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load.html).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_start_loader_job/](https://www.paws-r-sdk.com/docs/neptunedata_start_loader_job/) for full documentation.
#'
#' @param source &#91;required&#93; The `source` parameter accepts an S3 URI that identifies a single file,
#' multiple files, a folder, or multiple folders. Neptune loads every data
#' file in any folder that is specified.
#' 
#' The URI can be in any of the following formats.
#' 
#' -   `s3://(bucket_name)/(object-key-name)`
#' 
#' -   `https://s3.amazonaws.com/(bucket_name)/(object-key-name)`
#' 
#' -   `https://s3.us-east-1.amazonaws.com/(bucket_name)/(object-key-name)`
#' 
#' The `object-key-name` element of the URI is equivalent to the
#' [prefix](https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html#API_ListObjects_RequestParameters)
#' parameter in an S3
#' [ListObjects](https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html)
#' API call. It identifies all the objects in the specified S3 bucket whose
#' names begin with that prefix. That can be a single file or folder, or
#' multiple files and/or folders.
#' 
#' The specified folder or folders can contain multiple vertex files and
#' multiple edge files.
#' @param format &#91;required&#93; The format of the data. For more information about data formats for the
#' Neptune `Loader` command, see [Load Data
#' Formats](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format.html).
#' 
#' **Allowed values**
#' 
#' -   **`csv`** for the [Gremlin CSV data
#'     format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html).
#' 
#' -   **`opencypher`** for the [openCypher CSV data
#'     format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html).
#' 
#' -   **`ntriples`** for the [N-Triples RDF data
#'     format](https://www.w3.org/TR/n-triples/).
#' 
#' -   **`nquads`** for the [N-Quads RDF data
#'     format](https://www.w3.org/TR/n-quads/).
#' 
#' -   **`rdfxml`** for the [RDF\\XML RDF data
#'     format](https://www.w3.org/TR/rdf-syntax-grammar/).
#' 
#' -   **`turtle`** for the [Turtle RDF data
#'     format](https://www.w3.org/TR/turtle/).
#' @param s3BucketRegion &#91;required&#93; The Amazon region of the S3 bucket. This must match the Amazon Region of
#' the DB cluster.
#' @param iamRoleArn &#91;required&#93; The Amazon Resource Name (ARN) for an IAM role to be assumed by the
#' Neptune DB instance for access to the S3 bucket. The IAM role ARN
#' provided here should be attached to the DB cluster (see [Adding the IAM
#' Role to an Amazon Neptune
#' Cluster](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-IAM-add-role-cluster.html).
#' @param mode The load job mode.
#' 
#' *Allowed values*: `RESUME`, `NEW`, `AUTO`.
#' 
#' *Default value*: `AUTO`.
#' 
#' -   `RESUME`   –   In RESUME mode, the loader looks for a previous load
#'     from this source, and if it finds one, resumes that load job. If no
#'     previous load job is found, the loader stops.
#' 
#'     The loader avoids reloading files that were successfully loaded in a
#'     previous job. It only tries to process failed files. If you dropped
#'     previously loaded data from your Neptune cluster, that data is not
#'     reloaded in this mode. If a previous load job loaded all files from
#'     the same source successfully, nothing is reloaded, and the loader
#'     returns success.
#' 
#' -   `NEW`   –   In NEW mode, the creates a new load request regardless
#'     of any previous loads. You can use this mode to reload all the data
#'     from a source after dropping previously loaded data from your
#'     Neptune cluster, or to load new data available at the same source.
#' 
#' -   `AUTO`   –   In AUTO mode, the loader looks for a previous load job
#'     from the same source, and if it finds one, resumes that job, just as
#'     in `RESUME` mode.
#' 
#'     If the loader doesn't find a previous load job from the same source,
#'     it loads all data from the source, just as in `NEW` mode.
#' @param failOnError **`failOnError`**   –   A flag to toggle a complete stop on an error.
#' 
#' *Allowed values*: `"TRUE"`, `"FALSE"`.
#' 
#' *Default value*: `"TRUE"`.
#' 
#' When this parameter is set to `"FALSE"`, the loader tries to load all
#' the data in the location specified, skipping any entries with errors.
#' 
#' When this parameter is set to `"TRUE"`, the loader stops as soon as it
#' encounters an error. Data loaded up to that point persists.
#' @param parallelism The optional `parallelism` parameter can be set to reduce the number of
#' threads used by the bulk load process.
#' 
#' *Allowed values*:
#' 
#' -   `LOW` –   The number of threads used is the number of available
#'     vCPUs divided by 8.
#' 
#' -   `MEDIUM` –   The number of threads used is the number of available
#'     vCPUs divided by 2.
#' 
#' -   `HIGH` –   The number of threads used is the same as the number of
#'     available vCPUs.
#' 
#' -   `OVERSUBSCRIBE` –   The number of threads used is the number of
#'     available vCPUs multiplied by 2. If this value is used, the bulk
#'     loader takes up all available resources.
#' 
#'     This does not mean, however, that the `OVERSUBSCRIBE` setting
#'     results in 100% CPU utilization. Because the load operation is I/O
#'     bound, the highest CPU utilization to expect is in the 60% to 70%
#'     range.
#' 
#' *Default value*: `HIGH`
#' 
#' The `parallelism` setting can sometimes result in a deadlock between
#' threads when loading openCypher data. When this happens, Neptune returns
#' the `LOAD_DATA_DEADLOCK` error. You can generally fix the issue by
#' setting `parallelism` to a lower setting and retrying the load command.
#' @param parserConfiguration **`parserConfiguration`**   –   An optional object with additional
#' parser configuration values. Each of the child parameters is also
#' optional:
#' 
#' -   **`namedGraphUri`**   –   The default graph for all RDF formats when
#'     no graph is specified (for non-quads formats and NQUAD entries with
#'     no graph).
#' 
#'     The default is
#'     `https://aws.amazon.com/neptune/vocab/v01/DefaultNamedGraph`.
#' 
#' -   **`baseUri`**   –   The base URI for RDF/XML and Turtle formats.
#' 
#'     The default is `https://aws.amazon.com/neptune/default`.
#' 
#' -   **`allowEmptyStrings`**   –   Gremlin users need to be able to pass
#'     empty string values("") as node and edge properties when loading CSV
#'     data. If `allowEmptyStrings` is set to `false` (the default), such
#'     empty strings are treated as nulls and are not loaded.
#' 
#'     If `allowEmptyStrings` is set to `true`, the loader treats empty
#'     strings as valid property values and loads them accordingly.
#' @param updateSingleCardinalityProperties `updateSingleCardinalityProperties` is an optional parameter that
#' controls how the bulk loader treats a new value for single-cardinality
#' vertex or edge properties. This is not supported for loading openCypher
#' data.
#' 
#' *Allowed values*: `"TRUE"`, `"FALSE"`.
#' 
#' *Default value*: `"FALSE"`.
#' 
#' By default, or when `updateSingleCardinalityProperties` is explicitly
#' set to `"FALSE"`, the loader treats a new value as an error, because it
#' violates single cardinality.
#' 
#' When `updateSingleCardinalityProperties` is set to `"TRUE"`, on the
#' other hand, the bulk loader replaces the existing value with the new
#' one. If multiple edge or single-cardinality vertex property values are
#' provided in the source file(s) being loaded, the final value at the end
#' of the bulk load could be any one of those new values. The loader only
#' guarantees that the existing value has been replaced by one of the new
#' ones.
#' @param queueRequest This is an optional flag parameter that indicates whether the load
#' request can be queued up or not.
#' 
#' You don't have to wait for one load job to complete before issuing the
#' next one, because Neptune can queue up as many as 64 jobs at a time,
#' provided that their `queueRequest` parameters are all set to `"TRUE"`.
#' The queue order of the jobs will be first-in-first-out (FIFO).
#' 
#' If the `queueRequest` parameter is omitted or set to `"FALSE"`, the load
#' request will fail if another load job is already running.
#' 
#' *Allowed values*: `"TRUE"`, `"FALSE"`.
#' 
#' *Default value*: `"FALSE"`.
#' @param dependencies This is an optional parameter that can make a queued load request
#' contingent on the successful completion of one or more previous jobs in
#' the queue.
#' 
#' Neptune can queue up as many as 64 load requests at a time, if their
#' `queueRequest` parameters are set to `"TRUE"`. The `dependencies`
#' parameter lets you make execution of such a queued request dependent on
#' the successful completion of one or more specified previous requests in
#' the queue.
#' 
#' For example, if load `Job-A` and `Job-B` are independent of each other,
#' but load `Job-C` needs `Job-A` and `Job-B` to be finished before it
#' begins, proceed as follows:
#' 
#' 1.  Submit `load-job-A` and `load-job-B` one after another in any order,
#'     and save their load-ids.
#' 
#' 2.  Submit `load-job-C` with the load-ids of the two jobs in its
#'     `dependencies` field:
#' 
#' Because of the `dependencies` parameter, the bulk loader will not start
#' `Job-C` until `Job-A` and `Job-B` have completed successfully. If either
#' one of them fails, Job-C will not be executed, and its status will be
#' set to `LOAD_FAILED_BECAUSE_DEPENDENCY_NOT_SATISFIED`.
#' 
#' You can set up multiple levels of dependency in this way, so that the
#' failure of one job will cause all requests that are directly or
#' indirectly dependent on it to be cancelled.
#' @param userProvidedEdgeIds This parameter is required only when loading openCypher data that
#' contains relationship IDs. It must be included and set to `True` when
#' openCypher relationship IDs are explicitly provided in the load data
#' (recommended).
#' 
#' When `userProvidedEdgeIds` is absent or set to `True`, an `:ID` column
#' must be present in every relationship file in the load.
#' 
#' When `userProvidedEdgeIds` is present and set to `False`, relationship
#' files in the load **must not** contain an `:ID` column. Instead, the
#' Neptune loader automatically generates an ID for each relationship.
#' 
#' It's useful to provide relationship IDs explicitly so that the loader
#' can resume loading after error in the CSV data have been fixed, without
#' having to reload any relationships that have already been loaded. If
#' relationship IDs have not been explicitly assigned, the loader cannot
#' resume a failed load if any relationship file has had to be corrected,
#' and must instead reload all the relationships.
#'
#' @keywords internal
#'
#' @rdname neptunedata_start_loader_job
neptunedata_start_loader_job <- function(source, format, s3BucketRegion, iamRoleArn, mode = NULL, failOnError = NULL, parallelism = NULL, parserConfiguration = NULL, updateSingleCardinalityProperties = NULL, queueRequest = NULL, dependencies = NULL, userProvidedEdgeIds = NULL) {
  op <- new_operation(
    name = "StartLoaderJob",
    http_method = "POST",
    http_path = "/loader",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$start_loader_job_input(source = source, format = format, s3BucketRegion = s3BucketRegion, iamRoleArn = iamRoleArn, mode = mode, failOnError = failOnError, parallelism = parallelism, parserConfiguration = parserConfiguration, updateSingleCardinalityProperties = updateSingleCardinalityProperties, queueRequest = queueRequest, dependencies = dependencies, userProvidedEdgeIds = userProvidedEdgeIds)
  output <- .neptunedata$start_loader_job_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$start_loader_job <- neptunedata_start_loader_job

#' Creates a new Neptune ML data processing job for processing the graph
#' data exported from Neptune for training
#'
#' @description
#' Creates a new Neptune ML data processing job for processing the graph data exported from Neptune for training. See [The `dataprocessing` command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_start_ml_data_processing_job/](https://www.paws-r-sdk.com/docs/neptunedata_start_ml_data_processing_job/) for full documentation.
#'
#' @param id A unique identifier for the new job. The default is an autogenerated
#' UUID.
#' @param previousDataProcessingJobId The job ID of a completed data processing job run on an earlier version
#' of the data.
#' @param inputDataS3Location &#91;required&#93; The URI of the Amazon S3 location where you want SageMaker to download
#' the data needed to run the data processing job.
#' @param processedDataS3Location &#91;required&#93; The URI of the Amazon S3 location where you want SageMaker to save the
#' results of a data processing job.
#' @param sagemakerIamRoleArn The ARN of an IAM role for SageMaker execution. This must be listed in
#' your DB cluster parameter group or an error will occur.
#' @param neptuneIamRoleArn The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume
#' to perform tasks on your behalf. This must be listed in your DB cluster
#' parameter group or an error will occur.
#' @param processingInstanceType The type of ML instance used during data processing. Its memory should
#' be large enough to hold the processed dataset. The default is the
#' smallest ml.r5 type whose memory is ten times larger than the size of
#' the exported graph data on disk.
#' @param processingInstanceVolumeSizeInGB The disk volume size of the processing instance. Both input data and
#' processed data are stored on disk, so the volume size must be large
#' enough to hold both data sets. The default is 0. If not specified or 0,
#' Neptune ML chooses the volume size automatically based on the data size.
#' @param processingTimeOutInSeconds Timeout in seconds for the data processing job. The default is 86,400 (1
#' day).
#' @param modelType One of the two model types that Neptune ML currently supports:
#' heterogeneous graph models (`heterogeneous`), and knowledge graph
#' (`kge`). The default is none. If not specified, Neptune ML chooses the
#' model type automatically based on the data.
#' @param configFileName A data specification file that describes how to load the exported graph
#' data for training. The file is automatically generated by the Neptune
#' export toolkit. The default is `training-data-configuration.json`.
#' @param subnets The IDs of the subnets in the Neptune VPC. The default is None.
#' @param securityGroupIds The VPC security group IDs. The default is None.
#' @param volumeEncryptionKMSKey The Amazon Key Management Service (Amazon KMS) key that SageMaker uses
#' to encrypt data on the storage volume attached to the ML compute
#' instances that run the training job. The default is None.
#' @param s3OutputEncryptionKMSKey The Amazon Key Management Service (Amazon KMS) key that SageMaker uses
#' to encrypt the output of the processing job. The default is none.
#'
#' @keywords internal
#'
#' @rdname neptunedata_start_ml_data_processing_job
neptunedata_start_ml_data_processing_job <- function(id = NULL, previousDataProcessingJobId = NULL, inputDataS3Location, processedDataS3Location, sagemakerIamRoleArn = NULL, neptuneIamRoleArn = NULL, processingInstanceType = NULL, processingInstanceVolumeSizeInGB = NULL, processingTimeOutInSeconds = NULL, modelType = NULL, configFileName = NULL, subnets = NULL, securityGroupIds = NULL, volumeEncryptionKMSKey = NULL, s3OutputEncryptionKMSKey = NULL) {
  op <- new_operation(
    name = "StartMLDataProcessingJob",
    http_method = "POST",
    http_path = "/ml/dataprocessing",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$start_ml_data_processing_job_input(id = id, previousDataProcessingJobId = previousDataProcessingJobId, inputDataS3Location = inputDataS3Location, processedDataS3Location = processedDataS3Location, sagemakerIamRoleArn = sagemakerIamRoleArn, neptuneIamRoleArn = neptuneIamRoleArn, processingInstanceType = processingInstanceType, processingInstanceVolumeSizeInGB = processingInstanceVolumeSizeInGB, processingTimeOutInSeconds = processingTimeOutInSeconds, modelType = modelType, configFileName = configFileName, subnets = subnets, securityGroupIds = securityGroupIds, volumeEncryptionKMSKey = volumeEncryptionKMSKey, s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey)
  output <- .neptunedata$start_ml_data_processing_job_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$start_ml_data_processing_job <- neptunedata_start_ml_data_processing_job

#' Creates a new Neptune ML model training job
#'
#' @description
#' Creates a new Neptune ML model training job. See [Model training using the `modeltraining` command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_start_ml_model_training_job/](https://www.paws-r-sdk.com/docs/neptunedata_start_ml_model_training_job/) for full documentation.
#'
#' @param id A unique identifier for the new job. The default is An autogenerated
#' UUID.
#' @param previousModelTrainingJobId The job ID of a completed model-training job that you want to update
#' incrementally based on updated data.
#' @param dataProcessingJobId &#91;required&#93; The job ID of the completed data-processing job that has created the
#' data that the training will work with.
#' @param trainModelS3Location &#91;required&#93; The location in Amazon S3 where the model artifacts are to be stored.
#' @param sagemakerIamRoleArn The ARN of an IAM role for SageMaker execution.This must be listed in
#' your DB cluster parameter group or an error will occur.
#' @param neptuneIamRoleArn The ARN of an IAM role that provides Neptune access to SageMaker and
#' Amazon S3 resources. This must be listed in your DB cluster parameter
#' group or an error will occur.
#' @param baseProcessingInstanceType The type of ML instance used in preparing and managing training of ML
#' models. This is a CPU instance chosen based on memory requirements for
#' processing the training data and model.
#' @param trainingInstanceType The type of ML instance used for model training. All Neptune ML models
#' support CPU, GPU, and multiGPU training. The default is `ml.p3.2xlarge`.
#' Choosing the right instance type for training depends on the task type,
#' graph size, and your budget.
#' @param trainingInstanceVolumeSizeInGB The disk volume size of the training instance. Both input data and the
#' output model are stored on disk, so the volume size must be large enough
#' to hold both data sets. The default is 0. If not specified or 0, Neptune
#' ML selects a disk volume size based on the recommendation generated in
#' the data processing step.
#' @param trainingTimeOutInSeconds Timeout in seconds for the training job. The default is 86,400 (1 day).
#' @param maxHPONumberOfTrainingJobs Maximum total number of training jobs to start for the hyperparameter
#' tuning job. The default is 2. Neptune ML automatically tunes the
#' hyperparameters of the machine learning model. To obtain a model that
#' performs well, use at least 10 jobs (in other words, set
#' `maxHPONumberOfTrainingJobs` to 10). In general, the more tuning runs,
#' the better the results.
#' @param maxHPOParallelTrainingJobs Maximum number of parallel training jobs to start for the hyperparameter
#' tuning job. The default is 2. The number of parallel jobs you can run is
#' limited by the available resources on your training instance.
#' @param subnets The IDs of the subnets in the Neptune VPC. The default is None.
#' @param securityGroupIds The VPC security group IDs. The default is None.
#' @param volumeEncryptionKMSKey The Amazon Key Management Service (KMS) key that SageMaker uses to
#' encrypt data on the storage volume attached to the ML compute instances
#' that run the training job. The default is None.
#' @param s3OutputEncryptionKMSKey The Amazon Key Management Service (KMS) key that SageMaker uses to
#' encrypt the output of the processing job. The default is none.
#' @param enableManagedSpotTraining Optimizes the cost of training machine-learning models by using Amazon
#' Elastic Compute Cloud spot instances. The default is `False`.
#' @param customModelTrainingParameters The configuration for custom model training. This is a JSON object.
#'
#' @keywords internal
#'
#' @rdname neptunedata_start_ml_model_training_job
neptunedata_start_ml_model_training_job <- function(id = NULL, previousModelTrainingJobId = NULL, dataProcessingJobId, trainModelS3Location, sagemakerIamRoleArn = NULL, neptuneIamRoleArn = NULL, baseProcessingInstanceType = NULL, trainingInstanceType = NULL, trainingInstanceVolumeSizeInGB = NULL, trainingTimeOutInSeconds = NULL, maxHPONumberOfTrainingJobs = NULL, maxHPOParallelTrainingJobs = NULL, subnets = NULL, securityGroupIds = NULL, volumeEncryptionKMSKey = NULL, s3OutputEncryptionKMSKey = NULL, enableManagedSpotTraining = NULL, customModelTrainingParameters = NULL) {
  op <- new_operation(
    name = "StartMLModelTrainingJob",
    http_method = "POST",
    http_path = "/ml/modeltraining",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$start_ml_model_training_job_input(id = id, previousModelTrainingJobId = previousModelTrainingJobId, dataProcessingJobId = dataProcessingJobId, trainModelS3Location = trainModelS3Location, sagemakerIamRoleArn = sagemakerIamRoleArn, neptuneIamRoleArn = neptuneIamRoleArn, baseProcessingInstanceType = baseProcessingInstanceType, trainingInstanceType = trainingInstanceType, trainingInstanceVolumeSizeInGB = trainingInstanceVolumeSizeInGB, trainingTimeOutInSeconds = trainingTimeOutInSeconds, maxHPONumberOfTrainingJobs = maxHPONumberOfTrainingJobs, maxHPOParallelTrainingJobs = maxHPOParallelTrainingJobs, subnets = subnets, securityGroupIds = securityGroupIds, volumeEncryptionKMSKey = volumeEncryptionKMSKey, s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey, enableManagedSpotTraining = enableManagedSpotTraining, customModelTrainingParameters = customModelTrainingParameters)
  output <- .neptunedata$start_ml_model_training_job_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$start_ml_model_training_job <- neptunedata_start_ml_model_training_job

#' Creates a new model transform job
#'
#' @description
#' Creates a new model transform job. See [Use a trained model to generate new model artifacts](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
#'
#' See [https://www.paws-r-sdk.com/docs/neptunedata_start_ml_model_transform_job/](https://www.paws-r-sdk.com/docs/neptunedata_start_ml_model_transform_job/) for full documentation.
#'
#' @param id A unique identifier for the new job. The default is an autogenerated
#' UUID.
#' @param dataProcessingJobId The job ID of a completed data-processing job. You must include either
#' `dataProcessingJobId` and a `mlModelTrainingJobId`, or a
#' `trainingJobName`.
#' @param mlModelTrainingJobId The job ID of a completed model-training job. You must include either
#' `dataProcessingJobId` and a `mlModelTrainingJobId`, or a
#' `trainingJobName`.
#' @param trainingJobName The name of a completed SageMaker training job. You must include either
#' `dataProcessingJobId` and a `mlModelTrainingJobId`, or a
#' `trainingJobName`.
#' @param modelTransformOutputS3Location &#91;required&#93; The location in Amazon S3 where the model artifacts are to be stored.
#' @param sagemakerIamRoleArn The ARN of an IAM role for SageMaker execution. This must be listed in
#' your DB cluster parameter group or an error will occur.
#' @param neptuneIamRoleArn The ARN of an IAM role that provides Neptune access to SageMaker and
#' Amazon S3 resources. This must be listed in your DB cluster parameter
#' group or an error will occur.
#' @param customModelTransformParameters Configuration information for a model transform using a custom model.
#' The `customModelTransformParameters` object contains the following
#' fields, which must have values compatible with the saved model
#' parameters from the training job:
#' @param baseProcessingInstanceType The type of ML instance used in preparing and managing training of ML
#' models. This is an ML compute instance chosen based on memory
#' requirements for processing the training data and model.
#' @param baseProcessingInstanceVolumeSizeInGB The disk volume size of the training instance in gigabytes. The default
#' is 0. Both input data and the output model are stored on disk, so the
#' volume size must be large enough to hold both data sets. If not
#' specified or 0, Neptune ML selects a disk volume size based on the
#' recommendation generated in the data processing step.
#' @param subnets The IDs of the subnets in the Neptune VPC. The default is None.
#' @param securityGroupIds The VPC security group IDs. The default is None.
#' @param volumeEncryptionKMSKey The Amazon Key Management Service (KMS) key that SageMaker uses to
#' encrypt data on the storage volume attached to the ML compute instances
#' that run the training job. The default is None.
#' @param s3OutputEncryptionKMSKey The Amazon Key Management Service (KMS) key that SageMaker uses to
#' encrypt the output of the processing job. The default is none.
#'
#' @keywords internal
#'
#' @rdname neptunedata_start_ml_model_transform_job
neptunedata_start_ml_model_transform_job <- function(id = NULL, dataProcessingJobId = NULL, mlModelTrainingJobId = NULL, trainingJobName = NULL, modelTransformOutputS3Location, sagemakerIamRoleArn = NULL, neptuneIamRoleArn = NULL, customModelTransformParameters = NULL, baseProcessingInstanceType = NULL, baseProcessingInstanceVolumeSizeInGB = NULL, subnets = NULL, securityGroupIds = NULL, volumeEncryptionKMSKey = NULL, s3OutputEncryptionKMSKey = NULL) {
  op <- new_operation(
    name = "StartMLModelTransformJob",
    http_method = "POST",
    http_path = "/ml/modeltransform",
    host_prefix = "",
    paginator = list()
  )
  input <- .neptunedata$start_ml_model_transform_job_input(id = id, dataProcessingJobId = dataProcessingJobId, mlModelTrainingJobId = mlModelTrainingJobId, trainingJobName = trainingJobName, modelTransformOutputS3Location = modelTransformOutputS3Location, sagemakerIamRoleArn = sagemakerIamRoleArn, neptuneIamRoleArn = neptuneIamRoleArn, customModelTransformParameters = customModelTransformParameters, baseProcessingInstanceType = baseProcessingInstanceType, baseProcessingInstanceVolumeSizeInGB = baseProcessingInstanceVolumeSizeInGB, subnets = subnets, securityGroupIds = securityGroupIds, volumeEncryptionKMSKey = volumeEncryptionKMSKey, s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey)
  output <- .neptunedata$start_ml_model_transform_job_output()
  config <- get_config()
  svc <- .neptunedata$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptunedata$operations$start_ml_model_transform_job <- neptunedata_start_ml_model_transform_job
