% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_endpoint_access}
\alias{redshift_describe_endpoint_access}
\title{Describes a Redshift-managed VPC endpoint}
\usage{
redshift_describe_endpoint_access(
  ClusterIdentifier = NULL,
  ResourceOwner = NULL,
  EndpointName = NULL,
  VpcId = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{ClusterIdentifier}{The cluster identifier associated with the described endpoint.}

\item{ResourceOwner}{The Amazon Web Services account ID of the owner of the cluster.}

\item{EndpointName}{The name of the endpoint to be described.}

\item{VpcId}{The virtual private cloud (VPC) identifier with access to the cluster.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a \code{Marker} is included in the response so that the remaining
results can be retrieved.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=redshift_describe_endpoint_access]{describe_endpoint_access}} request.
If this parameter is specified, the response includes only records
beyond the marker, up to the value specified by the \code{MaxRecords}
parameter.}
}
\description{
Describes a Redshift-managed VPC endpoint.

See \url{https://www.paws-r-sdk.com/docs/redshift_describe_endpoint_access/} for full documentation.
}
\keyword{internal}
