% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_tenant_databases}
\alias{rds_describe_tenant_databases}
\title{Describes the tenant databases in a DB instance that uses the
multi-tenant configuration}
\usage{
rds_describe_tenant_databases(
  DBInstanceIdentifier = NULL,
  TenantDBName = NULL,
  Filters = NULL,
  Marker = NULL,
  MaxRecords = NULL
)
}
\arguments{
\item{DBInstanceIdentifier}{The user-supplied DB instance identifier, which must match the
identifier of an existing instance owned by the Amazon Web Services
account. This parameter isn't case-sensitive.}

\item{TenantDBName}{The user-supplied tenant database name, which must match the name of an
existing tenant database on the specified DB instance owned by your
Amazon Web Services account. This parameter isn’t case-sensitive.}

\item{Filters}{A filter that specifies one or more database tenants to describe.

Supported filters:
\itemize{
\item \code{tenant-db-name} - Tenant database names. The results list only
includes information about the tenant databases that match these
tenant DB names.
\item \code{tenant-database-resource-id} - Tenant database resource
identifiers.
\item \code{dbi-resource-id} - DB instance resource identifiers. The results
list only includes information about the tenants contained within
the DB instances identified by these resource identifiers.
}}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=rds_describe_tenant_databases]{describe_tenant_databases}} request. If
this parameter is specified, the response includes only records beyond
the marker, up to the value specified by \code{MaxRecords}.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that you can retrieve the
remaining results.}
}
\description{
Describes the tenant databases in a DB instance that uses the multi-tenant configuration. Only RDS for Oracle CDB instances are supported.

See \url{https://www.paws-r-sdk.com/docs/rds_describe_tenant_databases/} for full documentation.
}
\keyword{internal}
