% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptunedata_operations.R
\name{neptunedata_start_ml_model_transform_job}
\alias{neptunedata_start_ml_model_transform_job}
\title{Creates a new model transform job}
\usage{
neptunedata_start_ml_model_transform_job(
  id = NULL,
  dataProcessingJobId = NULL,
  mlModelTrainingJobId = NULL,
  trainingJobName = NULL,
  modelTransformOutputS3Location,
  sagemakerIamRoleArn = NULL,
  neptuneIamRoleArn = NULL,
  customModelTransformParameters = NULL,
  baseProcessingInstanceType = NULL,
  baseProcessingInstanceVolumeSizeInGB = NULL,
  subnets = NULL,
  securityGroupIds = NULL,
  volumeEncryptionKMSKey = NULL,
  s3OutputEncryptionKMSKey = NULL
)
}
\arguments{
\item{id}{A unique identifier for the new job. The default is an autogenerated
UUID.}

\item{dataProcessingJobId}{The job ID of a completed data-processing job. You must include either
\code{dataProcessingJobId} and a \code{mlModelTrainingJobId}, or a
\code{trainingJobName}.}

\item{mlModelTrainingJobId}{The job ID of a completed model-training job. You must include either
\code{dataProcessingJobId} and a \code{mlModelTrainingJobId}, or a
\code{trainingJobName}.}

\item{trainingJobName}{The name of a completed SageMaker training job. You must include either
\code{dataProcessingJobId} and a \code{mlModelTrainingJobId}, or a
\code{trainingJobName}.}

\item{modelTransformOutputS3Location}{[required] The location in Amazon S3 where the model artifacts are to be stored.}

\item{sagemakerIamRoleArn}{The ARN of an IAM role for SageMaker execution. This must be listed in
your DB cluster parameter group or an error will occur.}

\item{neptuneIamRoleArn}{The ARN of an IAM role that provides Neptune access to SageMaker and
Amazon S3 resources. This must be listed in your DB cluster parameter
group or an error will occur.}

\item{customModelTransformParameters}{Configuration information for a model transform using a custom model.
The \code{customModelTransformParameters} object contains the following
fields, which must have values compatible with the saved model
parameters from the training job:}

\item{baseProcessingInstanceType}{The type of ML instance used in preparing and managing training of ML
models. This is an ML compute instance chosen based on memory
requirements for processing the training data and model.}

\item{baseProcessingInstanceVolumeSizeInGB}{The disk volume size of the training instance in gigabytes. The default
is 0. Both input data and the output model are stored on disk, so the
volume size must be large enough to hold both data sets. If not
specified or 0, Neptune ML selects a disk volume size based on the
recommendation generated in the data processing step.}

\item{subnets}{The IDs of the subnets in the Neptune VPC. The default is None.}

\item{securityGroupIds}{The VPC security group IDs. The default is None.}

\item{volumeEncryptionKMSKey}{The Amazon Key Management Service (KMS) key that SageMaker uses to
encrypt data on the storage volume attached to the ML compute instances
that run the training job. The default is None.}

\item{s3OutputEncryptionKMSKey}{The Amazon Key Management Service (KMS) key that SageMaker uses to
encrypt the output of the processing job. The default is none.}
}
\description{
Creates a new model transform job. See \href{https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html}{Use a trained model to generate new model artifacts}.

See \url{https://www.paws-r-sdk.com/docs/neptunedata_start_ml_model_transform_job/} for full documentation.
}
\keyword{internal}
