% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptunedata_operations.R
\name{neptunedata_execute_gremlin_query}
\alias{neptunedata_execute_gremlin_query}
\title{This commands executes a Gremlin query}
\usage{
neptunedata_execute_gremlin_query(gremlinQuery, serializer = NULL)
}
\arguments{
\item{gremlinQuery}{[required] Using this API, you can run Gremlin queries in string format much as you
can using the HTTP endpoint. The interface is compatible with whatever
Gremlin version your DB cluster is using (see the \href{https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin-client.html#best-practices-gremlin-java-latest}{Tinkerpop client section}
to determine which Gremlin releases your engine version supports).}

\item{serializer}{If non-null, the query results are returned in a serialized response
message in the format specified by this parameter. See the
\href{https://tinkerpop.apache.org/docs/current/reference/#_graphson}{GraphSON}
section in the TinkerPop documentation for a list of the formats that
are currently supported.}
}
\description{
This commands executes a Gremlin query. Amazon Neptune is compatible with Apache TinkerPop3 and Gremlin, so you can use the Gremlin traversal language to query the graph, as described under \href{https://tinkerpop.apache.org/docs/current/reference/#graph}{The Graph} in the Apache TinkerPop3 documentation. More details can also be found in \href{https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin.html}{Accessing a Neptune graph with Gremlin}.

See \url{https://www.paws-r-sdk.com/docs/neptunedata_execute_gremlin_query/} for full documentation.
}
\keyword{internal}
