% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memorydb_operations.R
\name{memorydb_describe_clusters}
\alias{memorydb_describe_clusters}
\title{Returns information about all provisioned clusters if no cluster
identifier is specified, or about a specific cluster if a cluster name
is supplied}
\usage{
memorydb_describe_clusters(
  ClusterName = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  ShowShardDetails = NULL
)
}
\arguments{
\item{ClusterName}{The name of the cluster}

\item{MaxResults}{The maximum number of records to include in the response. If more
records exist than the specified MaxResults value, a token is included
in the response so that the remaining results can be retrieved.}

\item{NextToken}{An optional argument to pass in case the total number of records exceeds
the value of MaxResults. If nextToken is returned, there are more
results available. The value of nextToken is a unique pagination token
for each page. Make the call again using the returned token to retrieve
the next page. Keep all other arguments unchanged.}

\item{ShowShardDetails}{An optional flag that can be included in the request to retrieve
information about the individual shard(s).}
}
\description{
Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cluster if a cluster name is supplied.

See \url{https://www.paws-r-sdk.com/docs/memorydb_describe_clusters/} for full documentation.
}
\keyword{internal}
