% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_create_event_subscription}
\alias{docdb_create_event_subscription}
\title{Creates an Amazon DocumentDB event notification subscription}
\usage{
docdb_create_event_subscription(
  SubscriptionName,
  SnsTopicArn,
  SourceType = NULL,
  EventCategories = NULL,
  SourceIds = NULL,
  Enabled = NULL,
  Tags = NULL
)
}
\arguments{
\item{SubscriptionName}{[required] The name of the subscription.

Constraints: The name must be fewer than 255 characters.}

\item{SnsTopicArn}{[required] The Amazon Resource Name (ARN) of the SNS topic created for event
notification. Amazon SNS creates the ARN when you create a topic and
subscribe to it.}

\item{SourceType}{The type of source that is generating the events. For example, if you
want to be notified of events generated by an instance, you would set
this parameter to \code{db-instance}. If this value is not specified, all
events are returned.

Valid values: \code{db-instance}, \code{db-cluster}, \code{db-parameter-group},
\code{db-security-group}, \code{db-cluster-snapshot}}

\item{EventCategories}{A list of event categories for a \code{SourceType} that you want to subscribe
to.}

\item{SourceIds}{The list of identifiers of the event sources for which events are
returned. If not specified, then all sources are included in the
response. An identifier must begin with a letter and must contain only
ASCII letters, digits, and hyphens; it can't end with a hyphen or
contain two consecutive hyphens.

Constraints:
\itemize{
\item If \code{SourceIds} are provided, \code{SourceType} must also be provided.
\item If the source type is an instance, a \code{DBInstanceIdentifier} must be
provided.
\item If the source type is a security group, a \code{DBSecurityGroupName} must
be provided.
\item If the source type is a parameter group, a \code{DBParameterGroupName}
must be provided.
\item If the source type is a snapshot, a \code{DBSnapshotIdentifier} must be
provided.
}}

\item{Enabled}{A Boolean value; set to \code{true} to activate the subscription, set to
\code{false} to create the subscription but not active it.}

\item{Tags}{The tags to be assigned to the event subscription.}
}
\description{
Creates an Amazon DocumentDB event notification subscription. This action requires a topic Amazon Resource Name (ARN) created by using the Amazon DocumentDB console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the Amazon SNS console.

See \url{https://www.paws-r-sdk.com/docs/docdb_create_event_subscription/} for full documentation.
}
\keyword{internal}
