% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_restore_db_instance_to_point_in_time}
\alias{rds_restore_db_instance_to_point_in_time}
\title{Restores a DB instance to an arbitrary point in time}
\usage{
rds_restore_db_instance_to_point_in_time(
  SourceDBInstanceIdentifier = NULL,
  TargetDBInstanceIdentifier,
  RestoreTime = NULL,
  UseLatestRestorableTime = NULL,
  DBInstanceClass = NULL,
  Port = NULL,
  AvailabilityZone = NULL,
  DBSubnetGroupName = NULL,
  MultiAZ = NULL,
  PubliclyAccessible = NULL,
  AutoMinorVersionUpgrade = NULL,
  LicenseModel = NULL,
  DBName = NULL,
  Engine = NULL,
  Iops = NULL,
  OptionGroupName = NULL,
  CopyTagsToSnapshot = NULL,
  Tags = NULL,
  StorageType = NULL,
  TdeCredentialArn = NULL,
  TdeCredentialPassword = NULL,
  VpcSecurityGroupIds = NULL,
  Domain = NULL,
  DomainIAMRoleName = NULL,
  DomainFqdn = NULL,
  DomainOu = NULL,
  DomainAuthSecretArn = NULL,
  DomainDnsIps = NULL,
  EnableIAMDatabaseAuthentication = NULL,
  EnableCloudwatchLogsExports = NULL,
  ProcessorFeatures = NULL,
  UseDefaultProcessorFeatures = NULL,
  DBParameterGroupName = NULL,
  DeletionProtection = NULL,
  SourceDbiResourceId = NULL,
  MaxAllocatedStorage = NULL,
  SourceDBInstanceAutomatedBackupsArn = NULL,
  EnableCustomerOwnedIp = NULL,
  CustomIamInstanceProfile = NULL,
  BackupTarget = NULL,
  NetworkType = NULL,
  StorageThroughput = NULL,
  AllocatedStorage = NULL
)
}
\arguments{
\item{SourceDBInstanceIdentifier}{The identifier of the source DB instance from which to restore.

Constraints:
\itemize{
\item Must match the identifier of an existing DB instance.
}}

\item{TargetDBInstanceIdentifier}{[required] The name of the new DB instance to be created.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}}

\item{RestoreTime}{The date and time to restore from.

Valid Values: Value must be a time in Universal Coordinated Time (UTC)
format

Constraints:
\itemize{
\item Must be before the latest restorable time for the DB instance
\item Can't be specified if the \code{UseLatestRestorableTime} parameter is
enabled
}

Example: \verb{2009-09-07T23:45:00Z}}

\item{UseLatestRestorableTime}{A value that indicates whether the DB instance is restored from the
latest backup time. By default, the DB instance isn't restored from the
latest backup time.

Constraints: Can't be specified if the \code{RestoreTime} parameter is
provided.}

\item{DBInstanceClass}{The compute and memory capacity of the Amazon RDS DB instance, for
example db.m4.large. Not all DB instance classes are available in all
Amazon Web Services Regions, or for all database engines. For the full
list of DB instance classes, and availability for your engine, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html}{DB Instance Class}
in the \emph{Amazon RDS User Guide}.

Default: The same DBInstanceClass as the original DB instance.}

\item{Port}{The port number on which the database accepts connections.

Constraints: Value must be \code{1150-65535}

Default: The same port as the original DB instance.}

\item{AvailabilityZone}{The Availability Zone (AZ) where the DB instance will be created.

Default: A random, system-chosen Availability Zone.

Constraint: You can't specify the \code{AvailabilityZone} parameter if the DB
instance is a Multi-AZ deployment.

Example: \verb{us-east-1a}}

\item{DBSubnetGroupName}{The DB subnet group name to use for the new instance.

Constraints: If supplied, must match the name of an existing
DBSubnetGroup.

Example: \code{mydbsubnetgroup}}

\item{MultiAZ}{A value that indicates whether the DB instance is a Multi-AZ deployment.

This setting doesn't apply to RDS Custom.

Constraint: You can't specify the \code{AvailabilityZone} parameter if the DB
instance is a Multi-AZ deployment.}

\item{PubliclyAccessible}{A value that indicates whether the DB instance is publicly accessible.

When the DB cluster is publicly accessible, its Domain Name System (DNS)
endpoint resolves to the private IP address from within the DB cluster's
virtual private cloud (VPC). It resolves to the public IP address from
outside of the DB cluster's VPC. Access to the DB cluster is ultimately
controlled by the security group it uses. That public access isn't
permitted if the security group assigned to the DB cluster doesn't
permit it.

When the DB instance isn't publicly accessible, it is an internal DB
instance with a DNS name that resolves to a private IP address.

For more information, see
\code{\link[=rds_create_db_instance]{create_db_instance}}.}

\item{AutoMinorVersionUpgrade}{A value that indicates whether minor version upgrades are applied
automatically to the DB instance during the maintenance window.

This setting doesn't apply to RDS Custom.}

\item{LicenseModel}{License model information for the restored DB instance.

This setting doesn't apply to RDS Custom.

Default: Same as source.

Valid values: \code{license-included} | \code{bring-your-own-license} |
\code{general-public-license}}

\item{DBName}{The database name for the restored DB instance.

This parameter isn't supported for the MySQL or MariaDB engines. It also
doesn't apply to RDS Custom.}

\item{Engine}{The database engine to use for the new instance.

This setting doesn't apply to RDS Custom.

Default: The same as source

Constraint: Must be compatible with the engine of the source

Valid Values:
\itemize{
\item \code{mariadb}
\item \code{mysql}
\item \code{oracle-ee}
\item \code{oracle-ee-cdb}
\item \code{oracle-se2}
\item \code{oracle-se2-cdb}
\item \code{postgres}
\item \code{sqlserver-ee}
\item \code{sqlserver-se}
\item \code{sqlserver-ex}
\item \code{sqlserver-web}
}}

\item{Iops}{The amount of Provisioned IOPS (input/output operations per second) to
be initially allocated for the DB instance.

Constraints: Must be an integer greater than 1000.

\strong{SQL Server}

Setting the IOPS value for the SQL Server database engine isn't
supported.}

\item{OptionGroupName}{The name of the option group to be used for the restored DB instance.

Permanent options, such as the TDE option for Oracle Advanced Security
TDE, can't be removed from an option group, and that option group can't
be removed from a DB instance after it is associated with a DB instance

This setting doesn't apply to RDS Custom.}

\item{CopyTagsToSnapshot}{A value that indicates whether to copy all tags from the restored DB
instance to snapshots of the DB instance. By default, tags are not
copied.}

\item{Tags}{}

\item{StorageType}{Specifies the storage type to be associated with the DB instance.

Valid values: \code{gp2 | gp3 | io1 | standard}

If you specify \code{io1} or \code{gp3}, you must also include a value for the
\code{Iops} parameter.

Default: \code{io1} if the \code{Iops} parameter is specified, otherwise \code{gp2}}

\item{TdeCredentialArn}{The ARN from the key store with which to associate the instance for TDE
encryption.

This setting doesn't apply to RDS Custom.}

\item{TdeCredentialPassword}{The password for the given ARN from the key store in order to access the
device.

This setting doesn't apply to RDS Custom.}

\item{VpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with this DB instance.

Default: The default EC2 VPC security group for the DB subnet group's
VPC.}

\item{Domain}{Specify the Active Directory directory ID to restore the DB instance in.
Create the domain before running this command. Currently, you can create
only the MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB
instances in an Active Directory Domain.

This setting doesn't apply to RDS Custom.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/database-authentication.html}{Kerberos Authentication}
in the \emph{Amazon RDS User Guide}.}

\item{DomainIAMRoleName}{The name of the IAM role to use when making API calls to the Directory
Service.

This setting doesn't apply to RDS Custom DB instances.}

\item{DomainFqdn}{The fully qualified domain name (FQDN) of an Active Directory domain.

Constraints:
\itemize{
\item Can't be longer than 64 characters.
}

Example: \code{mymanagedADtest.mymanagedAD.mydomain}}

\item{DomainOu}{The Active Directory organizational unit for your DB instance to join.

Constraints:
\itemize{
\item Must be in the distinguished name format.
\item Can't be longer than 64 characters.
}

Example:
\verb{OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain}}

\item{DomainAuthSecretArn}{The ARN for the Secrets Manager secret with the credentials for the user
joining the domain.

Constraints:
\itemize{
\item Can't be longer than 64 characters.
}

Example:
\code{arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456}}

\item{DomainDnsIps}{The IPv4 DNS IP addresses of your primary and secondary Active Directory
domain controllers.

Constraints:
\itemize{
\item Two IP addresses must be provided. If there isn't a secondary domain
controller, use the IP address of the primary domain controller for
both entries in the list.
}

Example: \verb{123.124.125.126,234.235.236.237}}

\item{EnableIAMDatabaseAuthentication}{A value that indicates whether to enable mapping of Amazon Web Services
Identity and Access Management (IAM) accounts to database accounts. By
default, mapping isn't enabled.

This setting doesn't apply to RDS Custom.

For more information about IAM database authentication, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html}{IAM Database Authentication for MySQL and PostgreSQL}
in the \emph{Amazon RDS User Guide.}}

\item{EnableCloudwatchLogsExports}{The list of logs that the restored DB instance is to export to
CloudWatch Logs. The values in the list depend on the DB engine being
used. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon RDS User Guide}.

This setting doesn't apply to RDS Custom.}

\item{ProcessorFeatures}{The number of CPU cores and the number of threads per core for the DB
instance class of the DB instance.

This setting doesn't apply to RDS Custom.}

\item{UseDefaultProcessorFeatures}{A value that indicates whether the DB instance class of the DB instance
uses its default processor features.

This setting doesn't apply to RDS Custom.}

\item{DBParameterGroupName}{The name of the DB parameter group to associate with this DB instance.

If you do not specify a value for \code{DBParameterGroupName}, then the
default \code{DBParameterGroup} for the specified DB engine is used.

This setting doesn't apply to RDS Custom.

Constraints:
\itemize{
\item If supplied, must match the name of an existing DBParameterGroup.
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}}

\item{DeletionProtection}{A value that indicates whether the DB instance has deletion protection
enabled. The database can't be deleted when deletion protection is
enabled. By default, deletion protection isn't enabled. For more
information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html}{Deleting a DB Instance}.}

\item{SourceDbiResourceId}{The resource ID of the source DB instance from which to restore.}

\item{MaxAllocatedStorage}{The upper limit in gibibytes (GiB) to which Amazon RDS can automatically
scale the storage of the DB instance.

For more information about this setting, including limitations that
apply to it, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling}{Managing capacity automatically with Amazon RDS storage autoscaling}
in the \emph{Amazon RDS User Guide}.

This setting doesn't apply to RDS Custom.}

\item{SourceDBInstanceAutomatedBackupsArn}{The Amazon Resource Name (ARN) of the replicated automated backups from
which to restore, for example,
\code{arn:aws:rds:useast-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE}.

This setting doesn't apply to RDS Custom.}

\item{EnableCustomerOwnedIp}{A value that indicates whether to enable a customer-owned IP address
(CoIP) for an RDS on Outposts DB instance.

A \emph{CoIP} provides local or external connectivity to resources in your
Outpost subnets through your on-premises network. For some use cases, a
CoIP can provide lower latency for connections to the DB instance from
outside of its virtual private cloud (VPC) on your local network.

This setting doesn't apply to RDS Custom.

For more information about RDS on Outposts, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html}{Working with Amazon RDS on Amazon Web Services Outposts}
in the \emph{Amazon RDS User Guide}.

For more information about CoIPs, see \href{https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing}{Customer-owned IP addresses}
in the \emph{Amazon Web Services Outposts User Guide}.}

\item{CustomIamInstanceProfile}{The instance profile associated with the underlying Amazon EC2 instance
of an RDS Custom DB instance. The instance profile must meet the
following requirements:
\itemize{
\item The profile must exist in your account.
\item The profile must have an IAM role that Amazon EC2 has permissions to
assume.
\item The instance profile name and the associated IAM role name must
start with the prefix \code{AWSRDSCustom}.
}

For the list of permissions required for the IAM role, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc}{Configure IAM and your VPC}
in the \emph{Amazon RDS User Guide}.

This setting is required for RDS Custom.}

\item{BackupTarget}{Specifies where automated backups and manual snapshots are stored for
the restored DB instance.

Possible values are \code{outposts} (Amazon Web Services Outposts) and
\code{region} (Amazon Web Services Region). The default is \code{region}.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html}{Working with Amazon RDS on Amazon Web Services Outposts}
in the \emph{Amazon RDS User Guide}.}

\item{NetworkType}{The network type of the DB instance.

Valid values:
\itemize{
\item \code{IPV4}
\item \code{DUAL}
}

The network type is determined by the \code{DBSubnetGroup} specified for the
DB instance. A \code{DBSubnetGroup} can support only the IPv4 protocol or the
IPv4 and the IPv6 protocols (\code{DUAL}).

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html}{Working with a DB instance in a VPC}
in the \emph{Amazon RDS User Guide.}}

\item{StorageThroughput}{Specifies the storage throughput value for the DB instance.

This setting doesn't apply to RDS Custom or Amazon Aurora.}

\item{AllocatedStorage}{The amount of storage (in gibibytes) to allocate initially for the DB
instance. Follow the allocation rules specified in
\code{\link[=rds_create_db_instance]{create_db_instance}}.

Be sure to allocate enough storage for your new DB instance so that the
restore operation can succeed. You can also allocate additional storage
for future growth.}
}
\description{
Restores a DB instance to an arbitrary point in time. You can restore to any point in time before the time identified by the LatestRestorableTime property. You can restore to a point up to the number of days specified by the BackupRetentionPeriod property.

See \url{https://www.paws-r-sdk.com/docs/rds_restore_db_instance_to_point_in_time/} for full documentation.
}
\keyword{internal}
