% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeformation_operations.R
\name{lakeformation_list_transactions}
\alias{lakeformation_list_transactions}
\title{Returns metadata about transactions and their status}
\usage{
lakeformation_list_transactions(
  CatalogId = NULL,
  StatusFilter = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{CatalogId}{The catalog for which to list transactions. Defaults to the account ID
of the caller.}

\item{StatusFilter}{A filter indicating the status of transactions to return. Options are
ALL | COMPLETED | COMMITTED | ABORTED | ACTIVE. The default is \code{ALL}.}

\item{MaxResults}{The maximum number of transactions to return in a single call.}

\item{NextToken}{A continuation token if this is not the first call to retrieve
transactions.}
}
\description{
Returns metadata about transactions and their status. To prevent the response from growing indefinitely, only uncommitted transactions and those available for time-travel queries are returned.

See \url{https://www.paws-r-sdk.com/docs/lakeformation_list_transactions/} for full documentation.
}
\keyword{internal}
