% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timestreamquery_operations.R
\name{timestreamquery_query}
\alias{timestreamquery_query}
\title{Query is a synchronous operation that enables you to run a query against
your Amazon Timestream data}
\usage{
timestreamquery_query(
  QueryString,
  ClientToken = NULL,
  NextToken = NULL,
  MaxRows = NULL
)
}
\arguments{
\item{QueryString}{[required] The query to be run by Timestream.}

\item{ClientToken}{Unique, case-sensitive string of up to 64 ASCII characters specified
when a \code{\link[=timestreamquery_query]{query}} request is made. Providing a
\code{ClientToken} makes the call to \code{\link[=timestreamquery_query]{query}}
\emph{idempotent}. This means that running the same query repeatedly will
produce the same result. In other words, making multiple identical
\code{\link[=timestreamquery_query]{query}} requests has the same effect as making
a single request. When using \code{ClientToken} in a query, note the
following:
\itemize{
\item If the Query API is instantiated without a \code{ClientToken}, the Query
SDK generates a \code{ClientToken} on your behalf.
\item If the \code{\link[=timestreamquery_query]{query}} invocation only contains the
\code{ClientToken} but does not include a \code{NextToken}, that invocation of
\code{\link[=timestreamquery_query]{query}} is assumed to be a new query run.
\item If the invocation contains \code{NextToken}, that particular invocation
is assumed to be a subsequent invocation of a prior call to the
Query API, and a result set is returned.
\item After 4 hours, any request with the same \code{ClientToken} is treated as
a new request.
}}

\item{NextToken}{A pagination token used to return a set of results. When the
\code{\link[=timestreamquery_query]{query}} API is invoked using \code{NextToken}, that
particular invocation is assumed to be a subsequent invocation of a
prior call to \code{\link[=timestreamquery_query]{query}}, and a result set is
returned. However, if the \code{\link[=timestreamquery_query]{query}} invocation
only contains the \code{ClientToken}, that invocation of
\code{\link[=timestreamquery_query]{query}} is assumed to be a new query run.

Note the following when using NextToken in a query:
\itemize{
\item A pagination token can be used for up to five
\code{\link[=timestreamquery_query]{query}} invocations, OR for a duration of
up to 1 hour – whichever comes first.
\item Using the same \code{NextToken} will return the same set of records. To
keep paginating through the result set, you must to use the most
recent \code{nextToken}.
\item Suppose a \code{\link[=timestreamquery_query]{query}} invocation returns two
\code{NextToken} values, \code{TokenA} and \code{TokenB}. If \code{TokenB} is used in a
subsequent \code{\link[=timestreamquery_query]{query}} invocation, then
\code{TokenA} is invalidated and cannot be reused.
\item To request a previous result set from a query after pagination has
begun, you must re-invoke the Query API.
\item The latest \code{NextToken} should be used to paginate until \code{null} is
returned, at which point a new \code{NextToken} should be used.
\item If the IAM principal of the query initiator and the result reader
are not the same and/or the query initiator and the result reader do
not have the same query string in the query requests, the query will
fail with an \verb{Invalid pagination token} error.
}}

\item{MaxRows}{The total number of rows to be returned in the
\code{\link[=timestreamquery_query]{query}} output. The initial run of
\code{\link[=timestreamquery_query]{query}} with a \code{MaxRows} value specified will
return the result set of the query in two cases:
\itemize{
\item The size of the result is less than \verb{1MB}.
\item The number of rows in the result set is less than the value of
\code{maxRows}.
}

Otherwise, the initial invocation of \code{\link[=timestreamquery_query]{query}}
only returns a \code{NextToken}, which can then be used in subsequent calls
to fetch the result set. To resume pagination, provide the \code{NextToken}
value in the subsequent command.

If the row size is large (e.g. a row has many columns), Timestream may
return fewer rows to keep the response size from exceeding the 1 MB
limit. If \code{MaxRows} is not provided, Timestream will send the necessary
number of rows to meet the 1 MB limit.}
}
\description{
\code{\link[=timestreamquery_query]{query}} is a synchronous operation that enables you to run a query against your Amazon Timestream data. \code{\link[=timestreamquery_query]{query}} will time out after 60 seconds. You must update the default timeout in the SDK to support a timeout of 60 seconds. See the \href{https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.run-query.html}{code sample} for details.

See \url{https://paws-r.github.io/docs/timestreamquery/query.html} for full documentation.
}
\keyword{internal}
