% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftserverless_operations.R
\name{redshiftserverless_update_workgroup}
\alias{redshiftserverless_update_workgroup}
\title{Updates a workgroup with the specified configuration settings}
\usage{
redshiftserverless_update_workgroup(
  baseCapacity = NULL,
  configParameters = NULL,
  enhancedVpcRouting = NULL,
  publiclyAccessible = NULL,
  securityGroupIds = NULL,
  subnetIds = NULL,
  workgroupName
)
}
\arguments{
\item{baseCapacity}{The new base data warehouse capacity in Redshift Processing Units
(RPUs).}

\item{configParameters}{An array of parameters to set for advanced control over a database. The
options are \code{datestyle}, \code{enable_user_activity_logging}, \code{query_group},
\code{search_path}, and \code{max_query_execution_time}.}

\item{enhancedVpcRouting}{The value that specifies whether to turn on enhanced virtual private
cloud (VPC) routing, which forces Amazon Redshift Serverless to route
traffic through your VPC.}

\item{publiclyAccessible}{A value that specifies whether the workgroup can be accessible from a
public network.}

\item{securityGroupIds}{An array of security group IDs to associate with the workgroup.}

\item{subnetIds}{An array of VPC subnet IDs to associate with the workgroup.}

\item{workgroupName}{[required] The name of the workgroup to update.}
}
\description{
Updates a workgroup with the specified configuration settings.

See \url{https://paws-r.github.io/docs/redshiftserverless/update_workgroup.html} for full documentation.
}
\keyword{internal}
