% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftserverless_operations.R
\name{redshiftserverless_update_namespace}
\alias{redshiftserverless_update_namespace}
\title{Updates a namespace with the specified settings}
\usage{
redshiftserverless_update_namespace(
  adminUserPassword = NULL,
  adminUsername = NULL,
  defaultIamRoleArn = NULL,
  iamRoles = NULL,
  kmsKeyId = NULL,
  logExports = NULL,
  namespaceName
)
}
\arguments{
\item{adminUserPassword}{The password of the administrator for the first database created in the
namespace.}

\item{adminUsername}{The username of the administrator for the first database created in the
namespace.}

\item{defaultIamRoleArn}{The Amazon Resource Name (ARN) of the IAM role to set as a default in
the namespace.}

\item{iamRoles}{A list of IAM roles to associate with the namespace.}

\item{kmsKeyId}{The ID of the Amazon Web Services Key Management Service key used to
encrypt your data.}

\item{logExports}{The types of logs the namespace can export. The export types are
\code{userlog}, \code{connectionlog}, and \code{useractivitylog}.}

\item{namespaceName}{[required] The name of the namespace.}
}
\description{
Updates a namespace with the specified settings.

See \url{https://paws-r.github.io/docs/redshiftserverless/update_namespace.html} for full documentation.
}
\keyword{internal}
