% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftdataapiservice_operations.R
\name{redshiftdataapiservice_batch_execute_statement}
\alias{redshiftdataapiservice_batch_execute_statement}
\title{Runs one or more SQL statements, which can be data manipulation language
(DML) or data definition language (DDL)}
\usage{
redshiftdataapiservice_batch_execute_statement(
  ClusterIdentifier = NULL,
  Database,
  DbUser = NULL,
  SecretArn = NULL,
  Sqls,
  StatementName = NULL,
  WithEvent = NULL,
  WorkgroupName = NULL
)
}
\arguments{
\item{ClusterIdentifier}{The cluster identifier. This parameter is required when connecting to a
cluster and authenticating using either Secrets Manager or temporary
credentials.}

\item{Database}{[required] The name of the database. This parameter is required when authenticating
using either Secrets Manager or temporary credentials.}

\item{DbUser}{The database user name. This parameter is required when connecting to a
cluster and authenticating using temporary credentials.}

\item{SecretArn}{The name or ARN of the secret that enables access to the database. This
parameter is required when authenticating using Secrets Manager.}

\item{Sqls}{[required] One or more SQL statements to run.}

\item{StatementName}{The name of the SQL statements. You can name the SQL statements when you
create them to identify the query.}

\item{WithEvent}{A value that indicates whether to send an event to the Amazon
EventBridge event bus after the SQL statements run.}

\item{WorkgroupName}{The serverless workgroup name. This parameter is required when
connecting to a serverless workgroup and authenticating using either
Secrets Manager or temporary credentials.}
}
\description{
Runs one or more SQL statements, which can be data manipulation language (DML) or data definition language (DDL). Depending on the authorization method, use one of the following combinations of request parameters:

See \url{https://paws-r.github.io/docs/redshiftdataapiservice/batch_execute_statement.html} for full documentation.
}
\keyword{internal}
