% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyspaces_operations.R
\name{keyspaces_delete_table}
\alias{keyspaces_delete_table}
\title{The DeleteTable operation deletes a table and all of its data}
\usage{
keyspaces_delete_table(keyspaceName, tableName)
}
\arguments{
\item{keyspaceName}{[required] The name of the keyspace of the to be deleted table.}

\item{tableName}{[required] The name of the table to be deleted.}
}
\description{
The \code{\link[=keyspaces_delete_table]{delete_table}} operation deletes a table and all of its data. After a \code{\link[=keyspaces_delete_table]{delete_table}} request is received, the specified table is in the \code{DELETING} state until Amazon Keyspaces completes the deletion. If the table is in the \code{ACTIVE} state, you can delete it. If a table is either in the \code{CREATING} or \code{UPDATING} states, then Amazon Keyspaces returns a \code{ResourceInUseException}. If the specified table does not exist, Amazon Keyspaces returns a \code{ResourceNotFoundException}. If the table is already in the \code{DELETING} state, no error is returned.

See \url{https://paws-r.github.io/docs/keyspaces/delete_table.html} for full documentation.
}
\keyword{internal}
