% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_describe_reserved_cache_nodes}
\alias{elasticache_describe_reserved_cache_nodes}
\title{Returns information about reserved cache nodes for this account, or
about a specified reserved cache node}
\usage{
elasticache_describe_reserved_cache_nodes(
  ReservedCacheNodeId = NULL,
  ReservedCacheNodesOfferingId = NULL,
  CacheNodeType = NULL,
  Duration = NULL,
  ProductDescription = NULL,
  OfferingType = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{ReservedCacheNodeId}{The reserved cache node identifier filter value. Use this parameter to
show only the reservation that matches the specified reservation ID.}

\item{ReservedCacheNodesOfferingId}{The offering identifier filter value. Use this parameter to show only
purchased reservations matching the specified offering identifier.}

\item{CacheNodeType}{The cache node type filter value. Use this parameter to show only those
reservations matching the specified cache node type.

The following node types are supported by ElastiCache. Generally
speaking, the current generation types provide more memory and
computational power at lower cost when compared to their equivalent
previous generation counterparts.
\itemize{
\item General purpose:
\itemize{
\item Current generation:

\strong{M6g node types:} (available only for Redis engine version
5.0.6 onward and for Memcached engine version 1.5.16 onward):
\code{cache.m6g.large}, \code{cache.m6g.xlarge}, \code{cache.m6g.2xlarge},
\code{cache.m6g.4xlarge}, \code{cache.m6g.8xlarge}, \code{cache.m6g.12xlarge},
\code{cache.m6g.16xlarge}

For region availability, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion}{Supported Node Types}

\strong{M5 node types:} \code{cache.m5.large}, \code{cache.m5.xlarge},
\code{cache.m5.2xlarge}, \code{cache.m5.4xlarge}, \code{cache.m5.12xlarge},
\code{cache.m5.24xlarge}

\strong{M4 node types:} \code{cache.m4.large}, \code{cache.m4.xlarge},
\code{cache.m4.2xlarge}, \code{cache.m4.4xlarge}, \code{cache.m4.10xlarge}

\strong{T4g node types} (available only for Redis engine version
5.0.6 onward and for Memcached engine version 1.5.16 onward):
\code{cache.t4g.micro}, \code{cache.t4g.small}, \code{cache.t4g.medium}

\strong{T3 node types:} \code{cache.t3.micro}, \code{cache.t3.small},
\code{cache.t3.medium}

\strong{T2 node types:} \code{cache.t2.micro}, \code{cache.t2.small},
\code{cache.t2.medium}
\item Previous generation: (not recommended. Existing clusters are
still supported but creation of new clusters is not supported
for these types.)

\strong{T1 node types:} \code{cache.t1.micro}

\strong{M1 node types:} \code{cache.m1.small}, \code{cache.m1.medium},
\code{cache.m1.large}, \code{cache.m1.xlarge}

\strong{M3 node types:} \code{cache.m3.medium}, \code{cache.m3.large},
\code{cache.m3.xlarge}, \code{cache.m3.2xlarge}
}
\item Compute optimized:
\itemize{
\item Previous generation: (not recommended. Existing clusters are
still supported but creation of new clusters is not supported
for these types.)

\strong{C1 node types:} \code{cache.c1.xlarge}
}
\item Memory optimized with data tiering:
\itemize{
\item Current generation:

\strong{R6gd node types} (available only for Redis engine version 6.2
onward).

\code{cache.r6gd.xlarge}, \code{cache.r6gd.2xlarge}, \code{cache.r6gd.4xlarge},
\code{cache.r6gd.8xlarge}, \code{cache.r6gd.12xlarge},
\code{cache.r6gd.16xlarge}
}
\item Memory optimized:
\itemize{
\item Current generation:

\strong{R6g node types} (available only for Redis engine version
5.0.6 onward and for Memcached engine version 1.5.16 onward).

\code{cache.r6g.large}, \code{cache.r6g.xlarge}, \code{cache.r6g.2xlarge},
\code{cache.r6g.4xlarge}, \code{cache.r6g.8xlarge}, \code{cache.r6g.12xlarge},
\code{cache.r6g.16xlarge}

For region availability, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion}{Supported Node Types}

\strong{R5 node types:} \code{cache.r5.large}, \code{cache.r5.xlarge},
\code{cache.r5.2xlarge}, \code{cache.r5.4xlarge}, \code{cache.r5.12xlarge},
\code{cache.r5.24xlarge}

\strong{R4 node types:} \code{cache.r4.large}, \code{cache.r4.xlarge},
\code{cache.r4.2xlarge}, \code{cache.r4.4xlarge}, \code{cache.r4.8xlarge},
\code{cache.r4.16xlarge}
\item Previous generation: (not recommended. Existing clusters are
still supported but creation of new clusters is not supported
for these types.)

\strong{M2 node types:} \code{cache.m2.xlarge}, \code{cache.m2.2xlarge},
\code{cache.m2.4xlarge}

\strong{R3 node types:} \code{cache.r3.large}, \code{cache.r3.xlarge},
\code{cache.r3.2xlarge}, \code{cache.r3.4xlarge}, \code{cache.r3.8xlarge}
}
}

\strong{Additional node type info}
\itemize{
\item All current generation instance types are created in Amazon VPC by
default.
\item Redis append-only files (AOF) are not supported for T1 or T2
instances.
\item Redis Multi-AZ with automatic failover is not supported on T1
instances.
\item Redis configuration variables \code{appendonly} and \code{appendfsync} are not
supported on Redis version 2.8.22 and later.
}}

\item{Duration}{The duration filter value, specified in years or seconds. Use this
parameter to show only reservations for this duration.

Valid Values: \code{1 | 3 | 31536000 | 94608000}}

\item{ProductDescription}{The product description filter value. Use this parameter to show only
those reservations matching the specified product description.}

\item{OfferingType}{The offering type filter value. Use this parameter to show only the
available offerings matching the specified offering type.

Valid values:
\code{"Light Utilization"|"Medium Utilization"|"Heavy Utilization"|"All Upfront"|"Partial Upfront"| "No Upfront"}}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a marker is
included in the response so that the remaining results can be retrieved.

Default: 100

Constraints: minimum 20; maximum 100.}

\item{Marker}{An optional marker returned from a prior request. Use this marker for
pagination of results from this operation. If this parameter is
specified, the response includes only records beyond the marker, up to
the value specified by \code{MaxRecords}.}
}
\description{
Returns information about reserved cache nodes for this account, or about a specified reserved cache node.

See \url{https://paws-r.github.io/docs/elasticache/describe_reserved_cache_nodes.html} for full documentation.
}
\keyword{internal}
