% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_describe_replication_groups}
\alias{elasticache_describe_replication_groups}
\title{Returns information about a particular replication group}
\usage{
elasticache_describe_replication_groups(
  ReplicationGroupId = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{ReplicationGroupId}{The identifier for the replication group to be described. This parameter
is not case sensitive.

If you do not specify this parameter, information about all replication
groups is returned.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a marker is
included in the response so that the remaining results can be retrieved.

Default: 100

Constraints: minimum 20; maximum 100.}

\item{Marker}{An optional marker returned from a prior request. Use this marker for
pagination of results from this operation. If this parameter is
specified, the response includes only records beyond the marker, up to
the value specified by \code{MaxRecords}.}
}
\description{
Returns information about a particular replication group. If no identifier is specified, \code{\link[=elasticache_describe_replication_groups]{describe_replication_groups}} returns information about all replication groups.

See \url{https://paws-r.github.io/docs/elasticache/describe_replication_groups.html} for full documentation.
}
\keyword{internal}
