% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_query}
\alias{dynamodb_query}
\title{You must provide the name of the partition key attribute and a single
value for that attribute}
\usage{
dynamodb_query(
  TableName,
  IndexName = NULL,
  Select = NULL,
  AttributesToGet = NULL,
  Limit = NULL,
  ConsistentRead = NULL,
  KeyConditions = NULL,
  QueryFilter = NULL,
  ConditionalOperator = NULL,
  ScanIndexForward = NULL,
  ExclusiveStartKey = NULL,
  ReturnConsumedCapacity = NULL,
  ProjectionExpression = NULL,
  FilterExpression = NULL,
  KeyConditionExpression = NULL,
  ExpressionAttributeNames = NULL,
  ExpressionAttributeValues = NULL
)
}
\arguments{
\item{TableName}{[required] The name of the table containing the requested items.}

\item{IndexName}{The name of an index to query. This index can be any local secondary
index or global secondary index on the table. Note that if you use the
\code{IndexName} parameter, you must also provide \code{TableName.}}

\item{Select}{The attributes to be returned in the result. You can retrieve all item
attributes, specific item attributes, the count of matching items, or in
the case of an index, some or all of the attributes projected into the
index.
\itemize{
\item \code{ALL_ATTRIBUTES} - Returns all of the item attributes from the
specified table or index. If you query a local secondary index, then
for each matching item in the index, DynamoDB fetches the entire
item from the parent table. If the index is configured to project
all item attributes, then all of the data can be obtained from the
local secondary index, and no fetching is required.
\item \code{ALL_PROJECTED_ATTRIBUTES} - Allowed only when querying an index.
Retrieves all attributes that have been projected into the index. If
the index is configured to project all attributes, this return value
is equivalent to specifying \code{ALL_ATTRIBUTES}.
\item \code{COUNT} - Returns the number of matching items, rather than the
matching items themselves.
\item \code{SPECIFIC_ATTRIBUTES} - Returns only the attributes listed in
\code{ProjectionExpression}. This return value is equivalent to
specifying \code{ProjectionExpression} without specifying any value for
\code{Select}.

If you query or scan a local secondary index and request only
attributes that are projected into that index, the operation will
read only the index and not the table. If any of the requested
attributes are not projected into the local secondary index,
DynamoDB fetches each of these attributes from the parent table.
This extra fetching incurs additional throughput cost and latency.

If you query or scan a global secondary index, you can only request
attributes that are projected into the index. Global secondary index
queries cannot fetch attributes from the parent table.
}

If neither \code{Select} nor \code{ProjectionExpression} are specified, DynamoDB
defaults to \code{ALL_ATTRIBUTES} when accessing a table, and
\code{ALL_PROJECTED_ATTRIBUTES} when accessing an index. You cannot use both
\code{Select} and \code{ProjectionExpression} together in a single request, unless
the value for \code{Select} is \code{SPECIFIC_ATTRIBUTES}. (This usage is
equivalent to specifying \code{ProjectionExpression} without any value for
\code{Select}.)

If you use the \code{ProjectionExpression} parameter, then the value for
\code{Select} can only be \code{SPECIFIC_ATTRIBUTES}. Any other value for \code{Select}
will return an error.}

\item{AttributesToGet}{This is a legacy parameter. Use \code{ProjectionExpression} instead. For more
information, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html}{AttributesToGet}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{Limit}{The maximum number of items to evaluate (not necessarily the number of
matching items). If DynamoDB processes the number of items up to the
limit while processing the results, it stops the operation and returns
the matching values up to that point, and a key in \code{LastEvaluatedKey} to
apply in a subsequent operation, so that you can pick up where you left
off. Also, if the processed dataset size exceeds 1 MB before DynamoDB
reaches this limit, it stops the operation and returns the matching
values up to the limit, and a key in \code{LastEvaluatedKey} to apply in a
subsequent operation to continue the operation. For more information,
see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Query.html}{Query and Scan}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ConsistentRead}{Determines the read consistency model: If set to \code{true}, then the
operation uses strongly consistent reads; otherwise, the operation uses
eventually consistent reads.

Strongly consistent reads are not supported on global secondary indexes.
If you query a global secondary index with \code{ConsistentRead} set to
\code{true}, you will receive a \code{ValidationException}.}

\item{KeyConditions}{This is a legacy parameter. Use \code{KeyConditionExpression} instead. For
more information, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html}{KeyConditions}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{QueryFilter}{This is a legacy parameter. Use \code{FilterExpression} instead. For more
information, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html}{QueryFilter}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ConditionalOperator}{This is a legacy parameter. Use \code{FilterExpression} instead. For more
information, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html}{ConditionalOperator}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ScanIndexForward}{Specifies the order for index traversal: If \code{true} (default), the
traversal is performed in ascending order; if \code{false}, the traversal is
performed in descending order.

Items with the same partition key value are stored in sorted order by
sort key. If the sort key data type is Number, the results are stored in
numeric order. For type String, the results are stored in order of UTF-8
bytes. For type Binary, DynamoDB treats each byte of the binary data as
unsigned.

If \code{ScanIndexForward} is \code{true}, DynamoDB returns the results in the
order in which they are stored (by sort key value). This is the default
behavior. If \code{ScanIndexForward} is \code{false}, DynamoDB reads the results
in reverse order by sort key value, and then returns the results to the
client.}

\item{ExclusiveStartKey}{The primary key of the first item that this operation will evaluate. Use
the value that was returned for \code{LastEvaluatedKey} in the previous
operation.

The data type for \code{ExclusiveStartKey} must be String, Number, or Binary.
No set data types are allowed.}

\item{ReturnConsumedCapacity}{}

\item{ProjectionExpression}{A string that identifies one or more attributes to retrieve from the
table. These attributes can include scalars, sets, or elements of a JSON
document. The attributes in the expression must be separated by commas.

If no attribute names are specified, then all attributes will be
returned. If any of the requested attributes are not found, they will
not appear in the result.

For more information, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Attributes.html}{Accessing Item Attributes}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{FilterExpression}{A string that contains conditions that DynamoDB applies after the
\code{\link[=dynamodb_query]{query}} operation, but before the data is returned to
you. Items that do not satisfy the \code{FilterExpression} criteria are not
returned.

A \code{FilterExpression} does not allow key attributes. You cannot define a
filter expression based on a partition key or a sort key.

A \code{FilterExpression} is applied after the items have already been read;
the process of filtering does not consume any additional read capacity
units.

For more information, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Query.html#Query.FilterExpression}{Filter Expressions}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{KeyConditionExpression}{The condition that specifies the key values for items to be retrieved by
the \code{\link[=dynamodb_query]{query}} action.

The condition must perform an equality test on a single partition key
value.

The condition can optionally perform one of several comparison tests on
a single sort key value. This allows \code{\link[=dynamodb_query]{query}} to
retrieve one item with a given partition key value and sort key value,
or several items that have the same partition key value but different
sort key values.

The partition key equality test is required, and must be specified in
the following format:

\code{partitionKeyName} \emph{=} \verb{:partitionkeyval}

If you also want to provide a condition for the sort key, it must be
combined using \code{AND} with the condition for the sort key. Following is
an example, using the \strong{=} comparison operator for the sort key:

\code{partitionKeyName} \code{=} \verb{:partitionkeyval} \code{AND} \code{sortKeyName} \code{=}
\verb{:sortkeyval}

Valid comparisons for the sort key condition are as follows:
\itemize{
\item \code{sortKeyName} \code{=} \verb{:sortkeyval} - true if the sort key value is
equal to \verb{:sortkeyval}.
\item \code{sortKeyName} \code{<} \verb{:sortkeyval} - true if the sort key value is less
than \verb{:sortkeyval}.
\item \code{sortKeyName} \code{<=} \verb{:sortkeyval} - true if the sort key value is
less than or equal to \verb{:sortkeyval}.
\item \code{sortKeyName} \code{>} \verb{:sortkeyval} - true if the sort key value is
greater than \verb{:sortkeyval}.
\item \code{sortKeyName} \verb{>= } \verb{:sortkeyval} - true if the sort key value is
greater than or equal to \verb{:sortkeyval}.
\item \code{sortKeyName} \code{BETWEEN} \verb{:sortkeyval1} \code{AND} \verb{:sortkeyval2} - true
if the sort key value is greater than or equal to \verb{:sortkeyval1},
and less than or equal to \verb{:sortkeyval2}.
\item \verb{begins_with (} \code{sortKeyName}, \verb{:sortkeyval} \verb{)} - true if the sort
key value begins with a particular operand. (You cannot use this
function with a sort key that is of type Number.) Note that the
function name \code{begins_with} is case-sensitive.
}

Use the \code{ExpressionAttributeValues} parameter to replace tokens such as
\verb{:partitionval} and \verb{:sortval} with actual values at runtime.

You can optionally use the \code{ExpressionAttributeNames} parameter to
replace the names of the partition key and sort key with placeholder
tokens. This option might be necessary if an attribute name conflicts
with a DynamoDB reserved word. For example, the following
\code{KeyConditionExpression} parameter causes an error because \emph{Size} is a
reserved word:
\itemize{
\item \verb{Size = :myval}
}

To work around this, define a placeholder (such a \verb{#S}) to represent the
attribute name \emph{Size}. \code{KeyConditionExpression} then is as follows:
\itemize{
\item \verb{#S = :myval}
}

For a list of reserved words, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html}{Reserved Words}
in the \emph{Amazon DynamoDB Developer Guide}.

For more information on \code{ExpressionAttributeNames} and
\code{ExpressionAttributeValues}, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.ExpressionAttributeNames.html}{Using Placeholders for Attribute Names and Values}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ExpressionAttributeNames}{One or more substitution tokens for attribute names in an expression.
The following are some use cases for using \code{ExpressionAttributeNames}:
\itemize{
\item To access an attribute whose name conflicts with a DynamoDB reserved
word.
\item To create a placeholder for repeating occurrences of an attribute
name in an expression.
\item To prevent special characters in an attribute name from being
misinterpreted in an expression.
}

Use the \strong{#} character in an expression to dereference an attribute
name. For example, consider the following attribute name:
\itemize{
\item \code{Percentile}
}

The name of this attribute conflicts with a reserved word, so it cannot
be used directly in an expression. (For the complete list of reserved
words, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html}{Reserved Words}
in the \emph{Amazon DynamoDB Developer Guide}). To work around this, you
could specify the following for \code{ExpressionAttributeNames}:
\itemize{
\item \code{{"#P":"Percentile"}}
}

You could then use this substitution in an expression, as in this
example:
\itemize{
\item \verb{#P = :val}
}

Tokens that begin with the \strong{:} character are \emph{expression attribute
values}, which are placeholders for the actual value at runtime.

For more information on expression attribute names, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Attributes.html}{Specifying Item Attributes}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ExpressionAttributeValues}{One or more values that can be substituted in an expression.

Use the \strong{:} (colon) character in an expression to dereference an
attribute value. For example, suppose that you wanted to check whether
the value of the \emph{ProductStatus} attribute was one of the following:

\code{Available | Backordered | Discontinued}

You would first need to specify \code{ExpressionAttributeValues} as follows:

\verb{\{ ":avail":\{"S":"Available"\}, ":back":\{"S":"Backordered"\}, ":disc":\{"S":"Discontinued"\} \}}

You could then use these values in an expression, such as this:

\verb{ProductStatus IN (:avail, :back, :disc)}

For more information on expression attribute values, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.ConditionExpressions.html}{Specifying Conditions}
in the \emph{Amazon DynamoDB Developer Guide}.}
}
\description{
You must provide the name of the partition key attribute and a single value for that attribute. \code{\link[=dynamodb_query]{query}} returns all items with that partition key value. Optionally, you can provide a sort key attribute and use a comparison operator to refine the search results.

See \url{https://paws-r.github.io/docs/dynamodb/query.html} for full documentation.
}
\keyword{internal}
