% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_apply_pending_maintenance_action}
\alias{docdb_apply_pending_maintenance_action}
\title{Applies a pending maintenance action to a resource (for example, to an
Amazon DocumentDB instance)}
\usage{
docdb_apply_pending_maintenance_action(
  ResourceIdentifier,
  ApplyAction,
  OptInType
)
}
\arguments{
\item{ResourceIdentifier}{[required] The Amazon Resource Name (ARN) of the resource that the pending
maintenance action applies to.}

\item{ApplyAction}{[required] The pending maintenance action to apply to this resource.

Valid values: \code{system-update}, \code{db-upgrade}}

\item{OptInType}{[required] A value that specifies the type of opt-in request or undoes an opt-in
request. An opt-in request of type \code{immediate} can't be undone.

Valid values:
\itemize{
\item \code{immediate} - Apply the maintenance action immediately.
\item \code{next-maintenance} - Apply the maintenance action during the next
maintenance window for the resource.
\item \verb{undo-opt-in} - Cancel any existing \code{next-maintenance} opt-in
requests.
}}
}
\description{
Applies a pending maintenance action to a resource (for example, to an Amazon DocumentDB instance).

See \url{https://paws-r.github.io/docs/docdb/apply_pending_maintenance_action.html} for full documentation.
}
\keyword{internal}
