% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_delete_db_cluster}
\alias{neptune_delete_db_cluster}
\title{The DeleteDBCluster action deletes a previously provisioned DB cluster}
\usage{
neptune_delete_db_cluster(DBClusterIdentifier, SkipFinalSnapshot,
  FinalDBSnapshotIdentifier)
}
\arguments{
\item{DBClusterIdentifier}{[required] The DB cluster identifier for the DB cluster to be deleted. This
parameter isn\'t case-sensitive.

Constraints:
\itemize{
\item Must match an existing DBClusterIdentifier.
}}

\item{SkipFinalSnapshot}{Determines whether a final DB cluster snapshot is created before the DB
cluster is deleted. If \code{true} is specified, no DB cluster snapshot is
created. If \code{false} is specified, a DB cluster snapshot is created
before the DB cluster is deleted.

You must specify a \code{FinalDBSnapshotIdentifier} parameter if
\code{SkipFinalSnapshot} is \code{false}.

Default: \code{false}}

\item{FinalDBSnapshotIdentifier}{The DB cluster snapshot identifier of the new DB cluster snapshot
created when \code{SkipFinalSnapshot} is set to \code{false}.

Specifying this parameter and also setting the \code{SkipFinalShapshot}
parameter to true results in an error.

Constraints:
\itemize{
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter
\item Cannot end with a hyphen or contain two consecutive hyphens
}}
}
\description{
The DeleteDBCluster action deletes a previously provisioned DB cluster.
When you delete a DB cluster, all automated backups for that DB cluster
are deleted and can\'t be recovered. Manual DB cluster snapshots of the
specified DB cluster are not deleted.
}
\details{
Note that the DB Cluster cannot be deleted if deletion protection is
enabled. To delete it, you must first set its \code{DeletionProtection} field
to \code{False}.
}
\section{Request syntax}{
\preformatted{svc$delete_db_cluster(
  DBClusterIdentifier = "string",
  SkipFinalSnapshot = TRUE|FALSE,
  FinalDBSnapshotIdentifier = "string"
)
}
}

\keyword{internal}
