% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_db_snapshot}
\alias{rds_modify_db_snapshot}
\title{Updates a manual DB snapshot, which can be encrypted or not encrypted,
with a new engine version}
\usage{
rds_modify_db_snapshot(DBSnapshotIdentifier, EngineVersion,
  OptionGroupName)
}
\arguments{
\item{DBSnapshotIdentifier}{[required] The identifier of the DB snapshot to modify.}

\item{EngineVersion}{The engine version to upgrade the DB snapshot to.

The following are the database engines and engine versions that are
available when you upgrade a DB snapshot.

\strong{MySQL}
\itemize{
\item \verb{5.5.46} (supported for 5.1 DB snapshots)
}

\strong{Oracle}
\itemize{
\item \verb{12.1.0.2.v8} (supported for 12.1.0.1 DB snapshots)
\item \verb{11.2.0.4.v12} (supported for 11.2.0.2 DB snapshots)
\item \verb{11.2.0.4.v11} (supported for 11.2.0.3 DB snapshots)
}

\strong{PostgreSQL}

For the list of engine versions that are available for upgrading a DB
snapshot, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.PostgreSQL.html#USER_UpgradeDBInstance.PostgreSQL.MajorVersion}{Upgrading the PostgreSQL DB Engine for Amazon RDS}.}

\item{OptionGroupName}{The option group to identify with the upgraded DB snapshot.

You can specify this parameter when you upgrade an Oracle DB snapshot.
The same option group considerations apply when upgrading a DB snapshot
as when upgrading a DB instance. For more information, see \href{http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Oracle.html#USER_UpgradeDBInstance.Oracle.OGPG.OG}{Option Group Considerations}
in the \emph{Amazon RDS User Guide.}}
}
\description{
Updates a manual DB snapshot, which can be encrypted or not encrypted,
with a new engine version.
}
\details{
Amazon RDS supports upgrading DB snapshots for MySQL, Oracle, and
PostgreSQL.
}
\section{Request syntax}{
\preformatted{svc$modify_db_snapshot(
  DBSnapshotIdentifier = "string",
  EngineVersion = "string",
  OptionGroupName = "string"
)
}
}

\keyword{internal}
