% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_instance_automated_backups}
\alias{rds_describe_db_instance_automated_backups}
\title{Displays backups for both current and deleted instances}
\usage{
rds_describe_db_instance_automated_backups(DbiResourceId,
  DBInstanceIdentifier, Filters, MaxRecords, Marker)
}
\arguments{
\item{DbiResourceId}{The resource ID of the DB instance that is the source of the automated
backup. This parameter isn\'t case-sensitive.}

\item{DBInstanceIdentifier}{(Optional) The user-supplied instance identifier. If this parameter is
specified, it must match the identifier of an existing DB instance. It
returns information from the specific DB instance\' automated backup.
This parameter isn\'t case-sensitive.}

\item{Filters}{A filter that specifies which resources to return based on status.

Supported filters are the following:
\itemize{
\item \code{status}
\itemize{
\item \code{active} - automated backups for current instances
\item \code{retained} - automated backups for deleted instances
\item \code{creating} - automated backups that are waiting for the first
automated snapshot to be available
}
\item \code{db-instance-id} - Accepts DB instance identifiers and Amazon
Resource Names (ARNs) for DB instances. The results list includes
only information about the DB instance automated backupss identified
by these ARNs.
\item \code{dbi-resource-id} - Accepts DB instance resource identifiers and DB
Amazon Resource Names (ARNs) for DB instances. The results list
includes only information about the DB instance resources identified
by these ARNs.
}

Returns all resources by default. The status for each resource is
specified in the response.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that you can retrieve the
remaining results.}

\item{Marker}{The pagination token provided in the previous request. If this parameter
is specified the response includes only records beyond the marker, up to
\code{MaxRecords}.}
}
\description{
Displays backups for both current and deleted instances. For example,
use this operation to find details about automated backups for
previously deleted instances. Current instances with retention periods
greater than zero (0) are returned for both the
\code{DescribeDBInstanceAutomatedBackups} and \code{DescribeDBInstances}
operations.
}
\details{
All parameters are optional.
}
\section{Request syntax}{
\preformatted{svc$describe_db_instance_automated_backups(
  DbiResourceId = "string",
  DBInstanceIdentifier = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
