% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_delete_cache_cluster}
\alias{elasticache_delete_cache_cluster}
\title{Deletes a previously provisioned cluster}
\usage{
elasticache_delete_cache_cluster(CacheClusterId,
  FinalSnapshotIdentifier)
}
\arguments{
\item{CacheClusterId}{[required] The cluster identifier for the cluster to be deleted. This parameter is
not case sensitive.}

\item{FinalSnapshotIdentifier}{The user-supplied name of a final cluster snapshot. This is the unique
name that identifies the snapshot. ElastiCache creates the snapshot, and
then deletes the cluster immediately afterward.}
}
\description{
Deletes a previously provisioned cluster. \code{DeleteCacheCluster} deletes
all associated cache nodes, node endpoints and the cluster itself. When
you receive a successful response from this operation, Amazon
ElastiCache immediately begins deleting the cluster; you cannot cancel
or revert this operation.
}
\details{
This operation is not valid for:
\itemize{
\item Redis (cluster mode enabled) clusters
\item A cluster that is the last read replica of a replication group
\item A node group (shard) that has Multi-AZ mode enabled
\item A cluster from a Redis (cluster mode enabled) replication group
\item A cluster that is not in the \code{available} state
}
}
\section{Request syntax}{
\preformatted{svc$delete_cache_cluster(
  CacheClusterId = "string",
  FinalSnapshotIdentifier = "string"
)
}
}

\keyword{internal}
