# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include neptune_service.R
NULL

#' Associates an Identity and Access Management (IAM) role from an Neptune
#' DB cluster
#'
#' Associates an Identity and Access Management (IAM) role from an Neptune
#' DB cluster.
#'
#' @usage
#' neptune_add_role_to_db_cluster(DBClusterIdentifier, RoleArn)
#'
#' @param DBClusterIdentifier &#91;required&#93; The name of the DB cluster to associate the IAM role with.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to associate with the
#' Neptune DB cluster, for example
#' `arn:aws:iam::123456789012:role/NeptuneAccessRole`.
#'
#' @section Request syntax:
#' ```
#' svc$add_role_to_db_cluster(
#'   DBClusterIdentifier = "string",
#'   RoleArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_add_role_to_db_cluster
neptune_add_role_to_db_cluster <- function(DBClusterIdentifier, RoleArn) {
  op <- new_operation(
    name = "AddRoleToDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$add_role_to_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, RoleArn = RoleArn)
  output <- .neptune$add_role_to_db_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$add_role_to_db_cluster <- neptune_add_role_to_db_cluster

#' Adds a source identifier to an existing event notification subscription
#'
#' Adds a source identifier to an existing event notification subscription.
#'
#' @usage
#' neptune_add_source_identifier_to_subscription(SubscriptionName,
#'   SourceIdentifier)
#'
#' @param SubscriptionName &#91;required&#93; The name of the event notification subscription you want to add a source
#' identifier to.
#' @param SourceIdentifier &#91;required&#93; The identifier of the event source to be added.
#' 
#' Constraints:
#' 
#' -   If the source type is a DB instance, then a `DBInstanceIdentifier`
#'     must be supplied.
#' 
#' -   If the source type is a DB security group, a `DBSecurityGroupName`
#'     must be supplied.
#' 
#' -   If the source type is a DB parameter group, a `DBParameterGroupName`
#'     must be supplied.
#' 
#' -   If the source type is a DB snapshot, a `DBSnapshotIdentifier` must
#'     be supplied.
#'
#' @section Request syntax:
#' ```
#' svc$add_source_identifier_to_subscription(
#'   SubscriptionName = "string",
#'   SourceIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_add_source_identifier_to_subscription
neptune_add_source_identifier_to_subscription <- function(SubscriptionName, SourceIdentifier) {
  op <- new_operation(
    name = "AddSourceIdentifierToSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$add_source_identifier_to_subscription_input(SubscriptionName = SubscriptionName, SourceIdentifier = SourceIdentifier)
  output <- .neptune$add_source_identifier_to_subscription_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$add_source_identifier_to_subscription <- neptune_add_source_identifier_to_subscription

#' Adds metadata tags to an Amazon Neptune resource
#'
#' Adds metadata tags to an Amazon Neptune resource. These tags can also be
#' used with cost allocation reporting to track cost associated with Amazon
#' Neptune resources, or used in a Condition statement in an IAM policy for
#' Amazon Neptune.
#'
#' @usage
#' neptune_add_tags_to_resource(ResourceName, Tags)
#'
#' @param ResourceName &#91;required&#93; The Amazon Neptune resource that the tags are added to. This value is an
#' Amazon Resource Name (ARN). For information about creating an ARN, see
#' [Constructing an Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing).
#' @param Tags &#91;required&#93; The tags to be assigned to the Amazon Neptune resource.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags_to_resource(
#'   ResourceName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_add_tags_to_resource
neptune_add_tags_to_resource <- function(ResourceName, Tags) {
  op <- new_operation(
    name = "AddTagsToResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$add_tags_to_resource_input(ResourceName = ResourceName, Tags = Tags)
  output <- .neptune$add_tags_to_resource_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$add_tags_to_resource <- neptune_add_tags_to_resource

#' Applies a pending maintenance action to a resource (for example, to a DB
#' instance)
#'
#' Applies a pending maintenance action to a resource (for example, to a DB
#' instance).
#'
#' @usage
#' neptune_apply_pending_maintenance_action(ResourceIdentifier,
#'   ApplyAction, OptInType)
#'
#' @param ResourceIdentifier &#91;required&#93; The Amazon Resource Name (ARN) of the resource that the pending
#' maintenance action applies to. For information about creating an ARN,
#' see [Constructing an Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing).
#' @param ApplyAction &#91;required&#93; The pending maintenance action to apply to this resource.
#' 
#' Valid values: `system-update`, `db-upgrade`
#' @param OptInType &#91;required&#93; A value that specifies the type of opt-in request, or undoes an opt-in
#' request. An opt-in request of type `immediate` can\'t be undone.
#' 
#' Valid values:
#' 
#' -   `immediate` - Apply the maintenance action immediately.
#' 
#' -   `next-maintenance` - Apply the maintenance action during the next
#'     maintenance window for the resource.
#' 
#' -   `undo-opt-in` - Cancel any existing `next-maintenance` opt-in
#'     requests.
#'
#' @section Request syntax:
#' ```
#' svc$apply_pending_maintenance_action(
#'   ResourceIdentifier = "string",
#'   ApplyAction = "string",
#'   OptInType = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_apply_pending_maintenance_action
neptune_apply_pending_maintenance_action <- function(ResourceIdentifier, ApplyAction, OptInType) {
  op <- new_operation(
    name = "ApplyPendingMaintenanceAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$apply_pending_maintenance_action_input(ResourceIdentifier = ResourceIdentifier, ApplyAction = ApplyAction, OptInType = OptInType)
  output <- .neptune$apply_pending_maintenance_action_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$apply_pending_maintenance_action <- neptune_apply_pending_maintenance_action

#' Copies the specified DB cluster parameter group
#'
#' Copies the specified DB cluster parameter group.
#'
#' @usage
#' neptune_copy_db_cluster_parameter_group(
#'   SourceDBClusterParameterGroupIdentifier,
#'   TargetDBClusterParameterGroupIdentifier,
#'   TargetDBClusterParameterGroupDescription, Tags)
#'
#' @param SourceDBClusterParameterGroupIdentifier &#91;required&#93; The identifier or Amazon Resource Name (ARN) for the source DB cluster
#' parameter group. For information about creating an ARN, see
#' [Constructing an Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing).
#' 
#' Constraints:
#' 
#' -   Must specify a valid DB cluster parameter group.
#' 
#' -   If the source DB cluster parameter group is in the same AWS Region
#'     as the copy, specify a valid DB parameter group identifier, for
#'     example `my-db-cluster-param-group`, or a valid ARN.
#' 
#' -   If the source DB parameter group is in a different AWS Region than
#'     the copy, specify a valid DB cluster parameter group ARN, for
#'     example
#'     `arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1`.
#' @param TargetDBClusterParameterGroupIdentifier &#91;required&#93; The identifier for the copied DB cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Cannot be null, empty, or blank
#' 
#' -   Must contain from 1 to 255 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-cluster-param-group1`
#' @param TargetDBClusterParameterGroupDescription &#91;required&#93; A description for the copied DB cluster parameter group.
#' @param Tags The tags to be assigned to the copied DB cluster parameter group.
#'
#' @section Request syntax:
#' ```
#' svc$copy_db_cluster_parameter_group(
#'   SourceDBClusterParameterGroupIdentifier = "string",
#'   TargetDBClusterParameterGroupIdentifier = "string",
#'   TargetDBClusterParameterGroupDescription = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_copy_db_cluster_parameter_group
neptune_copy_db_cluster_parameter_group <- function(SourceDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupDescription, Tags = NULL) {
  op <- new_operation(
    name = "CopyDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$copy_db_cluster_parameter_group_input(SourceDBClusterParameterGroupIdentifier = SourceDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupIdentifier = TargetDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupDescription = TargetDBClusterParameterGroupDescription, Tags = Tags)
  output <- .neptune$copy_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$copy_db_cluster_parameter_group <- neptune_copy_db_cluster_parameter_group

#' Copies a snapshot of a DB cluster
#'
#' Copies a snapshot of a DB cluster.
#' 
#' To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
#' `SourceDBClusterSnapshotIdentifier` must be the Amazon Resource Name
#' (ARN) of the shared DB cluster snapshot.
#' 
#' You can\'t copy from one AWS Region to another.
#'
#' @usage
#' neptune_copy_db_cluster_snapshot(SourceDBClusterSnapshotIdentifier,
#'   TargetDBClusterSnapshotIdentifier, KmsKeyId, PreSignedUrl, CopyTags,
#'   Tags)
#'
#' @param SourceDBClusterSnapshotIdentifier &#91;required&#93; The identifier of the DB cluster snapshot to copy. This parameter is not
#' case-sensitive.
#' 
#' You can\'t copy from one AWS Region to another.
#' 
#' Constraints:
#' 
#' -   Must specify a valid system snapshot in the \"available\" state.
#' 
#' -   Specify a valid DB snapshot identifier.
#' 
#' Example: `my-cluster-snapshot1`
#' @param TargetDBClusterSnapshotIdentifier &#91;required&#93; The identifier of the new DB cluster snapshot to create from the source
#' DB cluster snapshot. This parameter is not case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster-snapshot2`
#' @param KmsKeyId The AWS AWS KMS key ID for an encrypted DB cluster snapshot. The KMS key
#' ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key
#' alias for the KMS encryption key.
#' 
#' If you copy an unencrypted DB cluster snapshot and specify a value for
#' the `KmsKeyId` parameter, Amazon Neptune encrypts the target DB cluster
#' snapshot using the specified KMS encryption key.
#' 
#' If you copy an encrypted DB cluster snapshot from your AWS account, you
#' can specify a value for `KmsKeyId` to encrypt the copy with a new KMS
#' encryption key. If you don\'t specify a value for `KmsKeyId`, then the
#' copy of the DB cluster snapshot is encrypted with the same KMS key as
#' the source DB cluster snapshot.
#' 
#' If you copy an encrypted DB cluster snapshot that is shared from another
#' AWS account, then you must specify a value for `KmsKeyId`.
#' 
#' KMS encryption keys are specific to the AWS Region that they are created
#' in, and you can\'t use encryption keys from one AWS Region in another
#' AWS Region.
#' @param PreSignedUrl Not currently supported.
#' @param CopyTags True to copy all tags from the source DB cluster snapshot to the target
#' DB cluster snapshot, and otherwise false. The default is false.
#' @param Tags The tags to assign to the new DB cluster snapshot copy.
#'
#' @section Request syntax:
#' ```
#' svc$copy_db_cluster_snapshot(
#'   SourceDBClusterSnapshotIdentifier = "string",
#'   TargetDBClusterSnapshotIdentifier = "string",
#'   KmsKeyId = "string",
#'   PreSignedUrl = "string",
#'   CopyTags = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_copy_db_cluster_snapshot
neptune_copy_db_cluster_snapshot <- function(SourceDBClusterSnapshotIdentifier, TargetDBClusterSnapshotIdentifier, KmsKeyId = NULL, PreSignedUrl = NULL, CopyTags = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CopyDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$copy_db_cluster_snapshot_input(SourceDBClusterSnapshotIdentifier = SourceDBClusterSnapshotIdentifier, TargetDBClusterSnapshotIdentifier = TargetDBClusterSnapshotIdentifier, KmsKeyId = KmsKeyId, PreSignedUrl = PreSignedUrl, CopyTags = CopyTags, Tags = Tags)
  output <- .neptune$copy_db_cluster_snapshot_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$copy_db_cluster_snapshot <- neptune_copy_db_cluster_snapshot

#' Copies the specified DB parameter group
#'
#' Copies the specified DB parameter group.
#'
#' @usage
#' neptune_copy_db_parameter_group(SourceDBParameterGroupIdentifier,
#'   TargetDBParameterGroupIdentifier, TargetDBParameterGroupDescription,
#'   Tags)
#'
#' @param SourceDBParameterGroupIdentifier &#91;required&#93; The identifier or ARN for the source DB parameter group. For information
#' about creating an ARN, see [Constructing an Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing).
#' 
#' Constraints:
#' 
#' -   Must specify a valid DB parameter group.
#' 
#' -   Must specify a valid DB parameter group identifier, for example
#'     `my-db-param-group`, or a valid ARN.
#' @param TargetDBParameterGroupIdentifier &#91;required&#93; The identifier for the copied DB parameter group.
#' 
#' Constraints:
#' 
#' -   Cannot be null, empty, or blank.
#' 
#' -   Must contain from 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-db-parameter-group`
#' @param TargetDBParameterGroupDescription &#91;required&#93; A description for the copied DB parameter group.
#' @param Tags The tags to be assigned to the copied DB parameter group.
#'
#' @section Request syntax:
#' ```
#' svc$copy_db_parameter_group(
#'   SourceDBParameterGroupIdentifier = "string",
#'   TargetDBParameterGroupIdentifier = "string",
#'   TargetDBParameterGroupDescription = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_copy_db_parameter_group
neptune_copy_db_parameter_group <- function(SourceDBParameterGroupIdentifier, TargetDBParameterGroupIdentifier, TargetDBParameterGroupDescription, Tags = NULL) {
  op <- new_operation(
    name = "CopyDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$copy_db_parameter_group_input(SourceDBParameterGroupIdentifier = SourceDBParameterGroupIdentifier, TargetDBParameterGroupIdentifier = TargetDBParameterGroupIdentifier, TargetDBParameterGroupDescription = TargetDBParameterGroupDescription, Tags = Tags)
  output <- .neptune$copy_db_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$copy_db_parameter_group <- neptune_copy_db_parameter_group

#' Creates a new Amazon Neptune DB cluster
#'
#' Creates a new Amazon Neptune DB cluster.
#' 
#' You can use the `ReplicationSourceIdentifier` parameter to create the DB
#' cluster as a Read Replica of another DB cluster or Amazon Neptune DB
#' instance.
#'
#' @usage
#' neptune_create_db_cluster(AvailabilityZones, BackupRetentionPeriod,
#'   CharacterSetName, DatabaseName, DBClusterIdentifier,
#'   DBClusterParameterGroupName, VpcSecurityGroupIds, DBSubnetGroupName,
#'   Engine, EngineVersion, Port, MasterUsername, MasterUserPassword,
#'   OptionGroupName, PreferredBackupWindow, PreferredMaintenanceWindow,
#'   ReplicationSourceIdentifier, Tags, StorageEncrypted, KmsKeyId,
#'   PreSignedUrl, EnableIAMDatabaseAuthentication,
#'   EnableCloudwatchLogsExports)
#'
#' @param AvailabilityZones A list of EC2 Availability Zones that instances in the DB cluster can be
#' created in.
#' @param BackupRetentionPeriod The number of days for which automated backups are retained. You must
#' specify a minimum value of 1.
#' 
#' Default: 1
#' 
#' Constraints:
#' 
#' -   Must be a value from 1 to 35
#' @param CharacterSetName A value that indicates that the DB cluster should be associated with the
#' specified CharacterSet.
#' @param DatabaseName The name for your database of up to 64 alpha-numeric characters. If you
#' do not provide a name, Amazon Neptune will not create a database in the
#' DB cluster you are creating.
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier. This parameter is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster1`
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to associate with this DB
#' cluster. If this argument is omitted, the default is used.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to associate with this DB cluster.
#' @param DBSubnetGroupName A DB subnet group to associate with this DB cluster.
#' 
#' Constraints: Must match the name of an existing DBSubnetGroup. Must not
#' be default.
#' 
#' Example: `mySubnetgroup`
#' @param Engine &#91;required&#93; The name of the database engine to be used for this DB cluster.
#' 
#' Valid Values: `neptune`
#' @param EngineVersion The version number of the database engine to use.
#' 
#' Example: `1.0.1`
#' @param Port The port number on which the instances in the DB cluster accept
#' connections.
#' 
#' Default: `8182`
#' @param MasterUsername The name of the master user for the DB cluster.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 16 letters or numbers.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot be a reserved word for the chosen database engine.
#' @param MasterUserPassword The password for the master database user. This password can contain any
#' printable ASCII character except \"/\", \"\"\", or \"@\".
#' 
#' Constraints: Must contain from 8 to 41 characters.
#' @param OptionGroupName A value that indicates that the DB cluster should be associated with the
#' specified option group.
#' 
#' Permanent options can\'t be removed from an option group. The option
#' group can\'t be removed from a DB cluster once it is associated with a
#' DB cluster.
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled using the `BackupRetentionPeriod`
#' parameter.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region. To see the time blocks available, see
#' [Adjusting the Preferred Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
#' in the *Amazon Neptune User Guide.*
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param PreferredMaintenanceWindow The weekly time range during which system maintenance can occur, in
#' Universal Coordinated Time (UTC).
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region, occurring on a random day of the
#' week. To see the time blocks available, see [Adjusting the Preferred
#' Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
#' in the *Amazon Neptune User Guide.*
#' 
#' Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' Constraints: Minimum 30-minute window.
#' @param ReplicationSourceIdentifier The Amazon Resource Name (ARN) of the source DB instance or DB cluster
#' if this DB cluster is created as a Read Replica.
#' @param Tags The tags to assign to the new DB cluster.
#' @param StorageEncrypted Specifies whether the DB cluster is encrypted.
#' @param KmsKeyId The AWS KMS key identifier for an encrypted DB cluster.
#' 
#' The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
#' encryption key. If you are creating a DB cluster with the same AWS
#' account that owns the KMS encryption key used to encrypt the new DB
#' cluster, then you can use the KMS key alias instead of the ARN for the
#' KMS encryption key.
#' 
#' If an encryption key is not specified in `KmsKeyId`:
#' 
#' -   If `ReplicationSourceIdentifier` identifies an encrypted source,
#'     then Amazon Neptune will use the encryption key used to encrypt the
#'     source. Otherwise, Amazon Neptune will use your default encryption
#'     key.
#' 
#' -   If the `StorageEncrypted` parameter is true and
#'     `ReplicationSourceIdentifier` is not specified, then Amazon Neptune
#'     will use your default encryption key.
#' 
#' AWS KMS creates the default encryption key for your AWS account. Your
#' AWS account has a different default encryption key for each AWS Region.
#' 
#' If you create a Read Replica of an encrypted DB cluster in another AWS
#' Region, you must set `KmsKeyId` to a KMS key ID that is valid in the
#' destination AWS Region. This key is used to encrypt the Read Replica in
#' that AWS Region.
#' @param PreSignedUrl This parameter is not currently supported.
#' @param EnableIAMDatabaseAuthentication True to enable mapping of AWS Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' Default: `false`
#' @param EnableCloudwatchLogsExports The list of log types that need to be enabled for exporting to
#' CloudWatch Logs.
#'
#' @section Request syntax:
#' ```
#' svc$create_db_cluster(
#'   AvailabilityZones = list(
#'     "string"
#'   ),
#'   BackupRetentionPeriod = 123,
#'   CharacterSetName = "string",
#'   DatabaseName = "string",
#'   DBClusterIdentifier = "string",
#'   DBClusterParameterGroupName = "string",
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   DBSubnetGroupName = "string",
#'   Engine = "string",
#'   EngineVersion = "string",
#'   Port = 123,
#'   MasterUsername = "string",
#'   MasterUserPassword = "string",
#'   OptionGroupName = "string",
#'   PreferredBackupWindow = "string",
#'   PreferredMaintenanceWindow = "string",
#'   ReplicationSourceIdentifier = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   StorageEncrypted = TRUE|FALSE,
#'   KmsKeyId = "string",
#'   PreSignedUrl = "string",
#'   EnableIAMDatabaseAuthentication = TRUE|FALSE,
#'   EnableCloudwatchLogsExports = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_create_db_cluster
neptune_create_db_cluster <- function(AvailabilityZones = NULL, BackupRetentionPeriod = NULL, CharacterSetName = NULL, DatabaseName = NULL, DBClusterIdentifier, DBClusterParameterGroupName = NULL, VpcSecurityGroupIds = NULL, DBSubnetGroupName = NULL, Engine, EngineVersion = NULL, Port = NULL, MasterUsername = NULL, MasterUserPassword = NULL, OptionGroupName = NULL, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, ReplicationSourceIdentifier = NULL, Tags = NULL, StorageEncrypted = NULL, KmsKeyId = NULL, PreSignedUrl = NULL, EnableIAMDatabaseAuthentication = NULL, EnableCloudwatchLogsExports = NULL) {
  op <- new_operation(
    name = "CreateDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$create_db_cluster_input(AvailabilityZones = AvailabilityZones, BackupRetentionPeriod = BackupRetentionPeriod, CharacterSetName = CharacterSetName, DatabaseName = DatabaseName, DBClusterIdentifier = DBClusterIdentifier, DBClusterParameterGroupName = DBClusterParameterGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, DBSubnetGroupName = DBSubnetGroupName, Engine = Engine, EngineVersion = EngineVersion, Port = Port, MasterUsername = MasterUsername, MasterUserPassword = MasterUserPassword, OptionGroupName = OptionGroupName, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, ReplicationSourceIdentifier = ReplicationSourceIdentifier, Tags = Tags, StorageEncrypted = StorageEncrypted, KmsKeyId = KmsKeyId, PreSignedUrl = PreSignedUrl, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports)
  output <- .neptune$create_db_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$create_db_cluster <- neptune_create_db_cluster

#' Creates a new DB cluster parameter group
#'
#' Creates a new DB cluster parameter group.
#' 
#' Parameters in a DB cluster parameter group apply to all of the instances
#' in a DB cluster.
#' 
#' A DB cluster parameter group is initially created with the default
#' parameters for the database engine used by instances in the DB cluster.
#' To provide custom values for any of the parameters, you must modify the
#' group after creating it using ModifyDBClusterParameterGroup. Once
#' you\'ve created a DB cluster parameter group, you need to associate it
#' with your DB cluster using ModifyDBCluster. When you associate a new DB
#' cluster parameter group with a running DB cluster, you need to reboot
#' the DB instances in the DB cluster without failover for the new DB
#' cluster parameter group and associated settings to take effect.
#' 
#' After you create a DB cluster parameter group, you should wait at least
#' 5 minutes before creating your first DB cluster that uses that DB
#' cluster parameter group as the default parameter group. This allows
#' Amazon Neptune to fully complete the create action before the DB cluster
#' parameter group is used as the default for a new DB cluster. This is
#' especially important for parameters that are critical when creating the
#' default database for a DB cluster, such as the character set for the
#' default database defined by the `character_set_database` parameter. You
#' can use the *Parameter Groups* option of the [Amazon Neptune
#' console](https://console.aws.amazon.com/rds/) or the
#' DescribeDBClusterParameters command to verify that your DB cluster
#' parameter group has been created or modified.
#'
#' @usage
#' neptune_create_db_cluster_parameter_group(DBClusterParameterGroupName,
#'   DBParameterGroupFamily, Description, Tags)
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Must match the name of an existing DBClusterParameterGroup.
#' 
#' This value is stored as a lowercase string.
#' @param DBParameterGroupFamily &#91;required&#93; The DB cluster parameter group family name. A DB cluster parameter group
#' can be associated with one and only one DB cluster parameter group
#' family, and can be applied only to a DB cluster running a database
#' engine and engine version compatible with that DB cluster parameter
#' group family.
#' @param Description &#91;required&#93; The description for the DB cluster parameter group.
#' @param Tags The tags to be assigned to the new DB cluster parameter group.
#'
#' @section Request syntax:
#' ```
#' svc$create_db_cluster_parameter_group(
#'   DBClusterParameterGroupName = "string",
#'   DBParameterGroupFamily = "string",
#'   Description = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_create_db_cluster_parameter_group
neptune_create_db_cluster_parameter_group <- function(DBClusterParameterGroupName, DBParameterGroupFamily, Description, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$create_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, DBParameterGroupFamily = DBParameterGroupFamily, Description = Description, Tags = Tags)
  output <- .neptune$create_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$create_db_cluster_parameter_group <- neptune_create_db_cluster_parameter_group

#' Creates a snapshot of a DB cluster
#'
#' Creates a snapshot of a DB cluster.
#'
#' @usage
#' neptune_create_db_cluster_snapshot(DBClusterSnapshotIdentifier,
#'   DBClusterIdentifier, Tags)
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier of the DB cluster snapshot. This parameter is stored as a
#' lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster1-snapshot1`
#' @param DBClusterIdentifier &#91;required&#93; The identifier of the DB cluster to create a snapshot for. This
#' parameter is not case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBCluster.
#' 
#' Example: `my-cluster1`
#' @param Tags The tags to be assigned to the DB cluster snapshot.
#'
#' @section Request syntax:
#' ```
#' svc$create_db_cluster_snapshot(
#'   DBClusterSnapshotIdentifier = "string",
#'   DBClusterIdentifier = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_create_db_cluster_snapshot
neptune_create_db_cluster_snapshot <- function(DBClusterSnapshotIdentifier, DBClusterIdentifier, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$create_db_cluster_snapshot_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, DBClusterIdentifier = DBClusterIdentifier, Tags = Tags)
  output <- .neptune$create_db_cluster_snapshot_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$create_db_cluster_snapshot <- neptune_create_db_cluster_snapshot

#' Creates a new DB instance
#'
#' Creates a new DB instance.
#'
#' @usage
#' neptune_create_db_instance(DBName, DBInstanceIdentifier,
#'   AllocatedStorage, DBInstanceClass, Engine, MasterUsername,
#'   MasterUserPassword, DBSecurityGroups, VpcSecurityGroupIds,
#'   AvailabilityZone, DBSubnetGroupName, PreferredMaintenanceWindow,
#'   DBParameterGroupName, BackupRetentionPeriod, PreferredBackupWindow,
#'   Port, MultiAZ, EngineVersion, AutoMinorVersionUpgrade, LicenseModel,
#'   Iops, OptionGroupName, CharacterSetName, PubliclyAccessible, Tags,
#'   DBClusterIdentifier, StorageType, TdeCredentialArn,
#'   TdeCredentialPassword, StorageEncrypted, KmsKeyId, Domain,
#'   CopyTagsToSnapshot, MonitoringInterval, MonitoringRoleArn,
#'   DomainIAMRoleName, PromotionTier, Timezone,
#'   EnableIAMDatabaseAuthentication, EnablePerformanceInsights,
#'   PerformanceInsightsKMSKeyId, EnableCloudwatchLogsExports)
#'
#' @param DBName Not supported.
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier. This parameter is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `mydbinstance`
#' @param AllocatedStorage The amount of storage (in gibibytes) to allocate for the DB instance.
#' 
#' Type: Integer
#' 
#' Not applicable. Neptune cluster volumes automatically grow as the amount
#' of data in your database increases, though you are only charged for the
#' space that you use in a Neptune cluster volume.
#' @param DBInstanceClass &#91;required&#93; The compute and memory capacity of the DB instance, for example,
#' `db.m4.large`. Not all DB instance classes are available in all AWS
#' Regions.
#' @param Engine &#91;required&#93; The name of the database engine to be used for this instance.
#' 
#' Valid Values: `neptune`
#' @param MasterUsername The name for the master user. Not used.
#' @param MasterUserPassword The password for the master user. The password can include any printable
#' ASCII character except \"/\", \"\"\", or \"@\".
#' 
#' Not used.
#' @param DBSecurityGroups A list of DB security groups to associate with this DB instance.
#' 
#' Default: The default DB security group for the database engine.
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to associate with this DB instance.
#' 
#' Not applicable. The associated list of EC2 VPC security groups is
#' managed by the DB cluster. For more information, see CreateDBCluster.
#' 
#' Default: The default EC2 VPC security group for the DB subnet group\'s
#' VPC.
#' @param AvailabilityZone The EC2 Availability Zone that the DB instance is created in
#' 
#' Default: A random, system-chosen Availability Zone in the endpoint\'s
#' AWS Region.
#' 
#' Example: `us-east-1d`
#' 
#' Constraint: The AvailabilityZone parameter can\'t be specified if the
#' MultiAZ parameter is set to `true`. The specified Availability Zone must
#' be in the same AWS Region as the current endpoint.
#' @param DBSubnetGroupName A DB subnet group to associate with this DB instance.
#' 
#' If there is no DB subnet group, then it is a non-VPC DB instance.
#' @param PreferredMaintenanceWindow The time range each week during which system maintenance can occur, in
#' Universal Coordinated Time (UTC).
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region, occurring on a random day of the
#' week.
#' 
#' Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' Constraints: Minimum 30-minute window.
#' @param DBParameterGroupName The name of the DB parameter group to associate with this DB instance.
#' If this argument is omitted, the default DBParameterGroup for the
#' specified engine is used.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' @param BackupRetentionPeriod The number of days for which automated backups are retained.
#' 
#' Not applicable. The retention period for automated backups is managed by
#' the DB cluster. For more information, see CreateDBCluster.
#' 
#' Default: 1
#' 
#' Constraints:
#' 
#' -   Must be a value from 0 to 35
#' 
#' -   Cannot be set to 0 if the DB instance is a source to Read Replicas
#' @param PreferredBackupWindow The daily time range during which automated backups are created.
#' 
#' Not applicable. The daily time range for creating automated backups is
#' managed by the DB cluster. For more information, see CreateDBCluster.
#' @param Port The port number on which the database accepts connections.
#' 
#' Not applicable. The port is managed by the DB cluster. For more
#' information, see CreateDBCluster.
#' 
#' Default: `8182`
#' 
#' Type: Integer
#' @param MultiAZ Specifies if the DB instance is a Multi-AZ deployment. You can\'t set
#' the AvailabilityZone parameter if the MultiAZ parameter is set to true.
#' @param EngineVersion The version number of the database engine to use.
#' @param AutoMinorVersionUpgrade Indicates that minor engine upgrades are applied automatically to the DB
#' instance during the maintenance window.
#' 
#' Default: `true`
#' @param LicenseModel License model information for this DB instance.
#' 
#' Valid values: `license-included` \\| `bring-your-own-license` \\|
#' `general-public-license`
#' @param Iops The amount of Provisioned IOPS (input/output operations per second) to
#' be initially allocated for the DB instance.
#' @param OptionGroupName Indicates that the DB instance should be associated with the specified
#' option group.
#' 
#' Permanent options, such as the TDE option for Oracle Advanced Security
#' TDE, can\'t be removed from an option group, and that option group
#' can\'t be removed from a DB instance once it is associated with a DB
#' instance
#' @param CharacterSetName Indicates that the DB instance should be associated with the specified
#' CharacterSet.
#' 
#' Not applicable. The character set is managed by the DB cluster. For more
#' information, see CreateDBCluster.
#' @param PubliclyAccessible This flag should no longer be used.
#' @param Tags The tags to assign to the new instance.
#' @param DBClusterIdentifier The identifier of the DB cluster that the instance will belong to.
#' 
#' For information on creating a DB cluster, see CreateDBCluster.
#' 
#' Type: String
#' @param StorageType Specifies the storage type to be associated with the DB instance.
#' 
#' Not applicable. Storage is managed by the DB Cluster.
#' @param TdeCredentialArn The ARN from the key store with which to associate the instance for TDE
#' encryption.
#' @param TdeCredentialPassword The password for the given ARN from the key store in order to access the
#' device.
#' @param StorageEncrypted Specifies whether the DB instance is encrypted.
#' 
#' Not applicable. The encryption for DB instances is managed by the DB
#' cluster. For more information, see CreateDBCluster.
#' 
#' Default: false
#' @param KmsKeyId The AWS KMS key identifier for an encrypted DB instance.
#' 
#' The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
#' encryption key. If you are creating a DB instance with the same AWS
#' account that owns the KMS encryption key used to encrypt the new DB
#' instance, then you can use the KMS key alias instead of the ARN for the
#' KM encryption key.
#' 
#' Not applicable. The KMS key identifier is managed by the DB cluster. For
#' more information, see CreateDBCluster.
#' 
#' If the `StorageEncrypted` parameter is true, and you do not specify a
#' value for the `KmsKeyId` parameter, then Amazon Neptune will use your
#' default encryption key. AWS KMS creates the default encryption key for
#' your AWS account. Your AWS account has a different default encryption
#' key for each AWS Region.
#' @param Domain Specify the Active Directory Domain to create the instance in.
#' @param CopyTagsToSnapshot True to copy all tags from the DB instance to snapshots of the DB
#' instance, and otherwise false. The default is false.
#' @param MonitoringInterval The interval, in seconds, between points when Enhanced Monitoring
#' metrics are collected for the DB instance. To disable collecting
#' Enhanced Monitoring metrics, specify 0. The default is 0.
#' 
#' If `MonitoringRoleArn` is specified, then you must also set
#' `MonitoringInterval` to a value other than 0.
#' 
#' Valid Values: `0, 1, 5, 10, 15, 30, 60`
#' @param MonitoringRoleArn The ARN for the IAM role that permits Neptune to send enhanced
#' monitoring metrics to Amazon CloudWatch Logs. For example,
#' `arn:aws:iam:123456789012:role/emaccess`.
#' 
#' If `MonitoringInterval` is set to a value other than 0, then you must
#' supply a `MonitoringRoleArn` value.
#' @param DomainIAMRoleName Specify the name of the IAM role to be used when making API calls to the
#' Directory Service.
#' @param PromotionTier A value that specifies the order in which an Read Replica is promoted to
#' the primary instance after a failure of the existing primary instance.
#' 
#' Default: 1
#' 
#' Valid Values: 0 - 15
#' @param Timezone The time zone of the DB instance.
#' @param EnableIAMDatabaseAuthentication True to enable AWS Identity and Access Management (IAM) authentication
#' for Neptune.
#' 
#' Default: `false`
#' @param EnablePerformanceInsights True to enable Performance Insights for the DB instance, and otherwise
#' false.
#' @param PerformanceInsightsKMSKeyId The AWS KMS key identifier for encryption of Performance Insights data.
#' The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or
#' the KMS key alias for the KMS encryption key.
#' @param EnableCloudwatchLogsExports The list of log types that need to be enabled for exporting to
#' CloudWatch Logs.
#'
#' @section Request syntax:
#' ```
#' svc$create_db_instance(
#'   DBName = "string",
#'   DBInstanceIdentifier = "string",
#'   AllocatedStorage = 123,
#'   DBInstanceClass = "string",
#'   Engine = "string",
#'   MasterUsername = "string",
#'   MasterUserPassword = "string",
#'   DBSecurityGroups = list(
#'     "string"
#'   ),
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   AvailabilityZone = "string",
#'   DBSubnetGroupName = "string",
#'   PreferredMaintenanceWindow = "string",
#'   DBParameterGroupName = "string",
#'   BackupRetentionPeriod = 123,
#'   PreferredBackupWindow = "string",
#'   Port = 123,
#'   MultiAZ = TRUE|FALSE,
#'   EngineVersion = "string",
#'   AutoMinorVersionUpgrade = TRUE|FALSE,
#'   LicenseModel = "string",
#'   Iops = 123,
#'   OptionGroupName = "string",
#'   CharacterSetName = "string",
#'   PubliclyAccessible = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   DBClusterIdentifier = "string",
#'   StorageType = "string",
#'   TdeCredentialArn = "string",
#'   TdeCredentialPassword = "string",
#'   StorageEncrypted = TRUE|FALSE,
#'   KmsKeyId = "string",
#'   Domain = "string",
#'   CopyTagsToSnapshot = TRUE|FALSE,
#'   MonitoringInterval = 123,
#'   MonitoringRoleArn = "string",
#'   DomainIAMRoleName = "string",
#'   PromotionTier = 123,
#'   Timezone = "string",
#'   EnableIAMDatabaseAuthentication = TRUE|FALSE,
#'   EnablePerformanceInsights = TRUE|FALSE,
#'   PerformanceInsightsKMSKeyId = "string",
#'   EnableCloudwatchLogsExports = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_create_db_instance
neptune_create_db_instance <- function(DBName = NULL, DBInstanceIdentifier, AllocatedStorage = NULL, DBInstanceClass, Engine, MasterUsername = NULL, MasterUserPassword = NULL, DBSecurityGroups = NULL, VpcSecurityGroupIds = NULL, AvailabilityZone = NULL, DBSubnetGroupName = NULL, PreferredMaintenanceWindow = NULL, DBParameterGroupName = NULL, BackupRetentionPeriod = NULL, PreferredBackupWindow = NULL, Port = NULL, MultiAZ = NULL, EngineVersion = NULL, AutoMinorVersionUpgrade = NULL, LicenseModel = NULL, Iops = NULL, OptionGroupName = NULL, CharacterSetName = NULL, PubliclyAccessible = NULL, Tags = NULL, DBClusterIdentifier = NULL, StorageType = NULL, TdeCredentialArn = NULL, TdeCredentialPassword = NULL, StorageEncrypted = NULL, KmsKeyId = NULL, Domain = NULL, CopyTagsToSnapshot = NULL, MonitoringInterval = NULL, MonitoringRoleArn = NULL, DomainIAMRoleName = NULL, PromotionTier = NULL, Timezone = NULL, EnableIAMDatabaseAuthentication = NULL, EnablePerformanceInsights = NULL, PerformanceInsightsKMSKeyId = NULL, EnableCloudwatchLogsExports = NULL) {
  op <- new_operation(
    name = "CreateDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$create_db_instance_input(DBName = DBName, DBInstanceIdentifier = DBInstanceIdentifier, AllocatedStorage = AllocatedStorage, DBInstanceClass = DBInstanceClass, Engine = Engine, MasterUsername = MasterUsername, MasterUserPassword = MasterUserPassword, DBSecurityGroups = DBSecurityGroups, VpcSecurityGroupIds = VpcSecurityGroupIds, AvailabilityZone = AvailabilityZone, DBSubnetGroupName = DBSubnetGroupName, PreferredMaintenanceWindow = PreferredMaintenanceWindow, DBParameterGroupName = DBParameterGroupName, BackupRetentionPeriod = BackupRetentionPeriod, PreferredBackupWindow = PreferredBackupWindow, Port = Port, MultiAZ = MultiAZ, EngineVersion = EngineVersion, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, LicenseModel = LicenseModel, Iops = Iops, OptionGroupName = OptionGroupName, CharacterSetName = CharacterSetName, PubliclyAccessible = PubliclyAccessible, Tags = Tags, DBClusterIdentifier = DBClusterIdentifier, StorageType = StorageType, TdeCredentialArn = TdeCredentialArn, TdeCredentialPassword = TdeCredentialPassword, StorageEncrypted = StorageEncrypted, KmsKeyId = KmsKeyId, Domain = Domain, CopyTagsToSnapshot = CopyTagsToSnapshot, MonitoringInterval = MonitoringInterval, MonitoringRoleArn = MonitoringRoleArn, DomainIAMRoleName = DomainIAMRoleName, PromotionTier = PromotionTier, Timezone = Timezone, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnablePerformanceInsights = EnablePerformanceInsights, PerformanceInsightsKMSKeyId = PerformanceInsightsKMSKeyId, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports)
  output <- .neptune$create_db_instance_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$create_db_instance <- neptune_create_db_instance

#' Creates a new DB parameter group
#'
#' Creates a new DB parameter group.
#' 
#' A DB parameter group is initially created with the default parameters
#' for the database engine used by the DB instance. To provide custom
#' values for any of the parameters, you must modify the group after
#' creating it using *ModifyDBParameterGroup*. Once you\'ve created a DB
#' parameter group, you need to associate it with your DB instance using
#' *ModifyDBInstance*. When you associate a new DB parameter group with a
#' running DB instance, you need to reboot the DB instance without failover
#' for the new DB parameter group and associated settings to take effect.
#' 
#' After you create a DB parameter group, you should wait at least 5
#' minutes before creating your first DB instance that uses that DB
#' parameter group as the default parameter group. This allows Amazon
#' Neptune to fully complete the create action before the parameter group
#' is used as the default for a new DB instance. This is especially
#' important for parameters that are critical when creating the default
#' database for a DB instance, such as the character set for the default
#' database defined by the `character_set_database` parameter. You can use
#' the *Parameter Groups* option of the Amazon Neptune console or the
#' *DescribeDBParameters* command to verify that your DB parameter group
#' has been created or modified.
#'
#' @usage
#' neptune_create_db_parameter_group(DBParameterGroupName,
#'   DBParameterGroupFamily, Description, Tags)
#'
#' @param DBParameterGroupName &#91;required&#93; The name of the DB parameter group.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' 
#' This value is stored as a lowercase string.
#' @param DBParameterGroupFamily &#91;required&#93; The DB parameter group family name. A DB parameter group can be
#' associated with one and only one DB parameter group family, and can be
#' applied only to a DB instance running a database engine and engine
#' version compatible with that DB parameter group family.
#' @param Description &#91;required&#93; The description for the DB parameter group.
#' @param Tags The tags to be assigned to the new DB parameter group.
#'
#' @section Request syntax:
#' ```
#' svc$create_db_parameter_group(
#'   DBParameterGroupName = "string",
#'   DBParameterGroupFamily = "string",
#'   Description = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_create_db_parameter_group
neptune_create_db_parameter_group <- function(DBParameterGroupName, DBParameterGroupFamily, Description, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$create_db_parameter_group_input(DBParameterGroupName = DBParameterGroupName, DBParameterGroupFamily = DBParameterGroupFamily, Description = Description, Tags = Tags)
  output <- .neptune$create_db_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$create_db_parameter_group <- neptune_create_db_parameter_group

#' Creates a new DB subnet group
#'
#' Creates a new DB subnet group. DB subnet groups must contain at least
#' one subnet in at least two AZs in the AWS Region.
#'
#' @usage
#' neptune_create_db_subnet_group(DBSubnetGroupName,
#'   DBSubnetGroupDescription, SubnetIds, Tags)
#'
#' @param DBSubnetGroupName &#91;required&#93; The name for the DB subnet group. This value is stored as a lowercase
#' string.
#' 
#' Constraints: Must contain no more than 255 letters, numbers, periods,
#' underscores, spaces, or hyphens. Must not be default.
#' 
#' Example: `mySubnetgroup`
#' @param DBSubnetGroupDescription &#91;required&#93; The description for the DB subnet group.
#' @param SubnetIds &#91;required&#93; The EC2 Subnet IDs for the DB subnet group.
#' @param Tags The tags to be assigned to the new DB subnet group.
#'
#' @section Request syntax:
#' ```
#' svc$create_db_subnet_group(
#'   DBSubnetGroupName = "string",
#'   DBSubnetGroupDescription = "string",
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_create_db_subnet_group
neptune_create_db_subnet_group <- function(DBSubnetGroupName, DBSubnetGroupDescription, SubnetIds, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$create_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName, DBSubnetGroupDescription = DBSubnetGroupDescription, SubnetIds = SubnetIds, Tags = Tags)
  output <- .neptune$create_db_subnet_group_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$create_db_subnet_group <- neptune_create_db_subnet_group

#' Creates an event notification subscription
#'
#' Creates an event notification subscription. This action requires a topic
#' ARN (Amazon Resource Name) created by either the Neptune console, the
#' SNS console, or the SNS API. To obtain an ARN with SNS, you must create
#' a topic in Amazon SNS and subscribe to the topic. The ARN is displayed
#' in the SNS console.
#' 
#' You can specify the type of source (SourceType) you want to be notified
#' of, provide a list of Neptune sources (SourceIds) that triggers the
#' events, and provide a list of event categories (EventCategories) for
#' events you want to be notified of. For example, you can specify
#' SourceType = db-instance, SourceIds = mydbinstance1, mydbinstance2 and
#' EventCategories = Availability, Backup.
#' 
#' If you specify both the SourceType and SourceIds, such as SourceType =
#' db-instance and SourceIdentifier = myDBInstance1, you are notified of
#' all the db-instance events for the specified source. If you specify a
#' SourceType but do not specify a SourceIdentifier, you receive notice of
#' the events for that source type for all your Neptune sources. If you do
#' not specify either the SourceType nor the SourceIdentifier, you are
#' notified of events generated from all Neptune sources belonging to your
#' customer account.
#'
#' @usage
#' neptune_create_event_subscription(SubscriptionName, SnsTopicArn,
#'   SourceType, EventCategories, SourceIds, Enabled, Tags)
#'
#' @param SubscriptionName &#91;required&#93; The name of the subscription.
#' 
#' Constraints: The name must be less than 255 characters.
#' @param SnsTopicArn &#91;required&#93; The Amazon Resource Name (ARN) of the SNS topic created for event
#' notification. The ARN is created by Amazon SNS when you create a topic
#' and subscribe to it.
#' @param SourceType The type of source that is generating the events. For example, if you
#' want to be notified of events generated by a DB instance, you would set
#' this parameter to db-instance. if this value is not specified, all
#' events are returned.
#' 
#' Valid values: `db-instance` \\| `db-cluster` \\| `db-parameter-group` \\|
#' `db-security-group` \\| `db-snapshot` \\| `db-cluster-snapshot`
#' @param EventCategories A list of event categories for a SourceType that you want to subscribe
#' to. You can see a list of the categories for a given SourceType by using
#' the **DescribeEventCategories** action.
#' @param SourceIds The list of identifiers of the event sources for which events are
#' returned. If not specified, then all sources are included in the
#' response. An identifier must begin with a letter and must contain only
#' ASCII letters, digits, and hyphens; it can\'t end with a hyphen or
#' contain two consecutive hyphens.
#' 
#' Constraints:
#' 
#' -   If SourceIds are supplied, SourceType must also be provided.
#' 
#' -   If the source type is a DB instance, then a `DBInstanceIdentifier`
#'     must be supplied.
#' 
#' -   If the source type is a DB security group, a `DBSecurityGroupName`
#'     must be supplied.
#' 
#' -   If the source type is a DB parameter group, a `DBParameterGroupName`
#'     must be supplied.
#' 
#' -   If the source type is a DB snapshot, a `DBSnapshotIdentifier` must
#'     be supplied.
#' @param Enabled A Boolean value; set to **true** to activate the subscription, set to
#' **false** to create the subscription but not active it.
#' @param Tags The tags to be applied to the new event subscription.
#'
#' @section Request syntax:
#' ```
#' svc$create_event_subscription(
#'   SubscriptionName = "string",
#'   SnsTopicArn = "string",
#'   SourceType = "string",
#'   EventCategories = list(
#'     "string"
#'   ),
#'   SourceIds = list(
#'     "string"
#'   ),
#'   Enabled = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_create_event_subscription
neptune_create_event_subscription <- function(SubscriptionName, SnsTopicArn, SourceType = NULL, EventCategories = NULL, SourceIds = NULL, Enabled = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateEventSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$create_event_subscription_input(SubscriptionName = SubscriptionName, SnsTopicArn = SnsTopicArn, SourceType = SourceType, EventCategories = EventCategories, SourceIds = SourceIds, Enabled = Enabled, Tags = Tags)
  output <- .neptune$create_event_subscription_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$create_event_subscription <- neptune_create_event_subscription

#' The DeleteDBCluster action deletes a previously provisioned DB cluster
#'
#' The DeleteDBCluster action deletes a previously provisioned DB cluster.
#' When you delete a DB cluster, all automated backups for that DB cluster
#' are deleted and can\'t be recovered. Manual DB cluster snapshots of the
#' specified DB cluster are not deleted.
#'
#' @usage
#' neptune_delete_db_cluster(DBClusterIdentifier, SkipFinalSnapshot,
#'   FinalDBSnapshotIdentifier)
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier for the DB cluster to be deleted. This
#' parameter isn\'t case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match an existing DBClusterIdentifier.
#' @param SkipFinalSnapshot Determines whether a final DB cluster snapshot is created before the DB
#' cluster is deleted. If `true` is specified, no DB cluster snapshot is
#' created. If `false` is specified, a DB cluster snapshot is created
#' before the DB cluster is deleted.
#' 
#' You must specify a `FinalDBSnapshotIdentifier` parameter if
#' `SkipFinalSnapshot` is `false`.
#' 
#' Default: `false`
#' @param FinalDBSnapshotIdentifier The DB cluster snapshot identifier of the new DB cluster snapshot
#' created when `SkipFinalSnapshot` is set to `false`.
#' 
#' Specifying this parameter and also setting the `SkipFinalShapshot`
#' parameter to true results in an error.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_cluster(
#'   DBClusterIdentifier = "string",
#'   SkipFinalSnapshot = TRUE|FALSE,
#'   FinalDBSnapshotIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_delete_db_cluster
neptune_delete_db_cluster <- function(DBClusterIdentifier, SkipFinalSnapshot = NULL, FinalDBSnapshotIdentifier = NULL) {
  op <- new_operation(
    name = "DeleteDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$delete_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, SkipFinalSnapshot = SkipFinalSnapshot, FinalDBSnapshotIdentifier = FinalDBSnapshotIdentifier)
  output <- .neptune$delete_db_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$delete_db_cluster <- neptune_delete_db_cluster

#' Deletes a specified DB cluster parameter group
#'
#' Deletes a specified DB cluster parameter group. The DB cluster parameter
#' group to be deleted can\'t be associated with any DB clusters.
#'
#' @usage
#' neptune_delete_db_cluster_parameter_group(DBClusterParameterGroupName)
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Must be the name of an existing DB cluster parameter group.
#' 
#' -   You can\'t delete a default DB cluster parameter group.
#' 
#' -   Cannot be associated with any DB clusters.
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_cluster_parameter_group(
#'   DBClusterParameterGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_delete_db_cluster_parameter_group
neptune_delete_db_cluster_parameter_group <- function(DBClusterParameterGroupName) {
  op <- new_operation(
    name = "DeleteDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$delete_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName)
  output <- .neptune$delete_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$delete_db_cluster_parameter_group <- neptune_delete_db_cluster_parameter_group

#' Deletes a DB cluster snapshot
#'
#' Deletes a DB cluster snapshot. If the snapshot is being copied, the copy
#' operation is terminated.
#' 
#' The DB cluster snapshot must be in the `available` state to be deleted.
#'
#' @usage
#' neptune_delete_db_cluster_snapshot(DBClusterSnapshotIdentifier)
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier of the DB cluster snapshot to delete.
#' 
#' Constraints: Must be the name of an existing DB cluster snapshot in the
#' `available` state.
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_cluster_snapshot(
#'   DBClusterSnapshotIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_delete_db_cluster_snapshot
neptune_delete_db_cluster_snapshot <- function(DBClusterSnapshotIdentifier) {
  op <- new_operation(
    name = "DeleteDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$delete_db_cluster_snapshot_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier)
  output <- .neptune$delete_db_cluster_snapshot_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$delete_db_cluster_snapshot <- neptune_delete_db_cluster_snapshot

#' The DeleteDBInstance action deletes a previously provisioned DB instance
#'
#' The DeleteDBInstance action deletes a previously provisioned DB
#' instance. When you delete a DB instance, all automated backups for that
#' instance are deleted and can\'t be recovered. Manual DB snapshots of the
#' DB instance to be deleted by `DeleteDBInstance` are not deleted.
#' 
#' If you request a final DB snapshot the status of the Amazon Neptune DB
#' instance is `deleting` until the DB snapshot is created. The API action
#' `DescribeDBInstance` is used to monitor the status of this operation.
#' The action can\'t be canceled or reverted once submitted.
#' 
#' Note that when a DB instance is in a failure state and has a status of
#' `failed`, `incompatible-restore`, or `incompatible-network`, you can
#' only delete it when the `SkipFinalSnapshot` parameter is set to `true`.
#' 
#' You can\'t delete a DB instance if it is the only instance in the DB
#' cluster.
#'
#' @usage
#' neptune_delete_db_instance(DBInstanceIdentifier, SkipFinalSnapshot,
#'   FinalDBSnapshotIdentifier)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier for the DB instance to be deleted. This
#' parameter isn\'t case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the name of an existing DB instance.
#' @param SkipFinalSnapshot Determines whether a final DB snapshot is created before the DB instance
#' is deleted. If `true` is specified, no DBSnapshot is created. If `false`
#' is specified, a DB snapshot is created before the DB instance is
#' deleted.
#' 
#' Note that when a DB instance is in a failure state and has a status of
#' \'failed\', \'incompatible-restore\', or \'incompatible-network\', it
#' can only be deleted when the SkipFinalSnapshot parameter is set to
#' \"true\".
#' 
#' Specify `true` when deleting a Read Replica.
#' 
#' The FinalDBSnapshotIdentifier parameter must be specified if
#' SkipFinalSnapshot is `false`.
#' 
#' Default: `false`
#' @param FinalDBSnapshotIdentifier The DBSnapshotIdentifier of the new DBSnapshot created when
#' SkipFinalSnapshot is set to `false`.
#' 
#' Specifying this parameter and also setting the SkipFinalShapshot
#' parameter to true results in an error.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters or numbers.
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' 
#' -   Cannot be specified when deleting a Read Replica.
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_instance(
#'   DBInstanceIdentifier = "string",
#'   SkipFinalSnapshot = TRUE|FALSE,
#'   FinalDBSnapshotIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_delete_db_instance
neptune_delete_db_instance <- function(DBInstanceIdentifier, SkipFinalSnapshot = NULL, FinalDBSnapshotIdentifier = NULL) {
  op <- new_operation(
    name = "DeleteDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$delete_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, SkipFinalSnapshot = SkipFinalSnapshot, FinalDBSnapshotIdentifier = FinalDBSnapshotIdentifier)
  output <- .neptune$delete_db_instance_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$delete_db_instance <- neptune_delete_db_instance

#' Deletes a specified DBParameterGroup
#'
#' Deletes a specified DBParameterGroup. The DBParameterGroup to be deleted
#' can\'t be associated with any DB instances.
#'
#' @usage
#' neptune_delete_db_parameter_group(DBParameterGroupName)
#'
#' @param DBParameterGroupName &#91;required&#93; The name of the DB parameter group.
#' 
#' Constraints:
#' 
#' -   Must be the name of an existing DB parameter group
#' 
#' -   You can\'t delete a default DB parameter group
#' 
#' -   Cannot be associated with any DB instances
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_parameter_group(
#'   DBParameterGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_delete_db_parameter_group
neptune_delete_db_parameter_group <- function(DBParameterGroupName) {
  op <- new_operation(
    name = "DeleteDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$delete_db_parameter_group_input(DBParameterGroupName = DBParameterGroupName)
  output <- .neptune$delete_db_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$delete_db_parameter_group <- neptune_delete_db_parameter_group

#' Deletes a DB subnet group
#'
#' Deletes a DB subnet group.
#' 
#' The specified database subnet group must not be associated with any DB
#' instances.
#'
#' @usage
#' neptune_delete_db_subnet_group(DBSubnetGroupName)
#'
#' @param DBSubnetGroupName &#91;required&#93; The name of the database subnet group to delete.
#' 
#' You can\'t delete the default subnet group.
#' 
#' Constraints:
#' 
#' Constraints: Must match the name of an existing DBSubnetGroup. Must not
#' be default.
#' 
#' Example: `mySubnetgroup`
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_subnet_group(
#'   DBSubnetGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_delete_db_subnet_group
neptune_delete_db_subnet_group <- function(DBSubnetGroupName) {
  op <- new_operation(
    name = "DeleteDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$delete_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName)
  output <- .neptune$delete_db_subnet_group_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$delete_db_subnet_group <- neptune_delete_db_subnet_group

#' Deletes an event notification subscription
#'
#' Deletes an event notification subscription.
#'
#' @usage
#' neptune_delete_event_subscription(SubscriptionName)
#'
#' @param SubscriptionName &#91;required&#93; The name of the event notification subscription you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_event_subscription(
#'   SubscriptionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_delete_event_subscription
neptune_delete_event_subscription <- function(SubscriptionName) {
  op <- new_operation(
    name = "DeleteEventSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$delete_event_subscription_input(SubscriptionName = SubscriptionName)
  output <- .neptune$delete_event_subscription_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$delete_event_subscription <- neptune_delete_event_subscription

#' Returns a list of DBClusterParameterGroup descriptions
#'
#' Returns a list of `DBClusterParameterGroup` descriptions. If a
#' `DBClusterParameterGroupName` parameter is specified, the list will
#' contain only the description of the specified DB cluster parameter
#' group.
#'
#' @usage
#' neptune_describe_db_cluster_parameter_groups(
#'   DBClusterParameterGroupName, Filters, MaxRecords, Marker)
#'
#' @param DBClusterParameterGroupName The name of a specific DB cluster parameter group to return details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeDBClusterParameterGroups` request. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_cluster_parameter_groups(
#'   DBClusterParameterGroupName = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_cluster_parameter_groups
neptune_describe_db_cluster_parameter_groups <- function(DBClusterParameterGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterParameterGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_db_cluster_parameter_groups_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_db_cluster_parameter_groups_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_cluster_parameter_groups <- neptune_describe_db_cluster_parameter_groups

#' Returns the detailed parameter list for a particular DB cluster
#' parameter group
#'
#' Returns the detailed parameter list for a particular DB cluster
#' parameter group.
#'
#' @usage
#' neptune_describe_db_cluster_parameters(DBClusterParameterGroupName,
#'   Source, Filters, MaxRecords, Marker)
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of a specific DB cluster parameter group to return parameter
#' details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param Source A value that indicates to return only parameters for a specific source.
#' Parameter sources can be `engine`, `service`, or `customer`.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeDBClusterParameters` request. If this parameter is specified,
#' the response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_cluster_parameters(
#'   DBClusterParameterGroupName = "string",
#'   Source = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_cluster_parameters
neptune_describe_db_cluster_parameters <- function(DBClusterParameterGroupName, Source = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_db_cluster_parameters_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Source = Source, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_db_cluster_parameters_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_cluster_parameters <- neptune_describe_db_cluster_parameters

#' Returns a list of DB cluster snapshot attribute names and values for a
#' manual DB cluster snapshot
#'
#' Returns a list of DB cluster snapshot attribute names and values for a
#' manual DB cluster snapshot.
#' 
#' When sharing snapshots with other AWS accounts,
#' `DescribeDBClusterSnapshotAttributes` returns the `restore` attribute
#' and a list of IDs for the AWS accounts that are authorized to copy or
#' restore the manual DB cluster snapshot. If `all` is included in the list
#' of values for the `restore` attribute, then the manual DB cluster
#' snapshot is public and can be copied or restored by all AWS accounts.
#' 
#' To add or remove access for an AWS account to copy or restore a manual
#' DB cluster snapshot, or to make the manual DB cluster snapshot public or
#' private, use the ModifyDBClusterSnapshotAttribute API action.
#'
#' @usage
#' neptune_describe_db_cluster_snapshot_attributes(
#'   DBClusterSnapshotIdentifier)
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier for the DB cluster snapshot to describe the attributes
#' for.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_cluster_snapshot_attributes(
#'   DBClusterSnapshotIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_cluster_snapshot_attributes
neptune_describe_db_cluster_snapshot_attributes <- function(DBClusterSnapshotIdentifier) {
  op <- new_operation(
    name = "DescribeDBClusterSnapshotAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_db_cluster_snapshot_attributes_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier)
  output <- .neptune$describe_db_cluster_snapshot_attributes_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_cluster_snapshot_attributes <- neptune_describe_db_cluster_snapshot_attributes

#' Returns information about DB cluster snapshots
#'
#' Returns information about DB cluster snapshots. This API action supports
#' pagination.
#'
#' @usage
#' neptune_describe_db_cluster_snapshots(DBClusterIdentifier,
#'   DBClusterSnapshotIdentifier, SnapshotType, Filters, MaxRecords, Marker,
#'   IncludeShared, IncludePublic)
#'
#' @param DBClusterIdentifier The ID of the DB cluster to retrieve the list of DB cluster snapshots
#' for. This parameter can\'t be used in conjunction with the
#' `DBClusterSnapshotIdentifier` parameter. This parameter is not
#' case-sensitive.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the identifier of an existing DBCluster.
#' @param DBClusterSnapshotIdentifier A specific DB cluster snapshot identifier to describe. This parameter
#' can\'t be used in conjunction with the `DBClusterIdentifier` parameter.
#' This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the identifier of an existing
#'     DBClusterSnapshot.
#' 
#' -   If this identifier is for an automated snapshot, the `SnapshotType`
#'     parameter must also be specified.
#' @param SnapshotType The type of DB cluster snapshots to be returned. You can specify one of
#' the following values:
#' 
#' -   `automated` - Return all DB cluster snapshots that have been
#'     automatically taken by Amazon Neptune for my AWS account.
#' 
#' -   `manual` - Return all DB cluster snapshots that have been taken by
#'     my AWS account.
#' 
#' -   `shared` - Return all manual DB cluster snapshots that have been
#'     shared to my AWS account.
#' 
#' -   `public` - Return all DB cluster snapshots that have been marked as
#'     public.
#' 
#' If you don\'t specify a `SnapshotType` value, then both automated and
#' manual DB cluster snapshots are returned. You can include shared DB
#' cluster snapshots with these results by setting the `IncludeShared`
#' parameter to `true`. You can include public DB cluster snapshots with
#' these results by setting the `IncludePublic` parameter to `true`.
#' 
#' The `IncludeShared` and `IncludePublic` parameters don\'t apply for
#' `SnapshotType` values of `manual` or `automated`. The `IncludePublic`
#' parameter doesn\'t apply when `SnapshotType` is set to `shared`. The
#' `IncludeShared` parameter doesn\'t apply when `SnapshotType` is set to
#' `public`.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeDBClusterSnapshots` request. If this parameter is specified,
#' the response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#' @param IncludeShared True to include shared manual DB cluster snapshots from other AWS
#' accounts that this AWS account has been given permission to copy or
#' restore, and otherwise false. The default is `false`.
#' 
#' You can give an AWS account permission to restore a manual DB cluster
#' snapshot from another AWS account by the
#' ModifyDBClusterSnapshotAttribute API action.
#' @param IncludePublic True to include manual DB cluster snapshots that are public and can be
#' copied or restored by any AWS account, and otherwise false. The default
#' is `false`. The default is false.
#' 
#' You can share a manual DB cluster snapshot as public by using the
#' ModifyDBClusterSnapshotAttribute API action.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_cluster_snapshots(
#'   DBClusterIdentifier = "string",
#'   DBClusterSnapshotIdentifier = "string",
#'   SnapshotType = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string",
#'   IncludeShared = TRUE|FALSE,
#'   IncludePublic = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_cluster_snapshots
neptune_describe_db_cluster_snapshots <- function(DBClusterIdentifier = NULL, DBClusterSnapshotIdentifier = NULL, SnapshotType = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL, IncludeShared = NULL, IncludePublic = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_db_cluster_snapshots_input(DBClusterIdentifier = DBClusterIdentifier, DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, SnapshotType = SnapshotType, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker, IncludeShared = IncludeShared, IncludePublic = IncludePublic)
  output <- .neptune$describe_db_cluster_snapshots_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_cluster_snapshots <- neptune_describe_db_cluster_snapshots

#' Returns information about provisioned DB clusters
#'
#' Returns information about provisioned DB clusters. This API supports
#' pagination.
#'
#' @usage
#' neptune_describe_db_clusters(DBClusterIdentifier, Filters, MaxRecords,
#'   Marker)
#'
#' @param DBClusterIdentifier The user-supplied DB cluster identifier. If this parameter is specified,
#' information from only the specific DB cluster is returned. This
#' parameter isn\'t case-sensitive.
#' 
#' Constraints:
#' 
#' -   If supplied, must match an existing DBClusterIdentifier.
#' @param Filters A filter that specifies one or more DB clusters to describe.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
#'     Amazon Resource Names (ARNs). The results list will only include
#'     information about the DB clusters identified by these ARNs.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous DescribeDBClusters
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_clusters(
#'   DBClusterIdentifier = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_clusters
neptune_describe_db_clusters <- function(DBClusterIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_db_clusters_input(DBClusterIdentifier = DBClusterIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_db_clusters_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_clusters <- neptune_describe_db_clusters

#' Returns a list of the available DB engines
#'
#' Returns a list of the available DB engines.
#'
#' @usage
#' neptune_describe_db_engine_versions(Engine, EngineVersion,
#'   DBParameterGroupFamily, Filters, MaxRecords, Marker, DefaultOnly,
#'   ListSupportedCharacterSets, ListSupportedTimezones)
#'
#' @param Engine The database engine to return.
#' @param EngineVersion The database engine version to return.
#' 
#' Example: `5.1.49`
#' @param DBParameterGroupFamily The name of a specific DB parameter group family to return details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match an existing DBParameterGroupFamily.
#' @param Filters Not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more than
#' the `MaxRecords` value is available, a pagination token called a marker
#' is included in the response so that the following results can be
#' retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#' @param DefaultOnly Indicates that only the default version of the specified engine or
#' engine and major version combination is returned.
#' @param ListSupportedCharacterSets If this parameter is specified and the requested engine supports the
#' `CharacterSetName` parameter for `CreateDBInstance`, the response
#' includes a list of supported character sets for each engine version.
#' @param ListSupportedTimezones If this parameter is specified and the requested engine supports the
#' `TimeZone` parameter for `CreateDBInstance`, the response includes a
#' list of supported time zones for each engine version.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_engine_versions(
#'   Engine = "string",
#'   EngineVersion = "string",
#'   DBParameterGroupFamily = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string",
#'   DefaultOnly = TRUE|FALSE,
#'   ListSupportedCharacterSets = TRUE|FALSE,
#'   ListSupportedTimezones = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_engine_versions
neptune_describe_db_engine_versions <- function(Engine = NULL, EngineVersion = NULL, DBParameterGroupFamily = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL, DefaultOnly = NULL, ListSupportedCharacterSets = NULL, ListSupportedTimezones = NULL) {
  op <- new_operation(
    name = "DescribeDBEngineVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_db_engine_versions_input(Engine = Engine, EngineVersion = EngineVersion, DBParameterGroupFamily = DBParameterGroupFamily, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker, DefaultOnly = DefaultOnly, ListSupportedCharacterSets = ListSupportedCharacterSets, ListSupportedTimezones = ListSupportedTimezones)
  output <- .neptune$describe_db_engine_versions_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_engine_versions <- neptune_describe_db_engine_versions

#' Returns information about provisioned instances
#'
#' Returns information about provisioned instances. This API supports
#' pagination.
#'
#' @usage
#' neptune_describe_db_instances(DBInstanceIdentifier, Filters, MaxRecords,
#'   Marker)
#'
#' @param DBInstanceIdentifier The user-supplied instance identifier. If this parameter is specified,
#' information from only the specific DB instance is returned. This
#' parameter isn\'t case-sensitive.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the identifier of an existing DBInstance.
#' @param Filters A filter that specifies one or more DB instances to describe.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
#'     Amazon Resource Names (ARNs). The results list will only include
#'     information about the DB instances associated with the DB clusters
#'     identified by these ARNs.
#' 
#' -   `db-instance-id` - Accepts DB instance identifiers and DB instance
#'     Amazon Resource Names (ARNs). The results list will only include
#'     information about the DB instances identified by these ARNs.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeDBInstances` request. If this parameter is specified, the
#' response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_instances(
#'   DBInstanceIdentifier = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_instances
neptune_describe_db_instances <- function(DBInstanceIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_db_instances_input(DBInstanceIdentifier = DBInstanceIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_db_instances_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_instances <- neptune_describe_db_instances

#' Returns a list of DBParameterGroup descriptions
#'
#' Returns a list of `DBParameterGroup` descriptions. If a
#' `DBParameterGroupName` is specified, the list will contain only the
#' description of the specified DB parameter group.
#'
#' @usage
#' neptune_describe_db_parameter_groups(DBParameterGroupName, Filters,
#'   MaxRecords, Marker)
#'
#' @param DBParameterGroupName The name of a specific DB parameter group to return details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeDBParameterGroups` request. If this parameter is specified, the
#' response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_parameter_groups(
#'   DBParameterGroupName = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_parameter_groups
neptune_describe_db_parameter_groups <- function(DBParameterGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBParameterGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_db_parameter_groups_input(DBParameterGroupName = DBParameterGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_db_parameter_groups_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_parameter_groups <- neptune_describe_db_parameter_groups

#' Returns the detailed parameter list for a particular DB parameter group
#'
#' Returns the detailed parameter list for a particular DB parameter group.
#'
#' @usage
#' neptune_describe_db_parameters(DBParameterGroupName, Source, Filters,
#'   MaxRecords, Marker)
#'
#' @param DBParameterGroupName &#91;required&#93; The name of a specific DB parameter group to return details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing DBParameterGroup.
#' @param Source The parameter types to return.
#' 
#' Default: All parameter types returned
#' 
#' Valid Values: `user | system | engine-default`
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeDBParameters` request. If this parameter is specified, the
#' response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_parameters(
#'   DBParameterGroupName = "string",
#'   Source = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_parameters
neptune_describe_db_parameters <- function(DBParameterGroupName, Source = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_db_parameters_input(DBParameterGroupName = DBParameterGroupName, Source = Source, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_db_parameters_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_parameters <- neptune_describe_db_parameters

#' Returns a list of DBSubnetGroup descriptions
#'
#' Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is
#' specified, the list will contain only the descriptions of the specified
#' DBSubnetGroup.
#' 
#' For an overview of CIDR ranges, go to the [Wikipedia
#' Tutorial](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
#'
#' @usage
#' neptune_describe_db_subnet_groups(DBSubnetGroupName, Filters,
#'   MaxRecords, Marker)
#'
#' @param DBSubnetGroupName The name of the DB subnet group to return details for.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' DescribeDBSubnetGroups request. If this parameter is specified, the
#' response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_subnet_groups(
#'   DBSubnetGroupName = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_subnet_groups
neptune_describe_db_subnet_groups <- function(DBSubnetGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBSubnetGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_db_subnet_groups_input(DBSubnetGroupName = DBSubnetGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_db_subnet_groups_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_subnet_groups <- neptune_describe_db_subnet_groups

#' Returns the default engine and system parameter information for the
#' cluster database engine
#'
#' Returns the default engine and system parameter information for the
#' cluster database engine.
#'
#' @usage
#' neptune_describe_engine_default_cluster_parameters(
#'   DBParameterGroupFamily, Filters, MaxRecords, Marker)
#'
#' @param DBParameterGroupFamily &#91;required&#93; The name of the DB cluster parameter group family to return engine
#' parameter information for.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeEngineDefaultClusterParameters` request. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_engine_default_cluster_parameters(
#'   DBParameterGroupFamily = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_engine_default_cluster_parameters
neptune_describe_engine_default_cluster_parameters <- function(DBParameterGroupFamily, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEngineDefaultClusterParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_engine_default_cluster_parameters_input(DBParameterGroupFamily = DBParameterGroupFamily, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_engine_default_cluster_parameters_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_engine_default_cluster_parameters <- neptune_describe_engine_default_cluster_parameters

#' Returns the default engine and system parameter information for the
#' specified database engine
#'
#' Returns the default engine and system parameter information for the
#' specified database engine.
#'
#' @usage
#' neptune_describe_engine_default_parameters(DBParameterGroupFamily,
#'   Filters, MaxRecords, Marker)
#'
#' @param DBParameterGroupFamily &#91;required&#93; The name of the DB parameter group family.
#' @param Filters Not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeEngineDefaultParameters` request. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_engine_default_parameters(
#'   DBParameterGroupFamily = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_engine_default_parameters
neptune_describe_engine_default_parameters <- function(DBParameterGroupFamily, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEngineDefaultParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_engine_default_parameters_input(DBParameterGroupFamily = DBParameterGroupFamily, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_engine_default_parameters_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_engine_default_parameters <- neptune_describe_engine_default_parameters

#' Displays a list of categories for all event source types, or, if
#' specified, for a specified source type
#'
#' Displays a list of categories for all event source types, or, if
#' specified, for a specified source type.
#'
#' @usage
#' neptune_describe_event_categories(SourceType, Filters)
#'
#' @param SourceType The type of source that is generating the events.
#' 
#' Valid values: db-instance \\| db-parameter-group \\| db-security-group \\|
#' db-snapshot
#' @param Filters This parameter is not currently supported.
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_categories(
#'   SourceType = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_event_categories
neptune_describe_event_categories <- function(SourceType = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeEventCategories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_event_categories_input(SourceType = SourceType, Filters = Filters)
  output <- .neptune$describe_event_categories_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_event_categories <- neptune_describe_event_categories

#' Lists all the subscription descriptions for a customer account
#'
#' Lists all the subscription descriptions for a customer account. The
#' description for a subscription includes SubscriptionName, SNSTopicARN,
#' CustomerID, SourceType, SourceID, CreationTime, and Status.
#' 
#' If you specify a SubscriptionName, lists the description for that
#' subscription.
#'
#' @usage
#' neptune_describe_event_subscriptions(SubscriptionName, Filters,
#'   MaxRecords, Marker)
#'
#' @param SubscriptionName The name of the event notification subscription you want to describe.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' DescribeOrderableDBInstanceOptions request. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords` .
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_subscriptions(
#'   SubscriptionName = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_event_subscriptions
neptune_describe_event_subscriptions <- function(SubscriptionName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEventSubscriptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_event_subscriptions_input(SubscriptionName = SubscriptionName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_event_subscriptions_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_event_subscriptions <- neptune_describe_event_subscriptions

#' Returns events related to DB instances, DB security groups, DB
#' snapshots, and DB parameter groups for the past 14 days
#'
#' Returns events related to DB instances, DB security groups, DB
#' snapshots, and DB parameter groups for the past 14 days. Events specific
#' to a particular DB instance, DB security group, database snapshot, or DB
#' parameter group can be obtained by providing the name as a parameter. By
#' default, the past hour of events are returned.
#'
#' @usage
#' neptune_describe_events(SourceIdentifier, SourceType, StartTime,
#'   EndTime, Duration, EventCategories, Filters, MaxRecords, Marker)
#'
#' @param SourceIdentifier The identifier of the event source for which events are returned. If not
#' specified, then all sources are included in the response.
#' 
#' Constraints:
#' 
#' -   If SourceIdentifier is supplied, SourceType must also be provided.
#' 
#' -   If the source type is `DBInstance`, then a `DBInstanceIdentifier`
#'     must be supplied.
#' 
#' -   If the source type is `DBSecurityGroup`, a `DBSecurityGroupName`
#'     must be supplied.
#' 
#' -   If the source type is `DBParameterGroup`, a `DBParameterGroupName`
#'     must be supplied.
#' 
#' -   If the source type is `DBSnapshot`, a `DBSnapshotIdentifier` must be
#'     supplied.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' @param SourceType The event source to retrieve events for. If no value is specified, all
#' events are returned.
#' @param StartTime The beginning of the time interval to retrieve events for, specified in
#' ISO 8601 format. For more information about ISO 8601, go to the [ISO8601
#' Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
#' 
#' Example: 2009-07-08T18:00Z
#' @param EndTime The end of the time interval for which to retrieve events, specified in
#' ISO 8601 format. For more information about ISO 8601, go to the [ISO8601
#' Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
#' 
#' Example: 2009-07-08T18:00Z
#' @param Duration The number of minutes to retrieve events for.
#' 
#' Default: 60
#' @param EventCategories A list of event categories that trigger notifications for a event
#' notification subscription.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous DescribeEvents
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_events(
#'   SourceIdentifier = "string",
#'   SourceType = "db-instance"|"db-parameter-group"|"db-security-group"|"db-snapshot"|"db-cluster"|"db-cluster-snapshot",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Duration = 123,
#'   EventCategories = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_events
neptune_describe_events <- function(SourceIdentifier = NULL, SourceType = NULL, StartTime = NULL, EndTime = NULL, Duration = NULL, EventCategories = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_events_input(SourceIdentifier = SourceIdentifier, SourceType = SourceType, StartTime = StartTime, EndTime = EndTime, Duration = Duration, EventCategories = EventCategories, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_events_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_events <- neptune_describe_events

#' Returns a list of orderable DB instance options for the specified engine
#'
#' Returns a list of orderable DB instance options for the specified
#' engine.
#'
#' @usage
#' neptune_describe_orderable_db_instance_options(Engine, EngineVersion,
#'   DBInstanceClass, LicenseModel, Vpc, Filters, MaxRecords, Marker)
#'
#' @param Engine &#91;required&#93; The name of the engine to retrieve DB instance options for.
#' @param EngineVersion The engine version filter value. Specify this parameter to show only the
#' available offerings matching the specified engine version.
#' @param DBInstanceClass The DB instance class filter value. Specify this parameter to show only
#' the available offerings matching the specified DB instance class.
#' @param LicenseModel The license model filter value. Specify this parameter to show only the
#' available offerings matching the specified license model.
#' @param Vpc The VPC filter value. Specify this parameter to show only the available
#' VPC or non-VPC offerings.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' DescribeOrderableDBInstanceOptions request. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords` .
#'
#' @section Request syntax:
#' ```
#' svc$describe_orderable_db_instance_options(
#'   Engine = "string",
#'   EngineVersion = "string",
#'   DBInstanceClass = "string",
#'   LicenseModel = "string",
#'   Vpc = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_orderable_db_instance_options
neptune_describe_orderable_db_instance_options <- function(Engine, EngineVersion = NULL, DBInstanceClass = NULL, LicenseModel = NULL, Vpc = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeOrderableDBInstanceOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_orderable_db_instance_options_input(Engine = Engine, EngineVersion = EngineVersion, DBInstanceClass = DBInstanceClass, LicenseModel = LicenseModel, Vpc = Vpc, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_orderable_db_instance_options_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_orderable_db_instance_options <- neptune_describe_orderable_db_instance_options

#' Returns a list of resources (for example, DB instances) that have at
#' least one pending maintenance action
#'
#' Returns a list of resources (for example, DB instances) that have at
#' least one pending maintenance action.
#'
#' @usage
#' neptune_describe_pending_maintenance_actions(ResourceIdentifier,
#'   Filters, Marker, MaxRecords)
#'
#' @param ResourceIdentifier The ARN of a resource to return pending maintenance actions for.
#' @param Filters A filter that specifies one or more resources to return pending
#' maintenance actions for.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
#'     Amazon Resource Names (ARNs). The results list will only include
#'     pending maintenance actions for the DB clusters identified by these
#'     ARNs.
#' 
#' -   `db-instance-id` - Accepts DB instance identifiers and DB instance
#'     ARNs. The results list will only include pending maintenance actions
#'     for the DB instances identified by these ARNs.
#' @param Marker An optional pagination token provided by a previous
#' `DescribePendingMaintenanceActions` request. If this parameter is
#' specified, the response includes only records beyond the marker, up to a
#' number of records specified by `MaxRecords`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#'
#' @section Request syntax:
#' ```
#' svc$describe_pending_maintenance_actions(
#'   ResourceIdentifier = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   Marker = "string",
#'   MaxRecords = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_pending_maintenance_actions
neptune_describe_pending_maintenance_actions <- function(ResourceIdentifier = NULL, Filters = NULL, Marker = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribePendingMaintenanceActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_pending_maintenance_actions_input(ResourceIdentifier = ResourceIdentifier, Filters = Filters, Marker = Marker, MaxRecords = MaxRecords)
  output <- .neptune$describe_pending_maintenance_actions_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_pending_maintenance_actions <- neptune_describe_pending_maintenance_actions

#' You can call DescribeValidDBInstanceModifications to learn what
#' modifications you can make to your DB instance
#'
#' You can call DescribeValidDBInstanceModifications to learn what
#' modifications you can make to your DB instance. You can use this
#' information when you call ModifyDBInstance.
#'
#' @usage
#' neptune_describe_valid_db_instance_modifications(DBInstanceIdentifier)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The customer identifier or the ARN of your DB instance.
#'
#' @section Request syntax:
#' ```
#' svc$describe_valid_db_instance_modifications(
#'   DBInstanceIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_describe_valid_db_instance_modifications
neptune_describe_valid_db_instance_modifications <- function(DBInstanceIdentifier) {
  op <- new_operation(
    name = "DescribeValidDBInstanceModifications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$describe_valid_db_instance_modifications_input(DBInstanceIdentifier = DBInstanceIdentifier)
  output <- .neptune$describe_valid_db_instance_modifications_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_valid_db_instance_modifications <- neptune_describe_valid_db_instance_modifications

#' Forces a failover for a DB cluster
#'
#' Forces a failover for a DB cluster.
#' 
#' A failover for a DB cluster promotes one of the Read Replicas (read-only
#' instances) in the DB cluster to be the primary instance (the cluster
#' writer).
#' 
#' Amazon Neptune will automatically fail over to a Read Replica, if one
#' exists, when the primary instance fails. You can force a failover when
#' you want to simulate a failure of a primary instance for testing.
#' Because each instance in a DB cluster has its own endpoint address, you
#' will need to clean up and re-establish any existing connections that use
#' those endpoint addresses when the failover is complete.
#'
#' @usage
#' neptune_failover_db_cluster(DBClusterIdentifier,
#'   TargetDBInstanceIdentifier)
#'
#' @param DBClusterIdentifier A DB cluster identifier to force a failover for. This parameter is not
#' case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBCluster.
#' @param TargetDBInstanceIdentifier The name of the instance to promote to the primary instance.
#' 
#' You must specify the instance identifier for an Read Replica in the DB
#' cluster. For example, `mydbcluster-replica1`.
#'
#' @section Request syntax:
#' ```
#' svc$failover_db_cluster(
#'   DBClusterIdentifier = "string",
#'   TargetDBInstanceIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_failover_db_cluster
neptune_failover_db_cluster <- function(DBClusterIdentifier = NULL, TargetDBInstanceIdentifier = NULL) {
  op <- new_operation(
    name = "FailoverDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$failover_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, TargetDBInstanceIdentifier = TargetDBInstanceIdentifier)
  output <- .neptune$failover_db_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$failover_db_cluster <- neptune_failover_db_cluster

#' Lists all tags on an Amazon Neptune resource
#'
#' Lists all tags on an Amazon Neptune resource.
#'
#' @usage
#' neptune_list_tags_for_resource(ResourceName, Filters)
#'
#' @param ResourceName &#91;required&#93; The Amazon Neptune resource with tags to be listed. This value is an
#' Amazon Resource Name (ARN). For information about creating an ARN, see
#' [Constructing an Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing).
#' @param Filters This parameter is not currently supported.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceName = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_list_tags_for_resource
neptune_list_tags_for_resource <- function(ResourceName, Filters = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$list_tags_for_resource_input(ResourceName = ResourceName, Filters = Filters)
  output <- .neptune$list_tags_for_resource_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$list_tags_for_resource <- neptune_list_tags_for_resource

#' Modify a setting for a DB cluster
#'
#' Modify a setting for a DB cluster. You can change one or more database
#' configuration parameters by specifying these parameters and the new
#' values in the request.
#'
#' @usage
#' neptune_modify_db_cluster(DBClusterIdentifier, NewDBClusterIdentifier,
#'   ApplyImmediately, BackupRetentionPeriod, DBClusterParameterGroupName,
#'   VpcSecurityGroupIds, Port, MasterUserPassword, OptionGroupName,
#'   PreferredBackupWindow, PreferredMaintenanceWindow,
#'   EnableIAMDatabaseAuthentication, CloudwatchLogsExportConfiguration,
#'   EngineVersion)
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier for the cluster being modified. This parameter
#' is not case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBCluster.
#' @param NewDBClusterIdentifier The new DB cluster identifier for the DB cluster when renaming a DB
#' cluster. This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens
#' 
#' -   The first character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-cluster2`
#' @param ApplyImmediately A value that specifies whether the modifications in this request and any
#' pending modifications are asynchronously applied as soon as possible,
#' regardless of the `PreferredMaintenanceWindow` setting for the DB
#' cluster. If this parameter is set to `false`, changes to the DB cluster
#' are applied during the next maintenance window.
#' 
#' The `ApplyImmediately` parameter only affects the
#' `NewDBClusterIdentifier` and `MasterUserPassword` values. If you set the
#' `ApplyImmediately` parameter value to false, then changes to the
#' `NewDBClusterIdentifier` and `MasterUserPassword` values are applied
#' during the next maintenance window. All other changes are applied
#' immediately, regardless of the value of the `ApplyImmediately`
#' parameter.
#' 
#' Default: `false`
#' @param BackupRetentionPeriod The number of days for which automated backups are retained. You must
#' specify a minimum value of 1.
#' 
#' Default: 1
#' 
#' Constraints:
#' 
#' -   Must be a value from 1 to 35
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to use for the DB cluster.
#' @param VpcSecurityGroupIds A list of VPC security groups that the DB cluster will belong to.
#' @param Port The port number on which the DB cluster accepts connections.
#' 
#' Constraints: Value must be `1150-65535`
#' 
#' Default: The same port as the original DB cluster.
#' @param MasterUserPassword The new password for the master database user. This password can contain
#' any printable ASCII character except \"/\", \"\"\", or \"@\".
#' 
#' Constraints: Must contain from 8 to 41 characters.
#' @param OptionGroupName A value that indicates that the DB cluster should be associated with the
#' specified option group. Changing this parameter doesn\'t result in an
#' outage except in the following case, and the change is applied during
#' the next maintenance window unless the `ApplyImmediately` parameter is
#' set to `true` for this request. If the parameter change results in an
#' option group that enables OEM, this change can cause a brief
#' (sub-second) period during which new connections are rejected but
#' existing connections are not interrupted.
#' 
#' Permanent options can\'t be removed from an option group. The option
#' group can\'t be removed from a DB cluster once it is associated with a
#' DB cluster.
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled, using the `BackupRetentionPeriod`
#' parameter.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region.
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param PreferredMaintenanceWindow The weekly time range during which system maintenance can occur, in
#' Universal Coordinated Time (UTC).
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region, occurring on a random day of the
#' week.
#' 
#' Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' Constraints: Minimum 30-minute window.
#' @param EnableIAMDatabaseAuthentication True to enable mapping of AWS Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' Default: `false`
#' @param CloudwatchLogsExportConfiguration The configuration setting for the log types to be enabled for export to
#' CloudWatch Logs for a specific DB cluster.
#' @param EngineVersion The version number of the database engine to which you want to upgrade.
#' Changing this parameter results in an outage. The change is applied
#' during the next maintenance window unless the ApplyImmediately parameter
#' is set to true.
#' 
#' For a list of valid engine versions, see CreateDBInstance, or call
#' DescribeDBEngineVersions.
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_cluster(
#'   DBClusterIdentifier = "string",
#'   NewDBClusterIdentifier = "string",
#'   ApplyImmediately = TRUE|FALSE,
#'   BackupRetentionPeriod = 123,
#'   DBClusterParameterGroupName = "string",
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   Port = 123,
#'   MasterUserPassword = "string",
#'   OptionGroupName = "string",
#'   PreferredBackupWindow = "string",
#'   PreferredMaintenanceWindow = "string",
#'   EnableIAMDatabaseAuthentication = TRUE|FALSE,
#'   CloudwatchLogsExportConfiguration = list(
#'     EnableLogTypes = list(
#'       "string"
#'     ),
#'     DisableLogTypes = list(
#'       "string"
#'     )
#'   ),
#'   EngineVersion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_modify_db_cluster
neptune_modify_db_cluster <- function(DBClusterIdentifier, NewDBClusterIdentifier = NULL, ApplyImmediately = NULL, BackupRetentionPeriod = NULL, DBClusterParameterGroupName = NULL, VpcSecurityGroupIds = NULL, Port = NULL, MasterUserPassword = NULL, OptionGroupName = NULL, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, EnableIAMDatabaseAuthentication = NULL, CloudwatchLogsExportConfiguration = NULL, EngineVersion = NULL) {
  op <- new_operation(
    name = "ModifyDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$modify_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, NewDBClusterIdentifier = NewDBClusterIdentifier, ApplyImmediately = ApplyImmediately, BackupRetentionPeriod = BackupRetentionPeriod, DBClusterParameterGroupName = DBClusterParameterGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Port = Port, MasterUserPassword = MasterUserPassword, OptionGroupName = OptionGroupName, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, CloudwatchLogsExportConfiguration = CloudwatchLogsExportConfiguration, EngineVersion = EngineVersion)
  output <- .neptune$modify_db_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$modify_db_cluster <- neptune_modify_db_cluster

#' Modifies the parameters of a DB cluster parameter group
#'
#' Modifies the parameters of a DB cluster parameter group. To modify more
#' than one parameter, submit a list of the following: `ParameterName`,
#' `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be
#' modified in a single request.
#' 
#' Changes to dynamic parameters are applied immediately. Changes to static
#' parameters require a reboot without failover to the DB cluster
#' associated with the parameter group before the change can take effect.
#' 
#' After you create a DB cluster parameter group, you should wait at least
#' 5 minutes before creating your first DB cluster that uses that DB
#' cluster parameter group as the default parameter group. This allows
#' Amazon Neptune to fully complete the create action before the parameter
#' group is used as the default for a new DB cluster. This is especially
#' important for parameters that are critical when creating the default
#' database for a DB cluster, such as the character set for the default
#' database defined by the `character_set_database` parameter. You can use
#' the *Parameter Groups* option of the Amazon Neptune console or the
#' DescribeDBClusterParameters command to verify that your DB cluster
#' parameter group has been created or modified.
#'
#' @usage
#' neptune_modify_db_cluster_parameter_group(DBClusterParameterGroupName,
#'   Parameters)
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group to modify.
#' @param Parameters &#91;required&#93; A list of parameters in the DB cluster parameter group to modify.
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_cluster_parameter_group(
#'   DBClusterParameterGroupName = "string",
#'   Parameters = list(
#'     list(
#'       ParameterName = "string",
#'       ParameterValue = "string",
#'       Description = "string",
#'       Source = "string",
#'       ApplyType = "string",
#'       DataType = "string",
#'       AllowedValues = "string",
#'       IsModifiable = TRUE|FALSE,
#'       MinimumEngineVersion = "string",
#'       ApplyMethod = "immediate"|"pending-reboot"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_modify_db_cluster_parameter_group
neptune_modify_db_cluster_parameter_group <- function(DBClusterParameterGroupName, Parameters) {
  op <- new_operation(
    name = "ModifyDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$modify_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Parameters = Parameters)
  output <- .neptune$modify_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$modify_db_cluster_parameter_group <- neptune_modify_db_cluster_parameter_group

#' Adds an attribute and values to, or removes an attribute and values
#' from, a manual DB cluster snapshot
#'
#' Adds an attribute and values to, or removes an attribute and values
#' from, a manual DB cluster snapshot.
#' 
#' To share a manual DB cluster snapshot with other AWS accounts, specify
#' `restore` as the `AttributeName` and use the `ValuesToAdd` parameter to
#' add a list of IDs of the AWS accounts that are authorized to restore the
#' manual DB cluster snapshot. Use the value `all` to make the manual DB
#' cluster snapshot public, which means that it can be copied or restored
#' by all AWS accounts. Do not add the `all` value for any manual DB
#' cluster snapshots that contain private information that you don\'t want
#' available to all AWS accounts. If a manual DB cluster snapshot is
#' encrypted, it can be shared, but only by specifying a list of authorized
#' AWS account IDs for the `ValuesToAdd` parameter. You can\'t use `all` as
#' a value for that parameter in this case.
#' 
#' To view which AWS accounts have access to copy or restore a manual DB
#' cluster snapshot, or whether a manual DB cluster snapshot public or
#' private, use the DescribeDBClusterSnapshotAttributes API action.
#'
#' @usage
#' neptune_modify_db_cluster_snapshot_attribute(
#'   DBClusterSnapshotIdentifier, AttributeName, ValuesToAdd, ValuesToRemove)
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier for the DB cluster snapshot to modify the attributes for.
#' @param AttributeName &#91;required&#93; The name of the DB cluster snapshot attribute to modify.
#' 
#' To manage authorization for other AWS accounts to copy or restore a
#' manual DB cluster snapshot, set this value to `restore`.
#' @param ValuesToAdd A list of DB cluster snapshot attributes to add to the attribute
#' specified by `AttributeName`.
#' 
#' To authorize other AWS accounts to copy or restore a manual DB cluster
#' snapshot, set this list to include one or more AWS account IDs, or `all`
#' to make the manual DB cluster snapshot restorable by any AWS account. Do
#' not add the `all` value for any manual DB cluster snapshots that contain
#' private information that you don\'t want available to all AWS accounts.
#' @param ValuesToRemove A list of DB cluster snapshot attributes to remove from the attribute
#' specified by `AttributeName`.
#' 
#' To remove authorization for other AWS accounts to copy or restore a
#' manual DB cluster snapshot, set this list to include one or more AWS
#' account identifiers, or `all` to remove authorization for any AWS
#' account to copy or restore the DB cluster snapshot. If you specify
#' `all`, an AWS account whose account ID is explicitly added to the
#' `restore` attribute can still copy or restore a manual DB cluster
#' snapshot.
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_cluster_snapshot_attribute(
#'   DBClusterSnapshotIdentifier = "string",
#'   AttributeName = "string",
#'   ValuesToAdd = list(
#'     "string"
#'   ),
#'   ValuesToRemove = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_modify_db_cluster_snapshot_attribute
neptune_modify_db_cluster_snapshot_attribute <- function(DBClusterSnapshotIdentifier, AttributeName, ValuesToAdd = NULL, ValuesToRemove = NULL) {
  op <- new_operation(
    name = "ModifyDBClusterSnapshotAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$modify_db_cluster_snapshot_attribute_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, AttributeName = AttributeName, ValuesToAdd = ValuesToAdd, ValuesToRemove = ValuesToRemove)
  output <- .neptune$modify_db_cluster_snapshot_attribute_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$modify_db_cluster_snapshot_attribute <- neptune_modify_db_cluster_snapshot_attribute

#' Modifies settings for a DB instance
#'
#' Modifies settings for a DB instance. You can change one or more database
#' configuration parameters by specifying these parameters and the new
#' values in the request. To learn what modifications you can make to your
#' DB instance, call DescribeValidDBInstanceModifications before you call
#' ModifyDBInstance.
#'
#' @usage
#' neptune_modify_db_instance(DBInstanceIdentifier, AllocatedStorage,
#'   DBInstanceClass, DBSubnetGroupName, DBSecurityGroups,
#'   VpcSecurityGroupIds, ApplyImmediately, MasterUserPassword,
#'   DBParameterGroupName, BackupRetentionPeriod, PreferredBackupWindow,
#'   PreferredMaintenanceWindow, MultiAZ, EngineVersion,
#'   AllowMajorVersionUpgrade, AutoMinorVersionUpgrade, LicenseModel, Iops,
#'   OptionGroupName, NewDBInstanceIdentifier, StorageType, TdeCredentialArn,
#'   TdeCredentialPassword, CACertificateIdentifier, Domain,
#'   CopyTagsToSnapshot, MonitoringInterval, DBPortNumber,
#'   PubliclyAccessible, MonitoringRoleArn, DomainIAMRoleName, PromotionTier,
#'   EnableIAMDatabaseAuthentication, EnablePerformanceInsights,
#'   PerformanceInsightsKMSKeyId, CloudwatchLogsExportConfiguration)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier. This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBInstance.
#' @param AllocatedStorage The new amount of storage (in gibibytes) to allocate for the DB
#' instance.
#' 
#' Not applicable. Storage is managed by the DB Cluster.
#' @param DBInstanceClass The new compute and memory capacity of the DB instance, for example,
#' `db.m4.large`. Not all DB instance classes are available in all AWS
#' Regions.
#' 
#' If you modify the DB instance class, an outage occurs during the change.
#' The change is applied during the next maintenance window, unless
#' `ApplyImmediately` is specified as `true` for this request.
#' 
#' Default: Uses existing setting
#' @param DBSubnetGroupName The new DB subnet group for the DB instance. You can use this parameter
#' to move your DB instance to a different VPC.
#' 
#' Changing the subnet group causes an outage during the change. The change
#' is applied during the next maintenance window, unless you specify `true`
#' for the `ApplyImmediately` parameter.
#' 
#' Constraints: If supplied, must match the name of an existing
#' DBSubnetGroup.
#' 
#' Example: `mySubnetGroup`
#' @param DBSecurityGroups A list of DB security groups to authorize on this DB instance. Changing
#' this setting doesn\'t result in an outage and the change is
#' asynchronously applied as soon as possible.
#' 
#' Constraints:
#' 
#' -   If supplied, must match existing DBSecurityGroups.
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to authorize on this DB instance. This
#' change is asynchronously applied as soon as possible.
#' 
#' Not applicable. The associated list of EC2 VPC security groups is
#' managed by the DB cluster. For more information, see ModifyDBCluster.
#' 
#' Constraints:
#' 
#' -   If supplied, must match existing VpcSecurityGroupIds.
#' @param ApplyImmediately Specifies whether the modifications in this request and any pending
#' modifications are asynchronously applied as soon as possible, regardless
#' of the `PreferredMaintenanceWindow` setting for the DB instance.
#' 
#' If this parameter is set to `false`, changes to the DB instance are
#' applied during the next maintenance window. Some parameter changes can
#' cause an outage and are applied on the next call to RebootDBInstance, or
#' the next failure reboot.
#' 
#' Default: `false`
#' @param MasterUserPassword Not applicable.
#' @param DBParameterGroupName The name of the DB parameter group to apply to the DB instance. Changing
#' this setting doesn\'t result in an outage. The parameter group name
#' itself is changed immediately, but the actual parameter changes are not
#' applied until you reboot the instance without failover. The db instance
#' will NOT be rebooted automatically and the parameter changes will NOT be
#' applied during the next maintenance window.
#' 
#' Default: Uses existing setting
#' 
#' Constraints: The DB parameter group must be in the same DB parameter
#' group family as this DB instance.
#' @param BackupRetentionPeriod Not applicable. The retention period for automated backups is managed by
#' the DB cluster. For more information, see ModifyDBCluster.
#' 
#' Default: Uses existing setting
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled.
#' 
#' Not applicable. The daily time range for creating automated backups is
#' managed by the DB cluster. For more information, see ModifyDBCluster.
#' 
#' Constraints:
#' 
#' -   Must be in the format hh24:mi-hh24:mi
#' 
#' -   Must be in Universal Time Coordinated (UTC)
#' 
#' -   Must not conflict with the preferred maintenance window
#' 
#' -   Must be at least 30 minutes
#' @param PreferredMaintenanceWindow The weekly time range (in UTC) during which system maintenance can
#' occur, which might result in an outage. Changing this parameter doesn\'t
#' result in an outage, except in the following situation, and the change
#' is asynchronously applied as soon as possible. If there are pending
#' actions that cause a reboot, and the maintenance window is changed to
#' include the current time, then changing this parameter will cause a
#' reboot of the DB instance. If moving this window to the current time,
#' there must be at least 30 minutes between the current time and end of
#' the window to ensure pending changes are applied.
#' 
#' Default: Uses existing setting
#' 
#' Format: ddd:hh24:mi-ddd:hh24:mi
#' 
#' Valid Days: Mon \\| Tue \\| Wed \\| Thu \\| Fri \\| Sat \\| Sun
#' 
#' Constraints: Must be at least 30 minutes
#' @param MultiAZ Specifies if the DB instance is a Multi-AZ deployment. Changing this
#' parameter doesn\'t result in an outage and the change is applied during
#' the next maintenance window unless the `ApplyImmediately` parameter is
#' set to `true` for this request.
#' @param EngineVersion The version number of the database engine to upgrade to. Changing this
#' parameter results in an outage and the change is applied during the next
#' maintenance window unless the `ApplyImmediately` parameter is set to
#' `true` for this request.
#' 
#' For major version upgrades, if a nondefault DB parameter group is
#' currently in use, a new DB parameter group in the DB parameter group
#' family for the new engine version must be specified. The new DB
#' parameter group can be the default for that DB parameter group family.
#' @param AllowMajorVersionUpgrade Indicates that major version upgrades are allowed. Changing this
#' parameter doesn\'t result in an outage and the change is asynchronously
#' applied as soon as possible.
#' 
#' Constraints: This parameter must be set to true when specifying a value
#' for the EngineVersion parameter that is a different major version than
#' the DB instance\'s current version.
#' @param AutoMinorVersionUpgrade Indicates that minor version upgrades are applied automatically to the
#' DB instance during the maintenance window. Changing this parameter
#' doesn\'t result in an outage except in the following case and the change
#' is asynchronously applied as soon as possible. An outage will result if
#' this parameter is set to `true` during the maintenance window, and a
#' newer minor version is available, and Neptune has enabled auto patching
#' for that engine version.
#' @param LicenseModel Not supported.
#' @param Iops The new Provisioned IOPS (I/O operations per second) value for the
#' instance.
#' 
#' Changing this setting doesn\'t result in an outage and the change is
#' applied during the next maintenance window unless the `ApplyImmediately`
#' parameter is set to `true` for this request.
#' 
#' Default: Uses existing setting
#' @param OptionGroupName Indicates that the DB instance should be associated with the specified
#' option group. Changing this parameter doesn\'t result in an outage
#' except in the following case and the change is applied during the next
#' maintenance window unless the `ApplyImmediately` parameter is set to
#' `true` for this request. If the parameter change results in an option
#' group that enables OEM, this change can cause a brief (sub-second)
#' period during which new connections are rejected but existing
#' connections are not interrupted.
#' 
#' Permanent options, such as the TDE option for Oracle Advanced Security
#' TDE, can\'t be removed from an option group, and that option group
#' can\'t be removed from a DB instance once it is associated with a DB
#' instance
#' @param NewDBInstanceIdentifier The new DB instance identifier for the DB instance when renaming a DB
#' instance. When you change the DB instance identifier, an instance reboot
#' will occur immediately if you set `Apply Immediately` to true, or will
#' occur during the next maintenance window if `Apply Immediately` to
#' false. This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `mydbinstance`
#' @param StorageType Not supported.
#' @param TdeCredentialArn The ARN from the key store with which to associate the instance for TDE
#' encryption.
#' @param TdeCredentialPassword The password for the given ARN from the key store in order to access the
#' device.
#' @param CACertificateIdentifier Indicates the certificate that needs to be associated with the instance.
#' @param Domain Not supported.
#' @param CopyTagsToSnapshot True to copy all tags from the DB instance to snapshots of the DB
#' instance, and otherwise false. The default is false.
#' @param MonitoringInterval The interval, in seconds, between points when Enhanced Monitoring
#' metrics are collected for the DB instance. To disable collecting
#' Enhanced Monitoring metrics, specify 0. The default is 0.
#' 
#' If `MonitoringRoleArn` is specified, then you must also set
#' `MonitoringInterval` to a value other than 0.
#' 
#' Valid Values: `0, 1, 5, 10, 15, 30, 60`
#' @param DBPortNumber The port number on which the database accepts connections.
#' 
#' The value of the `DBPortNumber` parameter must not match any of the port
#' values specified for options in the option group for the DB instance.
#' 
#' Your database will restart when you change the `DBPortNumber` value
#' regardless of the value of the `ApplyImmediately` parameter.
#' 
#' Default: `8182`
#' @param PubliclyAccessible This flag should no longer be used.
#' @param MonitoringRoleArn The ARN for the IAM role that permits Neptune to send enhanced
#' monitoring metrics to Amazon CloudWatch Logs. For example,
#' `arn:aws:iam:123456789012:role/emaccess`.
#' 
#' If `MonitoringInterval` is set to a value other than 0, then you must
#' supply a `MonitoringRoleArn` value.
#' @param DomainIAMRoleName Not supported
#' @param PromotionTier A value that specifies the order in which a Read Replica is promoted to
#' the primary instance after a failure of the existing primary instance.
#' 
#' Default: 1
#' 
#' Valid Values: 0 - 15
#' @param EnableIAMDatabaseAuthentication True to enable mapping of AWS Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' You can enable IAM database authentication for the following database
#' engines
#' 
#' Not applicable. Mapping AWS IAM accounts to database accounts is managed
#' by the DB cluster. For more information, see ModifyDBCluster.
#' 
#' Default: `false`
#' @param EnablePerformanceInsights Not supported.
#' @param PerformanceInsightsKMSKeyId Not supported.
#' @param CloudwatchLogsExportConfiguration The configuration setting for the log types to be enabled for export to
#' CloudWatch Logs for a specific DB instance or DB cluster.
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_instance(
#'   DBInstanceIdentifier = "string",
#'   AllocatedStorage = 123,
#'   DBInstanceClass = "string",
#'   DBSubnetGroupName = "string",
#'   DBSecurityGroups = list(
#'     "string"
#'   ),
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   ApplyImmediately = TRUE|FALSE,
#'   MasterUserPassword = "string",
#'   DBParameterGroupName = "string",
#'   BackupRetentionPeriod = 123,
#'   PreferredBackupWindow = "string",
#'   PreferredMaintenanceWindow = "string",
#'   MultiAZ = TRUE|FALSE,
#'   EngineVersion = "string",
#'   AllowMajorVersionUpgrade = TRUE|FALSE,
#'   AutoMinorVersionUpgrade = TRUE|FALSE,
#'   LicenseModel = "string",
#'   Iops = 123,
#'   OptionGroupName = "string",
#'   NewDBInstanceIdentifier = "string",
#'   StorageType = "string",
#'   TdeCredentialArn = "string",
#'   TdeCredentialPassword = "string",
#'   CACertificateIdentifier = "string",
#'   Domain = "string",
#'   CopyTagsToSnapshot = TRUE|FALSE,
#'   MonitoringInterval = 123,
#'   DBPortNumber = 123,
#'   PubliclyAccessible = TRUE|FALSE,
#'   MonitoringRoleArn = "string",
#'   DomainIAMRoleName = "string",
#'   PromotionTier = 123,
#'   EnableIAMDatabaseAuthentication = TRUE|FALSE,
#'   EnablePerformanceInsights = TRUE|FALSE,
#'   PerformanceInsightsKMSKeyId = "string",
#'   CloudwatchLogsExportConfiguration = list(
#'     EnableLogTypes = list(
#'       "string"
#'     ),
#'     DisableLogTypes = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_modify_db_instance
neptune_modify_db_instance <- function(DBInstanceIdentifier, AllocatedStorage = NULL, DBInstanceClass = NULL, DBSubnetGroupName = NULL, DBSecurityGroups = NULL, VpcSecurityGroupIds = NULL, ApplyImmediately = NULL, MasterUserPassword = NULL, DBParameterGroupName = NULL, BackupRetentionPeriod = NULL, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, MultiAZ = NULL, EngineVersion = NULL, AllowMajorVersionUpgrade = NULL, AutoMinorVersionUpgrade = NULL, LicenseModel = NULL, Iops = NULL, OptionGroupName = NULL, NewDBInstanceIdentifier = NULL, StorageType = NULL, TdeCredentialArn = NULL, TdeCredentialPassword = NULL, CACertificateIdentifier = NULL, Domain = NULL, CopyTagsToSnapshot = NULL, MonitoringInterval = NULL, DBPortNumber = NULL, PubliclyAccessible = NULL, MonitoringRoleArn = NULL, DomainIAMRoleName = NULL, PromotionTier = NULL, EnableIAMDatabaseAuthentication = NULL, EnablePerformanceInsights = NULL, PerformanceInsightsKMSKeyId = NULL, CloudwatchLogsExportConfiguration = NULL) {
  op <- new_operation(
    name = "ModifyDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$modify_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, AllocatedStorage = AllocatedStorage, DBInstanceClass = DBInstanceClass, DBSubnetGroupName = DBSubnetGroupName, DBSecurityGroups = DBSecurityGroups, VpcSecurityGroupIds = VpcSecurityGroupIds, ApplyImmediately = ApplyImmediately, MasterUserPassword = MasterUserPassword, DBParameterGroupName = DBParameterGroupName, BackupRetentionPeriod = BackupRetentionPeriod, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, MultiAZ = MultiAZ, EngineVersion = EngineVersion, AllowMajorVersionUpgrade = AllowMajorVersionUpgrade, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, LicenseModel = LicenseModel, Iops = Iops, OptionGroupName = OptionGroupName, NewDBInstanceIdentifier = NewDBInstanceIdentifier, StorageType = StorageType, TdeCredentialArn = TdeCredentialArn, TdeCredentialPassword = TdeCredentialPassword, CACertificateIdentifier = CACertificateIdentifier, Domain = Domain, CopyTagsToSnapshot = CopyTagsToSnapshot, MonitoringInterval = MonitoringInterval, DBPortNumber = DBPortNumber, PubliclyAccessible = PubliclyAccessible, MonitoringRoleArn = MonitoringRoleArn, DomainIAMRoleName = DomainIAMRoleName, PromotionTier = PromotionTier, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnablePerformanceInsights = EnablePerformanceInsights, PerformanceInsightsKMSKeyId = PerformanceInsightsKMSKeyId, CloudwatchLogsExportConfiguration = CloudwatchLogsExportConfiguration)
  output <- .neptune$modify_db_instance_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$modify_db_instance <- neptune_modify_db_instance

#' Modifies the parameters of a DB parameter group
#'
#' Modifies the parameters of a DB parameter group. To modify more than one
#' parameter, submit a list of the following: `ParameterName`,
#' `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be
#' modified in a single request.
#' 
#' Changes to dynamic parameters are applied immediately. Changes to static
#' parameters require a reboot without failover to the DB instance
#' associated with the parameter group before the change can take effect.
#' 
#' After you modify a DB parameter group, you should wait at least 5
#' minutes before creating your first DB instance that uses that DB
#' parameter group as the default parameter group. This allows Amazon
#' Neptune to fully complete the modify action before the parameter group
#' is used as the default for a new DB instance. This is especially
#' important for parameters that are critical when creating the default
#' database for a DB instance, such as the character set for the default
#' database defined by the `character_set_database` parameter. You can use
#' the *Parameter Groups* option of the Amazon Neptune console or the
#' *DescribeDBParameters* command to verify that your DB parameter group
#' has been created or modified.
#'
#' @usage
#' neptune_modify_db_parameter_group(DBParameterGroupName, Parameters)
#'
#' @param DBParameterGroupName &#91;required&#93; The name of the DB parameter group.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing DBParameterGroup.
#' @param Parameters &#91;required&#93; An array of parameter names, values, and the apply method for the
#' parameter update. At least one parameter name, value, and apply method
#' must be supplied; subsequent arguments are optional. A maximum of 20
#' parameters can be modified in a single request.
#' 
#' Valid Values (for the application method): `immediate | pending-reboot`
#' 
#' You can use the immediate value with dynamic parameters only. You can
#' use the pending-reboot value for both dynamic and static parameters, and
#' changes are applied when you reboot the DB instance without failover.
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_parameter_group(
#'   DBParameterGroupName = "string",
#'   Parameters = list(
#'     list(
#'       ParameterName = "string",
#'       ParameterValue = "string",
#'       Description = "string",
#'       Source = "string",
#'       ApplyType = "string",
#'       DataType = "string",
#'       AllowedValues = "string",
#'       IsModifiable = TRUE|FALSE,
#'       MinimumEngineVersion = "string",
#'       ApplyMethod = "immediate"|"pending-reboot"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_modify_db_parameter_group
neptune_modify_db_parameter_group <- function(DBParameterGroupName, Parameters) {
  op <- new_operation(
    name = "ModifyDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$modify_db_parameter_group_input(DBParameterGroupName = DBParameterGroupName, Parameters = Parameters)
  output <- .neptune$modify_db_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$modify_db_parameter_group <- neptune_modify_db_parameter_group

#' Modifies an existing DB subnet group
#'
#' Modifies an existing DB subnet group. DB subnet groups must contain at
#' least one subnet in at least two AZs in the AWS Region.
#'
#' @usage
#' neptune_modify_db_subnet_group(DBSubnetGroupName,
#'   DBSubnetGroupDescription, SubnetIds)
#'
#' @param DBSubnetGroupName &#91;required&#93; The name for the DB subnet group. This value is stored as a lowercase
#' string. You can\'t modify the default subnet group.
#' 
#' Constraints: Must match the name of an existing DBSubnetGroup. Must not
#' be default.
#' 
#' Example: `mySubnetgroup`
#' @param DBSubnetGroupDescription The description for the DB subnet group.
#' @param SubnetIds &#91;required&#93; The EC2 subnet IDs for the DB subnet group.
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_subnet_group(
#'   DBSubnetGroupName = "string",
#'   DBSubnetGroupDescription = "string",
#'   SubnetIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_modify_db_subnet_group
neptune_modify_db_subnet_group <- function(DBSubnetGroupName, DBSubnetGroupDescription = NULL, SubnetIds) {
  op <- new_operation(
    name = "ModifyDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$modify_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName, DBSubnetGroupDescription = DBSubnetGroupDescription, SubnetIds = SubnetIds)
  output <- .neptune$modify_db_subnet_group_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$modify_db_subnet_group <- neptune_modify_db_subnet_group

#' Modifies an existing event notification subscription
#'
#' Modifies an existing event notification subscription. Note that you
#' can\'t modify the source identifiers using this call; to change source
#' identifiers for a subscription, use the
#' AddSourceIdentifierToSubscription and
#' RemoveSourceIdentifierFromSubscription calls.
#' 
#' You can see a list of the event categories for a given SourceType by
#' using the **DescribeEventCategories** action.
#'
#' @usage
#' neptune_modify_event_subscription(SubscriptionName, SnsTopicArn,
#'   SourceType, EventCategories, Enabled)
#'
#' @param SubscriptionName &#91;required&#93; The name of the event notification subscription.
#' @param SnsTopicArn The Amazon Resource Name (ARN) of the SNS topic created for event
#' notification. The ARN is created by Amazon SNS when you create a topic
#' and subscribe to it.
#' @param SourceType The type of source that is generating the events. For example, if you
#' want to be notified of events generated by a DB instance, you would set
#' this parameter to db-instance. if this value is not specified, all
#' events are returned.
#' 
#' Valid values: db-instance \\| db-parameter-group \\| db-security-group \\|
#' db-snapshot
#' @param EventCategories A list of event categories for a SourceType that you want to subscribe
#' to. You can see a list of the categories for a given SourceType by using
#' the **DescribeEventCategories** action.
#' @param Enabled A Boolean value; set to **true** to activate the subscription.
#'
#' @section Request syntax:
#' ```
#' svc$modify_event_subscription(
#'   SubscriptionName = "string",
#'   SnsTopicArn = "string",
#'   SourceType = "string",
#'   EventCategories = list(
#'     "string"
#'   ),
#'   Enabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_modify_event_subscription
neptune_modify_event_subscription <- function(SubscriptionName, SnsTopicArn = NULL, SourceType = NULL, EventCategories = NULL, Enabled = NULL) {
  op <- new_operation(
    name = "ModifyEventSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$modify_event_subscription_input(SubscriptionName = SubscriptionName, SnsTopicArn = SnsTopicArn, SourceType = SourceType, EventCategories = EventCategories, Enabled = Enabled)
  output <- .neptune$modify_event_subscription_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$modify_event_subscription <- neptune_modify_event_subscription

#' Not supported
#'
#' Not supported.
#'
#' @usage
#' neptune_promote_read_replica_db_cluster(DBClusterIdentifier)
#'
#' @param DBClusterIdentifier &#91;required&#93; Not supported.
#'
#' @section Request syntax:
#' ```
#' svc$promote_read_replica_db_cluster(
#'   DBClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_promote_read_replica_db_cluster
neptune_promote_read_replica_db_cluster <- function(DBClusterIdentifier) {
  op <- new_operation(
    name = "PromoteReadReplicaDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$promote_read_replica_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier)
  output <- .neptune$promote_read_replica_db_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$promote_read_replica_db_cluster <- neptune_promote_read_replica_db_cluster

#' You might need to reboot your DB instance, usually for maintenance
#' reasons
#'
#' You might need to reboot your DB instance, usually for maintenance
#' reasons. For example, if you make certain modifications, or if you
#' change the DB parameter group associated with the DB instance, you must
#' reboot the instance for the changes to take effect.
#' 
#' Rebooting a DB instance restarts the database engine service. Rebooting
#' a DB instance results in a momentary outage, during which the DB
#' instance status is set to rebooting.
#'
#' @usage
#' neptune_reboot_db_instance(DBInstanceIdentifier, ForceFailover)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier. This parameter is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBInstance.
#' @param ForceFailover When `true`, the reboot is conducted through a MultiAZ failover.
#' 
#' Constraint: You can\'t specify `true` if the instance is not configured
#' for MultiAZ.
#'
#' @section Request syntax:
#' ```
#' svc$reboot_db_instance(
#'   DBInstanceIdentifier = "string",
#'   ForceFailover = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_reboot_db_instance
neptune_reboot_db_instance <- function(DBInstanceIdentifier, ForceFailover = NULL) {
  op <- new_operation(
    name = "RebootDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$reboot_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, ForceFailover = ForceFailover)
  output <- .neptune$reboot_db_instance_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$reboot_db_instance <- neptune_reboot_db_instance

#' Disassociates an Identity and Access Management (IAM) role from a DB
#' cluster
#'
#' Disassociates an Identity and Access Management (IAM) role from a DB
#' cluster.
#'
#' @usage
#' neptune_remove_role_from_db_cluster(DBClusterIdentifier, RoleArn)
#'
#' @param DBClusterIdentifier &#91;required&#93; The name of the DB cluster to disassociate the IAM role from.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to disassociate from the
#' DB cluster, for example
#' `arn:aws:iam::123456789012:role/NeptuneAccessRole`.
#'
#' @section Request syntax:
#' ```
#' svc$remove_role_from_db_cluster(
#'   DBClusterIdentifier = "string",
#'   RoleArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_remove_role_from_db_cluster
neptune_remove_role_from_db_cluster <- function(DBClusterIdentifier, RoleArn) {
  op <- new_operation(
    name = "RemoveRoleFromDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$remove_role_from_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, RoleArn = RoleArn)
  output <- .neptune$remove_role_from_db_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$remove_role_from_db_cluster <- neptune_remove_role_from_db_cluster

#' Removes a source identifier from an existing event notification
#' subscription
#'
#' Removes a source identifier from an existing event notification
#' subscription.
#'
#' @usage
#' neptune_remove_source_identifier_from_subscription(SubscriptionName,
#'   SourceIdentifier)
#'
#' @param SubscriptionName &#91;required&#93; The name of the event notification subscription you want to remove a
#' source identifier from.
#' @param SourceIdentifier &#91;required&#93; The source identifier to be removed from the subscription, such as the
#' **DB instance identifier** for a DB instance or the name of a security
#' group.
#'
#' @section Request syntax:
#' ```
#' svc$remove_source_identifier_from_subscription(
#'   SubscriptionName = "string",
#'   SourceIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_remove_source_identifier_from_subscription
neptune_remove_source_identifier_from_subscription <- function(SubscriptionName, SourceIdentifier) {
  op <- new_operation(
    name = "RemoveSourceIdentifierFromSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$remove_source_identifier_from_subscription_input(SubscriptionName = SubscriptionName, SourceIdentifier = SourceIdentifier)
  output <- .neptune$remove_source_identifier_from_subscription_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$remove_source_identifier_from_subscription <- neptune_remove_source_identifier_from_subscription

#' Removes metadata tags from an Amazon Neptune resource
#'
#' Removes metadata tags from an Amazon Neptune resource.
#'
#' @usage
#' neptune_remove_tags_from_resource(ResourceName, TagKeys)
#'
#' @param ResourceName &#91;required&#93; The Amazon Neptune resource that the tags are removed from. This value
#' is an Amazon Resource Name (ARN). For information about creating an ARN,
#' see [Constructing an Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing).
#' @param TagKeys &#91;required&#93; The tag key (name) of the tag to be removed.
#'
#' @section Request syntax:
#' ```
#' svc$remove_tags_from_resource(
#'   ResourceName = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_remove_tags_from_resource
neptune_remove_tags_from_resource <- function(ResourceName, TagKeys) {
  op <- new_operation(
    name = "RemoveTagsFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$remove_tags_from_resource_input(ResourceName = ResourceName, TagKeys = TagKeys)
  output <- .neptune$remove_tags_from_resource_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$remove_tags_from_resource <- neptune_remove_tags_from_resource

#' Modifies the parameters of a DB cluster parameter group to the default
#' value
#'
#' Modifies the parameters of a DB cluster parameter group to the default
#' value. To reset specific parameters submit a list of the following:
#' `ParameterName` and `ApplyMethod`. To reset the entire DB cluster
#' parameter group, specify the `DBClusterParameterGroupName` and
#' `ResetAllParameters` parameters.
#' 
#' When resetting the entire group, dynamic parameters are updated
#' immediately and static parameters are set to `pending-reboot` to take
#' effect on the next DB instance restart or RebootDBInstance request. You
#' must call RebootDBInstance for every DB instance in your DB cluster that
#' you want the updated static parameter to apply to.
#'
#' @usage
#' neptune_reset_db_cluster_parameter_group(DBClusterParameterGroupName,
#'   ResetAllParameters, Parameters)
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group to reset.
#' @param ResetAllParameters A value that is set to `true` to reset all parameters in the DB cluster
#' parameter group to their default values, and `false` otherwise. You
#' can\'t use this parameter if there is a list of parameter names
#' specified for the `Parameters` parameter.
#' @param Parameters A list of parameter names in the DB cluster parameter group to reset to
#' the default values. You can\'t use this parameter if the
#' `ResetAllParameters` parameter is set to `true`.
#'
#' @section Request syntax:
#' ```
#' svc$reset_db_cluster_parameter_group(
#'   DBClusterParameterGroupName = "string",
#'   ResetAllParameters = TRUE|FALSE,
#'   Parameters = list(
#'     list(
#'       ParameterName = "string",
#'       ParameterValue = "string",
#'       Description = "string",
#'       Source = "string",
#'       ApplyType = "string",
#'       DataType = "string",
#'       AllowedValues = "string",
#'       IsModifiable = TRUE|FALSE,
#'       MinimumEngineVersion = "string",
#'       ApplyMethod = "immediate"|"pending-reboot"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_reset_db_cluster_parameter_group
neptune_reset_db_cluster_parameter_group <- function(DBClusterParameterGroupName, ResetAllParameters = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "ResetDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$reset_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, ResetAllParameters = ResetAllParameters, Parameters = Parameters)
  output <- .neptune$reset_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$reset_db_cluster_parameter_group <- neptune_reset_db_cluster_parameter_group

#' Modifies the parameters of a DB parameter group to the engine/system
#' default value
#'
#' Modifies the parameters of a DB parameter group to the engine/system
#' default value. To reset specific parameters, provide a list of the
#' following: `ParameterName` and `ApplyMethod`. To reset the entire DB
#' parameter group, specify the `DBParameterGroup` name and
#' `ResetAllParameters` parameters. When resetting the entire group,
#' dynamic parameters are updated immediately and static parameters are set
#' to `pending-reboot` to take effect on the next DB instance restart or
#' `RebootDBInstance` request.
#'
#' @usage
#' neptune_reset_db_parameter_group(DBParameterGroupName,
#'   ResetAllParameters, Parameters)
#'
#' @param DBParameterGroupName &#91;required&#93; The name of the DB parameter group.
#' 
#' Constraints:
#' 
#' -   Must match the name of an existing DBParameterGroup.
#' @param ResetAllParameters Specifies whether (`true`) or not (`false`) to reset all parameters in
#' the DB parameter group to default values.
#' 
#' Default: `true`
#' @param Parameters To reset the entire DB parameter group, specify the `DBParameterGroup`
#' name and `ResetAllParameters` parameters. To reset specific parameters,
#' provide a list of the following: `ParameterName` and `ApplyMethod`. A
#' maximum of 20 parameters can be modified in a single request.
#' 
#' Valid Values (for Apply method): `pending-reboot`
#'
#' @section Request syntax:
#' ```
#' svc$reset_db_parameter_group(
#'   DBParameterGroupName = "string",
#'   ResetAllParameters = TRUE|FALSE,
#'   Parameters = list(
#'     list(
#'       ParameterName = "string",
#'       ParameterValue = "string",
#'       Description = "string",
#'       Source = "string",
#'       ApplyType = "string",
#'       DataType = "string",
#'       AllowedValues = "string",
#'       IsModifiable = TRUE|FALSE,
#'       MinimumEngineVersion = "string",
#'       ApplyMethod = "immediate"|"pending-reboot"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_reset_db_parameter_group
neptune_reset_db_parameter_group <- function(DBParameterGroupName, ResetAllParameters = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "ResetDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$reset_db_parameter_group_input(DBParameterGroupName = DBParameterGroupName, ResetAllParameters = ResetAllParameters, Parameters = Parameters)
  output <- .neptune$reset_db_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$reset_db_parameter_group <- neptune_reset_db_parameter_group

#' Creates a new DB cluster from a DB snapshot or DB cluster snapshot
#'
#' Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
#' 
#' If a DB snapshot is specified, the target DB cluster is created from the
#' source DB snapshot with a default configuration and default security
#' group.
#' 
#' If a DB cluster snapshot is specified, the target DB cluster is created
#' from the source DB cluster restore point with the same configuration as
#' the original source DB cluster, except that the new DB cluster is
#' created with the default security group.
#'
#' @usage
#' neptune_restore_db_cluster_from_snapshot(AvailabilityZones,
#'   DBClusterIdentifier, SnapshotIdentifier, Engine, EngineVersion, Port,
#'   DBSubnetGroupName, DatabaseName, OptionGroupName, VpcSecurityGroupIds,
#'   Tags, KmsKeyId, EnableIAMDatabaseAuthentication,
#'   EnableCloudwatchLogsExports, DBClusterParameterGroupName)
#'
#' @param AvailabilityZones Provides the list of EC2 Availability Zones that instances in the
#' restored DB cluster can be created in.
#' @param DBClusterIdentifier &#91;required&#93; The name of the DB cluster to create from the DB snapshot or DB cluster
#' snapshot. This parameter isn\'t case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-snapshot-id`
#' @param SnapshotIdentifier &#91;required&#93; The identifier for the DB snapshot or DB cluster snapshot to restore
#' from.
#' 
#' You can use either the name or the Amazon Resource Name (ARN) to specify
#' a DB cluster snapshot. However, you can use only the ARN to specify a DB
#' snapshot.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing Snapshot.
#' @param Engine &#91;required&#93; The database engine to use for the new DB cluster.
#' 
#' Default: The same as source
#' 
#' Constraint: Must be compatible with the engine of the source
#' @param EngineVersion The version of the database engine to use for the new DB cluster.
#' @param Port The port number on which the new DB cluster accepts connections.
#' 
#' Constraints: Value must be `1150-65535`
#' 
#' Default: The same port as the original DB cluster.
#' @param DBSubnetGroupName The name of the DB subnet group to use for the new DB cluster.
#' 
#' Constraints: If supplied, must match the name of an existing
#' DBSubnetGroup.
#' 
#' Example: `mySubnetgroup`
#' @param DatabaseName Not supported.
#' @param OptionGroupName The name of the option group to use for the restored DB cluster.
#' @param VpcSecurityGroupIds A list of VPC security groups that the new DB cluster will belong to.
#' @param Tags The tags to be assigned to the restored DB cluster.
#' @param KmsKeyId The AWS KMS key identifier to use when restoring an encrypted DB cluster
#' from a DB snapshot or DB cluster snapshot.
#' 
#' The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
#' encryption key. If you are restoring a DB cluster with the same AWS
#' account that owns the KMS encryption key used to encrypt the new DB
#' cluster, then you can use the KMS key alias instead of the ARN for the
#' KMS encryption key.
#' 
#' If you do not specify a value for the `KmsKeyId` parameter, then the
#' following will occur:
#' 
#' -   If the DB snapshot or DB cluster snapshot in `SnapshotIdentifier` is
#'     encrypted, then the restored DB cluster is encrypted using the KMS
#'     key that was used to encrypt the DB snapshot or DB cluster snapshot.
#' 
#' -   If the DB snapshot or DB cluster snapshot in `SnapshotIdentifier` is
#'     not encrypted, then the restored DB cluster is not encrypted.
#' @param EnableIAMDatabaseAuthentication True to enable mapping of AWS Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' Default: `false`
#' @param EnableCloudwatchLogsExports The list of logs that the restored DB cluster is to export to Amazon
#' CloudWatch Logs.
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to associate with the new DB
#' cluster.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#'
#' @section Request syntax:
#' ```
#' svc$restore_db_cluster_from_snapshot(
#'   AvailabilityZones = list(
#'     "string"
#'   ),
#'   DBClusterIdentifier = "string",
#'   SnapshotIdentifier = "string",
#'   Engine = "string",
#'   EngineVersion = "string",
#'   Port = 123,
#'   DBSubnetGroupName = "string",
#'   DatabaseName = "string",
#'   OptionGroupName = "string",
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   KmsKeyId = "string",
#'   EnableIAMDatabaseAuthentication = TRUE|FALSE,
#'   EnableCloudwatchLogsExports = list(
#'     "string"
#'   ),
#'   DBClusterParameterGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_restore_db_cluster_from_snapshot
neptune_restore_db_cluster_from_snapshot <- function(AvailabilityZones = NULL, DBClusterIdentifier, SnapshotIdentifier, Engine, EngineVersion = NULL, Port = NULL, DBSubnetGroupName = NULL, DatabaseName = NULL, OptionGroupName = NULL, VpcSecurityGroupIds = NULL, Tags = NULL, KmsKeyId = NULL, EnableIAMDatabaseAuthentication = NULL, EnableCloudwatchLogsExports = NULL, DBClusterParameterGroupName = NULL) {
  op <- new_operation(
    name = "RestoreDBClusterFromSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$restore_db_cluster_from_snapshot_input(AvailabilityZones = AvailabilityZones, DBClusterIdentifier = DBClusterIdentifier, SnapshotIdentifier = SnapshotIdentifier, Engine = Engine, EngineVersion = EngineVersion, Port = Port, DBSubnetGroupName = DBSubnetGroupName, DatabaseName = DatabaseName, OptionGroupName = OptionGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Tags = Tags, KmsKeyId = KmsKeyId, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, DBClusterParameterGroupName = DBClusterParameterGroupName)
  output <- .neptune$restore_db_cluster_from_snapshot_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$restore_db_cluster_from_snapshot <- neptune_restore_db_cluster_from_snapshot

#' Restores a DB cluster to an arbitrary point in time
#'
#' Restores a DB cluster to an arbitrary point in time. Users can restore
#' to any point in time before `LatestRestorableTime` for up to
#' `BackupRetentionPeriod` days. The target DB cluster is created from the
#' source DB cluster with the same configuration as the original DB
#' cluster, except that the new DB cluster is created with the default DB
#' security group.
#' 
#' This action only restores the DB cluster, not the DB instances for that
#' DB cluster. You must invoke the CreateDBInstance action to create DB
#' instances for the restored DB cluster, specifying the identifier of the
#' restored DB cluster in `DBClusterIdentifier`. You can create DB
#' instances only after the `RestoreDBClusterToPointInTime` action has
#' completed and the DB cluster is available.
#'
#' @usage
#' neptune_restore_db_cluster_to_point_in_time(DBClusterIdentifier,
#'   RestoreType, SourceDBClusterIdentifier, RestoreToTime,
#'   UseLatestRestorableTime, Port, DBSubnetGroupName, OptionGroupName,
#'   VpcSecurityGroupIds, Tags, KmsKeyId, EnableIAMDatabaseAuthentication,
#'   EnableCloudwatchLogsExports, DBClusterParameterGroupName)
#'
#' @param DBClusterIdentifier &#91;required&#93; The name of the new DB cluster to be created.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' @param RestoreType The type of restore to be performed. You can specify one of the
#' following values:
#' 
#' -   `full-copy` - The new DB cluster is restored as a full copy of the
#'     source DB cluster.
#' 
#' -   `copy-on-write` - The new DB cluster is restored as a clone of the
#'     source DB cluster.
#' 
#' If you don\'t specify a `RestoreType` value, then the new DB cluster is
#' restored as a full copy of the source DB cluster.
#' @param SourceDBClusterIdentifier &#91;required&#93; The identifier of the source DB cluster from which to restore.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBCluster.
#' @param RestoreToTime The date and time to restore the DB cluster to.
#' 
#' Valid Values: Value must be a time in Universal Coordinated Time (UTC)
#' format
#' 
#' Constraints:
#' 
#' -   Must be before the latest restorable time for the DB instance
#' 
#' -   Must be specified if `UseLatestRestorableTime` parameter is not
#'     provided
#' 
#' -   Cannot be specified if `UseLatestRestorableTime` parameter is true
#' 
#' -   Cannot be specified if `RestoreType` parameter is `copy-on-write`
#' 
#' Example: `2015-03-07T23:45:00Z`
#' @param UseLatestRestorableTime A value that is set to `true` to restore the DB cluster to the latest
#' restorable backup time, and `false` otherwise.
#' 
#' Default: `false`
#' 
#' Constraints: Cannot be specified if `RestoreToTime` parameter is
#' provided.
#' @param Port The port number on which the new DB cluster accepts connections.
#' 
#' Constraints: Value must be `1150-65535`
#' 
#' Default: The same port as the original DB cluster.
#' @param DBSubnetGroupName The DB subnet group name to use for the new DB cluster.
#' 
#' Constraints: If supplied, must match the name of an existing
#' DBSubnetGroup.
#' 
#' Example: `mySubnetgroup`
#' @param OptionGroupName The name of the option group for the new DB cluster.
#' @param VpcSecurityGroupIds A list of VPC security groups that the new DB cluster belongs to.
#' @param Tags The tags to be applied to the restored DB cluster.
#' @param KmsKeyId The AWS KMS key identifier to use when restoring an encrypted DB cluster
#' from an encrypted DB cluster.
#' 
#' The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
#' encryption key. If you are restoring a DB cluster with the same AWS
#' account that owns the KMS encryption key used to encrypt the new DB
#' cluster, then you can use the KMS key alias instead of the ARN for the
#' KMS encryption key.
#' 
#' You can restore to a new DB cluster and encrypt the new DB cluster with
#' a KMS key that is different than the KMS key used to encrypt the source
#' DB cluster. The new DB cluster is encrypted with the KMS key identified
#' by the `KmsKeyId` parameter.
#' 
#' If you do not specify a value for the `KmsKeyId` parameter, then the
#' following will occur:
#' 
#' -   If the DB cluster is encrypted, then the restored DB cluster is
#'     encrypted using the KMS key that was used to encrypt the source DB
#'     cluster.
#' 
#' -   If the DB cluster is not encrypted, then the restored DB cluster is
#'     not encrypted.
#' 
#' If `DBClusterIdentifier` refers to a DB cluster that is not encrypted,
#' then the restore request is rejected.
#' @param EnableIAMDatabaseAuthentication True to enable mapping of AWS Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' Default: `false`
#' @param EnableCloudwatchLogsExports The list of logs that the restored DB cluster is to export to CloudWatch
#' Logs.
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to associate with the new DB
#' cluster.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#'
#' @section Request syntax:
#' ```
#' svc$restore_db_cluster_to_point_in_time(
#'   DBClusterIdentifier = "string",
#'   RestoreType = "string",
#'   SourceDBClusterIdentifier = "string",
#'   RestoreToTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   UseLatestRestorableTime = TRUE|FALSE,
#'   Port = 123,
#'   DBSubnetGroupName = "string",
#'   OptionGroupName = "string",
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   KmsKeyId = "string",
#'   EnableIAMDatabaseAuthentication = TRUE|FALSE,
#'   EnableCloudwatchLogsExports = list(
#'     "string"
#'   ),
#'   DBClusterParameterGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname neptune_restore_db_cluster_to_point_in_time
neptune_restore_db_cluster_to_point_in_time <- function(DBClusterIdentifier, RestoreType = NULL, SourceDBClusterIdentifier, RestoreToTime = NULL, UseLatestRestorableTime = NULL, Port = NULL, DBSubnetGroupName = NULL, OptionGroupName = NULL, VpcSecurityGroupIds = NULL, Tags = NULL, KmsKeyId = NULL, EnableIAMDatabaseAuthentication = NULL, EnableCloudwatchLogsExports = NULL, DBClusterParameterGroupName = NULL) {
  op <- new_operation(
    name = "RestoreDBClusterToPointInTime",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .neptune$restore_db_cluster_to_point_in_time_input(DBClusterIdentifier = DBClusterIdentifier, RestoreType = RestoreType, SourceDBClusterIdentifier = SourceDBClusterIdentifier, RestoreToTime = RestoreToTime, UseLatestRestorableTime = UseLatestRestorableTime, Port = Port, DBSubnetGroupName = DBSubnetGroupName, OptionGroupName = OptionGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Tags = Tags, KmsKeyId = KmsKeyId, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, DBClusterParameterGroupName = DBClusterParameterGroupName)
  output <- .neptune$restore_db_cluster_to_point_in_time_output()
  config <- get_config()
  svc <- .neptune$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$restore_db_cluster_to_point_in_time <- neptune_restore_db_cluster_to_point_in_time
