% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpledb_operations.R
\name{simpledb_batch_delete_attributes}
\alias{simpledb_batch_delete_attributes}
\title{Performs multiple DeleteAttributes operations in a single call, which
reduces round trips and latencies}
\usage{
simpledb_batch_delete_attributes(DomainName, Items)
}
\arguments{
\item{DomainName}{[required] The name of the domain in which the attributes are being deleted.}

\item{Items}{[required] A list of items on which to perform the operation.}
}
\description{
Performs multiple DeleteAttributes operations in a single call, which
reduces round trips and latencies. This enables Amazon SimpleDB to
optimize requests, which generally yields better throughput.
}
\details{
If you specify BatchDeleteAttributes without attributes or values, all
the attributes for the item are deleted.

BatchDeleteAttributes is an idempotent operation; running it multiple
times on the same item or attribute doesn't result in an error.

The BatchDeleteAttributes operation succeeds or fails in its entirety.
There are no partial deletes. You can execute multiple
BatchDeleteAttributes operations and other operations in parallel.
However, large numbers of concurrent BatchDeleteAttributes calls can
result in Service Unavailable (503) responses.

This operation is vulnerable to exceeding the maximum URL size when
making a REST request using the HTTP GET method.

This operation does not support conditions using Expected.X.Name,
Expected.X.Value, or Expected.X.Exists.

The following limitations are enforced for this operation:
\itemize{
\item 1 MB request size
\item 25 item limit per BatchDeleteAttributes operation
}
}
\section{Request syntax}{
\preformatted{svc$batch_delete_attributes(
  DomainName = "string",
  Items = list(
    list(
      Name = "string",
      Attributes = list(
        list(
          Name = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}

\keyword{internal}
