% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_reset_db_parameter_group}
\alias{rds_reset_db_parameter_group}
\title{Modifies the parameters of a DB parameter group to the engine/system
default value}
\usage{
rds_reset_db_parameter_group(DBParameterGroupName, ResetAllParameters,
  Parameters)
}
\arguments{
\item{DBParameterGroupName}{[required] The name of the DB parameter group.

Constraints:
\itemize{
\item Must match the name of an existing DBParameterGroup.
}}

\item{ResetAllParameters}{A value that indicates whether to reset all parameters in the DB
parameter group to default values. By default, all parameters in the DB
parameter group are reset to default values.}

\item{Parameters}{To reset the entire DB parameter group, specify the \code{DBParameterGroup}
name and \code{ResetAllParameters} parameters. To reset specific parameters,
provide a list of the following: \code{ParameterName} and \code{ApplyMethod}. A
maximum of 20 parameters can be modified in a single request.

\strong{MySQL}

Valid Values (for Apply method): \code{immediate} \| \code{pending-reboot}

You can use the immediate value with dynamic parameters only. You can
use the \code{pending-reboot} value for both dynamic and static parameters,
and changes are applied when DB instance reboots.

\strong{MariaDB}

Valid Values (for Apply method): \code{immediate} \| \code{pending-reboot}

You can use the immediate value with dynamic parameters only. You can
use the \code{pending-reboot} value for both dynamic and static parameters,
and changes are applied when DB instance reboots.

\strong{Oracle}

Valid Values (for Apply method): \code{pending-reboot}}
}
\description{
Modifies the parameters of a DB parameter group to the engine/system
default value. To reset specific parameters, provide a list of the
following: \code{ParameterName} and \code{ApplyMethod}. To reset the entire DB
parameter group, specify the \code{DBParameterGroup} name and
\code{ResetAllParameters} parameters. When resetting the entire group,
dynamic parameters are updated immediately and static parameters are set
to \code{pending-reboot} to take effect on the next DB instance restart or
\code{RebootDBInstance} request.
}
\section{Request syntax}{
\preformatted{svc$reset_db_parameter_group(
  DBParameterGroupName = "string",
  ResetAllParameters = TRUE|FALSE,
  Parameters = list(
    list(
      ParameterName = "string",
      ParameterValue = "string",
      Description = "string",
      Source = "string",
      ApplyType = "string",
      DataType = "string",
      AllowedValues = "string",
      IsModifiable = TRUE|FALSE,
      MinimumEngineVersion = "string",
      ApplyMethod = "immediate"|"pending-reboot",
      SupportedEngineModes = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
