% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_create_table}
\alias{dynamodb_create_table}
\title{The CreateTable operation adds a new table to your account}
\usage{
dynamodb_create_table(AttributeDefinitions, TableName, KeySchema,
  LocalSecondaryIndexes, GlobalSecondaryIndexes, BillingMode,
  ProvisionedThroughput, StreamSpecification, SSESpecification, Tags)
}
\arguments{
\item{AttributeDefinitions}{[required] An array of attributes that describe the key schema for the table and
indexes.}

\item{TableName}{[required] The name of the table to create.}

\item{KeySchema}{[required] Specifies the attributes that make up the primary key for a table or an
index. The attributes in \code{KeySchema} must also be defined in the
\code{AttributeDefinitions} array. For more information, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html}{Data Model}
in the \emph{Amazon DynamoDB Developer Guide}.

Each \code{KeySchemaElement} in the array is composed of:
\itemize{
\item \code{AttributeName} - The name of this key attribute.
\item \code{KeyType} - The role that the key attribute will assume:
\itemize{
\item \code{HASH} - partition key
\item \code{RANGE} - sort key
}
}

The partition key of an item is also known as its \emph{hash attribute}. The
term "hash attribute" derives from the DynamoDB usage of an internal
hash function to evenly distribute data items across partitions, based
on their partition key values.

The sort key of an item is also known as its \emph{range attribute}. The term
"range attribute" derives from the way DynamoDB stores items with the
same partition key physically close together, in sorted order by the
sort key value.

For a simple primary key (partition key), you must provide exactly one
element with a \code{KeyType} of \code{HASH}.

For a composite primary key (partition key and sort key), you must
provide exactly two elements, in this order: The first element must have
a \code{KeyType} of \code{HASH}, and the second element must have a \code{KeyType} of
\code{RANGE}.

For more information, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key}{Working with Tables}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{LocalSecondaryIndexes}{One or more local secondary indexes (the maximum is 5) to be created on
the table. Each index is scoped to a given partition key value. There is
a 10 GB size limit per partition key value; otherwise, the size of a
local secondary index is unconstrained.

Each local secondary index in the array includes the following:
\itemize{
\item \code{IndexName} - The name of the local secondary index. Must be unique
only for this table.
\item \code{KeySchema} - Specifies the key schema for the local secondary
index. The key schema must begin with the same partition key as the
table.
\item \code{Projection} - Specifies attributes that are copied (projected) from
the table into the index. These are in addition to the primary key
attributes and index key attributes, which are automatically
projected. Each attribute specification is composed of:
\itemize{
\item \code{ProjectionType} - One of the following:
\itemize{
\item \code{KEYS_ONLY} - Only the index and primary keys are projected
into the index.
\item \code{INCLUDE} - Only the specified table attributes are
projected into the index. The list of projected attributes
is in \code{NonKeyAttributes}.
\item \code{ALL} - All of the table attributes are projected into the
index.
}
\item \code{NonKeyAttributes} - A list of one or more non-key attribute
names that are projected into the secondary index. The total
count of attributes provided in \code{NonKeyAttributes}, summed
across all of the secondary indexes, must not exceed 100. If you
project the same attribute into two different indexes, this
counts as two distinct attributes when determining the total.
}
}}

\item{GlobalSecondaryIndexes}{One or more global secondary indexes (the maximum is 20) to be created
on the table. Each global secondary index in the array includes the
following:
\itemize{
\item \code{IndexName} - The name of the global secondary index. Must be unique
only for this table.
\item \code{KeySchema} - Specifies the key schema for the global secondary
index.
\item \code{Projection} - Specifies attributes that are copied (projected) from
the table into the index. These are in addition to the primary key
attributes and index key attributes, which are automatically
projected. Each attribute specification is composed of:
\itemize{
\item \code{ProjectionType} - One of the following:
\itemize{
\item \code{KEYS_ONLY} - Only the index and primary keys are projected
into the index.
\item \code{INCLUDE} - Only the specified table attributes are
projected into the index. The list of projected attributes
is in \code{NonKeyAttributes}.
\item \code{ALL} - All of the table attributes are projected into the
index.
}
\item \code{NonKeyAttributes} - A list of one or more non-key attribute
names that are projected into the secondary index. The total
count of attributes provided in \code{NonKeyAttributes}, summed
across all of the secondary indexes, must not exceed 100. If you
project the same attribute into two different indexes, this
counts as two distinct attributes when determining the total.
}
\item \code{ProvisionedThroughput} - The provisioned throughput settings for
the global secondary index, consisting of read and write capacity
units.
}}

\item{BillingMode}{Controls how you are charged for read and write throughput and how you
manage capacity. This setting can be changed later.
\itemize{
\item \code{PROVISIONED} - Sets the billing mode to \code{PROVISIONED}. We recommend
using \code{PROVISIONED} for predictable workloads.
\item \code{PAY_PER_REQUEST} - Sets the billing mode to \code{PAY_PER_REQUEST}. We
recommend using \code{PAY_PER_REQUEST} for unpredictable workloads.
}}

\item{ProvisionedThroughput}{Represents the provisioned throughput settings for a specified table or
index. The settings can be modified using the \code{UpdateTable} operation.

If you set BillingMode as \code{PROVISIONED}, you must specify this property.
If you set BillingMode as \code{PAY_PER_REQUEST}, you cannot specify this
property.

For current minimum and maximum provisioned throughput values, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html}{Limits}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{StreamSpecification}{The settings for DynamoDB Streams on the table. These settings consist
of:
\itemize{
\item \code{StreamEnabled} - Indicates whether DynamoDB Streams is to be
enabled (true) or disabled (false).
\item \code{StreamViewType} - When an item in the table is modified,
\code{StreamViewType} determines what information is written to the
table's stream. Valid values for \code{StreamViewType} are:
\itemize{
\item \code{KEYS_ONLY} - Only the key attributes of the modified item are
written to the stream.
\item \code{NEW_IMAGE} - The entire item, as it appears after it was
modified, is written to the stream.
\item \code{OLD_IMAGE} - The entire item, as it appeared before it was
modified, is written to the stream.
\item \code{NEW_AND_OLD_IMAGES} - Both the new and the old item images of
the item are written to the stream.
}
}}

\item{SSESpecification}{Represents the settings used to enable server-side encryption.}

\item{Tags}{A list of key-value pairs to label the table. For more information, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html}{Tagging for DynamoDB}.}
}
\description{
The \code{CreateTable} operation adds a new table to your account. In an AWS
account, table names must be unique within each Region. That is, you can
have two tables with same name if you create the tables in different
Regions.
}
\details{
\code{CreateTable} is an asynchronous operation. Upon receiving a
\code{CreateTable} request, DynamoDB immediately returns a response with a
\code{TableStatus} of \code{CREATING}. After the table is created, DynamoDB sets
the \code{TableStatus} to \code{ACTIVE}. You can perform read and write operations
only on an \code{ACTIVE} table.

You can optionally define secondary indexes on the new table, as part of
the \code{CreateTable} operation. If you want to create multiple tables with
secondary indexes on them, you must create the tables sequentially. Only
one table with secondary indexes can be in the \code{CREATING} state at any
given time.

You can use the \code{DescribeTable} action to check the table status.
}
\section{Request syntax}{
\preformatted{svc$create_table(
  AttributeDefinitions = list(
    list(
      AttributeName = "string",
      AttributeType = "S"|"N"|"B"
    )
  ),
  TableName = "string",
  KeySchema = list(
    list(
      AttributeName = "string",
      KeyType = "HASH"|"RANGE"
    )
  ),
  LocalSecondaryIndexes = list(
    list(
      IndexName = "string",
      KeySchema = list(
        list(
          AttributeName = "string",
          KeyType = "HASH"|"RANGE"
        )
      ),
      Projection = list(
        ProjectionType = "ALL"|"KEYS_ONLY"|"INCLUDE",
        NonKeyAttributes = list(
          "string"
        )
      )
    )
  ),
  GlobalSecondaryIndexes = list(
    list(
      IndexName = "string",
      KeySchema = list(
        list(
          AttributeName = "string",
          KeyType = "HASH"|"RANGE"
        )
      ),
      Projection = list(
        ProjectionType = "ALL"|"KEYS_ONLY"|"INCLUDE",
        NonKeyAttributes = list(
          "string"
        )
      ),
      ProvisionedThroughput = list(
        ReadCapacityUnits = 123,
        WriteCapacityUnits = 123
      )
    )
  ),
  BillingMode = "PROVISIONED"|"PAY_PER_REQUEST",
  ProvisionedThroughput = list(
    ReadCapacityUnits = 123,
    WriteCapacityUnits = 123
  ),
  StreamSpecification = list(
    StreamEnabled = TRUE|FALSE,
    StreamViewType = "NEW_IMAGE"|"OLD_IMAGE"|"NEW_AND_OLD_IMAGES"|"KEYS_ONLY"
  ),
  SSESpecification = list(
    Enabled = TRUE|FALSE,
    SSEType = "AES256"|"KMS",
    KMSMasterKeyId = "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
# This example creates a table named Music.
\donttest{svc$create_table(
  AttributeDefinitions = list(
    list(
      AttributeName = "Artist",
      AttributeType = "S"
    ),
    list(
      AttributeName = "SongTitle",
      AttributeType = "S"
    )
  ),
  KeySchema = list(
    list(
      AttributeName = "Artist",
      KeyType = "HASH"
    ),
    list(
      AttributeName = "SongTitle",
      KeyType = "RANGE"
    )
  ),
  ProvisionedThroughput = list(
    ReadCapacityUnits = 5L,
    WriteCapacityUnits = 5L
  ),
  TableName = "Music"
)}

}
\keyword{internal}
