% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_restore_db_cluster_from_snapshot}
\alias{docdb_restore_db_cluster_from_snapshot}
\title{Creates a new DB cluster from a DB snapshot or DB cluster snapshot}
\usage{
docdb_restore_db_cluster_from_snapshot(AvailabilityZones,
  DBClusterIdentifier, SnapshotIdentifier, Engine, EngineVersion, Port,
  DBSubnetGroupName, VpcSecurityGroupIds, Tags, KmsKeyId,
  EnableCloudwatchLogsExports, DeletionProtection)
}
\arguments{
\item{AvailabilityZones}{Provides the list of Amazon EC2 Availability Zones that instances in the
restored DB cluster can be created in.}

\item{DBClusterIdentifier}{[required] The name of the DB cluster to create from the DB snapshot or DB cluster
snapshot. This parameter isn't case sensitive.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item The first character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-snapshot-id}}

\item{SnapshotIdentifier}{[required] The identifier for the DB snapshot or DB cluster snapshot to restore
from.

You can use either the name or the Amazon Resource Name (ARN) to specify
a DB cluster snapshot. However, you can use only the ARN to specify a DB
snapshot.

Constraints:
\itemize{
\item Must match the identifier of an existing snapshot.
}}

\item{Engine}{[required] The database engine to use for the new DB cluster.

Default: The same as source.

Constraint: Must be compatible with the engine of the source.}

\item{EngineVersion}{The version of the database engine to use for the new DB cluster.}

\item{Port}{The port number on which the new DB cluster accepts connections.

Constraints: Must be a value from \code{1150} to \code{65535}.

Default: The same port as the original DB cluster.}

\item{DBSubnetGroupName}{The name of the DB subnet group to use for the new DB cluster.

Constraints: If provided, must match the name of an existing
\code{DBSubnetGroup}.

Example: \code{mySubnetgroup}}

\item{VpcSecurityGroupIds}{A list of virtual private cloud (VPC) security groups that the new DB
cluster will belong to.}

\item{Tags}{The tags to be assigned to the restored DB cluster.}

\item{KmsKeyId}{The AWS KMS key identifier to use when restoring an encrypted DB cluster
from a DB snapshot or DB cluster snapshot.

The AWS KMS key identifier is the Amazon Resource Name (ARN) for the AWS
KMS encryption key. If you are restoring a DB cluster with the same AWS
account that owns the AWS KMS encryption key used to encrypt the new DB
cluster, then you can use the AWS KMS key alias instead of the ARN for
the AWS KMS encryption key.

If you do not specify a value for the \code{KmsKeyId} parameter, then the
following occurs:
\itemize{
\item If the DB snapshot or DB cluster snapshot in \code{SnapshotIdentifier} is
encrypted, then the restored DB cluster is encrypted using the AWS
KMS key that was used to encrypt the DB snapshot or the DB cluster
snapshot.
\item If the DB snapshot or the DB cluster snapshot in
\code{SnapshotIdentifier} is not encrypted, then the restored DB cluster
is not encrypted.
}}

\item{EnableCloudwatchLogsExports}{A list of log types that must be enabled for exporting to Amazon
CloudWatch Logs.}

\item{DeletionProtection}{Specifies whether this cluster can be deleted. If \code{DeletionProtection}
is enabled, the cluster cannot be deleted unless it is modified and
\code{DeletionProtection} is disabled. \code{DeletionProtection} protects clusters
from being accidentally deleted.}
}
\description{
Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
}
\details{
If a DB snapshot is specified, the target DB cluster is created from the
source DB snapshot with a default configuration and default security
group.

If a DB cluster snapshot is specified, the target DB cluster is created
from the source DB cluster restore point with the same configuration as
the original source DB cluster, except that the new DB cluster is
created with the default security group.
}
\section{Request syntax}{
\preformatted{svc$restore_db_cluster_from_snapshot(
  AvailabilityZones = list(
    "string"
  ),
  DBClusterIdentifier = "string",
  SnapshotIdentifier = "string",
  Engine = "string",
  EngineVersion = "string",
  Port = 123,
  DBSubnetGroupName = "string",
  VpcSecurityGroupIds = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  KmsKeyId = "string",
  EnableCloudwatchLogsExports = list(
    "string"
  ),
  DeletionProtection = TRUE|FALSE
)
}
}

\keyword{internal}
