% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_modify_db_instance}
\alias{neptune_modify_db_instance}
\title{Modifies settings for a DB instance}
\usage{
neptune_modify_db_instance(DBInstanceIdentifier, AllocatedStorage,
  DBInstanceClass, DBSubnetGroupName, DBSecurityGroups,
  VpcSecurityGroupIds, ApplyImmediately, MasterUserPassword,
  DBParameterGroupName, BackupRetentionPeriod, PreferredBackupWindow,
  PreferredMaintenanceWindow, MultiAZ, EngineVersion,
  AllowMajorVersionUpgrade, AutoMinorVersionUpgrade, LicenseModel, Iops,
  OptionGroupName, NewDBInstanceIdentifier, StorageType, TdeCredentialArn,
  TdeCredentialPassword, CACertificateIdentifier, Domain,
  CopyTagsToSnapshot, MonitoringInterval, DBPortNumber,
  PubliclyAccessible, MonitoringRoleArn, DomainIAMRoleName, PromotionTier,
  EnableIAMDatabaseAuthentication, EnablePerformanceInsights,
  PerformanceInsightsKMSKeyId, CloudwatchLogsExportConfiguration,
  DeletionProtection)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The DB instance identifier. This value is stored as a lowercase string.

Constraints:
\itemize{
\item Must match the identifier of an existing DBInstance.
}}

\item{AllocatedStorage}{The new amount of storage (in gibibytes) to allocate for the DB
instance.

Not applicable. Storage is managed by the DB Cluster.}

\item{DBInstanceClass}{The new compute and memory capacity of the DB instance, for example,
\code{db.m4.large}. Not all DB instance classes are available in all AWS
Regions.

If you modify the DB instance class, an outage occurs during the change.
The change is applied during the next maintenance window, unless
\code{ApplyImmediately} is specified as \code{true} for this request.

Default: Uses existing setting}

\item{DBSubnetGroupName}{The new DB subnet group for the DB instance. You can use this parameter
to move your DB instance to a different VPC.

Changing the subnet group causes an outage during the change. The change
is applied during the next maintenance window, unless you specify \code{true}
for the \code{ApplyImmediately} parameter.

Constraints: If supplied, must match the name of an existing
DBSubnetGroup.

Example: \code{mySubnetGroup}}

\item{DBSecurityGroups}{A list of DB security groups to authorize on this DB instance. Changing
this setting doesn't result in an outage and the change is
asynchronously applied as soon as possible.

Constraints:
\itemize{
\item If supplied, must match existing DBSecurityGroups.
}}

\item{VpcSecurityGroupIds}{A list of EC2 VPC security groups to authorize on this DB instance. This
change is asynchronously applied as soon as possible.

Not applicable. The associated list of EC2 VPC security groups is
managed by the DB cluster. For more information, see
\code{\link[=neptune_modify_db_cluster]{modify_db_cluster}}.

Constraints:
\itemize{
\item If supplied, must match existing VpcSecurityGroupIds.
}}

\item{ApplyImmediately}{Specifies whether the modifications in this request and any pending
modifications are asynchronously applied as soon as possible, regardless
of the \code{PreferredMaintenanceWindow} setting for the DB instance.

If this parameter is set to \code{false}, changes to the DB instance are
applied during the next maintenance window. Some parameter changes can
cause an outage and are applied on the next call to
\code{\link[=neptune_reboot_db_instance]{reboot_db_instance}}, or the next failure
reboot.

Default: \code{false}}

\item{MasterUserPassword}{Not applicable.}

\item{DBParameterGroupName}{The name of the DB parameter group to apply to the DB instance. Changing
this setting doesn't result in an outage. The parameter group name
itself is changed immediately, but the actual parameter changes are not
applied until you reboot the instance without failover. The db instance
will NOT be rebooted automatically and the parameter changes will NOT be
applied during the next maintenance window.

Default: Uses existing setting

Constraints: The DB parameter group must be in the same DB parameter
group family as this DB instance.}

\item{BackupRetentionPeriod}{Not applicable. The retention period for automated backups is managed by
the DB cluster. For more information, see
\code{\link[=neptune_modify_db_cluster]{modify_db_cluster}}.

Default: Uses existing setting}

\item{PreferredBackupWindow}{The daily time range during which automated backups are created if
automated backups are enabled.

Not applicable. The daily time range for creating automated backups is
managed by the DB cluster. For more information, see
\code{\link[=neptune_modify_db_cluster]{modify_db_cluster}}.

Constraints:
\itemize{
\item Must be in the format hh24:mi-hh24:mi
\item Must be in Universal Time Coordinated (UTC)
\item Must not conflict with the preferred maintenance window
\item Must be at least 30 minutes
}}

\item{PreferredMaintenanceWindow}{The weekly time range (in UTC) during which system maintenance can
occur, which might result in an outage. Changing this parameter doesn't
result in an outage, except in the following situation, and the change
is asynchronously applied as soon as possible. If there are pending
actions that cause a reboot, and the maintenance window is changed to
include the current time, then changing this parameter will cause a
reboot of the DB instance. If moving this window to the current time,
there must be at least 30 minutes between the current time and end of
the window to ensure pending changes are applied.

Default: Uses existing setting

Format: ddd:hh24:mi-ddd:hh24:mi

Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun

Constraints: Must be at least 30 minutes}

\item{MultiAZ}{Specifies if the DB instance is a Multi-AZ deployment. Changing this
parameter doesn't result in an outage and the change is applied during
the next maintenance window unless the \code{ApplyImmediately} parameter is
set to \code{true} for this request.}

\item{EngineVersion}{The version number of the database engine to upgrade to. Currently,
setting this parameter has no effect. To upgrade your database engine to
the most recent release, use the
\code{\link[=neptune_apply_pending_maintenance_action]{apply_pending_maintenance_action}}
API.}

\item{AllowMajorVersionUpgrade}{Indicates that major version upgrades are allowed. Changing this
parameter doesn't result in an outage and the change is asynchronously
applied as soon as possible.}

\item{AutoMinorVersionUpgrade}{Indicates that minor version upgrades are applied automatically to the
DB instance during the maintenance window. Changing this parameter
doesn't result in an outage except in the following case and the change
is asynchronously applied as soon as possible. An outage will result if
this parameter is set to \code{true} during the maintenance window, and a
newer minor version is available, and Neptune has enabled auto patching
for that engine version.}

\item{LicenseModel}{Not supported.}

\item{Iops}{The new Provisioned IOPS (I/O operations per second) value for the
instance.

Changing this setting doesn't result in an outage and the change is
applied during the next maintenance window unless the \code{ApplyImmediately}
parameter is set to \code{true} for this request.

Default: Uses existing setting}

\item{OptionGroupName}{\emph{(Not supported by Neptune)}}

\item{NewDBInstanceIdentifier}{The new DB instance identifier for the DB instance when renaming a DB
instance. When you change the DB instance identifier, an instance reboot
will occur immediately if you set \verb{Apply Immediately} to true, or will
occur during the next maintenance window if \verb{Apply Immediately} to
false. This value is stored as a lowercase string.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item The first character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}

Example: \code{mydbinstance}}

\item{StorageType}{Not supported.}

\item{TdeCredentialArn}{The ARN from the key store with which to associate the instance for TDE
encryption.}

\item{TdeCredentialPassword}{The password for the given ARN from the key store in order to access the
device.}

\item{CACertificateIdentifier}{Indicates the certificate that needs to be associated with the instance.}

\item{Domain}{Not supported.}

\item{CopyTagsToSnapshot}{True to copy all tags from the DB instance to snapshots of the DB
instance, and otherwise false. The default is false.}

\item{MonitoringInterval}{The interval, in seconds, between points when Enhanced Monitoring
metrics are collected for the DB instance. To disable collecting
Enhanced Monitoring metrics, specify 0. The default is 0.

If \code{MonitoringRoleArn} is specified, then you must also set
\code{MonitoringInterval} to a value other than 0.

Valid Values: \verb{0, 1, 5, 10, 15, 30, 60}}

\item{DBPortNumber}{The port number on which the database accepts connections.

The value of the \code{DBPortNumber} parameter must not match any of the port
values specified for options in the option group for the DB instance.

Your database will restart when you change the \code{DBPortNumber} value
regardless of the value of the \code{ApplyImmediately} parameter.

Default: \code{8182}}

\item{PubliclyAccessible}{This flag should no longer be used.}

\item{MonitoringRoleArn}{The ARN for the IAM role that permits Neptune to send enhanced
monitoring metrics to Amazon CloudWatch Logs. For example,
\code{arn:aws:iam:123456789012:role/emaccess}.

If \code{MonitoringInterval} is set to a value other than 0, then you must
supply a \code{MonitoringRoleArn} value.}

\item{DomainIAMRoleName}{Not supported}

\item{PromotionTier}{A value that specifies the order in which a Read Replica is promoted to
the primary instance after a failure of the existing primary instance.

Default: 1

Valid Values: 0 - 15}

\item{EnableIAMDatabaseAuthentication}{True to enable mapping of AWS Identity and Access Management (IAM)
accounts to database accounts, and otherwise false.

You can enable IAM database authentication for the following database
engines

Not applicable. Mapping AWS IAM accounts to database accounts is managed
by the DB cluster. For more information, see
\code{\link[=neptune_modify_db_cluster]{modify_db_cluster}}.

Default: \code{false}}

\item{EnablePerformanceInsights}{\emph{(Not supported by Neptune)}}

\item{PerformanceInsightsKMSKeyId}{\emph{(Not supported by Neptune)}}

\item{CloudwatchLogsExportConfiguration}{The configuration setting for the log types to be enabled for export to
CloudWatch Logs for a specific DB instance or DB cluster.}

\item{DeletionProtection}{A value that indicates whether the DB instance has deletion protection
enabled. The database can't be deleted when deletion protection is
enabled. By default, deletion protection is disabled. See \href{https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html}{Deleting a DB Instance}.}
}
\value{
A list with the following syntax:\preformatted{list(
  DBInstance = list(
    DBInstanceIdentifier = "string",
    DBInstanceClass = "string",
    Engine = "string",
    DBInstanceStatus = "string",
    MasterUsername = "string",
    DBName = "string",
    Endpoint = list(
      Address = "string",
      Port = 123,
      HostedZoneId = "string"
    ),
    AllocatedStorage = 123,
    InstanceCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    PreferredBackupWindow = "string",
    BackupRetentionPeriod = 123,
    DBSecurityGroups = list(
      list(
        DBSecurityGroupName = "string",
        Status = "string"
      )
    ),
    VpcSecurityGroups = list(
      list(
        VpcSecurityGroupId = "string",
        Status = "string"
      )
    ),
    DBParameterGroups = list(
      list(
        DBParameterGroupName = "string",
        ParameterApplyStatus = "string"
      )
    ),
    AvailabilityZone = "string",
    DBSubnetGroup = list(
      DBSubnetGroupName = "string",
      DBSubnetGroupDescription = "string",
      VpcId = "string",
      SubnetGroupStatus = "string",
      Subnets = list(
        list(
          SubnetIdentifier = "string",
          SubnetAvailabilityZone = list(
            Name = "string"
          ),
          SubnetStatus = "string"
        )
      ),
      DBSubnetGroupArn = "string"
    ),
    PreferredMaintenanceWindow = "string",
    PendingModifiedValues = list(
      DBInstanceClass = "string",
      AllocatedStorage = 123,
      MasterUserPassword = "string",
      Port = 123,
      BackupRetentionPeriod = 123,
      MultiAZ = TRUE|FALSE,
      EngineVersion = "string",
      LicenseModel = "string",
      Iops = 123,
      DBInstanceIdentifier = "string",
      StorageType = "string",
      CACertificateIdentifier = "string",
      DBSubnetGroupName = "string",
      PendingCloudwatchLogsExports = list(
        LogTypesToEnable = list(
          "string"
        ),
        LogTypesToDisable = list(
          "string"
        )
      )
    ),
    LatestRestorableTime = as.POSIXct(
      "2015-01-01"
    ),
    MultiAZ = TRUE|FALSE,
    EngineVersion = "string",
    AutoMinorVersionUpgrade = TRUE|FALSE,
    ReadReplicaSourceDBInstanceIdentifier = "string",
    ReadReplicaDBInstanceIdentifiers = list(
      "string"
    ),
    ReadReplicaDBClusterIdentifiers = list(
      "string"
    ),
    LicenseModel = "string",
    Iops = 123,
    OptionGroupMemberships = list(
      list(
        OptionGroupName = "string",
        Status = "string"
      )
    ),
    CharacterSetName = "string",
    SecondaryAvailabilityZone = "string",
    PubliclyAccessible = TRUE|FALSE,
    StatusInfos = list(
      list(
        StatusType = "string",
        Normal = TRUE|FALSE,
        Status = "string",
        Message = "string"
      )
    ),
    StorageType = "string",
    TdeCredentialArn = "string",
    DbInstancePort = 123,
    DBClusterIdentifier = "string",
    StorageEncrypted = TRUE|FALSE,
    KmsKeyId = "string",
    DbiResourceId = "string",
    CACertificateIdentifier = "string",
    DomainMemberships = list(
      list(
        Domain = "string",
        Status = "string",
        FQDN = "string",
        IAMRoleName = "string"
      )
    ),
    CopyTagsToSnapshot = TRUE|FALSE,
    MonitoringInterval = 123,
    EnhancedMonitoringResourceArn = "string",
    MonitoringRoleArn = "string",
    PromotionTier = 123,
    DBInstanceArn = "string",
    Timezone = "string",
    IAMDatabaseAuthenticationEnabled = TRUE|FALSE,
    PerformanceInsightsEnabled = TRUE|FALSE,
    PerformanceInsightsKMSKeyId = "string",
    EnabledCloudwatchLogsExports = list(
      "string"
    ),
    DeletionProtection = TRUE|FALSE
  )
)
}
}
\description{
Modifies settings for a DB instance. You can change one or more database
configuration parameters by specifying these parameters and the new
values in the request. To learn what modifications you can make to your
DB instance, call
\code{\link[=neptune_describe_valid_db_instance_modifications]{describe_valid_db_instance_modifications}}
before you call \code{\link[=neptune_modify_db_instance]{modify_db_instance}}.
}
\section{Request syntax}{
\preformatted{svc$modify_db_instance(
  DBInstanceIdentifier = "string",
  AllocatedStorage = 123,
  DBInstanceClass = "string",
  DBSubnetGroupName = "string",
  DBSecurityGroups = list(
    "string"
  ),
  VpcSecurityGroupIds = list(
    "string"
  ),
  ApplyImmediately = TRUE|FALSE,
  MasterUserPassword = "string",
  DBParameterGroupName = "string",
  BackupRetentionPeriod = 123,
  PreferredBackupWindow = "string",
  PreferredMaintenanceWindow = "string",
  MultiAZ = TRUE|FALSE,
  EngineVersion = "string",
  AllowMajorVersionUpgrade = TRUE|FALSE,
  AutoMinorVersionUpgrade = TRUE|FALSE,
  LicenseModel = "string",
  Iops = 123,
  OptionGroupName = "string",
  NewDBInstanceIdentifier = "string",
  StorageType = "string",
  TdeCredentialArn = "string",
  TdeCredentialPassword = "string",
  CACertificateIdentifier = "string",
  Domain = "string",
  CopyTagsToSnapshot = TRUE|FALSE,
  MonitoringInterval = 123,
  DBPortNumber = 123,
  PubliclyAccessible = TRUE|FALSE,
  MonitoringRoleArn = "string",
  DomainIAMRoleName = "string",
  PromotionTier = 123,
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  EnablePerformanceInsights = TRUE|FALSE,
  PerformanceInsightsKMSKeyId = "string",
  CloudwatchLogsExportConfiguration = list(
    EnableLogTypes = list(
      "string"
    ),
    DisableLogTypes = list(
      "string"
    )
  ),
  DeletionProtection = TRUE|FALSE
)
}
}

\keyword{internal}
