% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_custom_availability_zone}
\alias{rds_create_custom_availability_zone}
\title{Creates a custom Availability Zone (AZ)}
\usage{
rds_create_custom_availability_zone(CustomAvailabilityZoneName,
  ExistingVpnId, NewVpnTunnelName, VpnTunnelOriginatorIP)
}
\arguments{
\item{CustomAvailabilityZoneName}{[required] The name of the custom Availability Zone (AZ).}

\item{ExistingVpnId}{The ID of an existing virtual private network (VPN) between the Amazon
RDS website and the VMware vSphere cluster.}

\item{NewVpnTunnelName}{The name of a new VPN tunnel between the Amazon RDS website and the
VMware vSphere cluster.

Specify this parameter only if \code{ExistingVpnId} isn't specified.}

\item{VpnTunnelOriginatorIP}{The IP address of network traffic from your on-premises data center. A
custom AZ receives the network traffic.

Specify this parameter only if \code{ExistingVpnId} isn't specified.}
}
\description{
Creates a custom Availability Zone (AZ).

A custom AZ is an on-premises AZ that is integrated with a VMware
vSphere cluster.

For more information about RDS on VMware, see the \href{https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html}{RDS on VMware User Guide.}
}
\section{Request syntax}{
\preformatted{svc$create_custom_availability_zone(
  CustomAvailabilityZoneName = "string",
  ExistingVpnId = "string",
  NewVpnTunnelName = "string",
  VpnTunnelOriginatorIP = "string"
)
}
}

\keyword{internal}
