% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_copy_db_cluster_parameter_group}
\alias{rds_copy_db_cluster_parameter_group}
\title{Copies the specified DB cluster parameter group}
\usage{
rds_copy_db_cluster_parameter_group(
  SourceDBClusterParameterGroupIdentifier,
  TargetDBClusterParameterGroupIdentifier,
  TargetDBClusterParameterGroupDescription, Tags)
}
\arguments{
\item{SourceDBClusterParameterGroupIdentifier}{[required] The identifier or Amazon Resource Name (ARN) for the source DB cluster
parameter group. For information about creating an ARN, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing}{Constructing an ARN for Amazon RDS}
in the \emph{Amazon Aurora User Guide}.

Constraints:
\itemize{
\item Must specify a valid DB cluster parameter group.
\item If the source DB cluster parameter group is in the same AWS Region
as the copy, specify a valid DB parameter group identifier, for
example \code{my-db-cluster-param-group}, or a valid ARN.
\item If the source DB parameter group is in a different AWS Region than
the copy, specify a valid DB cluster parameter group ARN, for
example
\code{arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1}.
}}

\item{TargetDBClusterParameterGroupIdentifier}{[required] The identifier for the copied DB cluster parameter group.

Constraints:
\itemize{
\item Can't be null, empty, or blank
\item Must contain from 1 to 255 letters, numbers, or hyphens
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}

Example: \code{my-cluster-param-group1}}

\item{TargetDBClusterParameterGroupDescription}{[required] A description for the copied DB cluster parameter group.}

\item{Tags}{}
}
\description{
Copies the specified DB cluster parameter group.

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$copy_db_cluster_parameter_group(
  SourceDBClusterParameterGroupIdentifier = "string",
  TargetDBClusterParameterGroupIdentifier = "string",
  TargetDBClusterParameterGroupDescription = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
