# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include rdsdataservice_service.R
NULL

#' Executes any SQL statement on the target database synchronously
#'
#' Executes any SQL statement on the target database synchronously
#'
#' @usage
#' rdsdataservice_execute_sql(awsSecretStoreArn, database,
#'   dbClusterOrInstanceArn, schema, sqlStatements)
#'
#' @param awsSecretStoreArn &#91;required&#93; ARN of the db credentials in AWS Secret Store or the friendly secret name
#' @param database Target DB name
#' @param dbClusterOrInstanceArn &#91;required&#93; ARN of the target db cluster or instance
#' @param schema Target Schema name
#' @param sqlStatements &#91;required&#93; SQL statement(s) to be executed. Statements can be chained by using semicolons
#'
#' @section Request syntax:
#' ```
#' svc$execute_sql(
#'   awsSecretStoreArn = "string",
#'   database = "string",
#'   dbClusterOrInstanceArn = "string",
#'   schema = "string",
#'   sqlStatements = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rdsdataservice_execute_sql
rdsdataservice_execute_sql <- function(awsSecretStoreArn, database = NULL, dbClusterOrInstanceArn, schema = NULL, sqlStatements) {
  op <- new_operation(
    name = "ExecuteSql",
    http_method = "POST",
    http_path = "/ExecuteSql",
    paginator = list()
  )
  input <- .rdsdataservice$execute_sql_input(awsSecretStoreArn = awsSecretStoreArn, database = database, dbClusterOrInstanceArn = dbClusterOrInstanceArn, schema = schema, sqlStatements = sqlStatements)
  output <- .rdsdataservice$execute_sql_output()
  svc <- .rdsdataservice$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rdsdataservice$operations$execute_sql <- rdsdataservice_execute_sql
