# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' Amazon DynamoDB Streams
#'
#' @description
#' Amazon DynamoDB
#' 
#' Amazon DynamoDB Streams provides API actions for accessing streams and
#' processing stream records. To learn more about application development
#' with Streams, see [Capturing Table Activity with DynamoDB
#' Streams](http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Streams.html)
#' in the Amazon DynamoDB Developer Guide.
#'
#' @examples
#' # The following example describes a stream with a given stream ARN.
#' \donttest{svc <- dynamodbstreams()
#' svc$describe_stream(
#'   StreamArn = "arn:aws:dynamodb:us-west-2:111122223333:table/Forum/stream/2015-05-20T20:51:1..."
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=dynamodbstreams_describe_stream]{describe_stream} \tab Returns information about a stream, including the current status of the stream, its Amazon Resource Name (ARN), the composition of its shards, and its corresponding DynamoDB table\cr
#'  \link[=dynamodbstreams_get_records]{get_records} \tab Retrieves the stream records from a given shard \cr
#'  \link[=dynamodbstreams_get_shard_iterator]{get_shard_iterator} \tab Returns a shard iterator \cr
#'  \link[=dynamodbstreams_list_streams]{list_streams} \tab Returns an array of stream ARNs associated with the current account and endpoint 
#' }
#'
#' @rdname dynamodbstreams
#' @export
dynamodbstreams <- function() {
  .dynamodbstreams$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.dynamodbstreams <- list()

.dynamodbstreams$operations <- list()

.dynamodbstreams$metadata <- list(
  service_name = "streams.dynamodb",
  endpoints = list("*" = "streams.dynamodb.{region}.amazonaws.com", "cn-*" = "streams.dynamodb.{region}.amazonaws.com.cn"),
  service_id = "DynamoDB Streams",
  api_version = "2012-08-10",
  signing_name = "dynamodb",
  json_version = "1.0",
  target_prefix = "DynamoDBStreams_20120810"
)

.dynamodbstreams$handlers <- new_handlers("jsonrpc", "v4")

.dynamodbstreams$service <- function() {
  new_service(.dynamodbstreams$metadata, .dynamodbstreams$handlers)
}
