% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectparticipant_operations.R
\name{connectparticipant_send_message}
\alias{connectparticipant_send_message}
\title{Sends a message}
\usage{
connectparticipant_send_message(
  ContentType,
  Content,
  ClientToken = NULL,
  ConnectionToken
)
}
\arguments{
\item{ContentType}{[required] The type of the content. Supported types are \code{text/plain},
\code{text/markdown}, \code{application/json}, and
\code{application/vnd.amazonaws.connect.message.interactive.response}.}

\item{Content}{[required] The content of the message.
\itemize{
\item For \code{text/plain} and \code{text/markdown}, the Length Constraints are
Minimum of 1, Maximum of 1024.
\item For \code{application/json}, the Length Constraints are Minimum of 1,
Maximum of 12000.
\item For
\code{application/vnd.amazonaws.connect.message.interactive.response},
the Length Constraints are Minimum of 1, Maximum of 12288.
}}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}

\item{ConnectionToken}{[required] The authentication token associated with the connection.}
}
\description{
Sends a message.

See \url{https://www.paws-r-sdk.com/docs/connectparticipant_send_message/} for full documentation.
}
\keyword{internal}
